/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc;

import io.prestosql.jdbc.$internal.client.OkHttpUtil;
import io.prestosql.jdbc.$internal.client.SocketChannelSocketFactory;
import io.prestosql.jdbc.$internal.guava.base.MoreObjects;
import io.prestosql.jdbc.$internal.guava.base.Strings;
import io.prestosql.jdbc.$internal.okhttp3.OkHttpClient;
import io.prestosql.jdbc.ConnectionProperties;
import io.prestosql.jdbc.PrestoConnection;
import io.prestosql.jdbc.PrestoDriverUri;
import io.prestosql.jdbc.QueryExecutor;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrestoDriver
implements Driver,
Closeable {
    static final String DRIVER_NAME = "Presto JDBC Driver";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    private static final String DRIVER_URL_START = "jdbc:presto:";
    private final OkHttpClient httpClient = new OkHttpClient.Builder().addInterceptor(OkHttpUtil.userAgent("Presto JDBC Driver/" + DRIVER_VERSION)).socketFactory(new SocketChannelSocketFactory()).build();

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        PrestoDriverUri uri = new PrestoDriverUri(url, info);
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        uri.setupClient(builder);
        QueryExecutor executor = new QueryExecutor(builder.build());
        return new PrestoConnection(uri, executor);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(DRIVER_URL_START);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties properties = new PrestoDriverUri(url, info).getProperties();
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        String version = Strings.nullToEmpty(PrestoDriver.class.getPackage().getImplementationVersion());
        Matcher matcher = Pattern.compile("^(\\d+)(\\.(\\d+))?($|[.-])").matcher(version);
        if (!matcher.find()) {
            DRIVER_VERSION = "unknown";
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            DRIVER_VERSION = version;
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(MoreObjects.firstNonNull(matcher.group(3), "0"));
        }
        try {
            DriverManager.registerDriver(new PrestoDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException("Presto jdbc failed to register PrestoDriver");
        }
    }
}

