/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.prestosql.rcfile.RcFileCorruptionException;
import io.prestosql.rcfile.RcFileDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;

public class HadoopDecompressor
implements RcFileDecompressor {
    private final CompressionCodec codec;
    private final Decompressor decompressor;
    private boolean destroyed;

    public HadoopDecompressor(CompressionCodec codec) {
        this.codec = Objects.requireNonNull(codec, "codec is null");
        this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
    }

    @Override
    public void decompress(Slice compressed, Slice uncompressed) throws RcFileCorruptionException {
        Preconditions.checkState((!this.destroyed ? 1 : 0) != 0, (Object)"Codec has been destroyed");
        this.decompressor.reset();
        try (CompressionInputStream decompressorStream = this.codec.createInputStream((InputStream)compressed.getInput(), this.decompressor);){
            uncompressed.setBytes(0, (InputStream)decompressorStream, uncompressed.length());
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new RcFileCorruptionException(e, "Compressed stream is truncated", new Object[0]);
        }
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        CodecPool.returnDecompressor((Decompressor)this.decompressor);
    }
}

