/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.RcFileDecoderUtils;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public class BinaryEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public BinaryEncoding(Type type) {
        this.type = type;
    }

    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                Slice slice = this.type.getSlice(block, position);
                if (slice.length() == 0) {
                    throw new IllegalArgumentException("RCBinary encoder does not support empty VARBINARY values (HIVE-2483). Use ORC or Parquet format instead.");
                }
                output.writeBytes(slice);
            }
            encodeOutput.closeEntry();
        }
    }

    public void encodeValueInto(Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        RcFileDecoderUtils.writeVInt(output, slice.length());
        output.writeBytes(slice);
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length > 0) {
                int offset = columnData.getOffset(i);
                this.type.writeSlice(builder, slice, offset, length);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return RcFileDecoderUtils.decodeVIntSize(slice, offset);
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
    }

    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeSlice(builder, slice, offset, length);
    }
}

