/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import io.prestosql.rcfile.ColumnEncoding;
import io.prestosql.rcfile.RcFileEncoding;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.rcfile.binary.BinaryEncoding;
import io.prestosql.rcfile.binary.BooleanEncoding;
import io.prestosql.rcfile.binary.ByteEncoding;
import io.prestosql.rcfile.binary.DateEncoding;
import io.prestosql.rcfile.binary.DecimalEncoding;
import io.prestosql.rcfile.binary.DoubleEncoding;
import io.prestosql.rcfile.binary.FloatEncoding;
import io.prestosql.rcfile.binary.ListEncoding;
import io.prestosql.rcfile.binary.LongEncoding;
import io.prestosql.rcfile.binary.MapEncoding;
import io.prestosql.rcfile.binary.ShortEncoding;
import io.prestosql.rcfile.binary.StringEncoding;
import io.prestosql.rcfile.binary.StructEncoding;
import io.prestosql.rcfile.binary.TimestampEncoding;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class BinaryRcFileEncoding
implements RcFileEncoding {
    private final DateTimeZone timeZone;

    public BinaryRcFileEncoding(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    @Override
    public ColumnEncoding booleanEncoding(Type type) {
        return new BooleanEncoding(type);
    }

    @Override
    public ColumnEncoding byteEncoding(Type type) {
        return new ByteEncoding(type);
    }

    @Override
    public ColumnEncoding shortEncoding(Type type) {
        return new ShortEncoding(type);
    }

    @Override
    public ColumnEncoding intEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding longEncoding(Type type) {
        return new LongEncoding(type);
    }

    @Override
    public ColumnEncoding decimalEncoding(Type type) {
        return new DecimalEncoding(type);
    }

    @Override
    public ColumnEncoding floatEncoding(Type type) {
        return new FloatEncoding(type);
    }

    @Override
    public ColumnEncoding doubleEncoding(Type type) {
        return new DoubleEncoding(type);
    }

    @Override
    public ColumnEncoding stringEncoding(Type type) {
        return new StringEncoding(type);
    }

    @Override
    public ColumnEncoding binaryEncoding(Type type) {
        return new BinaryEncoding(type);
    }

    @Override
    public ColumnEncoding dateEncoding(Type type) {
        return new DateEncoding(type);
    }

    @Override
    public ColumnEncoding timestampEncoding(Type type) {
        return new TimestampEncoding(type, this.timeZone);
    }

    @Override
    public ColumnEncoding listEncoding(Type type, ColumnEncoding elementEncoding) {
        return new ListEncoding(type, (BinaryColumnEncoding)elementEncoding);
    }

    @Override
    public ColumnEncoding mapEncoding(Type type, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding) {
        return new MapEncoding(type, (BinaryColumnEncoding)keyEncoding, (BinaryColumnEncoding)valueEncoding);
    }

    @Override
    public ColumnEncoding structEncoding(Type type, List<ColumnEncoding> fieldEncodings) {
        return new StructEncoding(type, fieldEncodings.stream().map(field -> (BinaryColumnEncoding)field).collect(Collectors.toList()));
    }
}

