/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public class ByteEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public ByteEncoding(Type type) {
        this.type = type;
    }

    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                output.writeByte((int)((byte)this.type.getLong(block, position)));
            }
            encodeOutput.closeEntry();
        }
    }

    public void encodeValueInto(Block block, int position, SliceOutput output) {
        output.writeByte((int)((byte)this.type.getLong(block, position)));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                Preconditions.checkState((length == 1 ? 1 : 0) != 0, (Object)"Bytes should be 1 byte");
                this.type.writeLong(builder, (long)slice.getByte(columnData.getOffset(i)));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return 1;
    }

    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeLong(builder, (long)slice.getByte(offset));
    }
}

