/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.RcFileDecoderUtils;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.nio.charset.StandardCharsets;

public class StringEncoding
implements BinaryColumnEncoding {
    private static final byte HIVE_EMPTY_STRING_BYTE = -65;
    private final Type type;

    public StringEncoding(Type type) {
        this.type = type;
    }

    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                Slice slice = this.type.getSlice(block, position);
                if (slice.length() == 0) {
                    output.writeByte(-65);
                } else {
                    String escapedValue = RcFileDecoderUtils.unescapeText(new String(slice.getBytes(), StandardCharsets.UTF_8));
                    if (escapedValue.getBytes(StandardCharsets.UTF_8).length < slice.getBytes().length) {
                        output.writeBytes(escapedValue.getBytes(StandardCharsets.UTF_8));
                    } else {
                        output.writeBytes(slice);
                    }
                }
            }
            encodeOutput.closeEntry();
        }
    }

    public void encodeValueInto(Block block, int position, SliceOutput output) {
        Slice slice = this.type.getSlice(block, position);
        RcFileDecoderUtils.writeVInt(output, slice.length());
        output.writeBytes(slice);
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length > 0) {
                int offset = columnData.getOffset(i);
                if (length == 1 && slice.getByte(offset) == -65) {
                    this.type.writeSlice(builder, Slices.EMPTY_SLICE);
                    continue;
                }
                length = RcFileDecoderUtils.calculateTruncationLength(this.type, slice, offset, length);
                this.type.writeSlice(builder, slice.slice(offset, length));
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return RcFileDecoderUtils.decodeVIntSize(slice, offset);
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        return Math.toIntExact(RcFileDecoderUtils.readVInt(slice, offset));
    }

    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        int len = RcFileDecoderUtils.calculateTruncationLength(this.type, slice, offset, length);
        this.type.writeSlice(builder, slice, offset, len);
    }
}

