/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.RcFileDecoderUtils;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TimestampEncoding
implements BinaryColumnEncoding {
    private final Type type;
    private final DateTimeZone timeZone;

    public TimestampEncoding(Type type, DateTimeZone timeZone) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                this.writeTimestamp(output, this.type.getLong(block, position));
            }
            encodeOutput.closeEntry();
        }
    }

    public void encodeValueInto(Block block, int position, SliceOutput output) {
        this.writeTimestamp(output, this.type.getLong(block, position));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                int offset = columnData.getOffset(i);
                long millis = this.getTimestamp(slice, offset);
                this.type.writeLong(builder, millis);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        int length = 4;
        if (TimestampEncoding.hasNanosVInt(slice.getByte(offset))) {
            int nanosVintLength = RcFileDecoderUtils.decodeVIntSize(slice, offset + 4);
            length += nanosVintLength;
            if (RcFileDecoderUtils.isNegativeVInt(slice, offset + 4)) {
                length += RcFileDecoderUtils.decodeVIntSize(slice, offset + 4 + nanosVintLength);
            }
        }
        return length;
    }

    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        long millis = this.getTimestamp(slice, offset);
        this.type.writeLong(builder, millis);
    }

    private static boolean hasNanosVInt(byte b) {
        return b >> 7 != 0;
    }

    private long getTimestamp(Slice slice, int offset) {
        int newOffset = offset;
        int lowest31BitsOfSecondsAndFlag = Integer.reverseBytes(slice.getInt(newOffset));
        long seconds = lowest31BitsOfSecondsAndFlag & Integer.MAX_VALUE;
        newOffset += 4;
        int nanos = 0;
        if (lowest31BitsOfSecondsAndFlag < 0) {
            byte nanosFirstByte = slice.getByte(newOffset);
            int nanosLength = RcFileDecoderUtils.decodeVIntSize(nanosFirstByte);
            nanos = (int)RcFileDecoderUtils.readVInt(slice, newOffset, nanosLength);
            nanos = TimestampEncoding.decodeNanos(nanos);
            if (RcFileDecoderUtils.isNegativeVInt(nanosFirstByte)) {
                long highBits = RcFileDecoderUtils.readVInt(slice, newOffset + nanosLength);
                seconds |= highBits << 31;
            }
        }
        long millis = seconds * 1000L + (long)(nanos / 1000000);
        return this.timeZone.convertUTCToLocal(millis);
    }

    private static int decodeNanos(int nanos) {
        int nan = nanos;
        if (nan < 0) {
            nan = -nan - 1;
        }
        int nanosDigits = (int)Math.floor(Math.log10(nan)) + 1;
        int temp = 0;
        while (nan != 0) {
            temp *= 10;
            temp += nan % 10;
            nan /= 10;
        }
        nan = temp;
        if (nanosDigits < 9) {
            nan = (int)((double)nan * Math.pow(10.0, 9 - nanosDigits));
        }
        return nan;
    }

    private void writeTimestamp(SliceOutput output, long millis) {
        long ms = millis;
        ms = this.timeZone.convertLocalToUTC(ms, false);
        long seconds = Math.floorDiv(ms, 1000L);
        int nanos = Math.toIntExact(Math.floorMod(ms, 1000L) * 1000000L);
        TimestampEncoding.writeTimestamp(seconds, nanos, output);
    }

    private static void writeTimestamp(long seconds, int nanos, SliceOutput output) {
        boolean hasSecondsHigh32 = seconds < 0L || seconds > Integer.MAX_VALUE;
        int nanosReversed = TimestampEncoding.reverseDecimal(nanos);
        int secondsLow32 = (int)seconds;
        secondsLow32 = nanosReversed == 0 && !hasSecondsHigh32 ? (secondsLow32 &= Integer.MAX_VALUE) : (secondsLow32 |= Integer.MIN_VALUE);
        output.writeInt(Integer.reverseBytes(secondsLow32));
        if (hasSecondsHigh32 || nanosReversed != 0) {
            int value = hasSecondsHigh32 ? ~nanosReversed : nanosReversed;
            RcFileDecoderUtils.writeVInt(output, value);
        }
        if (hasSecondsHigh32) {
            int secondsHigh32 = (int)(seconds >> 31);
            RcFileDecoderUtils.writeVInt(output, secondsHigh32);
        }
    }

    private static int reverseDecimal(int nanos) {
        int nan = nanos;
        int decimal = 0;
        if (nan != 0) {
            for (int counter = 0; counter < 9; ++counter) {
                decimal *= 10;
                decimal += nan % 10;
                nan /= 10;
            }
        }
        return decimal;
    }
}

