/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public class LongEncoding
implements TextColumnEncoding {
    private static final Slice MIN_LONG = Slices.utf8Slice((String)"-9223372036854775808");
    private final Type type;
    private final Slice nullSequence;
    private final StringBuilder buffer = new StringBuilder();

    public LongEncoding(Type type, Slice nullSequence) {
        this.type = type;
        this.nullSequence = nullSequence;
    }

    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) {
                output.writeBytes(this.nullSequence);
            } else {
                long value = this.type.getLong(block, position);
                this.buffer.setLength(0);
                this.buffer.append(value);
                for (int index = 0; index < this.buffer.length(); ++index) {
                    output.writeByte((int)this.buffer.charAt(index));
                }
            }
            encodeOutput.closeEntry();
        }
    }

    public void encodeValueInto(int depth, Block block, int position, SliceOutput output) {
        long value = this.type.getLong(block, position);
        this.buffer.setLength(0);
        this.buffer.append(value);
        for (int index = 0; index < this.buffer.length(); ++index) {
            output.writeByte((int)this.buffer.charAt(index));
        }
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int offset = columnData.getOffset(i);
            int length = columnData.getLength(i);
            if (length == 0 || this.nullSequence.equals(0, this.nullSequence.length(), slice, offset, length)) {
                builder.appendNull();
                continue;
            }
            this.type.writeLong(builder, LongEncoding.parseLong(slice, offset, length));
        }
        return builder.build();
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) {
        this.type.writeLong(builder, LongEncoding.parseLong(slice, offset, length));
    }

    private static long parseLong(Slice slice, int start, int length) {
        int sign;
        int startIndex = start;
        if (slice.equals(startIndex, length, MIN_LONG, 0, MIN_LONG.length())) {
            return Long.MIN_VALUE;
        }
        int limit = startIndex + length;
        if (slice.getByte(startIndex) == 45) {
            sign = -1;
            ++startIndex;
        } else {
            sign = 1;
        }
        long value = slice.getByte(startIndex) - 48;
        ++startIndex;
        while (startIndex < limit) {
            value = value * 10L + (long)(slice.getByte(startIndex) - 48);
            ++startIndex;
        }
        return value * (long)sign;
    }
}

