/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.RcFileCorruptionException;
import io.prestosql.rcfile.text.BlockEncoding;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public class MapEncoding
extends BlockEncoding {
    private final TextColumnEncoding keyEncoding;
    private final TextColumnEncoding valueEncoding;

    public MapEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte, TextColumnEncoding keyEncoding, TextColumnEncoding valueEncoding) {
        super(type, nullSequence, separators, escapeByte);
        this.keyEncoding = keyEncoding;
        this.valueEncoding = valueEncoding;
    }

    @Override
    public <T> void encodeValueInto(int depth, Block<T> block, int position, SliceOutput output) throws RcFileCorruptionException {
        byte elementSeparator = this.getSeparator(depth);
        byte keyValueSeparator = this.getSeparator(depth + 1);
        Block map = (Block)block.getObject(position, Block.class);
        boolean first = true;
        for (int elementIndex = 0; elementIndex < map.getPositionCount(); elementIndex += 2) {
            if (map.isNull(elementIndex)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Map must never contain null keys");
            }
            if (!first) {
                output.writeByte((int)elementSeparator);
            }
            first = false;
            this.keyEncoding.encodeValueInto(depth + 2, map, elementIndex, output);
            output.writeByte((int)keyValueSeparator);
            if (map.isNull(elementIndex + 1)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.valueEncoding.encodeValueInto(depth + 2, map, elementIndex + 1, output);
        }
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        int newOffset;
        byte elementSeparator = this.getSeparator(depth);
        byte keyValueSeparator = this.getSeparator(depth + 1);
        int end = newOffset + length;
        BlockBuilder mapBuilder = builder.beginBlockEntry();
        if (length > 0) {
            int elementOffset = newOffset;
            int keyValueSeparatorPosition = -1;
            for (newOffset = offset; newOffset < end; ++newOffset) {
                byte currentByte = slice.getByte(newOffset);
                if (currentByte == elementSeparator) {
                    this.decodeEntryInto(depth, mapBuilder, slice, elementOffset, newOffset - elementOffset, keyValueSeparatorPosition);
                    elementOffset = newOffset + 1;
                    keyValueSeparatorPosition = -1;
                    continue;
                }
                if (currentByte == keyValueSeparator && keyValueSeparatorPosition == -1) {
                    keyValueSeparatorPosition = newOffset;
                    continue;
                }
                if (!this.isEscapeByte(currentByte) || newOffset + 1 >= length) continue;
                ++newOffset;
            }
            this.decodeEntryInto(depth, mapBuilder, slice, elementOffset, newOffset - elementOffset, keyValueSeparatorPosition);
        }
        builder.closeEntry();
    }

    private void decodeEntryInto(int depth, BlockBuilder builder, Slice slice, int offset, int length, int keyValueSeparatorPosition) throws RcFileCorruptionException {
        int keyLength = keyValueSeparatorPosition == -1 ? length : keyValueSeparatorPosition - offset;
        if (this.isNullSequence(slice, offset, keyLength)) {
            return;
        }
        this.keyEncoding.decodeValueInto(depth + 2, builder, slice, offset, keyLength);
        if (keyValueSeparatorPosition == -1) {
            builder.appendNull();
        } else {
            int valueOffset = keyValueSeparatorPosition + 1;
            int valueLength = length - keyLength - 1;
            if (this.isNullSequence(slice, valueOffset, valueLength)) {
                builder.appendNull();
            } else {
                this.valueEncoding.decodeValueInto(depth + 2, builder, slice, valueOffset, valueLength);
            }
        }
    }
}

