/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.text;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.RcFileCorruptionException;
import io.prestosql.rcfile.text.BlockEncoding;
import io.prestosql.rcfile.text.TextColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import java.util.List;

public class StructEncoding
extends BlockEncoding {
    private final boolean lastColumnTakesRest;
    private final List<TextColumnEncoding> structFields;

    public StructEncoding(Type type, Slice nullSequence, byte[] separators, Byte escapeByte, boolean lastColumnTakesRest, List<TextColumnEncoding> structFields) {
        super(type, nullSequence, separators, escapeByte);
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.structFields = structFields;
    }

    @Override
    public <T> void encodeValueInto(int depth, Block<T> block, int position, SliceOutput output) throws RcFileCorruptionException {
        byte separator = this.getSeparator(depth);
        Block row = (Block)block.getObject(position, Block.class);
        for (int fieldIndex = 0; fieldIndex < this.structFields.size(); ++fieldIndex) {
            if (fieldIndex > 0) {
                output.writeByte((int)separator);
            }
            if (row.isNull(fieldIndex)) {
                output.writeBytes(this.nullSequence);
                continue;
            }
            this.structFields.get(fieldIndex).encodeValueInto(depth + 1, row, fieldIndex, output);
        }
    }

    @Override
    public void decodeValueInto(int depth, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        int newOffset;
        byte separator = this.getSeparator(depth);
        int end = newOffset + length;
        BlockBuilder structBuilder = builder.beginBlockEntry();
        int elementOffset = newOffset;
        int fieldIndex = 0;
        for (newOffset = offset; !(newOffset >= end || this.lastColumnTakesRest && fieldIndex >= this.structFields.size()); ++newOffset) {
            byte currentByte = slice.getByte(newOffset);
            if (currentByte == separator) {
                this.decodeElementValueInto(depth, fieldIndex, structBuilder, slice, elementOffset, newOffset - elementOffset);
                elementOffset = newOffset + 1;
                ++fieldIndex;
                continue;
            }
            if (!this.isEscapeByte(currentByte) || newOffset + 1 >= length) continue;
            ++newOffset;
        }
        this.decodeElementValueInto(depth, fieldIndex, structBuilder, slice, elementOffset, end - elementOffset);
        ++fieldIndex;
        while (fieldIndex < this.structFields.size()) {
            structBuilder.appendNull();
            ++fieldIndex;
        }
        builder.closeEntry();
    }

    private void decodeElementValueInto(int depth, int fieldIndex, BlockBuilder builder, Slice slice, int offset, int length) throws RcFileCorruptionException {
        if (fieldIndex > this.structFields.size()) {
            return;
        }
        if (this.isNullSequence(slice, offset, length)) {
            builder.appendNull();
        } else {
            this.structFields.get(fieldIndex).decodeValueInto(depth + 1, builder, slice, offset, length);
        }
    }
}

