/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.ConcurrentLazyQueue;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.DirectoryLister;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HivePartitionMetadata;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.NamenodeStats;
import io.prestosql.plugin.hive.S3SelectPushdown;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.HiveFileIterator;
import io.prestosql.plugin.hive.util.InternalHiveSplitFactory;
import io.prestosql.plugin.hive.util.ResumableTask;
import io.prestosql.plugin.hive.util.ResumableTasks;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.spi.type.TypeManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidCompactorWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.common.util.Ref;
import org.apache.hudi.hadoop.HoodieParquetInputFormat;
import org.apache.hudi.hadoop.HoodieROTablePathFilter;
import org.apache.hudi.hadoop.realtime.HoodieParquetRealtimeInputFormat;

public class BackgroundHiveSplitLoader
implements HiveSplitLoader {
    private static final Logger LOG = Logger.get(BackgroundHiveSplitLoader.class);
    private static final Pattern DELETE_DELTA_PATTERN = Pattern.compile("delete_delta_(\\d+)_(\\d+)(_\\d+)?");
    private static final ListenableFuture<?> COMPLETED_FUTURE = Futures.immediateFuture(null);
    private final Table table;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final Optional<BucketSplitInfo> tableBucketInfo;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final NamenodeStats namenodeStats;
    private final DirectoryLister directoryLister;
    private final int loaderConcurrency;
    private final boolean recursiveDirWalkerEnabled;
    private final Executor executor;
    private final ConnectorSession session;
    private final ConcurrentLazyQueue<HivePartitionMetadata> partitions;
    private final Deque<Iterator<InternalHiveSplit>> fileIterators = new ConcurrentLinkedDeque<Iterator<InternalHiveSplit>>();
    private final Optional<ValidWriteIdList> validWriteIds;
    private final Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier;
    private final Configuration configuration;
    private final Supplier<HoodieROTablePathFilter> hoodiePathFilterSupplier;
    private final ReentrantReadWriteLock taskExecutionLock = new ReentrantReadWriteLock();
    private HiveSplitSource hiveSplitSource;
    private volatile boolean stopped;
    private Optional<QueryType> queryType;
    private Map<String, Object> queryInfo;
    private TypeManager typeManager;
    private JobConf jobConf;
    private final Map<ColumnHandle, DynamicFilter> cachedDynamicFilters = new ConcurrentHashMap<ColumnHandle, DynamicFilter>();

    public BackgroundHiveSplitLoader(Table table, Iterable<HivePartitionMetadata> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, Optional<BucketSplitInfo> tableBucketInfo, ConnectorSession session, HdfsEnvironment hdfsEnvironment, NamenodeStats namenodeStats, DirectoryLister directoryLister, Executor executor, int loaderConcurrency, boolean recursiveDirWalkerEnabled, Optional<ValidWriteIdList> validWriteIds, Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier, Optional<QueryType> queryType, Map<String, Object> queryInfo, TypeManager typeManager) {
        this.table = table;
        this.compactEffectivePredicate = compactEffectivePredicate;
        this.tableBucketInfo = tableBucketInfo;
        this.loaderConcurrency = loaderConcurrency;
        this.typeManager = typeManager;
        this.session = session;
        this.hdfsEnvironment = hdfsEnvironment;
        this.namenodeStats = namenodeStats;
        this.directoryLister = directoryLister;
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        this.executor = executor;
        this.hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        this.validWriteIds = Objects.requireNonNull(validWriteIds, "validWriteIds is null");
        this.dynamicFilterSupplier = dynamicFilterSupplier;
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.queryInfo = Objects.requireNonNull(queryInfo, "queryproperties is null");
        this.partitions = new ConcurrentLazyQueue<HivePartitionMetadata>(this.getPrunedPartitions(partitions));
        Path path = new Path(MetastoreUtil.getPartitionLocation(table, this.getPrunedPartitions(partitions).iterator().next().getPartition()));
        this.configuration = hdfsEnvironment.getConfiguration(this.hdfsContext, path);
        this.jobConf = ConfigurationUtils.toJobConf(this.configuration);
        this.hoodiePathFilterSupplier = Suppliers.memoize(() -> new HoodieROTablePathFilter(this.configuration));
    }

    private Iterable<HivePartitionMetadata> getPrunedPartitions(Iterable<HivePartitionMetadata> partitions) {
        String vacuumPartition;
        if (AcidUtils.isTransactionalTable(this.table.getParameters()) && this.queryType.map(t -> t == QueryType.VACUUM).orElse(false).booleanValue() && (vacuumPartition = (String)this.queryInfo.get("partition")) != null && !vacuumPartition.isEmpty()) {
            ArrayList list = new ArrayList();
            for (HivePartitionMetadata next : partitions) {
                if (!vacuumPartition.equals(next.getHivePartition().getPartitionId())) continue;
                return ImmutableList.of((Object)next);
            }
        }
        return partitions;
    }

    @Override
    public void start(HiveSplitSource splitSource) {
        this.hiveSplitSource = splitSource;
        for (int i = 0; i < this.loaderConcurrency; ++i) {
            ResumableTasks.submit(this.executor, new HiveSplitLoaderTask());
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private void invokeNoMoreSplitsIfNecessary() {
        this.taskExecutionLock.readLock().lock();
        try {
            if (!this.partitions.isEmpty() || !this.fileIterators.isEmpty()) {
                return;
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
            return;
        }
        finally {
            this.taskExecutionLock.readLock().unlock();
        }
        this.taskExecutionLock.writeLock().lock();
        try {
            if (this.partitions.isEmpty() && this.fileIterators.isEmpty()) {
                this.hiveSplitSource.noMoreSplits();
            }
        }
        catch (Exception e) {
            this.hiveSplitSource.fail(e);
            Preconditions.checkState((boolean)this.stopped, (Object)"Task is not marked as stopped even though it failed");
        }
        finally {
            this.taskExecutionLock.writeLock().unlock();
        }
    }

    private ListenableFuture<?> loadSplits() throws IOException {
        Iterator<InternalHiveSplit> splits = this.fileIterators.poll();
        if (splits == null) {
            HivePartitionMetadata partition = this.partitions.poll();
            if (partition == null) {
                return COMPLETED_FUTURE;
            }
            return this.loadPartition(partition);
        }
        while (splits.hasNext() && !this.stopped) {
            ListenableFuture<?> future = this.hiveSplitSource.addToQueue(splits.next());
            if (future.isDone()) continue;
            this.fileIterators.addFirst(splits);
            return future;
        }
        return COMPLETED_FUTURE;
    }

    private ListenableFuture<?> loadPartition(HivePartitionMetadata partition) throws IOException {
        Optional<DeleteDeltaLocations> deleteDeltaLocations;
        Object readPaths;
        AcidUtils.Directory directory;
        HivePartition hivePartition = partition.getHivePartition();
        String partitionName = hivePartition.getPartitionId();
        Properties schema = BackgroundHiveSplitLoader.getPartitionSchema(this.table, partition.getPartition());
        List<HivePartitionKey> partitionKeys = BackgroundHiveSplitLoader.getPartitionKeys(this.table, partition.getPartition());
        TupleDomain<? extends ColumnHandle> effectivePredicate = this.compactEffectivePredicate;
        if (this.dynamicFilterSupplier != null && HiveSessionProperties.isDynamicFilteringSplitFilteringEnabled(this.session) && HiveUtil.isPartitionFiltered(partitionKeys, this.dynamicFilterSupplier.get(), this.typeManager)) {
            return COMPLETED_FUTURE;
        }
        Path path = new Path(MetastoreUtil.getPartitionLocation(this.table, partition.getPartition()));
        InputFormat<?, ?> inputFormat = HiveUtil.getInputFormat(this.configuration, schema, false, this.jobConf);
        FileSystem fs = this.hdfsEnvironment.getFileSystem(this.hdfsContext, path);
        boolean s3SelectPushdownEnabled = S3SelectPushdown.shouldEnablePushdownForTable(this.session, this.table, path.toString(), partition.getPartition());
        if (inputFormat instanceof SymlinkTextInputFormat) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketed table in SymlinkTextInputFormat is not yet supported");
            }
            ListenableFuture<?> lastResult = COMPLETED_FUTURE;
            for (Path targetPath : BackgroundHiveSplitLoader.getTargetPathsFromSymlink(fs, path)) {
                TextInputFormat targetInputFormat = new TextInputFormat();
                FileSystem targetFilesystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, targetPath);
                this.jobConf.setInputFormat(TextInputFormat.class);
                targetInputFormat.configure(this.jobConf);
                FileInputFormat.setInputPaths((JobConf)this.jobConf, (Path[])new Path[]{targetPath});
                InputSplit[] targetSplits = targetInputFormat.getSplits(this.jobConf, 0);
                InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(targetFilesystem, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions(), Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
                lastResult = this.addSplitsToSource(targetSplits, splitFactory);
                if (!this.stopped) continue;
                return COMPLETED_FUTURE;
            }
            return lastResult;
        }
        Optional<HiveSplit.BucketConversion> bucketConversion = Optional.empty();
        boolean bucketConversionRequiresWorkerParticipation = false;
        if (partition.getPartition().isPresent()) {
            Optional<HiveBucketProperty> partitionBucketProperty = partition.getPartition().get().getStorage().getBucketProperty();
            if (this.tableBucketInfo.isPresent() && partitionBucketProperty.isPresent()) {
                int readBucketCount = this.tableBucketInfo.get().getReadBucketCount();
                HiveBucketing.BucketingVersion bucketingVersion = partitionBucketProperty.get().getBucketingVersion();
                int partitionBucketCount = partitionBucketProperty.get().getBucketCount();
                if (readBucketCount != partitionBucketCount) {
                    bucketConversion = Optional.of(new HiveSplit.BucketConversion(bucketingVersion, readBucketCount, partitionBucketCount, this.tableBucketInfo.get().getBucketColumns()));
                    if (readBucketCount > partitionBucketCount) {
                        bucketConversionRequiresWorkerParticipation = true;
                    }
                }
            }
        }
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory(fs, partitionName, inputFormat, schema, partitionKeys, effectivePredicate, partition.getColumnCoercions(), bucketConversionRequiresWorkerParticipation ? bucketConversion : Optional.empty(), HiveSessionProperties.isForceLocalScheduling(this.session), s3SelectPushdownEnabled);
        if (!BackgroundHiveSplitLoader.isHudiParquetInputFormat(inputFormat) && BackgroundHiveSplitLoader.shouldUseFileSplitsFromInputFormat(inputFormat)) {
            if (this.tableBucketInfo.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Presto cannot read bucketed partition in an input format with UseFileSplitsFromInputFormat annotation: " + inputFormat.getClass().getSimpleName());
            }
            if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive transactional tables in an input format with UseFileSplitsFromInputFormat annotation are not supported: " + inputFormat.getClass().getSimpleName());
            }
            FileInputFormat.setInputPaths((JobConf)this.jobConf, (Path[])new Path[]{path});
            InputSplit[] splits = inputFormat.getSplits(this.jobConf, 0);
            return this.addSplitsToSource(splits, splitFactory);
        }
        PathFilter pathFilter = BackgroundHiveSplitLoader.isHudiParquetInputFormat(inputFormat) ? (PathFilter)this.hoodiePathFilterSupplier.get() : path1 -> true;
        boolean splittable = HiveUtil.getHeaderCount(schema) == 0 && HiveUtil.getFooterCount(schema) == 0 && !s3SelectPushdownEnabled;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        if (AcidUtils.isTransactionalTable(this.table.getParameters())) {
            Object vacuumHandle;
            boolean isFullVacuum;
            boolean isVacuum = this.queryType.map(type -> type == QueryType.VACUUM).orElse(false);
            directory = this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> {
                Object writeIdList = this.validWriteIds.orElseThrow(() -> new IllegalStateException("No validWriteIds present"));
                if (isVacuum) {
                    writeIdList = new ValidCompactorWriteIdList(writeIdList.writeToString()){

                        public ValidWriteIdList.RangeResponse isWriteIdRangeValid(long minWriteId, long maxWriteId) {
                            ValidWriteIdList.RangeResponse writeIdRangeValid = super.isWriteIdRangeValid(minWriteId, maxWriteId);
                            if (writeIdRangeValid == ValidWriteIdList.RangeResponse.NONE) {
                                return ValidWriteIdList.RangeResponse.NONE;
                            }
                            if (super.isWriteIdRangeAborted(minWriteId, maxWriteId) == ValidWriteIdList.RangeResponse.ALL) {
                                return ValidWriteIdList.RangeResponse.NONE;
                            }
                            return writeIdRangeValid;
                        }
                    };
                }
                return AcidUtils.getAcidState((Path)path, (Configuration)this.configuration, (ValidWriteIdList)writeIdList, (Ref)Ref.from((Object)false), (boolean)true, this.table.getParameters());
            });
            if (AcidUtils.isFullAcidTable(this.table.getParameters())) {
                Path baseOrDeltaPath;
                Object object = directory.getBaseDirectory() != null ? directory.getBaseDirectory() : (baseOrDeltaPath = directory.getCurrentDirectories().size() > 0 ? ((AcidUtils.ParsedDelta)directory.getCurrentDirectories().get(0)).getPath() : null);
                if (baseOrDeltaPath != null && AcidUtils.OrcAcidVersion.getAcidVersionFromMetaFile((Path)baseOrDeltaPath, (FileSystem)fs) < 2) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive transactional tables are supported with Hive 3.0 and only after a major compaction has been run");
                }
            }
            readPaths = new ArrayList();
            boolean bl = isFullVacuum = isVacuum ? Boolean.valueOf(this.queryInfo.get("FULL").toString()) : false;
            if (isFullVacuum) {
                min = 0L;
            }
            if (directory.getBaseDirectory() != null && (!isVacuum || isFullVacuum)) {
                readPaths.add(directory.getBaseDirectory());
                if (isVacuum) {
                    min = 0L;
                    max = AcidUtils.parseBase((Path)directory.getBaseDirectory());
                }
            }
            for (Object delta : directory.getCurrentDirectories()) {
                if (!delta.isDeleteDelta()) {
                    readPaths.add(delta.getPath());
                } else if (isVacuum && !isFullVacuum) {
                    readPaths.add(delta.getPath());
                }
                if (!isVacuum) continue;
                min = Math.min(delta.getMinWriteId(), min);
                max = Math.max(delta.getMaxWriteId(), max);
            }
            DeleteDeltaLocations.Builder deleteDeltaLocationsBuilder = DeleteDeltaLocations.builder(path);
            for (AcidUtils.ParsedDelta delta : directory.getCurrentDirectories()) {
                if (!delta.isDeleteDelta() || isVacuum && !isFullVacuum) continue;
                OptionalInt statementId = BackgroundHiveSplitLoader.getStatementId(delta.getPath().getName());
                int stmtId = statementId.orElse(0);
                deleteDeltaLocationsBuilder.addDeleteDelta(delta.getPath(), delta.getMinWriteId(), delta.getMaxWriteId(), stmtId);
            }
            deleteDeltaLocations = deleteDeltaLocationsBuilder.build();
            if (!directory.getOriginalFiles().isEmpty()) {
                LOG.info("Now supporting read from non-ACID files in ACID reader");
                int numberOfBuckets = Integer.parseInt(schema.getProperty("bucket_count"));
                long[] bucketStartRowOffset = new long[Integer.max(numberOfBuckets, 1)];
                for (HadoopShims.HdfsFileStatusWithId f : directory.getOriginalFiles()) {
                    Path currFilePath = f.getFileStatus().getPath();
                    int currBucketNumber = HiveUtil.getBucketNumber(currFilePath.getName()).getAsInt();
                    this.fileIterators.addLast(this.createInternalHiveSplitIterator(currFilePath, fs, splitFactory, splittable, deleteDeltaLocations, Optional.of(bucketStartRowOffset[currBucketNumber]), pathFilter));
                    try {
                        Reader copyReader = OrcFile.createReader((Path)f.getFileStatus().getPath(), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.configuration));
                        int n = currBucketNumber;
                        bucketStartRowOffset[n] = bucketStartRowOffset[n] + copyReader.getNumberOfRows();
                    }
                    catch (Exception e) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, e.getMessage());
                    }
                }
            }
            if (isVacuum && !readPaths.isEmpty() && (vacuumHandle = this.queryInfo.get("vacuumHandle")) != null && vacuumHandle instanceof HiveVacuumTableHandle) {
                HiveVacuumTableHandle hiveVacuumTableHandle = (HiveVacuumTableHandle)vacuumHandle;
                hiveVacuumTableHandle.addRange(partitionName, new HiveVacuumTableHandle.Range(min, max));
            }
        } else {
            readPaths = ImmutableList.of((Object)path);
            deleteDeltaLocations = Optional.empty();
        }
        if (this.tableBucketInfo.isPresent()) {
            ListenableFuture<?> lastResult = Futures.immediateFuture(null);
            directory = readPaths.iterator();
            while (directory.hasNext()) {
                Path readPath = (Path)directory.next();
                lastResult = this.hiveSplitSource.addToQueue(this.getBucketedSplits(readPath, fs, splitFactory, this.tableBucketInfo.get(), bucketConversion, this.getDeleteDeltaLocationFor(readPath, deleteDeltaLocations), pathFilter));
            }
            return lastResult;
        }
        Iterator iterator = readPaths.iterator();
        while (iterator.hasNext()) {
            Path readPath = (Path)iterator.next();
            this.fileIterators.addLast(this.createInternalHiveSplitIterator(readPath, fs, splitFactory, splittable, this.getDeleteDeltaLocationFor(readPath, deleteDeltaLocations), Optional.empty(), pathFilter));
        }
        return COMPLETED_FUTURE;
    }

    private Optional<DeleteDeltaLocations> getDeleteDeltaLocationFor(Path readPath, Optional<DeleteDeltaLocations> allDeleteDeltaLocations) {
        if (!allDeleteDeltaLocations.isPresent() || allDeleteDeltaLocations.get().getDeleteDeltas().isEmpty()) {
            return allDeleteDeltaLocations;
        }
        Long sourceWriteId = AcidUtils.extractWriteId((Path)readPath);
        sourceWriteId = sourceWriteId == null ? 0L : sourceWriteId;
        if (sourceWriteId == 0L) {
            return allDeleteDeltaLocations;
        }
        long sId = sourceWriteId;
        DeleteDeltaLocations allLocations = allDeleteDeltaLocations.get();
        List<WriteIdInfo> filteredWriteIds = allLocations.getDeleteDeltas().stream().filter(writeIdInfo -> writeIdInfo.getMaxWriteId() > sId).collect(Collectors.toList());
        if (filteredWriteIds.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DeleteDeltaLocations(allLocations.getPartitionLocation(), filteredWriteIds));
    }

    private ListenableFuture<?> addSplitsToSource(InputSplit[] targetSplits, InternalHiveSplitFactory splitFactory) throws IOException {
        ListenableFuture<?> lastResult = COMPLETED_FUTURE;
        for (InputSplit inputSplit : targetSplits) {
            Optional<InternalHiveSplit> internalHiveSplit = splitFactory.createInternalHiveSplit((FileSplit)inputSplit);
            if (internalHiveSplit.isPresent()) {
                lastResult = this.hiveSplitSource.addToQueue(internalHiveSplit.get());
            }
            if (!this.stopped) continue;
            return COMPLETED_FUTURE;
        }
        return lastResult;
    }

    private static boolean isHudiParquetInputFormat(InputFormat<?, ?> inputFormat) {
        if (inputFormat instanceof HoodieParquetRealtimeInputFormat) {
            return false;
        }
        return inputFormat instanceof HoodieParquetInputFormat;
    }

    private static boolean shouldUseFileSplitsFromInputFormat(InputFormat<?, ?> inputFormat) {
        return Arrays.stream(inputFormat.getClass().getAnnotations()).map(Annotation::annotationType).map(Class::getSimpleName).anyMatch(name -> name.equals("UseFileSplitsFromInputFormat"));
    }

    private Iterator<InternalHiveSplit> createInternalHiveSplitIterator(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, boolean splittable, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, PathFilter pathFilter) {
        return Streams.stream((Iterator)((Object)new HiveFileIterator(this.table, path, fileSystem, this.directoryLister, this.namenodeStats, this.recursiveDirWalkerEnabled ? HiveFileIterator.NestedDirectoryPolicy.RECURSE : HiveFileIterator.NestedDirectoryPolicy.IGNORED, pathFilter))).map(status -> splitFactory.createInternalHiveSplit((LocatedFileStatus)status, splittable, deleteDeltaLocations, startRowOffsetOfFile)).filter(Optional::isPresent).map(Optional::get).iterator();
    }

    /*
     * WARNING - void declaration
     */
    private List<InternalHiveSplit> getBucketedSplits(Path path, FileSystem fileSystem, InternalHiveSplitFactory splitFactory, BucketSplitInfo bucketSplitInfo, Optional<HiveSplit.BucketConversion> bucketConversion, Optional<DeleteDeltaLocations> deleteDeltaLocations, PathFilter pathFilter) {
        void var15_18;
        int readBucketCount = bucketSplitInfo.getReadBucketCount();
        int tableBucketCount = bucketSplitInfo.getTableBucketCount();
        int partitionBucketCount = bucketConversion.map(HiveSplit.BucketConversion::getPartitionBucketCount).orElse(tableBucketCount);
        int bucketCount = Math.max(readBucketCount, partitionBucketCount);
        ArrayList files = new ArrayList(partitionBucketCount);
        try {
            Iterators.addAll(files, (Iterator)((Object)new HiveFileIterator(this.table, path, fileSystem, this.directoryLister, this.namenodeStats, HiveFileIterator.NestedDirectoryPolicy.FAIL, pathFilter)));
        }
        catch (HiveFileIterator.NestedDirectoryNotAllowedException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. Found sub-directory in bucket directory for partition: %s", this.table.getSchemaTableName(), splitFactory.getPartitionName()));
        }
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        for (LocatedFileStatus locatedFileStatus : files) {
            String fileName = locatedFileStatus.getPath().getName();
            OptionalInt bucket = HiveUtil.getBucketNumber(fileName);
            if (bucket.isPresent()) {
                bucketFiles.put((Object)bucket.getAsInt(), (Object)locatedFileStatus);
                continue;
            }
            if (files.size() != partitionBucketCount) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("Hive table '%s' is corrupt. File '%s' does not match the standard naming pattern, and the number of files in the directory (%s) does not match the declared bucket count (%s) for partition: %s", this.table.getSchemaTableName(), fileName, files.size(), partitionBucketCount, splitFactory.getPartitionName()));
            }
            files.sort(null);
            bucketFiles.clear();
            for (int i = 0; i < files.size(); ++i) {
                bucketFiles.put((Object)i, files.get(i));
            }
        }
        ArrayList<InternalHiveSplit> splitList = new ArrayList<InternalHiveSplit>();
        boolean bl = false;
        while (var15_18 < bucketCount) {
            void partitionBucketNumber = var15_18 % partitionBucketCount;
            void readBucketNumber = var15_18 % readBucketCount;
            boolean containsEligibleTableBucket = false;
            boolean containsIneligibleTableBucket = false;
            for (void tableBucketNumber = var15_18 % tableBucketCount; tableBucketNumber < tableBucketCount; tableBucketNumber += bucketCount) {
                if (bucketSplitInfo.isTableBucketEnabled((int)tableBucketNumber)) {
                    containsEligibleTableBucket = true;
                    continue;
                }
                containsIneligibleTableBucket = true;
            }
            if (containsEligibleTableBucket && containsIneligibleTableBucket) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The bucket filter cannot be satisfied. There are restrictions on the bucket filter when all the following is true: 1. a table has a different buckets count as at least one of its partitions that is read in this query; 2. the table has a different but compatible bucket number with another table in the query; 3. some buckets of the table is filtered out from the query, most likely using a filter on \"$bucket\". (table name: " + this.table.getTableName() + ", table bucket count: " + tableBucketCount + ", partition bucket count: " + partitionBucketCount + ", effective reading bucket count: " + readBucketCount + ")");
            }
            if (containsEligibleTableBucket) {
                for (LocatedFileStatus file : bucketFiles.get((Object)((int)partitionBucketNumber))) {
                    splitFactory.createInternalHiveSplit(file, (int)readBucketNumber, deleteDeltaLocations).ifPresent(splitList::add);
                }
            }
            ++var15_18;
        }
        return splitList;
    }

    static OptionalInt getStatementId(String deleteDeltaFileName) {
        Matcher matcher = DELETE_DELTA_PATTERN.matcher(deleteDeltaFileName);
        if (matcher.matches()) {
            String statementId = matcher.group(3);
            if (statementId == null) {
                return OptionalInt.of(-1);
            }
            return OptionalInt.of(Integer.valueOf(statementId.substring(1)));
        }
        return OptionalInt.empty();
    }

    private static List<Path> getTargetPathsFromSymlink(FileSystem fileSystem, Path symlinkDir) {
        try {
            FileStatus[] symlinks = fileSystem.listStatus(symlinkDir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            ArrayList<Path> targets = new ArrayList<Path>();
            for (FileStatus symlink : symlinks) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath()), StandardCharsets.UTF_8));){
                    CharStreams.readLines((Readable)reader).stream().map(Path::new).forEach(targets::add);
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "Error parsing symlinks from: " + symlinkDir, (Throwable)e);
        }
    }

    private static List<HivePartitionKey> getPartitionKeys(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder partitionKeys = ImmutableList.builder();
        List<Column> keys = table.getPartitionColumns();
        List<String> values = partition.get().getValues();
        HiveUtil.checkCondition(keys.size() == values.size(), HiveErrorCode.HIVE_INVALID_METADATA, "Expected %s partition key values, but got %s", keys.size(), values.size());
        for (int i = 0; i < keys.size(); ++i) {
            String name = keys.get(i).getName();
            HiveType hiveType = keys.get(i).getType();
            if (!hiveType.isSupportedType()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Hive type %s found in partition keys of table %s.%s", hiveType, table.getDatabaseName(), table.getTableName()));
            }
            String value = values.get(i);
            HiveUtil.checkCondition(value != null, HiveErrorCode.HIVE_INVALID_PARTITION_VALUE, "partition key value cannot be null for field: %s", name);
            partitionKeys.add((Object)new HivePartitionKey(name, value));
        }
        return partitionKeys.build();
    }

    private static Properties getPartitionSchema(Table table, Optional<Partition> partition) {
        if (!partition.isPresent()) {
            return MetastoreUtil.getHiveSchema(table);
        }
        return MetastoreUtil.getHiveSchema(partition.get(), table);
    }

    public Table getTable() {
        return this.table;
    }

    public static class BucketSplitInfo {
        private final List<HiveColumnHandle> bucketColumns;
        private final int tableBucketCount;
        private final int readBucketCount;
        private final IntPredicate bucketFilter;

        public static Optional<BucketSplitInfo> createBucketSplitInfo(Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
            int localReadBucketCount;
            Objects.requireNonNull(bucketHandle, "bucketHandle is null");
            Objects.requireNonNull(bucketFilter, "buckets is null");
            if (!bucketHandle.isPresent()) {
                Preconditions.checkArgument((!bucketFilter.isPresent() ? 1 : 0) != 0, (Object)"bucketHandle must be present if bucketFilter is present");
                return Optional.empty();
            }
            int localTableBucketCount = bucketHandle.get().getTableBucketCount();
            if (localTableBucketCount != (localReadBucketCount = bucketHandle.get().getReadBucketCount()) && bucketFilter.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Filter on \"$bucket\" is not supported when the table has partitions with different bucket counts");
            }
            List<HiveColumnHandle> localBucketColumns = bucketHandle.get().getColumns();
            IntPredicate predicate = bucketFilter.map(filter -> filter.getBucketsToKeep()::contains).orElse(bucket -> true);
            return Optional.of(new BucketSplitInfo(localBucketColumns, localTableBucketCount, localReadBucketCount, predicate));
        }

        private BucketSplitInfo(List<HiveColumnHandle> bucketColumns, int tableBucketCount, int readBucketCount, IntPredicate bucketFilter) {
            this.bucketColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumns, "bucketColumns is null"));
            this.tableBucketCount = tableBucketCount;
            this.readBucketCount = readBucketCount;
            this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        }

        public List<HiveColumnHandle> getBucketColumns() {
            return this.bucketColumns;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getReadBucketCount() {
            return this.readBucketCount;
        }

        public boolean isTableBucketEnabled(int tableBucketNumber) {
            return this.bucketFilter.test(tableBucketNumber);
        }
    }

    private class HiveSplitLoaderTask
    implements ResumableTask {
        private HiveSplitLoaderTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResumableTask.TaskStatus process() {
            ListenableFuture future;
            do {
                if (BackgroundHiveSplitLoader.this.stopped) {
                    return ResumableTask.TaskStatus.finished();
                }
                BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().lock();
                try {
                    future = BackgroundHiveSplitLoader.this.hdfsEnvironment.doAs(BackgroundHiveSplitLoader.this.hdfsContext.getIdentity().getUser(), () -> BackgroundHiveSplitLoader.this.loadSplits());
                }
                catch (Exception e2) {
                    PrestoException e2;
                    if (e2 instanceof IOException) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, (Throwable)e2);
                    } else if (!(e2 instanceof PrestoException)) {
                        e2 = new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, (Throwable)e2);
                    }
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e2);
                    Preconditions.checkState((boolean)BackgroundHiveSplitLoader.this.stopped);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                catch (Error e) {
                    BackgroundHiveSplitLoader.this.hiveSplitSource.fail(e);
                    ResumableTask.TaskStatus taskStatus = ResumableTask.TaskStatus.finished();
                    return taskStatus;
                }
                finally {
                    BackgroundHiveSplitLoader.this.taskExecutionLock.readLock().unlock();
                }
                BackgroundHiveSplitLoader.this.invokeNoMoreSplitsIfNecessary();
            } while (future.isDone());
            return ResumableTask.TaskStatus.continueOn(future);
        }
    }
}

