/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.spi.util.SizeOf;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.openjdk.jol.info.ClassLayout;

public class DeleteDeltaLocations {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(DeleteDeltaLocations.class).instanceSize();
    private final String partitionLocation;
    private final List<WriteIdInfo> deleteDeltas;

    @JsonCreator
    public DeleteDeltaLocations(@JsonProperty(value="partitionLocation") String partitionLocation, @JsonProperty(value="deleteDeltas") List<WriteIdInfo> deleteDeltas) {
        this.partitionLocation = Objects.requireNonNull(partitionLocation, "partitionLocation is null");
        this.deleteDeltas = ImmutableList.copyOf((Collection)Objects.requireNonNull(deleteDeltas, "deleteDeltas is null"));
        Preconditions.checkArgument((!deleteDeltas.isEmpty() ? 1 : 0) != 0, (Object)"deleteDeltas is empty");
    }

    @JsonProperty
    public String getPartitionLocation() {
        return this.partitionLocation;
    }

    @JsonProperty
    public List<WriteIdInfo> getDeleteDeltas() {
        return this.deleteDeltas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteDeltaLocations that = (DeleteDeltaLocations)o;
        return this.partitionLocation.equals(that.partitionLocation) && this.deleteDeltas.equals(that.deleteDeltas);
    }

    public int hashCode() {
        return Objects.hash(this.partitionLocation, this.deleteDeltas);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionLocation", (Object)this.partitionLocation).add("deleteDeltas", this.deleteDeltas).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.partitionLocation);
    }

    public static Builder builder(Path partitionPath) {
        return new Builder(partitionPath);
    }

    public static class Builder {
        private final Path partitionLocation;
        private final ImmutableList.Builder<WriteIdInfo> deleteDeltaInfoBuilder = ImmutableList.builder();

        private Builder(Path partitionPath) {
            this.partitionLocation = Objects.requireNonNull(partitionPath, "partitionPath is null");
        }

        public Builder addDeleteDelta(Path deleteDeltaPath, long minWriteId, long maxWriteId, int statementId) {
            Objects.requireNonNull(deleteDeltaPath, "deleteDeltaPath is null");
            Path partitionPathFromDeleteDelta = deleteDeltaPath.getParent();
            Preconditions.checkArgument((boolean)this.partitionLocation.equals((Object)partitionPathFromDeleteDelta), (String)"Partition location in DeleteDelta '%s' does not match stored location '%s'", (Object)deleteDeltaPath.getParent().toString(), (Object)this.partitionLocation);
            this.deleteDeltaInfoBuilder.add((Object)new WriteIdInfo(minWriteId, maxWriteId, statementId));
            return this;
        }

        public Optional<DeleteDeltaLocations> build() {
            ImmutableList localDeleteDeltas = this.deleteDeltaInfoBuilder.build();
            if (localDeleteDeltas.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new DeleteDeltaLocations(this.partitionLocation.toString(), (List<WriteIdInfo>)localDeleteDeltas));
        }
    }
}

