/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.prestosql.hadoop.SocksSocketFactory;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.s3.ConfigurationInitializer;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.orc.OrcConf;

public class HdfsConfigurationInitializer {
    private final HostAndPort socksProxy;
    private final Duration ipcPingInterval;
    private final Duration dfsTimeout;
    private final Duration dfsConnectTimeout;
    private final int dfsConnectMaxRetries;
    private final int dfsKeyProviderCacheTtlMillis;
    private final String domainSocketPath;
    private final Configuration resourcesConfiguration;
    private final HiveCompressionCodec compressionCodec;
    private final int fileSystemMaxCacheSize;
    private final Set<ConfigurationInitializer> configurationInitializers;
    private final boolean isHdfsWireEncryptionEnabled;
    private int textMaxLineLength;

    @VisibleForTesting
    public HdfsConfigurationInitializer(HiveConfig config) {
        this(config, (Set<ConfigurationInitializer>)ImmutableSet.of());
    }

    @Inject
    public HdfsConfigurationInitializer(HiveConfig config, Set<ConfigurationInitializer> configurationInitializers) {
        Objects.requireNonNull(config, "config is null");
        Preconditions.checkArgument((config.getDfsTimeout().toMillis() >= 1L ? 1 : 0) != 0, (Object)"dfsTimeout must be at least 1 ms");
        Preconditions.checkArgument((Math.toIntExact(config.getTextMaxLineLength().toBytes()) >= 1 ? 1 : 0) != 0, (Object)"textMaxLineLength must be at least 1 byte");
        this.socksProxy = config.getMetastoreSocksProxy();
        this.ipcPingInterval = config.getIpcPingInterval();
        this.dfsTimeout = config.getDfsTimeout();
        this.dfsConnectTimeout = config.getDfsConnectTimeout();
        this.dfsConnectMaxRetries = config.getDfsConnectMaxRetries();
        this.dfsKeyProviderCacheTtlMillis = Math.toIntExact(config.getDfsKeyProviderCacheTtl().toMillis());
        this.domainSocketPath = config.getDomainSocketPath();
        this.resourcesConfiguration = HdfsConfigurationInitializer.readConfiguration(config.getResourceConfigFiles());
        this.compressionCodec = config.getHiveCompressionCodec();
        this.fileSystemMaxCacheSize = config.getFileSystemMaxCacheSize();
        this.isHdfsWireEncryptionEnabled = config.isHdfsWireEncryptionEnabled();
        this.textMaxLineLength = Math.toIntExact(config.getTextMaxLineLength().toBytes());
        this.configurationInitializers = ImmutableSet.copyOf((Collection)Objects.requireNonNull(configurationInitializers, "configurationInitializers is null"));
    }

    private static Configuration readConfiguration(List<String> resourcePaths) {
        Configuration result = new Configuration(false);
        for (String resourcePath : resourcePaths) {
            Configuration resourceProperties = new Configuration(false);
            resourceProperties.addResource(new Path(resourcePath));
            ConfigurationUtils.copy(resourceProperties, result);
        }
        return result;
    }

    public void initializeConfiguration(Configuration config) {
        ConfigurationUtils.copy(this.resourcesConfiguration, config);
        config.setClass("net.topology.node.switch.mapping.impl", NoOpDNSToSwitchMapping.class, DNSToSwitchMapping.class);
        if (this.socksProxy != null) {
            config.setClass("hadoop.rpc.socket.factory.class.default", SocksSocketFactory.class, SocketFactory.class);
            config.set("hadoop.socks.server", this.socksProxy.toString());
        }
        if (this.domainSocketPath != null) {
            config.setStrings("dfs.domain.socket.path", new String[]{this.domainSocketPath});
        }
        if (!config.get("dfs.domain.socket.path", "").trim().isEmpty()) {
            config.setBooleanIfUnset(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        }
        config.setInt("dfs.client.socket-timeout", Math.toIntExact(this.dfsTimeout.toMillis()));
        config.setInt("ipc.ping.interval", Math.toIntExact(this.ipcPingInterval.toMillis()));
        config.setInt("ipc.client.connect.timeout", Math.toIntExact(this.dfsConnectTimeout.toMillis()));
        config.setInt("ipc.client.connect.max.retries", this.dfsConnectMaxRetries);
        if (this.isHdfsWireEncryptionEnabled) {
            config.set("hadoop.rpc.protection", "privacy");
            config.setBoolean("dfs.encrypt.data.transfer", true);
        }
        config.setInt("fs.cache.max-size", this.fileSystemMaxCacheSize);
        config.setInt("dfs.client.key.provider.cache.expiry", this.dfsKeyProviderCacheTtlMillis);
        config.setInt("mapreduce.input.linerecordreader.line.maxlength", this.textMaxLineLength);
        HdfsConfigurationInitializer.configureCompression(config, this.compressionCodec);
        this.configurationInitializers.forEach(configurationInitializer -> configurationInitializer.initializeConfiguration(config));
    }

    public static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        OrcConf.COMPRESS.setString(config, compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compressionCodec.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compressionCodec.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", compressionCodec.getParquetCompressionCodec().name());
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    public static class NoOpDNSToSwitchMapping
    implements DNSToSwitchMapping {
        public List<String> resolve(List<String> names) {
            return ImmutableList.of();
        }

        public void reloadCachedMappings() {
        }

        public void reloadCachedMappings(List<String> names) {
        }
    }
}

