/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

public enum HiveACIDWriteType {
    VACUUM(-2),
    VACUUM_UNIFY(-2),
    NONE(-1),
    INSERT(0),
    INSERT_OVERWRITE(0),
    UPDATE(0),
    DELETE(2);

    private int operationId;

    private HiveACIDWriteType(int operationId) {
        this.operationId = operationId;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public static boolean isUpdateOrDelete(HiveACIDWriteType writeType) {
        return writeType == UPDATE || writeType == DELETE;
    }

    public static boolean isRowIdNeeded(HiveACIDWriteType writeType) {
        return HiveACIDWriteType.isUpdateOrDelete(writeType) || HiveACIDWriteType.isVacuum(writeType);
    }

    public static boolean isVacuum(HiveACIDWriteType writeType) {
        return writeType == VACUUM || writeType == VACUUM_UNIFY;
    }
}

