/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.Page;
import io.prestosql.spi.connector.BucketFunction;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HiveBucketFunction
implements BucketFunction {
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketCount;
    private final List<TypeInfo> typeInfos;
    private final List<TypeInfo> typeInfosForUpdate;
    private final boolean isRowIdPartitioner;

    public HiveBucketFunction(HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<HiveType> hiveTypes) {
        this(bucketingVersion, bucketCount, hiveTypes, false);
    }

    public HiveBucketFunction(HiveBucketing.BucketingVersion bucketingVersion, int bucketCount, List<HiveType> hiveTypes, boolean forUpdate) {
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.bucketCount = bucketCount;
        this.typeInfos = Objects.requireNonNull(hiveTypes, "hiveTypes is null").stream().map(HiveType::getTypeInfo).collect(Collectors.toList());
        this.isRowIdPartitioner = forUpdate && this.typeInfos.get(this.typeInfos.size() - 1).getCategory() == ObjectInspector.Category.STRUCT;
        this.typeInfosForUpdate = forUpdate && this.typeInfos.size() > 1 ? this.typeInfos.subList(0, this.typeInfos.size() - 1) : ImmutableList.of();
    }

    public int getBucket(Page page, int position) {
        if (this.isRowIdPartitioner) {
            int bucketHashCode = 0;
            if (page.getChannelCount() > 1) {
                bucketHashCode = HiveBucketing.getBucketHashCode(this.bucketingVersion, this.typeInfosForUpdate, page, position, this.typeInfosForUpdate.size());
            }
            bucketHashCode = bucketHashCode * 31 + HiveBucketing.extractBucketNumber(page, position);
            return HiveBucketing.getBucketNumber(bucketHashCode, this.bucketCount);
        }
        return HiveBucketing.getHiveBucket(this.bucketingVersion, this.bucketCount, this.typeInfos, page, position);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.bucketingVersion).add("bucketCount", this.bucketCount).add("typeInfos", this.typeInfos).toString();
    }
}

