/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HiveBucketHandle {
    private final List<HiveColumnHandle> columns;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int tableBucketCount;
    private final int readBucketCount;

    @JsonCreator
    public HiveBucketHandle(@JsonProperty(value="columns") List<HiveColumnHandle> columns, @JsonProperty(value="bucketingVersion") HiveBucketing.BucketingVersion bucketingVersion, @JsonProperty(value="tableBucketCount") int tableBucketCount, @JsonProperty(value="readBucketCount") int readBucketCount) {
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.bucketingVersion = Objects.requireNonNull(bucketingVersion, "bucketingVersion is null");
        this.tableBucketCount = tableBucketCount;
        this.readBucketCount = readBucketCount;
    }

    @JsonProperty
    public List<HiveColumnHandle> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public HiveBucketing.BucketingVersion getBucketingVersion() {
        return this.bucketingVersion;
    }

    @JsonProperty
    public int getTableBucketCount() {
        return this.tableBucketCount;
    }

    @JsonProperty
    public int getReadBucketCount() {
        return this.readBucketCount;
    }

    public HiveBucketProperty toTableBucketProperty() {
        return new HiveBucketProperty(this.columns.stream().map(HiveColumnHandle::getName).collect(Collectors.toList()), this.bucketingVersion, this.tableBucketCount, (List<SortingColumn>)ImmutableList.of());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveBucketHandle that = (HiveBucketHandle)o;
        return Objects.equals(this.columns, that.columns) && Objects.equals(this.tableBucketCount, that.tableBucketCount) && Objects.equals(this.readBucketCount, that.readBucketCount) && Objects.equals((Object)this.bucketingVersion, (Object)that.bucketingVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columns, this.bucketingVersion, this.tableBucketCount, this.readBucketCount});
    }
}

