/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.util.HiveBucketingV1;
import io.prestosql.plugin.hive.util.HiveBucketingV2;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public final class HiveBucketing {
    private static final Set<HiveType> SUPPORTED_TYPES_FOR_BUCKET_FILTER = ImmutableSet.of((Object)HiveType.HIVE_BYTE, (Object)HiveType.HIVE_SHORT, (Object)HiveType.HIVE_INT, (Object)HiveType.HIVE_LONG, (Object)HiveType.HIVE_BOOLEAN, (Object)HiveType.HIVE_STRING, (Object[])new HiveType[0]);
    static final int MAX_BUCKET_NUMBER = 999999;

    private HiveBucketing() {
    }

    public static int getHiveBucket(BucketingVersion bucketingVersion, int bucketCount, List<TypeInfo> types, Page page, int position) {
        return HiveBucketing.getBucketNumber(HiveBucketing.getBucketHashCode(bucketingVersion, types, page, position), bucketCount);
    }

    public static int getHiveBucket(BucketingVersion bucketingVersion, int bucketCount, List<TypeInfo> types, Object[] values) {
        return HiveBucketing.getBucketNumber(HiveBucketing.getBucketHashCode(bucketingVersion, types, values), bucketCount);
    }

    @VisibleForTesting
    static int getBucketNumber(int hashCode, int bucketCount) {
        return (hashCode & Integer.MAX_VALUE) % bucketCount;
    }

    @VisibleForTesting
    static int getBucketHashCode(BucketingVersion bucketingVersion, List<TypeInfo> types, Page page, int position) {
        int channelCount = page.getChannelCount();
        return HiveBucketing.getBucketHashCode(bucketingVersion, types, page, position, channelCount);
    }

    static int getBucketHashCode(BucketingVersion bucketingVersion, List<TypeInfo> types, Page page, int position, int channelCount) {
        switch (bucketingVersion) {
            case BUCKETING_V1: {
                return HiveBucketingV1.getBucketHashCode(types, page, position, channelCount);
            }
            case BUCKETING_V2: {
                return HiveBucketingV2.getBucketHashCode(types, page, position, channelCount);
            }
        }
        throw new IllegalArgumentException("Unsupported bucketing version: " + (Object)((Object)bucketingVersion));
    }

    @VisibleForTesting
    static int getBucketHashCode(BucketingVersion bucketingVersion, List<TypeInfo> types, Object[] values) {
        switch (bucketingVersion) {
            case BUCKETING_V1: {
                return HiveBucketingV1.getBucketHashCode(types, values);
            }
            case BUCKETING_V2: {
                return HiveBucketingV2.getBucketHashCode(types, values);
            }
        }
        throw new IllegalArgumentException("Unsupported bucketing version: " + (Object)((Object)bucketingVersion));
    }

    public static Optional<HiveBucketHandle> getHiveBucketHandle(Table table) {
        Optional<HiveBucketProperty> hiveBucketProperty = table.getStorage().getBucketProperty();
        if (!hiveBucketProperty.isPresent()) {
            return Optional.empty();
        }
        Map map = HiveUtil.getRegularColumnHandles(table).stream().collect(Collectors.toMap(HiveColumnHandle::getName, Function.identity()));
        ImmutableList.Builder bucketColumns = ImmutableList.builder();
        for (String bucketColumnName : hiveBucketProperty.get().getBucketedBy()) {
            HiveColumnHandle bucketColumnHandle = (HiveColumnHandle)map.get(bucketColumnName);
            if (bucketColumnHandle == null) {
                return Optional.empty();
            }
            bucketColumns.add((Object)bucketColumnHandle);
        }
        BucketingVersion bucketingVersion = hiveBucketProperty.get().getBucketingVersion();
        int bucketCount = hiveBucketProperty.get().getBucketCount();
        return Optional.of(new HiveBucketHandle((List<HiveColumnHandle>)bucketColumns.build(), bucketingVersion, bucketCount, bucketCount));
    }

    public static Optional<HiveBucketFilter> getHiveBucketFilter(Table table, TupleDomain<ColumnHandle> effectivePredicate) {
        if (!HiveBucketing.getHiveBucketHandle(table).isPresent()) {
            return Optional.empty();
        }
        if (HiveBucketing.bucketedOnTimestamp(table.getStorage().getBucketProperty().get(), table)) {
            return Optional.empty();
        }
        Optional bindings = TupleDomain.extractFixedValues(effectivePredicate);
        if (!bindings.isPresent()) {
            return Optional.empty();
        }
        OptionalInt singleBucket = HiveBucketing.getHiveBucket(table, (Map)bindings.get());
        if (singleBucket.isPresent()) {
            return Optional.of(new HiveBucketFilter((Set<Integer>)ImmutableSet.of((Object)singleBucket.getAsInt())));
        }
        if (!effectivePredicate.getDomains().isPresent()) {
            return Optional.empty();
        }
        Optional<Domain> domain = ((Map)effectivePredicate.getDomains().get()).entrySet().stream().filter(entry -> ((HiveColumnHandle)entry.getKey()).getName().equals("$bucket")).findFirst().map(Map.Entry::getValue);
        if (!domain.isPresent()) {
            return Optional.empty();
        }
        ValueSet values = domain.get().getValues();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int bucketCount = table.getStorage().getBucketProperty().get().getBucketCount();
        for (int i = 0; i < bucketCount; ++i) {
            if (!values.containsValue((Object)i)) continue;
            builder.add((Object)i);
        }
        return Optional.of(new HiveBucketFilter((Set<Integer>)builder.build()));
    }

    private static OptionalInt getHiveBucket(Table table, Map<ColumnHandle, NullableValue> bindings) {
        if (bindings.isEmpty()) {
            return OptionalInt.empty();
        }
        List<String> bucketColumns = table.getStorage().getBucketProperty().get().getBucketedBy();
        HashMap<String, HiveType> hiveTypes = new HashMap<String, HiveType>();
        for (Column column : table.getDataColumns()) {
            hiveTypes.put(column.getName(), column.getType());
        }
        for (String string : bucketColumns) {
            if (SUPPORTED_TYPES_FOR_BUCKET_FILTER.contains(hiveTypes.get(string))) continue;
            return OptionalInt.empty();
        }
        HashMap<String, Object> bucketBindings = new HashMap<String, Object>();
        for (Map.Entry<ColumnHandle, NullableValue> entry : bindings.entrySet()) {
            HiveColumnHandle colHandle = (HiveColumnHandle)entry.getKey();
            if (entry.getValue().isNull() || !bucketColumns.contains(colHandle.getName())) continue;
            bucketBindings.put(colHandle.getName(), entry.getValue().getValue());
        }
        if (bucketBindings.size() != bucketColumns.size()) {
            return OptionalInt.empty();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        Object[] values = new Object[bucketColumns.size()];
        for (int i = 0; i < bucketColumns.size(); ++i) {
            String column = bucketColumns.get(i);
            builder.add((Object)((HiveType)hiveTypes.get(column)).getTypeInfo());
            values[i] = bucketBindings.get(column);
        }
        BucketingVersion bucketingVersion = HiveBucketing.getBucketingVersion(table);
        return OptionalInt.of(HiveBucketing.getHiveBucket(bucketingVersion, table.getStorage().getBucketProperty().get().getBucketCount(), (List<TypeInfo>)builder.build(), values));
    }

    public static BucketingVersion getBucketingVersion(Table table) {
        return HiveBucketing.getBucketingVersion(table.getParameters());
    }

    public static BucketingVersion getBucketingVersion(Map<String, String> tableProperties) {
        String bucketingVersion;
        switch (bucketingVersion = tableProperties.getOrDefault("bucketing_version", "1")) {
            case "1": {
                return BucketingVersion.BUCKETING_V1;
            }
            case "2": {
                return BucketingVersion.BUCKETING_V2;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported bucketing version: '%s'", bucketingVersion));
    }

    public static boolean bucketedOnTimestamp(HiveBucketProperty bucketProperty, Table table) {
        return bucketProperty.getBucketedBy().stream().map(columnName -> table.getColumn((String)columnName).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot find column '%s' in %s", columnName, table)))).map(Column::getType).map(HiveType::getTypeInfo).anyMatch(HiveBucketing::bucketedOnTimestamp);
    }

    private static boolean bucketedOnTimestamp(TypeInfo type) {
        switch (type.getCategory()) {
            case PRIMITIVE: {
                return ((PrimitiveTypeInfo)type).getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP;
            }
            case LIST: {
                return HiveBucketing.bucketedOnTimestamp(((ListTypeInfo)type).getListElementTypeInfo());
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)type;
                return HiveBucketing.bucketedOnTimestamp(mapTypeInfo.getMapKeyTypeInfo()) || HiveBucketing.bucketedOnTimestamp(mapTypeInfo.getMapValueTypeInfo());
            }
        }
        throw new UnsupportedOperationException("Computation of Hive bucket hashCode is not supported for Hive category: " + type.getCategory());
    }

    static int extractBucketNumber(Page page, int position) {
        Block block = page.getBlock(page.getChannelCount() - 1);
        RowBlock rowBlock = (RowBlock)block.getSingleValueBlock(position);
        int encodedBucketNumber = rowBlock.getRawFieldBlocks()[1].getInt(0, 0);
        return BucketCodec.determineVersion((int)encodedBucketNumber).decodeWriterId(encodedBucketNumber);
    }

    public static class HiveBucketFilter {
        private final Set<Integer> bucketsToKeep;

        @JsonCreator
        public HiveBucketFilter(@JsonProperty(value="bucketsToKeep") Set<Integer> bucketsToKeep) {
            this.bucketsToKeep = bucketsToKeep;
        }

        @JsonProperty
        public Set<Integer> getBucketsToKeep() {
            return this.bucketsToKeep;
        }
    }

    public static enum BucketingVersion {
        BUCKETING_V1(1),
        BUCKETING_V2(2);

        private final int version;

        private BucketingVersion(int version) {
            this.version = version;
        }

        public int getVersion() {
            return this.version;
        }
    }
}

