/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.util.SizeOf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.openjdk.jol.info.ClassLayout;

public class HiveColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveColumnHandle.class).instanceSize();
    public static final int PATH_COLUMN_INDEX = -11;
    public static final String PATH_COLUMN_NAME = "$path";
    public static final HiveType PATH_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final TypeSignature PATH_TYPE_SIGNATURE = PATH_HIVE_TYPE.getTypeSignature();
    public static final int BUCKET_COLUMN_INDEX = -12;
    public static final String BUCKET_COLUMN_NAME = "$bucket";
    public static final HiveType BUCKET_HIVE_TYPE = HiveType.HIVE_INT;
    public static final TypeSignature BUCKET_TYPE_SIGNATURE = BUCKET_HIVE_TYPE.getTypeSignature();
    public static final int ROW_ID__COLUMN_INDEX = -13;
    public static final String UPDATE_ROW_ID_COLUMN_NAME = "$rowId";
    public static final int MAX_PARTITION_KEY_COLUMN_INDEX = -14;
    private final String name;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final ColumnType columnType;
    private final Optional<String> comment;
    private final boolean required;

    public HiveColumnHandle(String name, HiveType hiveType, TypeSignature typeSignature, int hiveColumnIndex, ColumnType columnType, Optional<String> comment) {
        this(name, hiveType, typeSignature, hiveColumnIndex, columnType, comment, false);
    }

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="required") boolean required) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((hiveColumnIndex >= 0 || columnType == ColumnType.PARTITION_KEY || columnType == ColumnType.SYNTHESIZED ? 1 : 0) != 0, (Object)"hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.typeName = Objects.requireNonNull(typeSignature, "type is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.required = required;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public String getColumnName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    public boolean isPartitionKey() {
        return this.columnType == ColumnType.PARTITION_KEY;
    }

    public boolean isRegular() {
        return this.columnType == ColumnType.REGULAR;
    }

    public boolean isHidden() {
        return this.columnType == ColumnType.SYNTHESIZED;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.name, typeManager.getType(this.typeName), true, null, null, this.isHidden(), Collections.emptyMap(), this.required);
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @JsonProperty
    public boolean isRequired() {
        return this.required;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.hiveColumnIndex, this.hiveType, this.columnType, this.comment, this.required});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.hiveColumnIndex, other.hiveColumnIndex) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals((Object)this.columnType, (Object)other.columnType) && Objects.equals(this.comment, other.comment) && Objects.equals(this.required, other.required);
    }

    public String toString() {
        return this.name + ":" + this.hiveType + ":" + this.hiveColumnIndex + ":" + (Object)((Object)this.columnType);
    }

    public static HiveColumnHandle updateRowIdHandle() {
        ArrayList acidColumnNames = Lists.newArrayList((Object[])new String[]{"originalTransaction", "bucket", "rowId", "currentTransaction", "operation"});
        ArrayList acidColumnTypes = Lists.newArrayList((Object[])new TypeInfo[]{HiveType.HIVE_LONG.getTypeInfo(), HiveType.HIVE_INT.getTypeInfo(), HiveType.HIVE_LONG.getTypeInfo(), HiveType.HIVE_LONG.getTypeInfo(), HiveType.HIVE_INT.getTypeInfo()});
        StructTypeInfo structTypeInfo = new StructTypeInfo();
        structTypeInfo.setAllStructFieldNames(acidColumnNames);
        structTypeInfo.setAllStructFieldTypeInfos(acidColumnTypes);
        HiveType rowIdType = HiveType.createHiveType((TypeInfo)structTypeInfo);
        return new HiveColumnHandle(UPDATE_ROW_ID_COLUMN_NAME, rowIdType, rowIdType.getTypeSignature(), -13, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle pathColumnHandle() {
        return new HiveColumnHandle(PATH_COLUMN_NAME, PATH_HIVE_TYPE, PATH_TYPE_SIGNATURE, -11, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static HiveColumnHandle bucketColumnHandle() {
        return new HiveColumnHandle(BUCKET_COLUMN_NAME, BUCKET_HIVE_TYPE, BUCKET_TYPE_SIGNATURE, -12, ColumnType.SYNTHESIZED, Optional.empty());
    }

    public static boolean isPathColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -11;
    }

    public static boolean isBucketColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -12;
    }

    public static boolean isUpdateColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -13;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name) + this.hiveType.getRetainedSizeInBytes() + SizeOf.sizeOf(this.comment, SizeOf::estimatedSizeOf) + SizeOf.estimatedSizeOf((String)this.name);
    }

    public static enum ColumnType {
        PARTITION_KEY,
        REGULAR,
        SYNTHESIZED;

    }
}

