/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.plugin.hive.HiveCompressionCodec;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.s3.S3FileSystemType;
import io.prestosql.spi.function.Mandatory;
import io.prestosql.spi.queryeditorui.PropertyType;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"dfs.domain-socket-path", "hive.file-system-cache-ttl", "hive.max-global-split-iterator-threads", "hive.max-sort-files-per-bucket", "hive.bucket-writing", "hive.optimized-reader.enabled", "hive.orc.optimized-writer.enabled", "hive.rcfile-optimized-writer.enabled", "hive.time-zone"})
public class HiveConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private DataSize maxSplitSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private int maxPartitionsPerScan = 100000;
    private int maxOutstandingSplits = 1000;
    private DataSize maxOutstandingSplitsSize = new DataSize(256.0, DataSize.Unit.MEGABYTE);
    private int maxSplitIteratorThreads = 1000;
    private int minPartitionBatchSize = 10;
    private int maxPartitionBatchSize = 100;
    private int maxInitialSplits = 200;
    private int splitLoaderConcurrency = 4;
    private Integer maxSplitsPerSecond;
    private DataSize maxInitialSplitSize;
    private int domainCompactionThreshold = 100;
    private DataSize writerSortBufferSize = new DataSize(64.0, DataSize.Unit.MEGABYTE);
    private boolean forceLocalScheduling;
    private boolean recursiveDirWalkerEnabled;
    private int maxConcurrentFileRenames = 20;
    private boolean allowCorruptWritesForTesting;
    private Duration metastoreCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Duration metastoreRefreshInterval = new Duration(1.0, TimeUnit.SECONDS);
    private Duration metastoreDBCacheTtl = new Duration(0.0, TimeUnit.SECONDS);
    private Duration metastoreDBRefreshInterval = new Duration(1.0, TimeUnit.SECONDS);
    private long metastoreCacheMaximumSize = 10000L;
    private long perTransactionMetastoreCacheMaximumSize = 1000L;
    private int maxMetastoreRefreshThreads = 100;
    private HostAndPort metastoreSocksProxy;
    private Duration metastoreTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration ipcPingInterval = new Duration(10.0, TimeUnit.SECONDS);
    private Duration dfsTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private Duration dfsConnectTimeout = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration dfsKeyProviderCacheTtl = new Duration(30.0, TimeUnit.MINUTES);
    private int dfsConnectMaxRetries = 5;
    private boolean verifyChecksum = true;
    private String domainSocketPath;
    private S3FileSystemType s3FileSystemType = S3FileSystemType.PRESTO;
    private HiveStorageFormat hiveStorageFormat = HiveStorageFormat.ORC;
    private HiveCompressionCodec hiveCompressionCodec = HiveCompressionCodec.GZIP;
    private boolean respectTableFormat = true;
    private boolean immutablePartitions;
    private boolean createEmptyBucketFiles;
    private int maxPartitionsPerWriter = 100;
    private int maxOpenSortFiles = 50;
    private int writeValidationThreads = 16;
    private List<String> resourceConfigFiles = ImmutableList.of();
    private DataSize textMaxLineLength = new DataSize(100.0, DataSize.Unit.MEGABYTE);
    private String orcLegacyTimeZone = TimeZone.getDefault().getID();
    private String parquetTimeZone = TimeZone.getDefault().getID();
    private boolean useParquetColumnNames;
    private boolean failOnCorruptedParquetStatistics = true;
    private DataSize parquetMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean assumeCanonicalPartitionKeys;
    private boolean useOrcColumnNames;
    private boolean orcBloomFiltersEnabled;
    private double orcDefaultBloomFilterFpp = 0.05;
    private DataSize orcMaxMergeDistance = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcTinyStripeThreshold = new DataSize(1.0, DataSize.Unit.BYTE);
    private DataSize orcStreamBufferSize = new DataSize(8.0, DataSize.Unit.MEGABYTE);
    private DataSize orcMaxReadBlockSize = new DataSize(16.0, DataSize.Unit.MEGABYTE);
    private boolean orcLazyReadSmallRanges = true;
    private boolean orcWriteLegacyVersion;
    private double orcWriterValidationPercentage;
    private OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode = OrcWriteValidation.OrcWriteValidationMode.BOTH;
    private boolean orcFileTailCacheEnabled;
    private Duration orcFileTailCacheTtl = new Duration(4.0, TimeUnit.HOURS);
    private long orcFileTailCacheLimit = 50000L;
    private boolean orcStripeFooterCacheEnabled;
    private Duration orcStripeFooterCacheTtl = new Duration(4.0, TimeUnit.HOURS);
    private long orcStripeFooterCacheLimit = 250000L;
    private boolean orcRowIndexCacheEnabled;
    private Duration orcRowIndexCacheTtl = new Duration(4.0, TimeUnit.HOURS);
    private long orcRowIndexCacheLimit = 250000L;
    private boolean orcBloomFiltersCacheEnabled;
    private Duration orcBloomFiltersCacheTtl = new Duration(4.0, TimeUnit.HOURS);
    private long orcBloomFiltersCacheLimit = 250000L;
    private boolean orcRowDataCacheEnabled;
    private Duration orcRowDataCacheTtl = new Duration(4.0, TimeUnit.HOURS);
    private DataSize orcRowDataCacheMaximumWeight = new DataSize(20.0, DataSize.Unit.GIGABYTE);
    private String rcfileTimeZone = TimeZone.getDefault().getID();
    private boolean rcfileWriterValidate;
    private HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType = HiveMetastoreAuthenticationType.NONE;
    private HdfsAuthenticationType hdfsAuthenticationType = HdfsAuthenticationType.NONE;
    private boolean hdfsImpersonationEnabled;
    private boolean hdfsWireEncryptionEnabled;
    private boolean skipDeletionForAlter;
    private boolean skipTargetCleanupOnRollback;
    private boolean bucketExecutionEnabled = true;
    private boolean sortedWritingEnabled = true;
    private int fileSystemMaxCacheSize = 1000;
    private boolean optimizeMismatchedBucketCount;
    private boolean writesToNonManagedTablesEnabled;
    private boolean createsOfNonManagedTablesEnabled = true;
    private boolean tableStatisticsEnabled = true;
    private int partitionStatisticsSampleSize = 100;
    private boolean ignoreCorruptedStatistics;
    private boolean collectColumnStatisticsOnWrite = true;
    private String recordingPath;
    private boolean replay;
    private Duration recordingDuration = new Duration(10.0, TimeUnit.MINUTES);
    private boolean s3SelectPushdownEnabled;
    private int s3SelectPushdownMaxConnections = 500;
    private boolean temporaryStagingDirectoryEnabled = true;
    private String temporaryStagingDirectoryPath = "/tmp/presto-${USER}";
    private Duration fileStatusCacheExpireAfterWrite = new Duration(24.0, TimeUnit.HOURS);
    private long fileStatusCacheMaxSize = 1000000L;
    private List<String> fileStatusCacheTables = ImmutableList.of();
    private Optional<Duration> hiveTransactionHeartbeatInterval = Optional.empty();
    private int hiveTransactionHeartbeatThreads = 5;
    private boolean tableCreatesWithLocationAllowed = true;
    private boolean dynamicFilterPartitionFilteringEnabled = true;
    private int dynamicFilteringRowFilteringThreshold = 2000;
    private boolean orcCacheStatsMetricCollectionEnabled;
    private int vacuumDeltaNumThreshold = 10;
    private double vacuumDeltaPercentThreshold = 0.1;
    private boolean autoVacuumEnabled;
    private boolean orcPredicatePushdownEnabled;
    private int hmsWriteBatchSize = 8;
    private boolean tlsEnabled;
    private Duration vacuumCleanupRecheckInterval = new Duration(5.0, TimeUnit.MINUTES);
    private int vacuumServiceThreads = 2;
    private int metastoreClientServiceThreads = 4;
    private Optional<Duration> vacuumCollectorInterval = Optional.of(new Duration(5.0, TimeUnit.MINUTES));
    private int maxNumbSplitsToGroup = 1;
    private boolean workerMetaStoreCacheEnabled;

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="hive.max-initial-splits")
    public HiveConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return new DataSize(this.maxSplitSize.getValue() / 2.0, this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="hive.max-initial-split-size")
    public HiveConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSplitLoaderConcurrency() {
        return this.splitLoaderConcurrency;
    }

    @Config(value="hive.split-loader-concurrency")
    public HiveConfig setSplitLoaderConcurrency(int splitLoaderConcurrency) {
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        return this;
    }

    @Min(value=1L)
    @Nullable
    public @Min(value=1L) Integer getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="hive.max-splits-per-second")
    @ConfigDescription(value="Throttles the maximum number of splits that can be assigned to tasks per second")
    public HiveConfig setMaxSplitsPerSecond(Integer maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="hive.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public HiveConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public DataSize getWriterSortBufferSize() {
        return this.writerSortBufferSize;
    }

    @Config(value="hive.writer-sort-buffer-size")
    public HiveConfig setWriterSortBufferSize(DataSize writerSortBufferSize) {
        this.writerSortBufferSize = writerSortBufferSize;
        return this;
    }

    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @Config(value="hive.force-local-scheduling")
    public HiveConfig setForceLocalScheduling(boolean forceLocalScheduling) {
        this.forceLocalScheduling = forceLocalScheduling;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentFileRenames() {
        return this.maxConcurrentFileRenames;
    }

    @Config(value="hive.max-concurrent-file-renames")
    public HiveConfig setMaxConcurrentFileRenames(int maxConcurrentFileRenames) {
        this.maxConcurrentFileRenames = maxConcurrentFileRenames;
        return this;
    }

    @Config(value="hive.recursive-directories")
    public HiveConfig setRecursiveDirWalkerEnabled(boolean recursiveDirWalkerEnabled) {
        this.recursiveDirWalkerEnabled = recursiveDirWalkerEnabled;
        return this;
    }

    public boolean getRecursiveDirWalkerEnabled() {
        return this.recursiveDirWalkerEnabled;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="hive.max-split-size")
    public HiveConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerScan() {
        return this.maxPartitionsPerScan;
    }

    @Config(value="hive.max-partitions-per-scan")
    @ConfigDescription(value="Maximum allowed partitions for a single table scan")
    public HiveConfig setMaxPartitionsPerScan(int maxPartitionsPerScan) {
        this.maxPartitionsPerScan = maxPartitionsPerScan;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="hive.max-outstanding-splits")
    @ConfigDescription(value="Target number of buffered splits for each table scan in a query, before the scheduler tries to pause itself")
    public HiveConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @MinDataSize(value="1MB")
    public DataSize getMaxOutstandingSplitsSize() {
        return this.maxOutstandingSplitsSize;
    }

    @Config(value="hive.max-outstanding-splits-size")
    @ConfigDescription(value="Maximum amount of memory allowed for split buffering for each table scan in a query, before the query is failed")
    public HiveConfig setMaxOutstandingSplitsSize(DataSize maxOutstandingSplits) {
        this.maxOutstandingSplitsSize = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitIteratorThreads() {
        return this.maxSplitIteratorThreads;
    }

    @Config(value="hive.max-split-iterator-threads")
    public HiveConfig setMaxSplitIteratorThreads(int maxSplitIteratorThreads) {
        this.maxSplitIteratorThreads = maxSplitIteratorThreads;
        return this;
    }

    @Deprecated
    public boolean getAllowCorruptWritesForTesting() {
        return this.allowCorruptWritesForTesting;
    }

    @Deprecated
    @Config(value="hive.allow-corrupt-writes-for-testing")
    @ConfigDescription(value="Allow Hive connector to write data even when data will likely be corrupt")
    public HiveConfig setAllowCorruptWritesForTesting(boolean allowCorruptWritesForTesting) {
        this.allowCorruptWritesForTesting = allowCorruptWritesForTesting;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getMetastoreCacheTtl() {
        return this.metastoreCacheTtl;
    }

    @Config(value="hive.metastore-cache-ttl")
    public HiveConfig setMetastoreCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getMetastoreRefreshInterval() {
        return this.metastoreRefreshInterval;
    }

    @Config(value="hive.metastore-refresh-interval")
    public HiveConfig setMetastoreRefreshInterval(Duration metastoreRefreshInterval) {
        this.metastoreRefreshInterval = metastoreRefreshInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getMetastoreDBCacheTtl() {
        return this.metastoreDBCacheTtl;
    }

    @Config(value="hive.metastore-db-cache-ttl")
    public HiveConfig setMetastoreDBCacheTtl(Duration metastoreCacheTtl) {
        this.metastoreDBCacheTtl = metastoreCacheTtl;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getMetastoreDBRefreshInterval() {
        return this.metastoreDBRefreshInterval;
    }

    @Config(value="hive.metastore-db-refresh-interval")
    public HiveConfig setMetastoreDBRefreshInterval(Duration metastoreDBRefreshInterval) {
        this.metastoreDBRefreshInterval = metastoreDBRefreshInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getMetastoreCacheMaximumSize() {
        return this.metastoreCacheMaximumSize;
    }

    @Config(value="hive.metastore-cache-maximum-size")
    public HiveConfig setMetastoreCacheMaximumSize(long metastoreCacheMaximumSize) {
        this.metastoreCacheMaximumSize = metastoreCacheMaximumSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @Config(value="hive.per-transaction-metastore-cache-maximum-size")
    public HiveConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }

    @Min(value=10L)
    public @Min(value=10L) int getMaxMetastoreRefreshThreads() {
        return this.maxMetastoreRefreshThreads;
    }

    @Config(value="hive.metastore-refresh-max-threads")
    public HiveConfig setMaxMetastoreRefreshThreads(int maxMetastoreRefreshThreads) {
        this.maxMetastoreRefreshThreads = maxMetastoreRefreshThreads;
        return this;
    }

    public HostAndPort getMetastoreSocksProxy() {
        return this.metastoreSocksProxy;
    }

    @Config(value="hive.metastore.thrift.client.socks-proxy")
    public HiveConfig setMetastoreSocksProxy(HostAndPort metastoreSocksProxy) {
        this.metastoreSocksProxy = metastoreSocksProxy;
        return this;
    }

    @NotNull
    public Duration getMetastoreTimeout() {
        return this.metastoreTimeout;
    }

    @Config(value="hive.metastore-timeout")
    public HiveConfig setMetastoreTimeout(Duration metastoreTimeout) {
        this.metastoreTimeout = metastoreTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinPartitionBatchSize() {
        return this.minPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.min")
    public HiveConfig setMinPartitionBatchSize(int minPartitionBatchSize) {
        this.minPartitionBatchSize = minPartitionBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionBatchSize() {
        return this.maxPartitionBatchSize;
    }

    @Config(value="hive.metastore.partition-batch-size.max")
    public HiveConfig setMaxPartitionBatchSize(int maxPartitionBatchSize) {
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        return this;
    }

    @NotNull
    public List<String> getResourceConfigFiles() {
        return this.resourceConfigFiles;
    }

    @Mandatory(name="hive.config.resources", description="An optional comma-separated list of HDFS configuration files. These files must exist on the machines running openLooKeng. Only specify this if absolutely necessary to access HDFS. Ensure to upload these files.", defaultValue="core-site.xml,hdfs-site.xml", readOnly=true, type=PropertyType.FILES)
    @Config(value="hive.config.resources")
    public HiveConfig setResourceConfigFiles(String files) {
        this.resourceConfigFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)files);
        return this;
    }

    public HiveConfig setResourceConfigFiles(List<String> files) {
        this.resourceConfigFiles = ImmutableList.copyOf(files);
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getIpcPingInterval() {
        return this.ipcPingInterval;
    }

    @Config(value="hive.dfs.ipc-ping-interval")
    public HiveConfig setIpcPingInterval(Duration pingInterval) {
        this.ipcPingInterval = pingInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getDfsTimeout() {
        return this.dfsTimeout;
    }

    @Config(value="hive.dfs-timeout")
    public HiveConfig setDfsTimeout(Duration dfsTimeout) {
        this.dfsTimeout = dfsTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getDfsKeyProviderCacheTtl() {
        return this.dfsKeyProviderCacheTtl;
    }

    @Config(value="hive.dfs.key-provider.cache-ttl")
    public HiveConfig setDfsKeyProviderCacheTtl(Duration dfsClientKeyProviderCacheTtl) {
        this.dfsKeyProviderCacheTtl = dfsClientKeyProviderCacheTtl;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public Duration getDfsConnectTimeout() {
        return this.dfsConnectTimeout;
    }

    @Config(value="hive.dfs.connect.timeout")
    public HiveConfig setDfsConnectTimeout(Duration dfsConnectTimeout) {
        this.dfsConnectTimeout = dfsConnectTimeout;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getDfsConnectMaxRetries() {
        return this.dfsConnectMaxRetries;
    }

    @Config(value="hive.dfs.connect.max-retries")
    public HiveConfig setDfsConnectMaxRetries(int dfsConnectMaxRetries) {
        this.dfsConnectMaxRetries = dfsConnectMaxRetries;
        return this;
    }

    public HiveStorageFormat getHiveStorageFormat() {
        return this.hiveStorageFormat;
    }

    @Config(value="hive.storage-format")
    public HiveConfig setHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        this.hiveStorageFormat = hiveStorageFormat;
        return this;
    }

    public HiveCompressionCodec getHiveCompressionCodec() {
        return this.hiveCompressionCodec;
    }

    @Config(value="hive.compression-codec")
    public HiveConfig setHiveCompressionCodec(HiveCompressionCodec hiveCompressionCodec) {
        this.hiveCompressionCodec = hiveCompressionCodec;
        return this;
    }

    public boolean isRespectTableFormat() {
        return this.respectTableFormat;
    }

    @Config(value="hive.respect-table-format")
    @ConfigDescription(value="Should new partitions be written using the existing table format or the default Presto format")
    public HiveConfig setRespectTableFormat(boolean respectTableFormat) {
        this.respectTableFormat = respectTableFormat;
        return this;
    }

    public boolean isImmutablePartitions() {
        return this.immutablePartitions;
    }

    @Config(value="hive.immutable-partitions")
    @ConfigDescription(value="Can new data be inserted into existing partitions or existing unpartitioned tables")
    public HiveConfig setImmutablePartitions(boolean immutablePartitions) {
        this.immutablePartitions = immutablePartitions;
        return this;
    }

    public boolean isCreateEmptyBucketFiles() {
        return this.createEmptyBucketFiles;
    }

    @Config(value="hive.create-empty-bucket-files")
    @ConfigDescription(value="Create empty files for buckets that have no data")
    public HiveConfig setCreateEmptyBucketFiles(boolean createEmptyBucketFiles) {
        this.createEmptyBucketFiles = createEmptyBucketFiles;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="hive.max-partitions-per-writers")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public HiveConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    @Min(value=2L)
    @Max(value=1000L)
    public @Min(value=2L) @Max(value=1000L) int getMaxOpenSortFiles() {
        return this.maxOpenSortFiles;
    }

    @Config(value="hive.max-open-sort-files")
    @ConfigDescription(value="Maximum number of writer temporary files to read in one pass")
    public HiveConfig setMaxOpenSortFiles(int maxOpenSortFiles) {
        this.maxOpenSortFiles = maxOpenSortFiles;
        return this;
    }

    public int getWriteValidationThreads() {
        return this.writeValidationThreads;
    }

    @Config(value="hive.write-validation-threads")
    @ConfigDescription(value="Number of threads used for verifying data after a write")
    public HiveConfig setWriteValidationThreads(int writeValidationThreads) {
        this.writeValidationThreads = writeValidationThreads;
        return this;
    }

    public String getDomainSocketPath() {
        return this.domainSocketPath;
    }

    @Config(value="hive.dfs.domain-socket-path")
    public HiveConfig setDomainSocketPath(String domainSocketPath) {
        this.domainSocketPath = domainSocketPath;
        return this;
    }

    @NotNull
    public S3FileSystemType getS3FileSystemType() {
        return this.s3FileSystemType;
    }

    @Config(value="hive.s3-file-system-type")
    public HiveConfig setS3FileSystemType(S3FileSystemType s3FileSystemType) {
        this.s3FileSystemType = s3FileSystemType;
        return this;
    }

    public boolean isVerifyChecksum() {
        return this.verifyChecksum;
    }

    @Config(value="hive.dfs.verify-checksum")
    public HiveConfig setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
        return this;
    }

    public boolean isUseOrcColumnNames() {
        return this.useOrcColumnNames;
    }

    @Config(value="hive.orc.use-column-names")
    @ConfigDescription(value="Access ORC columns using names from the file")
    public HiveConfig setUseOrcColumnNames(boolean useOrcColumnNames) {
        this.useOrcColumnNames = useOrcColumnNames;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.orcMaxMergeDistance;
    }

    @Config(value="hive.orc.max-merge-distance")
    public HiveConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.orcMaxMergeDistance = orcMaxMergeDistance;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxBufferSize() {
        return this.orcMaxBufferSize;
    }

    @Config(value="hive.orc.max-buffer-size")
    public HiveConfig setOrcMaxBufferSize(DataSize orcMaxBufferSize) {
        this.orcMaxBufferSize = orcMaxBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.orcStreamBufferSize;
    }

    @Config(value="hive.orc.stream-buffer-size")
    public HiveConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.orcStreamBufferSize = orcStreamBufferSize;
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.orcTinyStripeThreshold;
    }

    @Config(value="hive.orc.tiny-stripe-threshold")
    public HiveConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.orcTinyStripeThreshold = orcTinyStripeThreshold;
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadBlockSize() {
        return this.orcMaxReadBlockSize;
    }

    @Config(value="hive.orc.max-read-block-size")
    public HiveConfig setOrcMaxReadBlockSize(DataSize orcMaxReadBlockSize) {
        this.orcMaxReadBlockSize = orcMaxReadBlockSize;
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.orcLazyReadSmallRanges;
    }

    @Deprecated
    @Config(value="hive.orc.lazy-read-small-ranges")
    @ConfigDescription(value="ORC read small disk ranges lazily")
    public HiveConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.orcLazyReadSmallRanges = orcLazyReadSmallRanges;
        return this;
    }

    public boolean isOrcBloomFiltersEnabled() {
        return this.orcBloomFiltersEnabled;
    }

    @Config(value="hive.orc.bloom-filters.enabled")
    public HiveConfig setOrcBloomFiltersEnabled(boolean orcBloomFiltersEnabled) {
        this.orcBloomFiltersEnabled = orcBloomFiltersEnabled;
        return this;
    }

    public double getOrcDefaultBloomFilterFpp() {
        return this.orcDefaultBloomFilterFpp;
    }

    @Config(value="hive.orc.default-bloom-filter-fpp")
    @ConfigDescription(value="ORC Bloom filter false positive probability")
    public HiveConfig setOrcDefaultBloomFilterFpp(double orcDefaultBloomFilterFpp) {
        this.orcDefaultBloomFilterFpp = orcDefaultBloomFilterFpp;
        return this;
    }

    public boolean isOrcWriteLegacyVersion() {
        return this.orcWriteLegacyVersion;
    }

    @Config(value="hive.orc.writer.use-legacy-version-number")
    @ConfigDescription(value="Write ORC files with a version number that is readable by Hive 2.0.0 to 2.2.0")
    public HiveConfig setOrcWriteLegacyVersion(boolean orcWriteLegacyVersion) {
        this.orcWriteLegacyVersion = orcWriteLegacyVersion;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="100.0") double getOrcWriterValidationPercentage() {
        return this.orcWriterValidationPercentage;
    }

    @Config(value="hive.orc.writer.validation-percentage")
    @ConfigDescription(value="Percentage of ORC files to validate after write by re-reading the whole file")
    public HiveConfig setOrcWriterValidationPercentage(double orcWriterValidationPercentage) {
        this.orcWriterValidationPercentage = orcWriterValidationPercentage;
        return this;
    }

    @NotNull
    public OrcWriteValidation.OrcWriteValidationMode getOrcWriterValidationMode() {
        return this.orcWriterValidationMode;
    }

    @Config(value="hive.orc.writer.validation-mode")
    @ConfigDescription(value="Level of detail in ORC validation. Lower levels require more memory.")
    public HiveConfig setOrcWriterValidationMode(OrcWriteValidation.OrcWriteValidationMode orcWriterValidationMode) {
        this.orcWriterValidationMode = orcWriterValidationMode;
        return this;
    }

    public DateTimeZone getRcfileDateTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.rcfileTimeZone));
    }

    @NotNull
    public String getRcfileTimeZone() {
        return this.rcfileTimeZone;
    }

    @Config(value="hive.rcfile.time-zone")
    @ConfigDescription(value="Time zone for RCFile binary read and write")
    public HiveConfig setRcfileTimeZone(String rcfileTimeZone) {
        this.rcfileTimeZone = rcfileTimeZone;
        return this;
    }

    public boolean isRcfileWriterValidate() {
        return this.rcfileWriterValidate;
    }

    @Config(value="hive.rcfile.writer.validate")
    @ConfigDescription(value="Validate RCFile after write by re-reading the whole file")
    public HiveConfig setRcfileWriterValidate(boolean rcfileWriterValidate) {
        this.rcfileWriterValidate = rcfileWriterValidate;
        return this;
    }

    public boolean isAssumeCanonicalPartitionKeys() {
        return this.assumeCanonicalPartitionKeys;
    }

    @Config(value="hive.assume-canonical-partition-keys")
    public HiveConfig setAssumeCanonicalPartitionKeys(boolean assumeCanonicalPartitionKeys) {
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        return this;
    }

    @MinDataSize(value="1B")
    @MaxDataSize(value="1GB")
    @NotNull
    public DataSize getTextMaxLineLength() {
        return this.textMaxLineLength;
    }

    @Config(value="hive.text.max-line-length")
    @ConfigDescription(value="Maximum line length for text files")
    public HiveConfig setTextMaxLineLength(DataSize textMaxLineLength) {
        this.textMaxLineLength = textMaxLineLength;
        return this;
    }

    public DateTimeZone getOrcLegacyDateTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.orcLegacyTimeZone));
    }

    @NotNull
    public String getOrcLegacyTimeZone() {
        return this.orcLegacyTimeZone;
    }

    @Config(value="hive.orc.time-zone")
    @ConfigDescription(value="Time zone for legacy ORC files that do not contain a time zone")
    public HiveConfig setOrcLegacyTimeZone(String orcLegacyTimeZone) {
        this.orcLegacyTimeZone = orcLegacyTimeZone;
        return this;
    }

    public DateTimeZone getParquetDateTimeZone() {
        return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(this.parquetTimeZone));
    }

    @NotNull
    public String getParquetTimeZone() {
        return this.parquetTimeZone;
    }

    @Config(value="hive.parquet.time-zone")
    @ConfigDescription(value="Time zone for Parquet read and write")
    public HiveConfig setParquetTimeZone(String parquetTimeZone) {
        this.parquetTimeZone = parquetTimeZone;
        return this;
    }

    public boolean isUseParquetColumnNames() {
        return this.useParquetColumnNames;
    }

    @Config(value="hive.parquet.use-column-names")
    @ConfigDescription(value="Access Parquet columns using names from the file")
    public HiveConfig setUseParquetColumnNames(boolean useParquetColumnNames) {
        this.useParquetColumnNames = useParquetColumnNames;
        return this;
    }

    public boolean isFailOnCorruptedParquetStatistics() {
        return this.failOnCorruptedParquetStatistics;
    }

    @Config(value="hive.parquet.fail-on-corrupted-statistics")
    @ConfigDescription(value="Fail when scanning Parquet files with corrupted statistics")
    public HiveConfig setFailOnCorruptedParquetStatistics(boolean failOnCorruptedParquetStatistics) {
        this.failOnCorruptedParquetStatistics = failOnCorruptedParquetStatistics;
        return this;
    }

    @NotNull
    public DataSize getParquetMaxReadBlockSize() {
        return this.parquetMaxReadBlockSize;
    }

    @Config(value="hive.parquet.max-read-block-size")
    public HiveConfig setParquetMaxReadBlockSize(DataSize parquetMaxReadBlockSize) {
        this.parquetMaxReadBlockSize = parquetMaxReadBlockSize;
        return this;
    }

    public boolean isOptimizeMismatchedBucketCount() {
        return this.optimizeMismatchedBucketCount;
    }

    @Config(value="hive.optimize-mismatched-bucket-count")
    public HiveConfig setOptimizeMismatchedBucketCount(boolean optimizeMismatchedBucketCount) {
        this.optimizeMismatchedBucketCount = optimizeMismatchedBucketCount;
        return this;
    }

    public List<String> getFileStatusCacheTables() {
        return this.fileStatusCacheTables;
    }

    @Config(value="hive.file-status-cache-tables")
    public HiveConfig setFileStatusCacheTables(String fileStatusCacheTables) {
        this.fileStatusCacheTables = SPLITTER.splitToList((CharSequence)fileStatusCacheTables);
        return this;
    }

    public long getFileStatusCacheMaxSize() {
        return this.fileStatusCacheMaxSize;
    }

    @Config(value="hive.file-status-cache-size")
    public HiveConfig setFileStatusCacheMaxSize(long fileStatusCacheMaxSize) {
        this.fileStatusCacheMaxSize = fileStatusCacheMaxSize;
        return this;
    }

    public Duration getFileStatusCacheExpireAfterWrite() {
        return this.fileStatusCacheExpireAfterWrite;
    }

    @Config(value="hive.file-status-cache-expire-time")
    public HiveConfig setFileStatusCacheExpireAfterWrite(Duration fileStatusCacheExpireAfterWrite) {
        this.fileStatusCacheExpireAfterWrite = fileStatusCacheExpireAfterWrite;
        return this;
    }

    public int getMetastoreWriteBatchSize() {
        return this.hmsWriteBatchSize;
    }

    @Config(value="hive.metastore-write-batch-size")
    @ConfigDescription(value="Batch size for writing to hms")
    public HiveConfig setMetastoreWriteBatchSize(int hmsWriteBatchSize) {
        this.hmsWriteBatchSize = hmsWriteBatchSize;
        return this;
    }

    @NotNull
    public HiveMetastoreAuthenticationType getHiveMetastoreAuthenticationType() {
        return this.hiveMetastoreAuthenticationType;
    }

    @Config(value="hive.metastore.authentication.type")
    @ConfigDescription(value="Hive Metastore authentication type")
    public HiveConfig setHiveMetastoreAuthenticationType(HiveMetastoreAuthenticationType hiveMetastoreAuthenticationType) {
        this.hiveMetastoreAuthenticationType = hiveMetastoreAuthenticationType;
        return this;
    }

    @NotNull
    public HdfsAuthenticationType getHdfsAuthenticationType() {
        return this.hdfsAuthenticationType;
    }

    @Config(value="hive.hdfs.authentication.type")
    @ConfigDescription(value="HDFS authentication type")
    public HiveConfig setHdfsAuthenticationType(HdfsAuthenticationType hdfsAuthenticationType) {
        this.hdfsAuthenticationType = hdfsAuthenticationType;
        return this;
    }

    public boolean isHdfsImpersonationEnabled() {
        return this.hdfsImpersonationEnabled;
    }

    @Config(value="hive.hdfs.impersonation.enabled")
    @ConfigDescription(value="Should Presto user be impersonated when communicating with HDFS")
    public HiveConfig setHdfsImpersonationEnabled(boolean hdfsImpersonationEnabled) {
        this.hdfsImpersonationEnabled = hdfsImpersonationEnabled;
        return this;
    }

    public boolean isHdfsWireEncryptionEnabled() {
        return this.hdfsWireEncryptionEnabled;
    }

    @Config(value="hive.hdfs.wire-encryption.enabled")
    @ConfigDescription(value="Should be turned on when HDFS wire encryption is enabled")
    public HiveConfig setHdfsWireEncryptionEnabled(boolean hdfsWireEncryptionEnabled) {
        this.hdfsWireEncryptionEnabled = hdfsWireEncryptionEnabled;
        return this;
    }

    public boolean isSkipDeletionForAlter() {
        return this.skipDeletionForAlter;
    }

    @Config(value="hive.skip-deletion-for-alter")
    @ConfigDescription(value="Skip deletion of old partition data when a partition is deleted and then inserted in the same transaction")
    public HiveConfig setSkipDeletionForAlter(boolean skipDeletionForAlter) {
        this.skipDeletionForAlter = skipDeletionForAlter;
        return this;
    }

    public boolean isSkipTargetCleanupOnRollback() {
        return this.skipTargetCleanupOnRollback;
    }

    @Config(value="hive.skip-target-cleanup-on-rollback")
    @ConfigDescription(value="Skip deletion of target directories when a metastore operation fails")
    public HiveConfig setSkipTargetCleanupOnRollback(boolean skipTargetCleanupOnRollback) {
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        return this;
    }

    public boolean isBucketExecutionEnabled() {
        return this.bucketExecutionEnabled;
    }

    @Config(value="hive.bucket-execution")
    @ConfigDescription(value="Enable bucket-aware execution: only use a single worker per bucket")
    public HiveConfig setBucketExecutionEnabled(boolean bucketExecutionEnabled) {
        this.bucketExecutionEnabled = bucketExecutionEnabled;
        return this;
    }

    public boolean isSortedWritingEnabled() {
        return this.sortedWritingEnabled;
    }

    @Config(value="hive.sorted-writing")
    @ConfigDescription(value="Enable writing to bucketed sorted tables")
    public HiveConfig setSortedWritingEnabled(boolean sortedWritingEnabled) {
        this.sortedWritingEnabled = sortedWritingEnabled;
        return this;
    }

    public int getFileSystemMaxCacheSize() {
        return this.fileSystemMaxCacheSize;
    }

    @Config(value="hive.fs.cache.max-size")
    @ConfigDescription(value="Hadoop FileSystem cache size")
    public HiveConfig setFileSystemMaxCacheSize(int fileSystemMaxCacheSize) {
        this.fileSystemMaxCacheSize = fileSystemMaxCacheSize;
        return this;
    }

    @Config(value="hive.non-managed-table-writes-enabled")
    @ConfigDescription(value="Enable writes to non-managed (external) tables")
    public HiveConfig setWritesToNonManagedTablesEnabled(boolean writesToNonManagedTablesEnabled) {
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        return this;
    }

    public boolean getWritesToNonManagedTablesEnabled() {
        return this.writesToNonManagedTablesEnabled;
    }

    @Deprecated
    @Config(value="hive.non-managed-table-creates-enabled")
    @ConfigDescription(value="Enable non-managed (external) table creates")
    public HiveConfig setCreatesOfNonManagedTablesEnabled(boolean createsOfNonManagedTablesEnabled) {
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        return this;
    }

    @Deprecated
    public boolean getCreatesOfNonManagedTablesEnabled() {
        return this.createsOfNonManagedTablesEnabled;
    }

    @Config(value="hive.table-statistics-enabled")
    @ConfigDescription(value="Enable use of table statistics")
    public HiveConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPartitionStatisticsSampleSize() {
        return this.partitionStatisticsSampleSize;
    }

    @Config(value="hive.partition-statistics-sample-size")
    @ConfigDescription(value="Maximum sample size of the partitions column statistics")
    public HiveConfig setPartitionStatisticsSampleSize(int partitionStatisticsSampleSize) {
        this.partitionStatisticsSampleSize = partitionStatisticsSampleSize;
        return this;
    }

    public boolean isIgnoreCorruptedStatistics() {
        return this.ignoreCorruptedStatistics;
    }

    @Config(value="hive.ignore-corrupted-statistics")
    @ConfigDescription(value="Ignore corrupted statistics rather than failing")
    public HiveConfig setIgnoreCorruptedStatistics(boolean ignoreCorruptedStatistics) {
        this.ignoreCorruptedStatistics = ignoreCorruptedStatistics;
        return this;
    }

    public boolean isCollectColumnStatisticsOnWrite() {
        return this.collectColumnStatisticsOnWrite;
    }

    @Config(value="hive.collect-column-statistics-on-write")
    @ConfigDescription(value="Enables automatic column level statistics collection on write")
    public HiveConfig setCollectColumnStatisticsOnWrite(boolean collectColumnStatisticsOnWrite) {
        this.collectColumnStatisticsOnWrite = collectColumnStatisticsOnWrite;
        return this;
    }

    @Config(value="hive.metastore-recording-path")
    public HiveConfig setRecordingPath(String recordingPath) {
        this.recordingPath = recordingPath;
        return this;
    }

    public String getRecordingPath() {
        return this.recordingPath;
    }

    @Config(value="hive.replay-metastore-recording")
    public HiveConfig setReplay(boolean replay) {
        this.replay = replay;
        return this;
    }

    public boolean isReplay() {
        return this.replay;
    }

    @Config(value="hive.metastore-recording-duration")
    public HiveConfig setRecordingDuration(Duration recordingDuration) {
        this.recordingDuration = recordingDuration;
        return this;
    }

    @NotNull
    public Duration getRecordingDuration() {
        return this.recordingDuration;
    }

    public boolean isS3SelectPushdownEnabled() {
        return this.s3SelectPushdownEnabled;
    }

    @Config(value="hive.s3select-pushdown.enabled")
    @ConfigDescription(value="Enable query pushdown to AWS S3 Select service")
    public HiveConfig setS3SelectPushdownEnabled(boolean s3SelectPushdownEnabled) {
        this.s3SelectPushdownEnabled = s3SelectPushdownEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getS3SelectPushdownMaxConnections() {
        return this.s3SelectPushdownMaxConnections;
    }

    @Config(value="hive.s3select-pushdown.max-connections")
    public HiveConfig setS3SelectPushdownMaxConnections(int s3SelectPushdownMaxConnections) {
        this.s3SelectPushdownMaxConnections = s3SelectPushdownMaxConnections;
        return this;
    }

    @Config(value="hive.temporary-staging-directory-enabled")
    @ConfigDescription(value="Should use (if possible) temporary staging directory for write operations")
    public HiveConfig setTemporaryStagingDirectoryEnabled(boolean temporaryStagingDirectoryEnabled) {
        this.temporaryStagingDirectoryEnabled = temporaryStagingDirectoryEnabled;
        return this;
    }

    public boolean isTemporaryStagingDirectoryEnabled() {
        return this.temporaryStagingDirectoryEnabled;
    }

    @Config(value="hive.temporary-staging-directory-path")
    @ConfigDescription(value="Location of temporary staging directory for write operations. Use ${USER} placeholder to use different location for each user.")
    public HiveConfig setTemporaryStagingDirectoryPath(String temporaryStagingDirectoryPath) {
        this.temporaryStagingDirectoryPath = temporaryStagingDirectoryPath;
        return this;
    }

    @NotNull
    public String getTemporaryStagingDirectoryPath() {
        return this.temporaryStagingDirectoryPath;
    }

    @NotNull
    public boolean isOrcFileTailCacheEnabled() {
        return this.orcFileTailCacheEnabled;
    }

    @Config(value="hive.orc.file-tail.cache.enabled")
    @ConfigDescription(value="Enable caching of Orc file tail.")
    public HiveConfig setOrcFileTailCacheEnabled(boolean orcFileTailCacheEnabled) {
        this.orcFileTailCacheEnabled = orcFileTailCacheEnabled;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public Duration getOrcFileTailCacheTtl() {
        return this.orcFileTailCacheTtl;
    }

    @Config(value="hive.orc.file-tail.cache.ttl")
    @ConfigDescription(value="Orc file tail cache TTL.")
    public HiveConfig setOrcFileTailCacheTtl(Duration orcFileTailCacheTtl) {
        this.orcFileTailCacheTtl = orcFileTailCacheTtl;
        return this;
    }

    @NotNull
    public long getOrcFileTailCacheLimit() {
        return this.orcFileTailCacheLimit;
    }

    @Config(value="hive.orc.file-tail.cache.limit")
    @ConfigDescription(value="Orc file tail cache limit.")
    public HiveConfig setOrcFileTailCacheLimit(long orcFileTailCacheLimit) {
        this.orcFileTailCacheLimit = orcFileTailCacheLimit;
        return this;
    }

    public boolean isOrcStripeFooterCacheEnabled() {
        return this.orcStripeFooterCacheEnabled;
    }

    @Config(value="hive.orc.stripe-footer.cache.enabled")
    @ConfigDescription(value="Enable caching of Orc stripe footer.")
    public HiveConfig setOrcStripeFooterCacheEnabled(boolean orcStripeFooterCacheEnabled) {
        this.orcStripeFooterCacheEnabled = orcStripeFooterCacheEnabled;
        return this;
    }

    @MinDuration(value="0ms")
    public Duration getOrcStripeFooterCacheTtl() {
        return this.orcStripeFooterCacheTtl;
    }

    @Config(value="hive.orc.stripe-footer.cache.ttl")
    @ConfigDescription(value="Orc strip footer cache TTL.")
    public HiveConfig setOrcStripeFooterCacheTtl(Duration orcStripeFooterCacheTtl) {
        this.orcStripeFooterCacheTtl = orcStripeFooterCacheTtl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) long getOrcStripeFooterCacheLimit() {
        return this.orcStripeFooterCacheLimit;
    }

    @Config(value="hive.orc.stripe-footer.cache.limit")
    @ConfigDescription(value="Orc stripe footer cache limit.")
    public HiveConfig setOrcStripeFooterCacheLimit(long orcStripeFooterCacheLimit) {
        this.orcStripeFooterCacheLimit = orcStripeFooterCacheLimit;
        return this;
    }

    public boolean isOrcRowIndexCacheEnabled() {
        return this.orcRowIndexCacheEnabled;
    }

    @Config(value="hive.orc.row-index.cache.enabled")
    @ConfigDescription(value="Enable caching of Orc row group index.")
    public HiveConfig setOrcRowIndexCacheEnabled(boolean orcRowIndexCacheEnabled) {
        this.orcRowIndexCacheEnabled = orcRowIndexCacheEnabled;
        return this;
    }

    @MinDuration(value="0ms")
    public Duration getOrcRowIndexCacheTtl() {
        return this.orcRowIndexCacheTtl;
    }

    @Config(value="hive.orc.row-index.cache.ttl")
    public HiveConfig setOrcRowIndexCacheTtl(Duration orcRowIndexCacheTtl) {
        this.orcRowIndexCacheTtl = orcRowIndexCacheTtl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) long getOrcRowIndexCacheLimit() {
        return this.orcRowIndexCacheLimit;
    }

    @Config(value="hive.orc.row-index.cache.limit")
    public HiveConfig setOrcRowIndexCacheLimit(long orcRowIndexCacheLimit) {
        this.orcRowIndexCacheLimit = orcRowIndexCacheLimit;
        return this;
    }

    public boolean isOrcBloomFiltersCacheEnabled() {
        return this.orcBloomFiltersCacheEnabled;
    }

    @Config(value="hive.orc.bloom-filters.cache.enabled")
    @ConfigDescription(value="Enable caching of Orc bloom filters.")
    public HiveConfig setOrcBloomFiltersCacheEnabled(boolean orcBloomFiltersCacheEnabled) {
        this.orcBloomFiltersCacheEnabled = orcBloomFiltersCacheEnabled;
        return this;
    }

    @MinDuration(value="0ms")
    public Duration getOrcBloomFiltersCacheTtl() {
        return this.orcBloomFiltersCacheTtl;
    }

    @Config(value="hive.orc.bloom-filters.cache.ttl")
    public HiveConfig setOrcBloomFiltersCacheTtl(Duration orcBloomFiltersCacheTtl) {
        this.orcBloomFiltersCacheTtl = orcBloomFiltersCacheTtl;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) long getOrcBloomFiltersCacheLimit() {
        return this.orcBloomFiltersCacheLimit;
    }

    @Config(value="hive.orc.bloom-filters.cache.limit")
    public HiveConfig setOrcBloomFiltersCacheLimit(long orcBloomFiltersCacheLimit) {
        this.orcBloomFiltersCacheLimit = orcBloomFiltersCacheLimit;
        return this;
    }

    public boolean isOrcRowDataCacheEnabled() {
        return this.orcRowDataCacheEnabled;
    }

    @Config(value="hive.orc.row-data.block.cache.enabled")
    @ConfigDescription(value="Flag to enable caching Orc row data as blocks")
    public HiveConfig setOrcRowDataCacheEnabled(boolean orcRowDataCacheEnabled) {
        this.orcRowDataCacheEnabled = orcRowDataCacheEnabled;
        return this;
    }

    @MinDuration(value="0ms")
    public Duration getOrcRowDataCacheTtl() {
        return this.orcRowDataCacheTtl;
    }

    @Config(value="hive.orc.row-data.block.cache.ttl")
    @ConfigDescription(value="Orc Row data block cache TTL.")
    public HiveConfig setOrcRowDataCacheTtl(Duration orcRowDataCacheTtl) {
        this.orcRowDataCacheTtl = orcRowDataCacheTtl;
        return this;
    }

    public DataSize getOrcRowDataCacheMaximumWeight() {
        return this.orcRowDataCacheMaximumWeight;
    }

    @Config(value="hive.orc.row-data.block.cache.max.weight")
    @ConfigDescription(value="Orc Row data block cache max weight.")
    public HiveConfig setOrcRowDataCacheMaximumWeight(DataSize orcRowDataCacheMaximumWeight) {
        this.orcRowDataCacheMaximumWeight = orcRowDataCacheMaximumWeight;
        return this;
    }

    @Config(value="hive.transaction-heartbeat-interval")
    @ConfigDescription(value="Interval after which heartbeat is sent for open Hive transaction")
    public HiveConfig setHiveTransactionHeartbeatInterval(Duration interval) {
        this.hiveTransactionHeartbeatInterval = Optional.ofNullable(interval);
        return this;
    }

    @NotNull
    public Optional<Duration> getHiveTransactionHeartbeatInterval() {
        return this.hiveTransactionHeartbeatInterval;
    }

    public int getHiveTransactionHeartbeatThreads() {
        return this.hiveTransactionHeartbeatThreads;
    }

    @Config(value="hive.transaction-heartbeat-threads")
    @ConfigDescription(value="Number of threads to run in the Hive transaction heartbeat service")
    public HiveConfig setHiveTransactionHeartbeatThreads(int hiveTransactionHeartbeatThreads) {
        this.hiveTransactionHeartbeatThreads = hiveTransactionHeartbeatThreads;
        return this;
    }

    @Config(value="hive.table-creates-with-location-allowed")
    @ConfigDescription(value="Allow setting table location in CREATE TABLE and CREATE TABLE AS SELECT statements")
    public HiveConfig setTableCreatesWithLocationAllowed(boolean tableCreatesWithLocationAllowed) {
        this.tableCreatesWithLocationAllowed = tableCreatesWithLocationAllowed;
        return this;
    }

    public boolean getTableCreatesWithLocationAllowed() {
        return this.tableCreatesWithLocationAllowed;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="hive.metastore.thrift.client.ssl.enabled")
    @ConfigDescription(value="Whether TLS security is enabled")
    public HiveConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    @Config(value="hive.dynamic-filter-partition-filtering")
    @ConfigDescription(value="Filter out hive splits early based on partition value using dynamic filter")
    public HiveConfig setDynamicFilterPartitionFilteringEnabled(boolean dynamicFilterPartitionFilteringEnabled) {
        this.dynamicFilterPartitionFilteringEnabled = dynamicFilterPartitionFilteringEnabled;
        return this;
    }

    public boolean isDynamicFilterPartitionFilteringEnabled() {
        return this.dynamicFilterPartitionFilteringEnabled;
    }

    @Config(value="hive.dynamic-filtering-row-filtering-threshold")
    @ConfigDescription(value="Filter out hive rows early if the dynamic filter size is below the threshold")
    public HiveConfig setDynamicFilteringRowFilteringThreshold(int dynamicFilteringRowFilteringThreshold) {
        this.dynamicFilteringRowFilteringThreshold = dynamicFilteringRowFilteringThreshold;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDynamicFilteringRowFilteringThreshold() {
        return this.dynamicFilteringRowFilteringThreshold;
    }

    public boolean isOrcCacheStatsMetricCollectionEnabled() {
        return this.orcCacheStatsMetricCollectionEnabled;
    }

    @Config(value="hive.orc-cache-stats-metric-collection.enabled")
    @ConfigDescription(value="Whether orc cache stats metric collection is enabled")
    public HiveConfig setOrcCacheStatsMetricCollectionEnabled(boolean orcCacheStatsMetricCollectionEnabled) {
        this.orcCacheStatsMetricCollectionEnabled = orcCacheStatsMetricCollectionEnabled;
        return this;
    }

    @Config(value="hive.vacuum-cleanup-recheck-interval")
    @ConfigDescription(value="Interval after which vacuum cleanup task will be resubmitted")
    public HiveConfig setVacuumCleanupRecheckInterval(Duration interval) {
        this.vacuumCleanupRecheckInterval = interval;
        return this;
    }

    @NotNull
    @MinDuration(value="5m")
    public Duration getVacuumCleanupRecheckInterval() {
        return this.vacuumCleanupRecheckInterval;
    }

    @Config(value="hive.vacuum-service-threads")
    @ConfigDescription(value="Number of threads to run in the vacuum service")
    public HiveConfig setVacuumServiceThreads(int vacuumServiceThreads) {
        this.vacuumServiceThreads = vacuumServiceThreads;
        return this;
    }

    public int getVacuumServiceThreads() {
        return this.vacuumServiceThreads;
    }

    @Config(value="hive.metastore-client-service-threads")
    @ConfigDescription(value="Number of threads for metastore client")
    public HiveConfig setMetastoreClientServiceThreads(int metastoreClientServiceThreads) {
        this.metastoreClientServiceThreads = metastoreClientServiceThreads;
        return this;
    }

    public int getMetastoreClientServiceThreads() {
        return this.metastoreClientServiceThreads;
    }

    @Config(value="hive.vacuum-delta-num-threshold")
    @ConfigDescription(value="Maximum number of delta directories to allow without compacting it")
    public HiveConfig setVacuumDeltaNumThreshold(int vacuumDeltaNumThreshold) {
        this.vacuumDeltaNumThreshold = vacuumDeltaNumThreshold;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getVacuumDeltaNumThreshold() {
        return this.vacuumDeltaNumThreshold;
    }

    @Config(value="hive.vacuum-delta-percent-threshold")
    @ConfigDescription(value="Maximum percent of delta directories to allow without compacting it")
    public HiveConfig setVacuumDeltaPercentThreshold(double vacuumDeltaPercentThreshold) {
        this.vacuumDeltaPercentThreshold = vacuumDeltaPercentThreshold;
        return this;
    }

    @DecimalMin(value="0.1")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.1") @DecimalMax(value="1.0") double getVacuumDeltaPercentThreshold() {
        return this.vacuumDeltaPercentThreshold;
    }

    @Config(value="hive.auto-vacuum-enabled")
    @ConfigDescription(value="Enable auto-vacuum on Hive tables")
    public HiveConfig setAutoVacuumEnabled(boolean autoVacuumEnabled) {
        this.autoVacuumEnabled = autoVacuumEnabled;
        return this;
    }

    public boolean getAutoVacuumEnabled() {
        return this.autoVacuumEnabled;
    }

    @Config(value="hive.orc-predicate-pushdown-enabled")
    @ConfigDescription(value="Enables processing of predicates within ORC reading")
    public HiveConfig setOrcPredicatePushdownEnabled(boolean orcPredicatePushdownEnabled) {
        this.orcPredicatePushdownEnabled = orcPredicatePushdownEnabled;
        return this;
    }

    public boolean isOrcPredicatePushdownEnabled() {
        return this.orcPredicatePushdownEnabled;
    }

    @Config(value="hive.vacuum-collector-interval")
    @ConfigDescription(value="Interval after which vacuum collector task will be resubmitted")
    public HiveConfig setVacuumCollectorInterval(Duration interval) {
        this.vacuumCollectorInterval = Optional.ofNullable(interval);
        return this;
    }

    @NotNull
    public Optional<Duration> getVacuumCollectorInterval() {
        return this.vacuumCollectorInterval;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitsToGroup() {
        return this.maxNumbSplitsToGroup;
    }

    @Config(value="hive.max-splits-to-group")
    @ConfigDescription(value="max number of small splits can be grouped")
    public HiveConfig setMaxSplitsToGroup(int maxNumbSplitsToGroup) {
        this.maxNumbSplitsToGroup = maxNumbSplitsToGroup;
        return this;
    }

    @Config(value="hive.worker-metastore-cache-enabled")
    public HiveConfig setWorkerMetaStoreCacheEnabled(boolean isEnabled) {
        this.workerMetaStoreCacheEnabled = isEnabled;
        return this;
    }

    public boolean getWorkerMetaStoreCacheEnabled() {
        return this.workerMetaStoreCacheEnabled;
    }

    public static enum HdfsAuthenticationType {
        NONE,
        KERBEROS;

    }

    public static enum HiveMetastoreAuthenticationType {
        NONE,
        KERBEROS;

    }
}

