/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HiveTransactionHandle;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorMetadata;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class HiveConnector
implements Connector {
    private static final Logger log = Logger.get(HiveConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final Supplier<TransactionalMetadata> metadataFactory;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> analyzeProperties;
    private final ConnectorAccessControl accessControl;
    private final ClassLoader classLoader;
    private final HiveTransactionManager transactionManager;

    public HiveConnector(LifeCycleManager lifeCycleManager, Supplier<TransactionalMetadata> metadataFactory, HiveTransactionManager transactionManager, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, Set<Procedure> procedures, List<PropertyMetadata<?>> sessionProperties, List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> analyzeProperties, ConnectorAccessControl accessControl, ClassLoader classLoader) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadata is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.sessionProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
        this.schemaProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemaProperties, "schemaProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.analyzeProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(analyzeProperties, "analyzeProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.get(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.classLoader);
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl;
    }

    public boolean isSingleStatementWritesOnly() {
        return false;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            this.transactionManager.put(transaction, this.metadataFactory.get());
        }
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            metadata.commit();
        }
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        TransactionalMetadata metadata = this.transactionManager.remove(transaction);
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (String)"no such transaction: %s", (Object)transaction);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            metadata.rollback();
        }
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }

    public ConnectorMetadata getConnectorMetadata() {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ClassLoaderSafeConnectorMetadata classLoaderSafeConnectorMetadata = new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)this.metadataFactory.get(), this.classLoader);
            return classLoaderSafeConnectorMetadata;
        }
    }
}

