/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.prestosql.plugin.base.jmx.MBeanServerModule;
import io.prestosql.plugin.hive.ConnectorObjectNameGeneratorModule;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveCatalogName;
import io.prestosql.plugin.hive.HiveConnector;
import io.prestosql.plugin.hive.HiveHandleResolver;
import io.prestosql.plugin.hive.HiveMetadataFactory;
import io.prestosql.plugin.hive.HiveModule;
import io.prestosql.plugin.hive.HiveProcedureModule;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.HiveTransactionManager;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.authentication.HiveAuthenticationModule;
import io.prestosql.plugin.hive.gcs.HiveGcsModule;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastoreModule;
import io.prestosql.plugin.hive.s3.HiveS3Module;
import io.prestosql.plugin.hive.security.HiveSecurityModule;
import io.prestosql.plugin.hive.security.SystemTableAwareAccessControl;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.VersionEmbedder;
import io.prestosql.spi.classloader.ThreadContextClassLoader;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorAccessControl;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPageSinkProvider;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeConnectorSplitManager;
import io.prestosql.spi.connector.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.prestosql.spi.heuristicindex.IndexClient;
import io.prestosql.spi.procedure.Procedure;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public class HiveConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final ClassLoader classLoader;
    private final Optional<HiveMetastore> metastore;

    public HiveConnectorFactory(String name, ClassLoader classLoader, Optional<HiveMetastore> metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new HiveHandleResolver();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(config, "config is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule(catalogName), new JsonModule(), new HiveModule(), new HiveS3Module(), new HiveGcsModule(), new HiveMetastoreModule(this.metastore), new HiveSecurityModule(), new HiveAuthenticationModule(), new HiveProcedureModule(), new MBeanServerModule(), binder -> {
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(HiveCatalogName.class).toInstance((Object)new HiveCatalogName(catalogName));
                binder.bind(IndexClient.class).toInstance((Object)context.getIndexClient());
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveMetadataFactory metadataFactory = (HiveMetadataFactory)injector.getInstance(HiveMetadataFactory.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            HiveSessionProperties hiveSessionProperties = (HiveSessionProperties)injector.getInstance(HiveSessionProperties.class);
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            SystemTableAwareAccessControl accessControl = new SystemTableAwareAccessControl((ConnectorAccessControl)injector.getInstance(ConnectorAccessControl.class));
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            HiveConnector hiveConnector = new HiveConnector(lifeCycleManager, metadataFactory, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, this.classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, this.classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, this.classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, this.classLoader), (Set<SystemTable>)ImmutableSet.of(), procedures, hiveSessionProperties.getSessionProperties(), HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), (ConnectorAccessControl)accessControl, this.classLoader);
            return hiveConnector;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

