/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.BaseStorageFormat;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveAnalyzeProperties;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveDeleteAsInsertTableHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveInputInfo;
import io.prestosql.plugin.hive.HiveInsertTableHandle;
import io.prestosql.plugin.hive.HiveOutputTableHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HivePartitionResult;
import io.prestosql.plugin.hive.HivePartitioningHandle;
import io.prestosql.plugin.hive.HiveSchemaProperties;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveTableProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUpdateTableHandle;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.plugin.hive.HiveViewNotSupportedException;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.HiveWrittenPartitions;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.VacuumEligibleTableCollector;
import io.prestosql.plugin.hive.ViewAlreadyExistsException;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveColumnStatistics;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.security.AccessControlMetadata;
import io.prestosql.plugin.hive.statistics.HiveStatisticsProvider;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.Statistics;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PartialAndFinalAggregationType;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorDeleteAsInsertTableHandle;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTablePartitioning;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorUpdateTableHandle;
import io.prestosql.spi.connector.ConnectorVacuumTableHandle;
import io.prestosql.spi.connector.ConnectorVacuumTableInfo;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.DiscretePredicates;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RetryMode;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.connector.TableAlreadyExistsException;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.connector.ViewNotFoundException;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatisticType;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;

public class HiveMetadata
implements TransactionalMetadata {
    private static final Logger log = Logger.get(HiveMetadata.class);
    public static final String PRESTO_VERSION_NAME = "presto_version";
    public static final String PRESTO_QUERY_ID_NAME = "presto_query_id";
    public static final String BUCKETING_VERSION = "bucketing_version";
    public static final String TABLE_COMMENT = "comment";
    public static final String STORAGE_FORMAT = "storage_format";
    private static final String ORC_BLOOM_FILTER_COLUMNS_KEY = "orc.bloom.filter.columns";
    private static final String ORC_BLOOM_FILTER_FPP_KEY = "orc.bloom.filter.fpp";
    private static final String TEXT_SKIP_HEADER_COUNT_KEY = "skip.header.line.count";
    private static final String TEXT_SKIP_FOOTER_COUNT_KEY = "skip.footer.line.count";
    public static final String AVRO_SCHEMA_URL_KEY = "avro.schema.url";
    private static final String CSV_SEPARATOR_KEY = "separatorChar";
    private static final String CSV_QUOTE_KEY = "quoteChar";
    private static final String CSV_ESCAPE_KEY = "escapeChar";
    protected final SemiTransactionalHiveMetastore metastore;
    protected final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    protected final TypeManager typeManager;
    protected final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    protected final TypeTranslator typeTranslator;
    protected final String prestoVersion;
    private final HiveStatisticsProvider hiveStatisticsProvider;
    private final AccessControlMetadata accessControlMetadata;
    protected final boolean tableCreatesWithLocationAllowed;
    private final int vacuumDeltaNumThreshold;
    private final double vacuumDeltaPercentThreshold;
    private final boolean autoVacuumEnabled;
    protected final ScheduledExecutorService vacuumExecutorService;
    protected final ScheduledExecutorService hiveMetastoreClientService;
    private final long vacuumCollectorInterval;
    private boolean externalTable;

    public HiveMetadata(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean tableCreatesWithLocationAllowed, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, String prestoVersion, HiveStatisticsProvider hiveStatisticsProvider, AccessControlMetadata accessControlMetadata, boolean autoVacuumEnabled, int vacuumDeltaNumThreshold, double vacuumDeltaPercentThreshold, ScheduledExecutorService vacuumExecutorService, Optional<Duration> vacuumCollectorInterval, ScheduledExecutorService hiveMetastoreClientService) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.tableCreatesWithLocationAllowed = tableCreatesWithLocationAllowed;
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.hiveStatisticsProvider = Objects.requireNonNull(hiveStatisticsProvider, "hiveStatisticsProvider is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
        this.externalTable = false;
        this.vacuumDeltaNumThreshold = vacuumDeltaNumThreshold;
        this.vacuumDeltaPercentThreshold = vacuumDeltaPercentThreshold;
        this.autoVacuumEnabled = autoVacuumEnabled;
        this.vacuumExecutorService = vacuumExecutorService;
        this.vacuumCollectorInterval = vacuumCollectorInterval.map(Duration::toMillis).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Vacuum collector interval is not set correctly"));
        this.hiveMetastoreClientService = hiveMetastoreClientService;
    }

    public SemiTransactionalHiveMetastore getMetastore() {
        return this.metastore;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.metastore.getAllDatabases();
    }

    public HiveTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent()) {
            return null;
        }
        if (HiveMetadata.getSourceTableNameFromSystemTable(tableName).isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Unexpected table present in Hive metastore: " + tableName);
        }
        MetastoreUtil.verifyOnline(tableName, Optional.empty(), MetastoreUtil.getProtectMode(table.get()), table.get().getParameters());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(table.get().getParameters());
        String format = table.get().getStorage().getStorageFormat().getOutputFormatNullable();
        if (format != null) {
            parameters.put(STORAGE_FORMAT, format);
        }
        return new HiveTableHandle(tableName.getSchemaName(), tableName.getTableName(), parameters, HiveUtil.getPartitionKeyColumnHandles(table.get()), HiveBucketing.getHiveBucketHandle(table.get()));
    }

    public ConnectorTableHandle getTableHandleForStatisticsCollection(ConnectorSession session, SchemaTableName tableName, Map<String, Object> analyzeProperties) {
        HiveTableHandle handle = this.getTableHandle(session, tableName);
        if (handle == null) {
            return null;
        }
        Optional<List<List<String>>> partitionValuesList = HiveAnalyzeProperties.getPartitionList(analyzeProperties);
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle.getSchemaTableName());
        handle = handle.withAnalyzePartitionValues(partitionValuesList);
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        partitionValuesList.ifPresent(list -> {
            if (partitionedBy.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition list provided but table is not partitioned");
            }
            for (List values : list) {
                if (values.size() == partitionedBy.size()) continue;
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Partition value count does not match partition column count");
            }
        });
        HiveTableHandle table = handle;
        return partitionValuesList.map(values -> this.partitionManager.getPartitions(table, (List<List<String>>)values)).map(result -> this.partitionManager.applyPartitionResult(table, (HivePartitionResult)result)).orElse(table);
    }

    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        if (SystemTableHandler.PARTITIONS.matches(tableName)) {
            return this.getPartitionsSystemTable(session, tableName, SystemTableHandler.PARTITIONS.getSourceTableName(tableName));
        }
        if (SystemTableHandler.PROPERTIES.matches(tableName)) {
            return this.getPropertiesSystemTable(session, tableName, SystemTableHandler.PROPERTIES.getSourceTableName(tableName));
        }
        return Optional.empty();
    }

    private Optional<SystemTable> getPropertiesSystemTable(ConnectorSession session, SchemaTableName tableName, SchemaTableName sourceTableName) {
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), sourceTableName.getSchemaName(), sourceTableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        ImmutableSortedMap sortedTableParameters = ImmutableSortedMap.copyOf(table.get().getParameters());
        List columns = (List)sortedTableParameters.keySet().stream().map(key -> new ColumnMetadata(key, (Type)VarcharType.VARCHAR)).collect(ImmutableList.toImmutableList());
        List types = (List)columns.stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        ImmutableList propertyValues = ImmutableList.of((Object)ImmutableList.copyOf(sortedTableParameters.values()));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(sourceTableName, columns), arg_0 -> HiveMetadata.lambda$getPropertiesSystemTable$5(types, (Iterable)propertyValues, arg_0)));
    }

    private Optional<SystemTable> getPartitionsSystemTable(ConnectorSession session, SchemaTableName tableName, SchemaTableName sourceTableName) {
        HiveTableHandle sourceTableHandle = this.getTableHandle(session, sourceTableName);
        if (sourceTableHandle == null) {
            return Optional.empty();
        }
        SchemaTableName schemaTableName = sourceTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), schemaTableName.getSchemaName(), schemaTableName.getTableName()).orElseThrow(() -> new TableNotFoundException(schemaTableName));
        List<HiveColumnHandle> partitionColumns = sourceTableHandle.getPartitionColumns();
        if (partitionColumns.isEmpty()) {
            return Optional.empty();
        }
        List partitionColumnTypes = (List)partitionColumns.stream().map(HiveColumnHandle::getTypeSignature).map(arg_0 -> ((TypeManager)this.typeManager).getType(arg_0)).collect(ImmutableList.toImmutableList());
        List partitionSystemTableColumns = (List)partitionColumns.stream().map(column -> new ColumnMetadata(column.getName(), this.typeManager.getType(column.getTypeSignature()), (String)column.getComment().orElse(null), column.isHidden())).collect(ImmutableList.toImmutableList());
        Map fieldIdToColumnHandle = (Map)IntStream.range(0, partitionColumns.size()).boxed().collect(ImmutableMap.toImmutableMap(Function.identity(), partitionColumns::get));
        return Optional.of(HiveMetadata.createSystemTable(new ConnectorTableMetadata(tableName, partitionSystemTableColumns), constraint -> {
            TupleDomain targetTupleDomain = constraint.transform(fieldIdToColumnHandle::get);
            Predicate<Map<ColumnHandle, NullableValue>> targetPredicate = HiveMetadata.convertToPredicate((TupleDomain<ColumnHandle>)targetTupleDomain);
            Constraint targetConstraint = new Constraint(targetTupleDomain, targetPredicate);
            Iterable records = () -> Streams.stream(this.partitionManager.getPartitions(this.metastore, new HiveIdentity(session), sourceTableHandle, targetConstraint, table).getPartitions()).map(hivePartition -> IntStream.range(0, partitionColumns.size()).mapToObj(fieldIdToColumnHandle::get).map(columnHandle -> hivePartition.getKeys().get(columnHandle).getValue()).collect(Collectors.toList())).iterator();
            return new InMemoryRecordSet((Collection)partitionColumnTypes, records).cursor();
        }));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.getTableMetadata(session, ((HiveTableHandle)tableHandle).getSchemaTableName());
    }

    private ConnectorTableMetadata getTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        try {
            return this.doGetTableMetadata(session, tableName);
        }
        catch (PrestoException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to construct table metadata for table " + tableName, e);
        }
    }

    protected ConnectorTableMetadata doGetTableMetadata(ConnectorSession session, SchemaTableName tableName) {
        String textSkipFooterCount;
        String textSkipHeaderCount;
        String avroSchemaUrl;
        String orcBloomFilterFfp;
        String orcBloomFilterColumns;
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName());
        if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new TableNotFoundException(tableName);
        }
        Function<HiveColumnHandle, ColumnMetadata> metadataGetter = HiveMetadata.columnMetadataGetter(table.get(), this.typeManager);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table.get())) {
            columns.add((Object)metadataGetter.apply(columnHandle));
        }
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)"location", (Object)table.get().getStorage().getLocation());
        properties.put((Object)"external", (Object)table.get().getTableType().equals(TableType.EXTERNAL_TABLE.name()));
        try {
            HiveStorageFormat format = HiveMetadata.extractHiveStorageFormat(table.get());
            properties.put((Object)"format", (Object)format);
        }
        catch (PrestoException ignored) {
            log.debug("Format is not known error");
        }
        List partitionedBy = table.get().getPartitionColumns().stream().map(Column::getName).collect(Collectors.toList());
        if (!partitionedBy.isEmpty()) {
            properties.put((Object)"partitioned_by", partitionedBy);
        }
        table.get().getStorage().getBucketProperty().ifPresent(property -> {
            properties.put((Object)BUCKETING_VERSION, (Object)property.getBucketingVersion().getVersion());
            properties.put((Object)"bucket_count", (Object)property.getBucketCount());
            properties.put((Object)"bucketed_by", property.getBucketedBy());
            properties.put((Object)"sorted_by", property.getSortedBy());
        });
        if (Boolean.valueOf(table.get().getParameters().get("transactional")).booleanValue()) {
            properties.put((Object)"transactional", (Object)true);
        }
        if ((orcBloomFilterColumns = table.get().getParameters().get(ORC_BLOOM_FILTER_COLUMNS_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_columns", (Object)Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)orcBloomFilterColumns));
        }
        if ((orcBloomFilterFfp = table.get().getParameters().get(ORC_BLOOM_FILTER_FPP_KEY)) != null) {
            properties.put((Object)"orc_bloom_filter_fpp", (Object)Double.parseDouble(orcBloomFilterFfp));
        }
        if ((avroSchemaUrl = table.get().getParameters().get(AVRO_SCHEMA_URL_KEY)) != null) {
            properties.put((Object)"avro_schema_url", (Object)avroSchemaUrl);
        }
        if ((textSkipHeaderCount = table.get().getParameters().get(TEXT_SKIP_HEADER_COUNT_KEY)) != null) {
            properties.put((Object)"textfile_skip_header_line_count", (Object)Integer.valueOf(textSkipHeaderCount));
        }
        if ((textSkipFooterCount = table.get().getParameters().get(TEXT_SKIP_FOOTER_COUNT_KEY)) != null) {
            properties.put((Object)"textfile_skip_footer_line_count", (Object)Integer.valueOf(textSkipFooterCount));
        }
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_SEPARATOR_KEY).ifPresent(csvSeparator -> properties.put((Object)"csv_separator", csvSeparator));
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_QUOTE_KEY).ifPresent(csvQuote -> properties.put((Object)"csv_quote", csvQuote));
        HiveMetadata.getCsvSerdeProperty(table.get(), CSV_ESCAPE_KEY).ifPresent(csvEscape -> properties.put((Object)"csv_escape", csvEscape));
        Optional<String> comment = Optional.ofNullable(table.get().getParameters().get(TABLE_COMMENT));
        ImmutableList.Builder immutableColumns = ImmutableList.builder();
        ArrayList bucketedColumns = new ArrayList();
        table.get().getStorage().getBucketProperty().ifPresent(property -> bucketedColumns.addAll(property.getBucketedBy()));
        for (HiveColumnHandle columnHandle : HiveUtil.hiveColumnHandles(table.get())) {
            if (columnHandle.getColumnType().equals((Object)HiveColumnHandle.ColumnType.PARTITION_KEY)) {
                immutableColumns.add((Object)metadataGetter.apply(columnHandle));
            }
            if (!bucketedColumns.contains(columnHandle.getColumnName())) continue;
            immutableColumns.add((Object)metadataGetter.apply(columnHandle));
        }
        return new ConnectorTableMetadata(tableName, (List)columns.build(), (Map)properties.build(), comment, Optional.of(immutableColumns.build()), Optional.of(HiveTableProperties.NON_INHERITABLE_PROPERTIES));
    }

    private static Optional<String> getCsvSerdeProperty(Table table, String key) {
        return HiveMetadata.getSerdeProperty(table, key).map(csvSerdeProperty -> {
            if (csvSerdeProperty.length() > 1) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Only single character can be set for property: " + key);
            }
            return csvSerdeProperty;
        });
    }

    private static Optional<String> getSerdeProperty(Table table, String key) {
        String serdePropertyValue = table.getStorage().getSerdeParameters().get(key);
        String tablePropertyValue = table.getParameters().get(key);
        if (serdePropertyValue != null && tablePropertyValue != null && !tablePropertyValue.equals(serdePropertyValue)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Different values for '%s' set in serde properties and table properties: '%s' and '%s'", key, serdePropertyValue, tablePropertyValue));
        }
        return HiveMetadata.firstNonNullable(tablePropertyValue, serdePropertyValue);
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return ((HiveTableHandle)table).getPartitions().map(partitions -> new HiveInputInfo((List)partitions.stream().map(HivePartition::getPartitionId).collect(ImmutableList.toImmutableList()), false));
    }

    public boolean isHeuristicIndexSupported() {
        return true;
    }

    public boolean isPreAggregationSupported(ConnectorSession session) {
        return true;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllTables(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    private List<String> listSchemas(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent()) {
            return ImmutableList.of((Object)schemaName.get());
        }
        return this.listSchemaNames(session);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return (Map)HiveUtil.hiveColumnHandles(table).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    private Map<String, ColumnHandle> getColumnHandles(Table table) {
        return (Map)HiveUtil.hiveColumnHandles(table).stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
    }

    public long getTableModificationTime(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        String tableLocation = table.getStorage().getLocation();
        Path tablePath = new Path(tableLocation);
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, tableName.getSchemaName()), tablePath);
            return fileSystem.getFileStatus(tablePath).getModificationTime();
        }
        catch (Exception e) {
            log.error("Exception thrown while trying to get modified time", new Object[]{e});
            return -1L;
        }
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            try {
                columns.put((Object)tableName, (Object)this.getTableMetadata(session, tableName).getColumns());
            }
            catch (HiveViewNotSupportedException e) {
                log.debug("View is not supported error");
            }
            catch (TableNotFoundException e) {
                log.debug("Table disappeared during listing operation error");
            }
        }
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint, boolean includeColumnStatistics) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        Map columns = (Map)this.getColumnHandles(table).entrySet().stream().filter(entry -> !((HiveColumnHandle)entry.getValue()).isHidden()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Map columnTypes = (Map)columns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.getColumnMetadata(session, tableHandle, (ColumnHandle)entry.getValue()).getType()));
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, new HiveIdentity(session), tableHandle, constraint, table);
        List<HivePartition> partitions = this.partitionManager.getPartitionsAsList(partitionResult);
        return this.hiveStatisticsProvider.getTableStatistics(session, ((HiveTableHandle)tableHandle).getSchemaTableName(), columns, columnTypes, partitions, includeColumnStatistics, table);
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (!prefix.getTable().isPresent()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata(this.typeManager);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties) {
        Optional<String> location = HiveSchemaProperties.getLocation(properties).map(locationUri -> {
            try {
                this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, schemaName), new Path(locationUri));
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
            }
            return locationUri;
        });
        Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(PrincipalType.USER).setOwnerName(session.getUser()).build();
        this.metastore.createDatabase(new HiveIdentity(session), database);
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        if (!this.listTables(session, Optional.of(schemaName)).isEmpty() || !this.listViews(session, Optional.of(schemaName)).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        this.metastore.dropDatabase(new HiveIdentity(session), schemaName);
    }

    public void renameSchema(ConnectorSession session, String source, String target) {
        this.metastore.renameDatabase(new HiveIdentity(session), source, target);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Path targetPath;
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if ((bucketProperty.isPresent() || !partitionedBy.isEmpty()) && HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Bucketing/Partitioning columns not supported when Avro schema url is set");
        }
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, new HdfsEnvironment.HdfsContext(session, schemaName, tableName));
        hiveStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        boolean external = HiveTableProperties.isExternalTable(tableMetadata.getProperties());
        String externalLocation = HiveTableProperties.getExternalLocation(tableMetadata.getProperties());
        if ((external || externalLocation != null) && !this.createsOfNonManagedTablesEnabled) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot create non-managed Hive table");
        }
        Optional<String> location = HiveTableProperties.getLocation(tableMetadata.getProperties());
        if (location.isPresent()) {
            if (!this.tableCreatesWithLocationAllowed) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Setting %s property is not allowed", "location"));
            }
            targetPath = this.getPath(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), location.get(), external);
        } else {
            if (external) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot create external Hive table without location. Set it through '%s' property", "location"));
            }
            if (externalLocation != null) {
                external = true;
                targetPath = this.getPath(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), externalLocation, true);
            } else {
                external = false;
                LocationHandle locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, Optional.empty(), Optional.empty(), HiveWriteUtils.OpertionType.CREATE_TABLE);
                targetPath = this.locationService.getQueryWriteInfo(locationHandle).getTargetPath();
            }
        }
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), schemaName, tableName, session.getUser(), columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, tableProperties, targetPath, external, this.prestoVersion);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(table.getOwner());
        HiveBasicStatistics basicStatistics = table.getPartitionColumns().isEmpty() ? HiveBasicStatistics.createZeroStatistics() : HiveBasicStatistics.createEmptyStatistics();
        this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), ignoreExisting, new PartitionStatistics(basicStatistics, (Map<String, HiveColumnStatistics>)ImmutableMap.of()), Optional.empty(), false);
    }

    protected Map<String, String> getEmptyTableProperties(ConnectorTableMetadata tableMetadata, Optional<HiveBucketProperty> bucketProperty, HdfsEnvironment.HdfsContext hdfsContext) {
        String avroSchemaUrl;
        List<String> columns;
        HiveStorageFormat hiveStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        ImmutableMap.Builder tableProperties = ImmutableMap.builder();
        bucketProperty.ifPresent(hiveBucketProperty -> tableProperties.put((Object)BUCKETING_VERSION, (Object)Integer.toString(hiveBucketProperty.getBucketingVersion().getVersion())));
        if (HiveTableProperties.getTransactionalValue(tableMetadata.getProperties())) {
            if (!hiveStorageFormat.equals(HiveStorageFormat.ORC)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Only ORC storage format supports creating transactional table.");
            }
            tableProperties.put((Object)"transactional", (Object)Boolean.toString(HiveTableProperties.getTransactionalValue(tableMetadata.getProperties())));
        }
        if ((columns = HiveTableProperties.getOrcBloomFilterColumns(tableMetadata.getProperties())) != null && !columns.isEmpty()) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.ORC, "orc_bloom_filter_columns");
            tableProperties.put((Object)ORC_BLOOM_FILTER_COLUMNS_KEY, (Object)Joiner.on((String)",").join(columns));
            tableProperties.put((Object)ORC_BLOOM_FILTER_FPP_KEY, (Object)String.valueOf(HiveTableProperties.getOrcBloomFilterFpp(tableMetadata.getProperties())));
        }
        if ((avroSchemaUrl = HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties())) != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.AVRO, "avro_schema_url");
            tableProperties.put((Object)AVRO_SCHEMA_URL_KEY, (Object)this.validateAndNormalizeAvroSchemaUrl(avroSchemaUrl, hdfsContext));
        }
        HiveTableProperties.getTextHeaderSkipCount(tableMetadata.getProperties()).ifPresent(headerSkipCount -> {
            if (headerSkipCount > 0) {
                HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, "textfile_skip_header_line_count");
                tableProperties.put((Object)TEXT_SKIP_HEADER_COUNT_KEY, (Object)String.valueOf(headerSkipCount));
            }
            if (headerSkipCount < 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "textfile_skip_header_line_count", headerSkipCount));
            }
        });
        HiveTableProperties.getTextFooterSkipCount(tableMetadata.getProperties()).ifPresent(footerSkipCount -> {
            if (footerSkipCount > 0) {
                HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.TEXTFILE, "textfile_skip_footer_line_count");
                tableProperties.put((Object)TEXT_SKIP_FOOTER_COUNT_KEY, (Object)String.valueOf(footerSkipCount));
            }
            if (footerSkipCount < 0) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Invalid value for %s property: %s", "textfile_skip_footer_line_count", footerSkipCount));
            }
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_escape").ifPresent(escape -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_escape");
            tableProperties.put((Object)CSV_ESCAPE_KEY, (Object)escape.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_quote").ifPresent(quote -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_quote");
            tableProperties.put((Object)CSV_QUOTE_KEY, (Object)quote.toString());
        });
        HiveTableProperties.getCsvProperty(tableMetadata.getProperties(), "csv_separator").ifPresent(separator -> {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.CSV, "csv_separator");
            tableProperties.put((Object)CSV_SEPARATOR_KEY, (Object)separator.toString());
        });
        tableMetadata.getComment().ifPresent(value -> tableProperties.put((Object)TABLE_COMMENT, value));
        Object fieldDelimit = tableMetadata.getProperties().get("field.delim");
        if (hiveStorageFormat.equals(HiveStorageFormat.MULTIDELIMIT) && fieldDelimit == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "This table does not have serde property \"field.delim\"!");
        }
        if (fieldDelimit != null) {
            HiveMetadata.checkFormatForProperty(hiveStorageFormat, HiveStorageFormat.MULTIDELIMIT, "field.delim");
            tableProperties.put((Object)"field.delim", (Object)fieldDelimit.toString());
        }
        return tableProperties.build();
    }

    private static void checkFormatForProperty(HiveStorageFormat actualStorageFormat, HiveStorageFormat expectedStorageFormat, String propertyName) {
        if (actualStorageFormat != expectedStorageFormat) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Cannot specify %s table property for storage format: %s", propertyName, actualStorageFormat));
        }
    }

    private String validateAndNormalizeAvroSchemaUrl(String url, HdfsEnvironment.HdfsContext context) {
        try {
            new URL(url).openStream().close();
            return url;
        }
        catch (MalformedURLException e) {
            if (new File(url).exists()) {
                return new File(url).toURI().toString();
            }
            try {
                if (!this.hdfsEnvironment.getFileSystem(context, new Path(url)).exists(new Path(url))) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot locate Avro schema file: " + url);
                }
                return url;
            }
            catch (IOException ex) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Avro schema file is not a valid file system URI: " + url, (Throwable)ex);
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Cannot open Avro schema file: " + url, (Throwable)e);
        }
    }

    protected Path getPath(HdfsEnvironment.HdfsContext context, String location, Boolean external) {
        try {
            Path path = new Path(location);
            if (!HiveWriteUtils.isS3FileSystem(context, this.hdfsEnvironment, path) && !this.hdfsEnvironment.getFileSystem(context, path).isDirectory(path)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Location is not a directory: %s", location));
            }
            if (!external.booleanValue()) {
                return new Path(path, context.getTableName().get());
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Location is not a valid file system URI", (Throwable)e);
        }
    }

    protected void checkPartitionTypesSupported(List<Column> partitionColumns) {
        for (Column partitionColumn : partitionColumns) {
            Type partitionType = this.typeManager.getType(partitionColumn.getType().getTypeSignature());
            HiveUtil.verifyPartitionTypeSupported(partitionColumn.getName(), partitionType);
        }
    }

    protected static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, BaseStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Path targetPath, boolean external, String prestoVersion) {
        return HiveMetadata.buildTableObject(queryId, schemaName, tableName, tableOwner, columnHandles, hiveStorageFormat, partitionedBy, bucketProperty, additionalTableParameters, targetPath, external, prestoVersion, null);
    }

    protected static Table buildTableObject(String queryId, String schemaName, String tableName, String tableOwner, List<HiveColumnHandle> columnHandles, BaseStorageFormat hiveStorageFormat, List<String> partitionedBy, Optional<HiveBucketProperty> bucketProperty, Map<String, String> additionalTableParameters, Path targetPath, boolean external, String prestoVersion, Map<String, String> serdeParameters) {
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(partitionedBy);
        ImmutableList.Builder columns = ImmutableList.builder();
        for (HiveColumnHandle columnHandle : columnHandles) {
            String name = columnHandle.getName();
            HiveType type = columnHandle.getHiveType();
            if (!partitionColumnNames.contains(name)) {
                Verify.verify((!columnHandle.isPartitionKey() ? 1 : 0) != 0, (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
                columns.add((Object)new Column(name, type, columnHandle.getComment()));
                continue;
            }
            Verify.verify((boolean)columnHandle.isPartitionKey(), (String)"Column handles are not consistent with partitioned by property", (Object[])new Object[0]);
        }
        ImmutableMap.Builder tableParameters = ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)queryId).putAll(additionalTableParameters);
        if (external) {
            tableParameters.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(tableOwner).setTableType((external ? TableType.EXTERNAL_TABLE : TableType.MANAGED_TABLE).name()).setDataColumns((List<Column>)columns.build()).setPartitionColumns(partitionColumns).setParameters((Map<String, String>)tableParameters.build());
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.fromHiveStorageFormat(hiveStorageFormat)).setSerdeParameters((Map<String, String>)ImmutableMap.of((Object)"serialization.format", (Object)"1")).setBucketProperty(bucketProperty).setLocation(targetPath.toString());
        if (null != serdeParameters) {
            tableBuilder.getStorageBuilder().setSerdeParameters(serdeParameters);
        }
        return tableBuilder.build();
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, handle);
        HiveIdentity hiveIdentity = new HiveIdentity(session);
        Optional<Table> table = this.metastore.getTable(hiveIdentity, handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(table.get().getStorage().getStorageFormat());
        this.metastore.addColumn(hiveIdentity, handle.getSchemaName(), handle.getTableName(), column.getName(), HiveType.toHiveType(this.typeTranslator, column.getType()), column.getComment());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle sourceHandle = (HiveColumnHandle)source;
        HiveIdentity hiveIdentity = new HiveIdentity(session);
        Optional<Table> table = this.metastore.getTable(hiveIdentity, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(hiveTableHandle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(table.get().getStorage().getStorageFormat());
        this.metastore.renameColumn(hiveIdentity, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), sourceHandle.getName(), target);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        this.failIfAvroSchemaIsSet(session, hiveTableHandle);
        HiveColumnHandle columnHandle = (HiveColumnHandle)column;
        HiveIdentity hiveIdentity = new HiveIdentity(session);
        Optional<Table> table = this.metastore.getTable(hiveIdentity, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(hiveTableHandle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(table.get().getStorage().getStorageFormat());
        this.metastore.dropColumn(hiveIdentity, hiveTableHandle.getSchemaName(), hiveTableHandle.getTableName(), columnHandle.getName());
    }

    private void failIfAvroSchemaIsSet(ConnectorSession session, HiveTableHandle handle) {
        Table table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getParameters().containsKey(AVRO_SCHEMA_URL_KEY) || table.getStorage().getSerdeParameters().containsKey(AVRO_SCHEMA_URL_KEY)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "ALTER TABLE not supported when Avro schema url is set");
        }
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        HiveIdentity hiveIdentity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<Table> target = this.metastore.getTable(hiveIdentity, handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(target.get().getStorage().getStorageFormat());
        this.metastore.renameTable(hiveIdentity, handle.getSchemaName(), handle.getTableName(), newTableName.getSchemaName(), newTableName.getTableName());
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        HiveIdentity hiveIdentity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<Table> target = this.metastore.getTable(hiveIdentity, handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(target.get().getStorage().getStorageFormat());
        this.metastore.commentTable(hiveIdentity, handle.getSchemaName(), handle.getTableName(), comment);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Optional<Table> target = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName());
        if (!target.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        this.verifyStorageFormatForCatalog(target.get().getStorage().getStorageFormat());
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        List<Column> partitionColumns = table.getPartitionColumns();
        List partitionColumnNames = (List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        List<HiveColumnHandle> hiveColumnHandles = HiveUtil.hiveColumnHandles(table);
        Map columnTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !columnHandle.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> computedStatisticsMap = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionColumnNames, columnTypes);
        if (partitionColumns.isEmpty()) {
            this.metastore.setTableStatistics(identity, table, this.createPartitionStatistics(session, columnTypes, computedStatisticsMap.get(ImmutableList.of())));
        } else {
            List partitionValuesList = handle.getAnalyzePartitionValues().isPresent() ? handle.getAnalyzePartitionValues().get() : (List)this.metastore.getPartitionNames(identity, handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(((HiveTableHandle)tableHandle).getSchemaTableName())).stream().map(HiveUtil::toPartitionValues).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder partitionStatistics = ImmutableMap.builder();
            Map columnStatisticTypes = (Map)hiveColumnHandles.stream().filter(columnHandle -> !partitionColumnNames.contains(columnHandle.getName())).filter(column -> !column.isHidden()).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> ImmutableSet.copyOf(this.metastore.getSupportedColumnStatistics(this.typeManager.getType(column.getTypeSignature())))));
            Supplier emptyPartitionStatistics = Suppliers.memoize(() -> Statistics.createEmptyPartitionStatistics(columnTypes, columnStatisticTypes));
            int usedComputedStatistics = 0;
            for (List partitionValues : partitionValuesList) {
                ComputedStatistics collectedStatistics = computedStatisticsMap.get(partitionValues);
                if (collectedStatistics == null) {
                    partitionStatistics.put((Object)partitionValues, emptyPartitionStatistics.get());
                    continue;
                }
                ++usedComputedStatistics;
                partitionStatistics.put((Object)partitionValues, (Object)this.createPartitionStatistics(session, columnTypes, collectedStatistics));
            }
            Verify.verify((usedComputedStatistics == computedStatistics.size() ? 1 : 0) != 0, (String)"All computed statistics must be used", (Object[])new Object[0]);
            this.metastore.setPartitionStatistics(identity, table, (Map<List<String>, PartitionStatistics>)partitionStatistics.build());
        }
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout) {
        return this.beginCreateTable(session, tableMetadata, (Optional)layout, RetryMode.NO_RETRIES);
    }

    public HiveOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorNewTableLayout> layout, RetryMode retryMode) {
        LocationHandle locationHandle;
        if (HiveTableProperties.getExternalLocation(tableMetadata.getProperties()) != null || HiveTableProperties.isExternalTable(tableMetadata.getProperties())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "External tables cannot be created using CREATE TABLE AS");
        }
        if (HiveTableProperties.getAvroSchemaUrl(tableMetadata.getProperties()) != null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS not supported when Avro schema url is set");
        }
        HiveStorageFormat tableStorageFormat = HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties());
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Map<String, String> tableProperties = this.getEmptyTableProperties(tableMetadata, bucketProperty, new HdfsEnvironment.HdfsContext(session, schemaName, tableName));
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(tableMetadata, (Set<String>)ImmutableSet.copyOf(partitionedBy), this.typeTranslator);
        HiveStorageFormat partitionStorageFormat = HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session);
        HiveStorageFormat actualStorageFormat = partitionedBy.isEmpty() ? tableStorageFormat : partitionStorageFormat;
        actualStorageFormat.validateColumns(columnHandles);
        ImmutableMap columnHandlesByName = Maps.uniqueIndex(columnHandles, HiveColumnHandle::getName);
        List<Column> partitionColumns = partitionedBy.stream().map(((Map)columnHandlesByName)::get).map(column -> new Column(column.getName(), column.getHiveType(), column.getComment())).collect(Collectors.toList());
        this.checkPartitionTypesSupported(partitionColumns);
        Optional<String> location = HiveTableProperties.getLocation(tableMetadata.getProperties());
        if (location.isPresent() && !this.tableCreatesWithLocationAllowed) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Setting %s property is not allowed", "location"));
        }
        Optional<WriteIdInfo> writeIdInfo = Optional.empty();
        if (AcidUtils.isTransactionalTable(tableProperties)) {
            if (retryMode != RetryMode.NO_RETRIES) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE AS is not supported for transactional tables with query retries enabled");
            }
            List<HiveColumnHandle> partitionColumnHandles = partitionedBy.stream().map(((Map)columnHandlesByName)::get).collect(Collectors.toList());
            HiveTableHandle tableHandle = new HiveTableHandle(schemaName, tableName, tableProperties, partitionColumnHandles, Optional.empty());
            Optional<Long> writeId = this.metastore.getTableWriteId(session, tableHandle, HiveACIDWriteType.INSERT);
            if (!writeId.isPresent()) {
                throw new IllegalStateException("No validWriteIds present");
            }
            writeIdInfo = Optional.of(new WriteIdInfo(writeId.get(), writeId.get(), 0));
        }
        if (location.isPresent()) {
            Path path = this.getPath(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), location.get(), false);
            locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, writeIdInfo, Optional.of(path), HiveWriteUtils.OpertionType.CREATE_TABLE_AS);
        } else {
            locationHandle = this.locationService.forNewTable(this.metastore, session, schemaName, tableName, writeIdInfo, Optional.empty(), HiveWriteUtils.OpertionType.CREATE_TABLE_AS);
        }
        HiveOutputTableHandle result = new HiveOutputTableHandle(schemaName, tableName, columnHandles, this.metastore.generatePageSinkMetadata(new HiveIdentity(session), schemaTableName), locationHandle, tableStorageFormat, partitionStorageFormat, partitionedBy, bucketProperty, session.getUser(), tableProperties, retryMode != RetryMode.NO_RETRIES);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), schemaTableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishCreateTable(session, tableHandle, fragments, computedStatistics, null);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, Map<String, String> serdeParameters) {
        PartitionStatistics tableStatistics;
        HiveOutputTableHandle handle = (HiveOutputTableHandle)tableHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).collect(Collectors.toList());
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(handle.getLocationHandle());
        Table table = HiveMetadata.buildTableObject(session.getQueryId(), handle.getSchemaName(), handle.getTableName(), handle.getTableOwner(), handle.getInputColumns(), handle.getTableStorageFormat(), handle.getPartitionedBy(), handle.getBucketProperty(), handle.getAdditionalTableParameters(), writeInfo.getTargetPath(), this.externalTable, this.prestoVersion, serdeParameters);
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(handle.getTableOwner());
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (session.isRecoveryEnabled()) {
            Set<String> mergedFileNames = this.collectMergedFileNames(partitionUpdates);
            this.updateSnapshotFiles(session, handle, false, mergedFileNames, OptionalLong.empty());
            partitionUpdates = this.updateSnapshotFileNames(partitionUpdates, session.getQueryId());
        }
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
        }
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, handle.getPartitionedBy(), columnTypes);
        if (table.getPartitionColumns().isEmpty()) {
            HiveBasicStatistics basicStatistics = partitionUpdates.stream().map(PartitionUpdate::getStatistics).reduce((first, second) -> Statistics.reduce(first, second, Statistics.ReduceOperator.ADD)).orElse(HiveBasicStatistics.createZeroStatistics());
            tableStatistics = this.createPartitionStatistics(session, basicStatistics, columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
        } else {
            tableStatistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
        }
        if (handle.getPartitionedBy().isEmpty()) {
            Object fileNames = partitionUpdates.isEmpty() ? ImmutableList.of() : ((PartitionUpdate)Iterables.getOnlyElement(partitionUpdates)).getFileNames();
            this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false, tableStatistics, Optional.of(fileNames), handle.isRetriesEnabled());
        } else {
            this.metastore.createTable(session, table, principalPrivileges, Optional.of(writeInfo.getWritePath()), false, tableStatistics, Optional.empty(), false);
        }
        if (!handle.getPartitionedBy().isEmpty()) {
            if (HiveSessionProperties.isRespectTableFormat(session)) {
                Verify.verify((handle.getPartitionStorageFormat() == handle.getTableStorageFormat() ? 1 : 0) != 0);
            }
            List<Future> futures = partitionUpdates.stream().map(update -> this.hiveMetastoreClientService.submit(() -> {
                Partition partition = this.buildPartitionObject(session, table, (PartitionUpdate)update);
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, update.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
                this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), this.buildPartitionObject(session, table, (PartitionUpdate)update), update.getWritePath(), partitionStatistics, HiveACIDWriteType.NONE, Optional.of(update.getFileNames()), handle.isRetriesEnabled());
            })).collect(Collectors.toList());
            futures.forEach(future -> {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException ignore) {
                    log.debug("Get future error");
                }
            });
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    private List<PartitionUpdate> computePartitionUpdatesForMissingBuckets(ConnectorSession session, HiveWritableTableHandle handle, Table table, List<PartitionUpdate> partitionUpdates) {
        ImmutableList.Builder partitionUpdatesForMissingBucketsBuilder = ImmutableList.builder();
        HiveStorageFormat storageFormat = table.getPartitionColumns().isEmpty() ? handle.getTableStorageFormat() : handle.getPartitionStorageFormat();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            int bucketCount = handle.getBucketProperty().get().getBucketCount();
            List<String> fileNamesForMissingBuckets = this.computeFileNamesForMissingBuckets(session, table, storageFormat, partitionUpdate.getTargetPath(), bucketCount, partitionUpdate);
            partitionUpdatesForMissingBucketsBuilder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), fileNamesForMissingBuckets, 0L, 0L, 0L, partitionUpdate.getMiscData()));
        }
        return partitionUpdatesForMissingBucketsBuilder.build();
    }

    private List<String> computeFileNamesForMissingBuckets(ConnectorSession session, Table table, HiveStorageFormat storageFormat, Path targetPath, int bucketCount, PartitionUpdate partitionUpdate) {
        if (partitionUpdate.getFileNames().size() == bucketCount) {
            return ImmutableList.of();
        }
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName());
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(hdfsContext, targetPath));
        String fileExtension = HiveWriterFactory.getFileExtension(conf, StorageFormat.fromHiveStorageFormat(storageFormat));
        ImmutableSet fileNames = ImmutableSet.copyOf(partitionUpdate.getFileNames());
        Set bucketsWithFiles = (Set)fileNames.stream().map(HiveWriterFactory::getBucketFromFileName).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder missingFileNamesBuilder = ImmutableList.builder();
        for (int i = 0; i < bucketCount; ++i) {
            if (bucketsWithFiles.contains(i)) continue;
            String fileName = HiveWriterFactory.computeNonTransactionalBucketedFilename(session.getQueryId(), i) + fileExtension;
            missingFileNamesBuilder.add((Object)fileName);
        }
        ImmutableList missingFileNames = missingFileNamesBuilder.build();
        Verify.verify((fileNames.size() + missingFileNames.size() == bucketCount ? 1 : 0) != 0);
        return missingFileNames;
    }

    private void createEmptyFiles(ConnectorSession session, Path path, Table table, Optional<Partition> partition, List<String> fileNames) {
        StorageFormat format;
        Properties schema;
        JobConf conf = ConfigurationUtils.toJobConf(this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, table.getDatabaseName(), table.getTableName()), path));
        if (partition.isPresent()) {
            schema = MetastoreUtil.getHiveSchema(partition.get(), table);
            format = partition.get().getStorage().getStorageFormat();
        } else {
            schema = MetastoreUtil.getHiveSchema(table);
            format = table.getStorage().getStorageFormat();
        }
        this.hdfsEnvironment.doAs(session.getUser(), () -> {
            for (String fileName : fileNames) {
                HiveMetadata.writeEmptyFile(session, new Path(path, fileName), conf, schema, format.getSerDe(), format.getOutputFormat());
            }
        });
    }

    private static void writeEmptyFile(ConnectorSession session, Path target, JobConf conf, Properties properties, String serDe, String outputFormatName) {
        HiveWriteUtils.initializeSerializer((Configuration)conf, properties, serDe);
        FileSinkOperator.RecordWriter recordWriter = HiveWriteUtils.createRecordWriter(target, conf, properties, outputFormatName, session);
        try {
            recordWriter.close(false);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error write empty file to Hive", (Throwable)e);
        }
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.INSERT, RetryMode.NO_RETRIES);
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        return this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.INSERT, retryMode);
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, boolean isOverwrite) {
        return this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.INSERT_OVERWRITE, RetryMode.NO_RETRIES);
    }

    public HiveInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, boolean isOverwrite, RetryMode retryMode) {
        return this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.INSERT_OVERWRITE, retryMode);
    }

    private HiveInsertTableHandle beginInsertUpdateInternal(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> partition, HiveACIDWriteType writeType, RetryMode retryMode) {
        boolean isInsertExistingPartitionsOverwrite;
        HiveIdentity identity = new HiveIdentity(session);
        SchemaTableName tableName = ((HiveTableHandle)tableHandle).getSchemaTableName();
        Table table = this.metastore.getTable(identity, tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        this.verifyStorageFormatForCatalog(table.getStorage().getStorageFormat());
        HiveWriteUtils.checkTableIsWritable(table, this.writesToNonManagedTablesEnabled, writeType);
        for (Column column : table.getDataColumns()) {
            if (HiveWriteUtils.isWritableType(column.getType())) continue;
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table %s with column type %s not supported", tableName, column.getType()));
        }
        boolean isTransactional = AcidUtils.isTransactionalTable(((HiveTableHandle)tableHandle).getTableParameters().orElseThrow(() -> new IllegalStateException("tableParameters missing")));
        if (isTransactional && retryMode != RetryMode.NO_RETRIES && (writeType == HiveACIDWriteType.INSERT || writeType == HiveACIDWriteType.INSERT_OVERWRITE)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Inserting into Hive transactional tables is not supported with query retries enabled");
        }
        List<HiveColumnHandle> handles = HiveUtil.hiveColumnHandles(table).stream().filter(columnHandle -> !columnHandle.isHidden()).collect(Collectors.toList());
        if (partition.isPresent() && table.getPartitionColumns().isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Table %s not partitioned", tableName));
        }
        HiveStorageFormat tableStorageFormat = HiveMetadata.extractHiveStorageFormat(table);
        if (tableStorageFormat == HiveStorageFormat.TEXTFILE) {
            if (table.getParameters().containsKey(TEXT_SKIP_HEADER_COUNT_KEY)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with %s property not supported", TEXT_SKIP_HEADER_COUNT_KEY));
            }
            if (table.getParameters().containsKey(TEXT_SKIP_FOOTER_COUNT_KEY)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserting into Hive table with %s property not supported", TEXT_SKIP_FOOTER_COUNT_KEY));
            }
        }
        Optional<WriteIdInfo> writeIdInfo = Optional.empty();
        if (isTransactional) {
            Optional<Long> writeId = this.metastore.getTableWriteId(session, (HiveTableHandle)tableHandle, writeType);
            if (!writeId.isPresent()) {
                throw new IllegalStateException("No validWriteIds present");
            }
            writeIdInfo = Optional.of(new WriteIdInfo(writeId.get(), writeId.get(), 0));
        }
        HiveWriteUtils.OpertionType operationType = HiveWriteUtils.OpertionType.INSERT;
        boolean bl = isInsertExistingPartitionsOverwrite = HiveSessionProperties.getInsertExistingPartitionsBehavior(session) == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE;
        if (isInsertExistingPartitionsOverwrite || writeType == HiveACIDWriteType.INSERT_OVERWRITE) {
            operationType = HiveWriteUtils.OpertionType.INSERT_OVERWRITE;
        }
        LocationHandle locationHandle = this.locationService.forExistingTable(this.metastore, session, table, writeIdInfo, operationType);
        HiveInsertTableHandle result = new HiveInsertTableHandle(tableName.getSchemaName(), tableName.getTableName(), handles, this.metastore.generatePageSinkMetadata(identity, tableName), locationHandle, table.getStorage().getBucketProperty(), tableStorageFormat, HiveSessionProperties.isRespectTableFormat(session) ? tableStorageFormat : HiveSessionProperties.getHiveStorageFormat(session), writeType == HiveACIDWriteType.INSERT_OVERWRITE, retryMode != RetryMode.NO_RETRIES);
        LocationService.WriteInfo writeInfo = this.locationService.getQueryWriteInfo(locationHandle);
        this.metastore.declareIntentionToWrite(session, writeInfo.getWriteMode(), writeInfo.getWritePath(), tableName);
        return result;
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return this.finishInsertInternal(session, insertHandle, fragments, computedStatistics, null, HiveACIDWriteType.INSERT);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<PartitionUpdate> partitions) {
        return this.finishInsertInternal(session, insertHandle, fragments, computedStatistics, partitions, HiveACIDWriteType.INSERT);
    }

    private Optional<ConnectorOutputMetadata> finishInsertInternal(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<PartitionUpdate> partitions, HiveACIDWriteType hiveACIDWriteType) {
        Table table;
        HiveInsertTableHandle handle = (HiveInsertTableHandle)insertHandle;
        List<PartitionUpdate> partitionUpdates = fragments.stream().map(Slice::getBytes).map(arg_0 -> this.partitionUpdateCodec.fromJson(arg_0)).sorted(Comparator.comparing(PartitionUpdate::getName)).collect(Collectors.toList());
        HiveStorageFormat tableStorageFormat = handle.getTableStorageFormat();
        partitionUpdates = PartitionUpdate.mergePartitionUpdates(partitionUpdates);
        if (session.isSnapshotEnabled()) {
            Set<String> mergedFileNames = this.collectMergedFileNames(partitionUpdates);
            this.updateSnapshotFiles(session, handle, false, mergedFileNames, OptionalLong.empty());
            partitionUpdates = this.updateSnapshotFileNames(partitionUpdates, session.getQueryId());
        }
        if (!(table = this.metastore.getTable(new HiveIdentity(session), handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()))).getStorage().getStorageFormat().getInputFormat().equals(tableStorageFormat.getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
        }
        if (handle.getBucketProperty().isPresent() && HiveSessionProperties.isCreateEmptyBucketFiles(session)) {
            List<PartitionUpdate> partitionUpdatesForMissingBuckets = this.computePartitionUpdatesForMissingBuckets(session, handle, table, partitionUpdates);
            partitionUpdates = PartitionUpdate.mergePartitionUpdates(Iterables.concat(partitionUpdates, partitionUpdatesForMissingBuckets));
            for (PartitionUpdate partitionUpdate : partitionUpdatesForMissingBuckets) {
                Optional<Partition> partition = table.getPartitionColumns().isEmpty() ? Optional.empty() : Optional.of(this.buildPartitionObject(session, table, partitionUpdate));
                this.createEmptyFiles(session, partitionUpdate.getWritePath(), table, partition, partitionUpdate.getFileNames());
            }
        }
        List partitionedBy = (List)table.getPartitionColumns().stream().map(Column::getName).collect(ImmutableList.toImmutableList());
        Map columnTypes = (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, column -> column.getHiveType().getType(this.typeManager)));
        Map<List<String>, ComputedStatistics> partitionComputedStatistics = Statistics.createComputedStatisticsToPartitionMap(computedStatistics, partitionedBy, columnTypes);
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            if (partitionUpdate.getName().isEmpty()) {
                if (!table.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Table format changed during insert");
                }
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, (List<String>)ImmutableList.of()));
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                    this.finishInsertOverwrite(session, handle, table, partitionUpdate, partitionStatistics);
                    continue;
                }
                if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                    this.metastore.finishInsertIntoExistingTable(session, handle.getSchemaName(), handle.getTableName(), partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics, hiveACIDWriteType, handle.isRetriesEnabled());
                    continue;
                }
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)partitionUpdate.getUpdateMode()));
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.APPEND) {
                List<String> partitionValues = HiveUtil.toPartitionValues(partitionUpdate.getName());
                PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partitionValues));
                this.metastore.finishInsertIntoExistingPartition(session, handle.getSchemaName(), handle.getTableName(), partitionValues, partitionUpdate.getWritePath(), partitionUpdate.getFileNames(), partitionStatistics, hiveACIDWriteType, handle.isRetriesEnabled());
                continue;
            }
            if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.NEW || partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
                this.finishInsertInNewPartition(session, handle, table, columnTypes, partitionUpdate, partitionComputedStatistics, hiveACIDWriteType);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported update mode: %s", new Object[]{partitionUpdate.getUpdateMode()}));
        }
        if (partitions != null) {
            partitions.addAll(partitionUpdates);
        }
        return Optional.of(new HiveWrittenPartitions(partitionUpdates.stream().map(PartitionUpdate::getName).collect(Collectors.toList())));
    }

    public HiveUpdateTableHandle beginUpdateAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveInsertTableHandle insertTableHandle = this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.UPDATE, RetryMode.NO_RETRIES);
        return new HiveUpdateTableHandle(insertTableHandle.getSchemaName(), insertTableHandle.getTableName(), insertTableHandle.getInputColumns(), insertTableHandle.getPageSinkMetadata(), insertTableHandle.getLocationHandle(), insertTableHandle.getBucketProperty(), insertTableHandle.getTableStorageFormat(), insertTableHandle.getPartitionStorageFormat());
    }

    public HiveUpdateTableHandle beginUpdateAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updating a Hive tables is not supported with query retries enabled");
        }
        return this.beginUpdateAsInsert(session, tableHandle);
    }

    public HiveDeleteAsInsertTableHandle beginDeletesAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveInsertTableHandle insertTableHandle = this.beginInsertUpdateInternal(session, tableHandle, Optional.empty(), HiveACIDWriteType.DELETE, RetryMode.NO_RETRIES);
        List<HiveColumnHandle> inputColumns = insertTableHandle.getInputColumns().stream().filter(HiveColumnHandle::isRequired).collect(Collectors.toList());
        return new HiveDeleteAsInsertTableHandle(insertTableHandle.getSchemaName(), insertTableHandle.getTableName(), inputColumns, insertTableHandle.getPageSinkMetadata(), insertTableHandle.getLocationHandle(), insertTableHandle.getBucketProperty(), insertTableHandle.getTableStorageFormat(), insertTableHandle.getPartitionStorageFormat());
    }

    public HiveDeleteAsInsertTableHandle beginDeletesAsInsert(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Deleting from Hive tables is not supported with query retries enabled");
        }
        return this.beginDeletesAsInsert(session, tableHandle);
    }

    public Optional<ConnectorOutputMetadata> finishUpdateAsInsert(ConnectorSession session, ConnectorUpdateTableHandle updateHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveUpdateTableHandle updateTableHandle = (HiveUpdateTableHandle)updateHandle;
        HiveInsertTableHandle insertTableHandle = new HiveInsertTableHandle(updateTableHandle.getSchemaName(), updateTableHandle.getTableName(), updateTableHandle.getInputColumns(), updateTableHandle.getPageSinkMetadata(), updateTableHandle.getLocationHandle(), updateTableHandle.getBucketProperty(), updateTableHandle.getTableStorageFormat(), updateTableHandle.getPartitionStorageFormat(), false, updateTableHandle.isRetriesEnabled());
        return this.finishInsertInternal(session, insertTableHandle, fragments, computedStatistics, null, HiveACIDWriteType.UPDATE);
    }

    public Optional<ConnectorOutputMetadata> finishDeleteAsInsert(ConnectorSession session, ConnectorDeleteAsInsertTableHandle deleteHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveDeleteAsInsertTableHandle deleteTableHandle = (HiveDeleteAsInsertTableHandle)deleteHandle;
        HiveInsertTableHandle insertTableHandle = new HiveInsertTableHandle(deleteTableHandle.getSchemaName(), deleteTableHandle.getTableName(), deleteTableHandle.getInputColumns(), deleteTableHandle.getPageSinkMetadata(), deleteTableHandle.getLocationHandle(), deleteTableHandle.getBucketProperty(), deleteTableHandle.getTableStorageFormat(), deleteTableHandle.getPartitionStorageFormat(), false, deleteTableHandle.isRetriesEnabled());
        return this.finishInsertInternal(session, insertTableHandle, fragments, computedStatistics, null, HiveACIDWriteType.DELETE);
    }

    public ConnectorVacuumTableHandle beginVacuum(ConnectorSession session, ConnectorTableHandle tableHandle, boolean full, boolean unify, Optional<String> partition) {
        HiveInsertTableHandle insertTableHandle = this.beginInsertUpdateInternal(session, tableHandle, partition, unify ? HiveACIDWriteType.VACUUM_UNIFY : HiveACIDWriteType.VACUUM, RetryMode.NO_RETRIES);
        if (!((String)session.getSource().get()).isEmpty() && ((String)session.getSource().get()).equals("auto-vacuum")) {
            this.metastore.setVacuumTableHandle((HiveTableHandle)tableHandle);
        }
        return new HiveVacuumTableHandle(insertTableHandle.getSchemaName(), insertTableHandle.getTableName(), insertTableHandle.getInputColumns(), insertTableHandle.getPageSinkMetadata(), insertTableHandle.getLocationHandle(), insertTableHandle.getBucketProperty(), insertTableHandle.getTableStorageFormat(), insertTableHandle.getPartitionStorageFormat(), full, unify, null);
    }

    public Optional<ConnectorOutputMetadata> finishVacuum(ConnectorSession session, ConnectorVacuumTableHandle handle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        HiveVacuumTableHandle vacuumTableHandle = (HiveVacuumTableHandle)handle;
        HiveInsertTableHandle insertTableHandle = new HiveInsertTableHandle(vacuumTableHandle.getSchemaName(), vacuumTableHandle.getTableName(), vacuumTableHandle.getInputColumns(), vacuumTableHandle.getPageSinkMetadata(), vacuumTableHandle.getLocationHandle(), vacuumTableHandle.getBucketProperty(), vacuumTableHandle.getTableStorageFormat(), vacuumTableHandle.getPartitionStorageFormat(), false, vacuumTableHandle.isRetriesEnabled());
        ArrayList<PartitionUpdate> partitionUpdates = new ArrayList<PartitionUpdate>();
        Optional<ConnectorOutputMetadata> connectorOutputMetadata = this.finishInsertInternal(session, insertTableHandle, fragments, computedStatistics, partitionUpdates, vacuumTableHandle.isUnifyVacuum() ? HiveACIDWriteType.VACUUM_UNIFY : HiveACIDWriteType.VACUUM);
        this.metastore.initiateVacuumCleanupTasks(vacuumTableHandle, session, partitionUpdates);
        return connectorOutputMetadata;
    }

    protected Partition buildPartitionObject(ConnectorSession session, Table table, PartitionUpdate partitionUpdate) {
        return Partition.builder().setDatabaseName(table.getDatabaseName()).setTableName(table.getTableName()).setColumns(table.getDataColumns()).setValues(HivePartitionManager.extractPartitionValues(partitionUpdate.getName())).setParameters((Map<String, String>)ImmutableMap.builder().put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build()).withStorage(storage -> storage.setStorageFormat(HiveSessionProperties.isRespectTableFormat(session) ? table.getStorage().getStorageFormat() : StorageFormat.fromHiveStorageFormat(HiveSessionProperties.getHiveStorageFormat(session))).setLocation(partitionUpdate.getTargetPath().toString()).setBucketProperty(table.getStorage().getBucketProperty()).setSerdeParameters(table.getStorage().getSerdeParameters())).build();
    }

    private PartitionStatistics createPartitionStatistics(ConnectorSession session, Map<String, Type> columnTypes, ComputedStatistics computedStatistics) {
        Map computedColumnStatistics = computedStatistics.getColumnStatistics();
        Block rowCountBlock = (Block)Optional.ofNullable(computedStatistics.getTableStatistics().get(TableStatisticType.ROW_COUNT)).orElseThrow(() -> new VerifyException("rowCount not present"));
        Verify.verify((!rowCountBlock.isNull(0) ? 1 : 0) != 0, (String)"rowCount must never be null", (Object[])new Object[0]);
        long rowCount = BigintType.BIGINT.getLong(rowCountBlock, 0);
        HiveBasicStatistics rowCountOnlyBasicStatistics = new HiveBasicStatistics(OptionalLong.empty(), OptionalLong.of(rowCount), OptionalLong.empty(), OptionalLong.empty());
        return this.createPartitionStatistics(session, rowCountOnlyBasicStatistics, columnTypes, computedColumnStatistics);
    }

    protected PartitionStatistics createPartitionStatistics(ConnectorSession session, HiveBasicStatistics basicStatistics, Map<String, Type> columnTypes, Map<ColumnStatisticMetadata, Block> computedColumnStatistics) {
        long rowCount = basicStatistics.getRowCount().orElseThrow(() -> new IllegalArgumentException("rowCount not present"));
        Map<String, HiveColumnStatistics> columnStatistics = Statistics.fromComputedStatistics(session, computedColumnStatistics, columnTypes, rowCount);
        return new PartitionStatistics(basicStatistics, columnStatistics);
    }

    protected static Map<ColumnStatisticMetadata, Block> getColumnStatistics(Map<List<String>, ComputedStatistics> statistics, List<String> partitionValues) {
        return Optional.ofNullable(statistics.get(partitionValues)).map(ComputedStatistics::getColumnStatistics).orElse((Map)ImmutableMap.of());
    }

    public void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        HiveIdentity identity = new HiveIdentity(session);
        ImmutableMap properties = ImmutableMap.builder().put((Object)TABLE_COMMENT, (Object)"Presto View").put((Object)"presto_view", (Object)"true").put((Object)PRESTO_VERSION_NAME, (Object)this.prestoVersion).put((Object)PRESTO_QUERY_ID_NAME, (Object)session.getQueryId()).build();
        Column dummyColumn = new Column("dummy", HiveType.HIVE_STRING, Optional.empty());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(viewName.getSchemaName()).setTableName(viewName.getTableName()).setOwner(session.getUser()).setTableType(TableType.VIRTUAL_VIEW.name()).setDataColumns((List<Column>)ImmutableList.of((Object)dummyColumn)).setPartitionColumns((List<Column>)ImmutableList.of()).setParameters((Map<String, String>)properties).setViewOriginalText(Optional.of(HiveUtil.encodeViewData(definition))).setViewExpandedText(Optional.of("/* Presto View */"));
        tableBuilder.getStorageBuilder().setStorageFormat(StorageFormat.VIEW_STORAGE_FORMAT).setLocation("");
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet(session.getUser());
        Optional<Table> existing = this.metastore.getTable(identity, viewName.getSchemaName(), viewName.getTableName());
        if (existing.isPresent()) {
            if (!replace || !HiveUtil.isPrestoView(existing.get())) {
                throw new ViewAlreadyExistsException(viewName);
            }
            this.metastore.replaceView(identity, viewName.getSchemaName(), viewName.getTableName(), table, principalPrivileges);
            return;
        }
        try {
            this.metastore.createTable(session, table, principalPrivileges, Optional.empty(), false, new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map<String, HiveColumnStatistics>)ImmutableMap.of()), Optional.empty(), false);
        }
        catch (TableAlreadyExistsException e) {
            throw new ViewAlreadyExistsException(e.getTableName());
        }
    }

    public void dropView(ConnectorSession session, SchemaTableName viewName) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        try {
            this.metastore.dropTable(session, viewName.getSchemaName(), viewName.getTableName());
        }
        catch (TableNotFoundException e) {
            throw new ViewNotFoundException(e.getTableName());
        }
    }

    public List<SchemaTableName> listViews(ConnectorSession session, Optional<String> optionalSchemaName) {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (String schemaName : this.listSchemas(session, optionalSchemaName)) {
            for (String tableName : this.metastore.getAllViews(schemaName).orElse(Collections.emptyList())) {
                tableNames.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return tableNames.build();
    }

    public Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return this.metastore.getTable(new HiveIdentity(session), viewName.getSchemaName(), viewName.getTableName()).filter(HiveUtil::isView).map(view -> {
            ConnectorViewDefinition definition = HiveUtil.isPrestoView(view) ? this.processPrestoView((Table)view, viewName) : this.processHiveView(session, (Table)view, viewName);
            return definition;
        });
    }

    private ConnectorViewDefinition processPrestoView(Table view, SchemaTableName viewName) {
        ConnectorViewDefinition definition = HiveUtil.decodeViewData(view.getViewOriginalText().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + viewName)));
        if (view.getOwner() != null && !definition.isRunAsInvoker()) {
            definition = new ConnectorViewDefinition(definition.getOriginalSql(), definition.getCatalog(), definition.getSchema(), definition.getColumns(), Optional.of(view.getOwner()), false);
        }
        return definition;
    }

    private ConnectorViewDefinition processHiveView(ConnectorSession session, Table view, SchemaTableName viewName) {
        String fullNameOwner;
        int domainIndex;
        String hiveViewQuery = view.getViewExpandedText().orElseThrow(() -> new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "No view original text: " + viewName));
        hiveViewQuery = hiveViewQuery.replace('`', '\"');
        Optional<Object> owner = view.getOwner() != null ? Optional.of((domainIndex = (fullNameOwner = view.getOwner()).indexOf(64)) < 0 ? fullNameOwner : fullNameOwner.substring(0, domainIndex)) : Optional.empty();
        ArrayList<ConnectorViewDefinition.ViewColumn> viewColumns = new ArrayList<ConnectorViewDefinition.ViewColumn>();
        for (Column item : view.getDataColumns()) {
            ConnectorViewDefinition.ViewColumn vc = new ConnectorViewDefinition.ViewColumn(item.getName(), item.getType().getTypeSignature());
            viewColumns.add(vc);
        }
        return new ConnectorViewDefinition(hiveViewQuery, Optional.of(this.getCatalogName(session)), Optional.of(view.getDatabaseName()), viewColumns, owner, !owner.isPresent());
    }

    private String getCatalogName(ConnectorSession session) {
        if (session.getCatalog().isPresent()) {
            return (String)session.getCatalog().get();
        }
        return "hive";
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        if (AcidUtils.isInsertOnlyTable(handle.getTableParameters().get())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Attempt to do delete on table " + handle.getTableName() + " that is insert-only transactional");
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector only supports delete where one or more partitions are deleted entirely for Non-Transactional tables");
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Deleting from Hive tables is not supported with query retries enabled");
        }
        return this.beginDelete(session, tableHandle);
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        return HiveColumnHandle.updateRowIdHandle();
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle) {
        return Optional.of(handle);
    }

    public Optional<ConnectorTableHandle> applyDelete(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)handle;
        if (constraint == null) {
            return Optional.of(handle);
        }
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HiveIdentity identity = new HiveIdentity(session);
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, identity, handle, constraint, table);
        HiveTableHandle newHandle = this.partitionManager.applyPartitionResult(hiveTableHandle, partitionResult);
        return Optional.of(newHandle);
    }

    public OptionalLong executeDelete(ConnectorSession session, ConnectorTableHandle deleteHandle) {
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)deleteHandle;
        Optional<Table> table = this.metastore.getTable(identity, handle.getSchemaName(), handle.getTableName());
        if (!table.isPresent()) {
            throw new TableNotFoundException(handle.getSchemaTableName());
        }
        if (table.get().getPartitionColumns().isEmpty()) {
            this.metastore.truncateUnpartitionedTable(session, handle.getSchemaName(), handle.getTableName());
        } else {
            for (HivePartition hivePartition : this.partitionManager.getOrLoadPartitions(session, this.metastore, identity, handle)) {
                this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), HiveUtil.toPartitionValues(hivePartition.getPartitionId()));
            }
        }
        return OptionalLong.empty();
    }

    @VisibleForTesting
    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        ImmutableList partitionColumns = ImmutableList.copyOf(hiveTable.getPartitionColumns());
        List<HivePartition> partitions = this.partitionManager.getOrLoadPartitions(session, this.metastore, identity, hiveTable);
        TupleDomain predicate = HiveMetadata.createPredicate((List<ColumnHandle>)partitionColumns, partitions);
        if (hiveTable.isSuitableToPush()) {
            Table hmsTable = this.metastore.getTable(identity, hiveTable.getSchemaName(), hiveTable.getTableName()).orElseThrow(() -> new TableNotFoundException(hiveTable.getSchemaTableName()));
            ImmutableMap.Builder pushedDown = ImmutableMap.builder();
            pushedDown.putAll(((Map)hiveTable.getCompactEffectivePredicate().getDomains().get()).entrySet().stream().collect(Collectors.toMap(e -> (ColumnHandle)e.getKey(), e -> (Domain)e.getValue())));
            predicate = predicate.intersect(TupleDomain.withColumnDomains((Map)pushedDown.build()));
        }
        Optional<Object> discretePredicates = Optional.empty();
        if (!partitionColumns.isEmpty()) {
            Iterable partitionDomains = Iterables.transform(partitions, hivePartition -> TupleDomain.fromFixedValues(hivePartition.getKeys()));
            discretePredicates = Optional.of(new DiscretePredicates((List)partitionColumns, partitionDomains));
        }
        Optional<Object> tablePartitioning = Optional.empty();
        if (HiveSessionProperties.isBucketExecutionEnabled(session) && hiveTable.getBucketHandle().isPresent()) {
            tablePartitioning = hiveTable.getBucketHandle().map(bucketing -> new ConnectorTablePartitioning((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketing.getBucketingVersion(), bucketing.getReadBucketCount(), (List)bucketing.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList()), OptionalInt.empty()), bucketing.getColumns().stream().map(ColumnHandle.class::cast).collect(Collectors.toList())));
        }
        return new ConnectorTableProperties(predicate, tablePartitioning, Optional.empty(), discretePredicates, (List)ImmutableList.of());
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        return this.applyFilter(session, tableHandle, constraint, (List<Constraint>)ImmutableList.of(), (Set<ColumnHandle>)ImmutableSet.of(), false);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint, List<Constraint> disjuctConstaints, Set<ColumnHandle> allColumnHandles, boolean pushPartitionsOnly) {
        HiveIdentity identity = new HiveIdentity(session);
        HiveTableHandle handle = (HiveTableHandle)tableHandle;
        Preconditions.checkArgument((!handle.getAnalyzePartitionValues().isPresent() || constraint.getSummary().isAll() ? 1 : 0) != 0, (Object)"Analyze should not have a constraint");
        SchemaTableName tableName = handle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        HivePartitionResult partitionResult = this.partitionManager.getPartitions(this.metastore, identity, handle, constraint, table);
        HiveTableHandle newHandle = this.partitionManager.applyPartitionResult(handle, partitionResult);
        ImmutableMap.Builder pushedDown = ImmutableMap.builder();
        pushedDown.putAll(((Map)partitionResult.getUnenforcedConstraint().getDomains().get()).entrySet().stream().collect(Collectors.toMap(e -> (HiveColumnHandle)e.getKey(), e -> (Domain)e.getValue())));
        TupleDomain newEffectivePredicate = newHandle.getCompactEffectivePredicate().intersect(handle.getCompactEffectivePredicate()).intersect(TupleDomain.withColumnDomains((Map)pushedDown.build()));
        ImmutableList.Builder builder = ImmutableList.builder();
        disjuctConstaints.stream().forEach(c -> {
            TupleDomain newSubDomain = TupleDomain.withColumnDomains(((Map)c.getSummary().getDomains().get()).entrySet().stream().collect(Collectors.toMap(e -> (HiveColumnHandle)e.getKey(), e -> (Domain)e.getValue()))).subtract(newEffectivePredicate);
            if (!newSubDomain.isNone()) {
                builder.add((Object)newSubDomain);
            }
        });
        HashSet predicateColumnNames = new HashSet();
        ((Map)newEffectivePredicate.getDomains().get()).keySet().stream().map(HiveColumnHandle::getColumnName).forEach(predicateColumnNames::add);
        ImmutableList newEffectivePredicates = null;
        boolean isSuitableToPush = false;
        if (HiveSessionProperties.isOrcPredicatePushdownEnabled(session)) {
            isSuitableToPush = this.checkIfSuitableToPush(allColumnHandles, tableHandle, session);
        }
        if (isSuitableToPush && HiveSessionProperties.isOrcDisjunctPredicatePushdownEnabled(session)) {
            newEffectivePredicates = builder.build();
            newEffectivePredicates.stream().forEach(nfp -> ((Map)nfp.getDomains().get()).keySet().stream().map(HiveColumnHandle::getColumnName).forEach(predicateColumnNames::add));
        }
        if (isSuitableToPush && partitionResult.getEnforcedConstraint().equals((Object)newEffectivePredicate) && (newEffectivePredicates == null || newEffectivePredicates.size() == 0)) {
            isSuitableToPush = false;
        }
        Map<String, ColumnHandle> columnHandles = this.getColumnHandles(table);
        Map predicateColumns = (Map)predicateColumnNames.stream().map(columnHandles::get).map(HiveColumnHandle.class::cast).filter(HiveColumnHandle::isRegular).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getName, Function.identity()));
        newHandle = new HiveTableHandle(newHandle.getSchemaName(), newHandle.getTableName(), newHandle.getTableParameters(), newHandle.getPartitionColumns(), newHandle.getPartitions(), (TupleDomain<HiveColumnHandle>)newEffectivePredicate, newHandle.getEnforcedConstraint(), newHandle.getBucketHandle(), newHandle.getBucketFilter(), newHandle.getAnalyzePartitionValues(), predicateColumns, Optional.ofNullable(newEffectivePredicates), isSuitableToPush);
        if (pushPartitionsOnly && handle.getPartitions().equals(newHandle.getPartitions()) && handle.getCompactEffectivePredicate().equals(newHandle.getCompactEffectivePredicate()) && handle.getBucketFilter().equals(newHandle.getBucketFilter())) {
            return Optional.empty();
        }
        if (!pushPartitionsOnly && isSuitableToPush) {
            return Optional.of(new ConstraintApplicationResult((Object)newHandle, TupleDomain.all()));
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, partitionResult.getUnenforcedConstraint()));
    }

    protected boolean checkIfSuitableToPush(Set<ColumnHandle> allColumnHandles, ConnectorTableHandle tableHandle, ConnectorSession session) {
        if (HiveTableProperties.getHiveStorageFormat(this.getTableMetadata(session, tableHandle).getProperties()) != HiveStorageFormat.ORC || HiveTableProperties.getTransactionalValue(this.getTableMetadata(session, tableHandle).getProperties())) {
            return false;
        }
        for (ColumnHandle handle : allColumnHandles) {
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)handle;
            if (hiveColumnHandle.getHiveType().getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && !hiveColumnHandle.getHiveType().equals(HiveType.HIVE_BYTE)) continue;
            return false;
        }
        return true;
    }

    public Optional<ConnectorPartitioningHandle> getCommonPartitioningHandle(ConnectorSession session, ConnectorPartitioningHandle left, ConnectorPartitioningHandle right) {
        int smallerBucketCount;
        HivePartitioningHandle leftHandle = (HivePartitioningHandle)left;
        HivePartitioningHandle rightHandle = (HivePartitioningHandle)right;
        if (!leftHandle.getHiveTypes().equals(rightHandle.getHiveTypes())) {
            return Optional.empty();
        }
        if (leftHandle.getBucketingVersion() != rightHandle.getBucketingVersion()) {
            return Optional.empty();
        }
        if (leftHandle.getBucketCount() == rightHandle.getBucketCount()) {
            return Optional.of(leftHandle);
        }
        if (!HiveSessionProperties.isOptimizedMismatchedBucketCount(session)) {
            return Optional.empty();
        }
        int largerBucketCount = Math.max(leftHandle.getBucketCount(), rightHandle.getBucketCount());
        if (largerBucketCount % (smallerBucketCount = Math.min(leftHandle.getBucketCount(), rightHandle.getBucketCount())) != 0) {
            return Optional.empty();
        }
        if (Integer.bitCount(largerBucketCount / smallerBucketCount) != 1) {
            return Optional.empty();
        }
        OptionalInt maxCompatibleBucketCount = HiveMetadata.min(leftHandle.getMaxCompatibleBucketCount(), rightHandle.getMaxCompatibleBucketCount());
        if (maxCompatibleBucketCount.isPresent() && maxCompatibleBucketCount.getAsInt() < smallerBucketCount) {
            return Optional.empty();
        }
        return Optional.of(new HivePartitioningHandle(leftHandle.getBucketingVersion(), smallerBucketCount, leftHandle.getHiveTypes(), maxCompatibleBucketCount));
    }

    private static OptionalInt min(OptionalInt left, OptionalInt right) {
        if (!left.isPresent()) {
            return right;
        }
        if (!right.isPresent()) {
            return left;
        }
        return OptionalInt.of(Math.min(left.getAsInt(), right.getAsInt()));
    }

    public ConnectorTableHandle makeCompatiblePartitioning(ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorPartitioningHandle partitioningHandle) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        HivePartitioningHandle hivePartitioningHandle = (HivePartitioningHandle)partitioningHandle;
        Preconditions.checkArgument((boolean)hiveTable.getBucketHandle().isPresent(), (Object)"Hive connector only provides alternative layout for bucketed table");
        HiveBucketHandle bucketHandle = hiveTable.getBucketHandle().get();
        ImmutableList bucketTypes = (ImmutableList)bucketHandle.getColumns().stream().map(HiveColumnHandle::getHiveType).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)hivePartitioningHandle.getHiveTypes().equals(bucketTypes), (String)"Types from the new PartitioningHandle (%s) does not match the TableHandle (%s)", hivePartitioningHandle.getHiveTypes(), (Object)bucketTypes);
        int largerBucketCount = Math.max(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        int smallerBucketCount = Math.min(bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount());
        Preconditions.checkArgument((largerBucketCount % smallerBucketCount == 0 && Integer.bitCount(largerBucketCount / smallerBucketCount) == 1 ? 1 : 0) != 0, (Object)"The requested partitioning is not a valid alternative for the table layout");
        return new HiveTableHandle(hiveTable.getSchemaName(), hiveTable.getTableName(), hiveTable.getTableParameters(), hiveTable.getPartitionColumns(), hiveTable.getPartitions(), hiveTable.getCompactEffectivePredicate(), hiveTable.getEnforcedConstraint(), Optional.of(new HiveBucketHandle(bucketHandle.getColumns(), bucketHandle.getBucketingVersion(), bucketHandle.getTableBucketCount(), hivePartitioningHandle.getBucketCount())), hiveTable.getBucketFilter(), hiveTable.getAnalyzePartitionValues(), hiveTable.getPredicateColumns(), hiveTable.getDisjunctCompactEffectivePredicate(), hiveTable.isSuitableToPush());
    }

    @VisibleForTesting
    static TupleDomain<ColumnHandle> createPredicate(List<ColumnHandle> partitionColumns, List<HivePartition> partitions) {
        if (partitions.isEmpty()) {
            return TupleDomain.none();
        }
        return TupleDomain.withColumnDomains(partitionColumns.stream().collect(Collectors.toMap(Function.identity(), column -> HiveMetadata.buildColumnDomain(column, partitions))));
    }

    private static Domain buildColumnDomain(ColumnHandle column, List<HivePartition> partitions) {
        Preconditions.checkArgument((!partitions.isEmpty() ? 1 : 0) != 0, (Object)"partitions cannot be empty");
        boolean hasNull = false;
        ArrayList<Object> nonNullValues = new ArrayList<Object>();
        Type type = null;
        for (HivePartition partition : partitions) {
            NullableValue value = partition.getKeys().get(column);
            if (value == null) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, String.format("Partition %s does not have a value for partition column %s", partition, column));
            }
            if (value.isNull()) {
                hasNull = true;
            } else {
                nonNullValues.add(value.getValue());
            }
            if (type != null) continue;
            type = value.getType();
        }
        if (!nonNullValues.isEmpty()) {
            Domain domain = Domain.multipleValues(type, nonNullValues);
            if (hasNull) {
                return domain.union(Domain.onlyNull(type));
            }
            return domain;
        }
        return Domain.onlyNull(type);
    }

    public Optional<ConnectorNewTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return this.getInsertTableLayoutInternal(session, table);
    }

    private Optional<ConnectorNewTableLayout> getInsertTableLayoutInternal(ConnectorSession session, Table table) {
        if (table.getStorage().getBucketProperty().isPresent() && HiveBucketing.bucketedOnTimestamp(table.getStorage().getBucketProperty().get(), table)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables bucketed on timestamp not supported");
        }
        Optional<HiveBucketHandle> hiveBucketHandle = HiveBucketing.getHiveBucketHandle(table);
        if (!hiveBucketHandle.isPresent()) {
            List<Column> partitionColumns = table.getPartitionColumns();
            if (partitionColumns.isEmpty() || !HiveSessionProperties.isWritePartitionDistributionEnabled(session)) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorNewTableLayout((List)partitionColumns.stream().map(Column::getName).collect(ImmutableList.toImmutableList())));
        }
        HiveBucketProperty bucketProperty = table.getStorage().getBucketProperty().orElseThrow(() -> new NoSuchElementException("Bucket property should be set"));
        if (!bucketProperty.getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(hiveBucketHandle.get().getBucketingVersion(), hiveBucketHandle.get().getTableBucketCount(), hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getHiveType).collect(Collectors.toList()), OptionalInt.of(hiveBucketHandle.get().getTableBucketCount()));
        List partitionColumns = hiveBucketHandle.get().getColumns().stream().map(HiveColumnHandle::getName).collect(Collectors.toList());
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumns));
    }

    public Optional<ConnectorNewTableLayout> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Table table = this.metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        List<Column> tablePartitionColumns = table.getPartitionColumns();
        ArrayList<String> partitionColumnNames = new ArrayList<String>();
        ArrayList<HiveType> partitionColumnTypes = new ArrayList<HiveType>();
        tablePartitionColumns.forEach(column -> {
            partitionColumnNames.add(column.getName());
            partitionColumnTypes.add(column.getType());
        });
        partitionColumnNames.add("$rowId".toLowerCase(Locale.ENGLISH));
        partitionColumnTypes.add(HiveColumnHandle.updateRowIdHandle().getHiveType());
        HivePartitioningHandle partitioningHandle = new HivePartitioningHandle(HiveBucketing.BucketingVersion.BUCKETING_V2, 999999, partitionColumnTypes, OptionalInt.empty(), true);
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumnNames));
    }

    public Optional<ConnectorNewTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        this.validateBucketColumns(tableMetadata);
        this.validateCsvColumns(tableMetadata);
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
            if (partitionedBy.isEmpty() || !HiveSessionProperties.isWritePartitionDistributionEnabled(session)) {
                return Optional.empty();
            }
            return Optional.of(new ConnectorNewTableLayout(partitionedBy));
        }
        if (!bucketProperty.get().getSortedBy().isEmpty() && !HiveSessionProperties.isSortedWritingEnabled(session)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to bucketed sorted Hive tables is disabled");
        }
        List<String> bucketedBy = bucketProperty.get().getBucketedBy();
        Map<String, HiveType> hiveTypeMap = tableMetadata.getColumns().stream().collect(Collectors.toMap(ColumnMetadata::getName, column -> HiveType.toHiveType(this.typeTranslator, column.getType())));
        return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new HivePartitioningHandle(bucketProperty.get().getBucketingVersion(), bucketProperty.get().getBucketCount(), bucketedBy.stream().map(hiveTypeMap::get).collect(Collectors.toList()), OptionalInt.of(bucketProperty.get().getBucketCount())), bucketedBy));
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        if (!HiveSessionProperties.isCollectColumnStatisticsOnWrite(session)) {
            return TableStatisticsMetadata.empty();
        }
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, false);
    }

    public TableStatisticsMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        List partitionedBy = (List)MoreObjects.firstNonNull(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()), (Object)ImmutableList.of());
        return this.getStatisticsCollectionMetadata(tableMetadata.getColumns(), partitionedBy, true);
    }

    private TableStatisticsMetadata getStatisticsCollectionMetadata(List<ColumnMetadata> columns, List<String> partitionedBy, boolean includeRowCount) {
        Set columnStatistics = (Set)columns.stream().filter(column -> !partitionedBy.contains(column.getName())).filter(column -> !column.isHidden()).map(this::getColumnStatisticMetadata).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        ImmutableSet tableStatistics = includeRowCount ? ImmutableSet.of((Object)TableStatisticType.ROW_COUNT) : ImmutableSet.of();
        return new TableStatisticsMetadata(columnStatistics, (Set)tableStatistics, partitionedBy);
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(ColumnMetadata columnMetadata) {
        return this.getColumnStatisticMetadata(columnMetadata.getName(), this.metastore.getSupportedColumnStatistics(columnMetadata.getType()));
    }

    private List<ColumnStatisticMetadata> getColumnStatisticMetadata(String columnName, Set<ColumnStatisticType> statisticTypes) {
        return (List)statisticTypes.stream().map(type -> new ColumnStatisticMetadata(columnName, type)).collect(ImmutableList.toImmutableList());
    }

    public void createRole(ConnectorSession session, String role, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, PrestoPrincipal principal) {
        return ImmutableSet.copyOf(this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from(principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean withAdminOption, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), withAdminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOptionFor, Optional<PrestoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOptionFor, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, PrestoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from(principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from(grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    public static HiveStorageFormat extractHiveStorageFormat(Table table) {
        StorageFormat storageFormat = table.getStorage().getStorageFormat();
        String outputFormat = storageFormat.getOutputFormat();
        String serde = storageFormat.getSerDe();
        for (HiveStorageFormat format : HiveStorageFormat.values()) {
            if (!format.getOutputFormat().equals(outputFormat) || !format.getSerDe().equals(serde)) continue;
            return format;
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, String.format("Output format %s with SerDe %s is not supported", outputFormat, serde));
    }

    protected void validateBucketColumns(ConnectorTableMetadata tableMetadata) {
        List<String> bucketedBy;
        Optional<HiveBucketProperty> bucketProperty = HiveTableProperties.getBucketProperty(tableMetadata.getProperties());
        if (!bucketProperty.isPresent()) {
            return;
        }
        Set allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toSet());
        if (!allColumns.containsAll(bucketedBy = bucketProperty.get().getBucketedBy())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Bucketing columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(bucketedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        List sortedBy = (List)bucketProperty.get().getSortedBy().stream().map(SortingColumn::getColumnName).collect(ImmutableList.toImmutableList());
        if (!allColumns.containsAll(sortedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Sorting columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf((Collection)sortedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
    }

    private static void validatePartitionColumns(ConnectorTableMetadata tableMetadata) {
        List<String> partitionedBy = HiveTableProperties.getPartitionedBy(tableMetadata.getProperties());
        List allColumns = tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        if (!allColumns.containsAll(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Partition columns %s not present in schema", Sets.difference((Set)ImmutableSet.copyOf(partitionedBy), (Set)ImmutableSet.copyOf(allColumns))));
        }
        if (allColumns.size() == partitionedBy.size()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "Table contains only partition columns");
        }
        if (!allColumns.subList(allColumns.size() - partitionedBy.size(), allColumns.size()).equals(partitionedBy)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_COLUMN_ORDER_MISMATCH, "Partition keys must be the last columns in the table and in the same order as the table properties: " + partitionedBy);
        }
    }

    protected List<HiveColumnHandle> getColumnHandles(ConnectorTableMetadata tableMetadata, Set<String> partitionColumnNames, TypeTranslator typeTranslator) {
        HiveMetadata.validatePartitionColumns(tableMetadata);
        this.validateBucketColumns(tableMetadata);
        this.validateCsvColumns(tableMetadata);
        ImmutableList.Builder columnHandles = ImmutableList.builder();
        int ordinal = 0;
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            HiveColumnHandle.ColumnType columnType = partitionColumnNames.contains(column.getName()) ? HiveColumnHandle.ColumnType.PARTITION_KEY : (column.isHidden() ? HiveColumnHandle.ColumnType.SYNTHESIZED : HiveColumnHandle.ColumnType.REGULAR);
            columnHandles.add((Object)new HiveColumnHandle(column.getName(), HiveType.toHiveType(typeTranslator, column.getType()), column.getType().getTypeSignature(), ordinal, columnType, Optional.ofNullable(column.getComment())));
            ++ordinal;
        }
        return columnHandles.build();
    }

    protected void validateCsvColumns(ConnectorTableMetadata tableMetadata) {
        if (HiveTableProperties.getHiveStorageFormat(tableMetadata.getProperties()) != HiveStorageFormat.CSV) {
            return;
        }
        ImmutableSet partitionedBy = ImmutableSet.copyOf(HiveTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        List unsupportedColumns = (List)tableMetadata.getColumns().stream().filter(arg_0 -> HiveMetadata.lambda$validateCsvColumns$86((Set)partitionedBy, arg_0)).filter(columnMetadata -> !columnMetadata.getType().equals(VarcharType.createUnboundedVarcharType())).collect(ImmutableList.toImmutableList());
        if (!unsupportedColumns.isEmpty()) {
            String joinedUnsupportedColumns = unsupportedColumns.stream().map(columnMetadata -> String.format("%s %s", columnMetadata.getName(), columnMetadata.getType())).collect(Collectors.joining(", "));
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive CSV storage format only supports VARCHAR (unbounded). Unsupported columns: " + joinedUnsupportedColumns);
        }
    }

    protected static Function<HiveColumnHandle, ColumnMetadata> columnMetadataGetter(Table table, TypeManager typeManager) {
        ImmutableList.Builder columnNames = ImmutableList.builder();
        table.getPartitionColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        table.getDataColumns().stream().map(Column::getName).forEach(arg_0 -> ((ImmutableList.Builder)columnNames).add(arg_0));
        ImmutableList allColumnNames = columnNames.build();
        if (allColumnNames.size() > Sets.newHashSet((Iterable)allColumnNames).size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Hive metadata for table %s is invalid: Table descriptor contains duplicate columns", table.getTableName()));
        }
        List<Column> tableColumns = table.getDataColumns();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Column field : Iterables.concat(tableColumns, table.getPartitionColumns())) {
            if (field.getComment().isPresent() && !field.getComment().get().equals("from deserializer")) {
                builder.put((Object)field.getName(), field.getComment());
                continue;
            }
            builder.put((Object)field.getName(), Optional.empty());
        }
        builder.put((Object)"$path", Optional.empty());
        if (table.getStorage().getBucketProperty().isPresent()) {
            builder.put((Object)"$bucket", Optional.empty());
        }
        ImmutableMap columnComment = builder.build();
        return arg_0 -> HiveMetadata.lambda$columnMetadataGetter$89(typeManager, (Map)columnComment, arg_0);
    }

    @Override
    public void rollback() {
        this.metastore.rollback();
    }

    @Override
    public void commit() {
        this.metastore.commit();
        this.metastore.submitCleanupTasks();
    }

    public void beginQuery(ConnectorSession session) {
        this.metastore.beginQuery(session);
    }

    public void cleanupQuery(ConnectorSession session) {
        this.metastore.cleanupQuery(session);
    }

    public static Optional<SchemaTableName> getSourceTableNameFromSystemTable(SchemaTableName tableName) {
        return Stream.of(SystemTableHandler.values()).filter(handler -> handler.matches(tableName)).map(handler -> handler.getSourceTableName(tableName)).findAny();
    }

    private static SystemTable createSystemTable(final ConnectorTableMetadata metadata, final Function<TupleDomain<Integer>, RecordCursor> cursor) {
        return new SystemTable(){

            public SystemTable.Distribution getDistribution() {
                return SystemTable.Distribution.SINGLE_COORDINATOR;
            }

            public ConnectorTableMetadata getTableMetadata() {
                return metadata;
            }

            public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
                return (RecordCursor)cursor.apply(constraint);
            }
        };
    }

    private static <T> Optional<T> firstNonNullable(T ... values) {
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean isExecutionPlanCacheSupported(ConnectorSession session, ConnectorTableHandle handle) {
        return true;
    }

    public boolean isSnapshotSupportedAsInput(ConnectorSession session, ConnectorTableHandle handle) {
        return true;
    }

    public boolean isSnapshotSupportedAsOutput(ConnectorSession session, ConnectorTableHandle handle) {
        HiveTableHandle tableHandle = (HiveTableHandle)handle;
        Optional<Table> table = this.metastore.getTable(new HiveIdentity(session), tableHandle.getSchemaName(), tableHandle.getTableName());
        return table.isPresent() && HiveMetadata.extractHiveStorageFormat(table.get()) == HiveStorageFormat.ORC;
    }

    public boolean isSnapshotSupportedAsNewTable(ConnectorSession session, Map<String, Object> tableProperties) {
        return HiveTableProperties.getHiveStorageFormat(tableProperties) == HiveStorageFormat.ORC;
    }

    public void resetInsertForRerun(ConnectorSession session, ConnectorInsertTableHandle tableHandle, OptionalLong snapshotIndex) {
        this.updateSnapshotFiles(session, (HiveWritableTableHandle)tableHandle, true, null, snapshotIndex);
    }

    public void resetCreateForRerun(ConnectorSession session, ConnectorOutputTableHandle tableHandle, OptionalLong snapshotIndex) {
        this.updateSnapshotFiles(session, (HiveWritableTableHandle)tableHandle, true, null, snapshotIndex);
    }

    private void updateSnapshotFiles(ConnectorSession session, HiveWritableTableHandle tableHandle, boolean resume, Set<String> mergedFileNames, OptionalLong snapshotIndex) {
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session, tableHandle.getSchemaName(), tableHandle.getTableName()), tableHandle.getLocationHandle().getWritePath());
            this.updatePreviousFiles(fileSystem, tableHandle.getLocationHandle().getWritePath(), session.getQueryId(), resume, mergedFileNames, snapshotIndex.orElse(0L));
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to update Hive files for " + tableHandle.getSchemaName() + "." + tableHandle.getTableName(), (Throwable)e);
        }
    }

    private void updatePreviousFiles(FileSystem fileSystem, Path folder, String queryId, boolean resume, Set<String> mergedFileNames, long snapshotIndex) throws IOException {
        if (fileSystem.exists(folder)) {
            for (FileStatus status : fileSystem.listStatus(folder)) {
                if (status.isDirectory()) {
                    this.updatePreviousFiles(fileSystem, status.getPath(), queryId, resume, mergedFileNames, snapshotIndex);
                    continue;
                }
                if (!HiveWriterFactory.isSnapshotFile(status.getPath().getName(), queryId)) continue;
                String fileName = status.getPath().getName();
                if (resume) {
                    long subFileIndex = HiveWriterFactory.getSnapshotSubFileIndex(fileName, queryId);
                    if (subFileIndex >= 0L && subFileIndex < snapshotIndex) continue;
                    log.debug("Deleting file resume=true: %s", new Object[]{fileName});
                    fileSystem.delete(status.getPath());
                    continue;
                }
                if (HiveWriterFactory.isSnapshotSubFile(fileName, queryId)) {
                    log.debug("Deleting sub file resume=false: %s", new Object[]{fileName});
                    fileSystem.delete(status.getPath());
                    continue;
                }
                if (mergedFileNames.contains(fileName) || mergedFileNames.contains(status.getPath().getParent().getName())) {
                    String newName = HiveWriterFactory.removeSnapshotFileName(fileName, queryId);
                    log.debug("Renaming merged file resume=false: %s to %s", new Object[]{fileName, newName});
                    fileSystem.rename(status.getPath(), new Path(folder, newName));
                    continue;
                }
                log.debug("Deleting old merged file resume=false: %s", new Object[]{fileName});
                fileSystem.delete(status.getPath());
            }
            Path acidVersionFile = AcidUtils.OrcAcidVersion.getVersionFilePath((Path)folder);
            if (fileSystem.exists(acidVersionFile) && fileSystem.getFileStatus(acidVersionFile).getLen() == 0L) {
                fileSystem.delete(acidVersionFile);
                AcidUtils.OrcAcidVersion.writeVersionFile((Path)folder, (FileSystem)fileSystem);
            }
        }
    }

    private Set<String> collectMergedFileNames(List<PartitionUpdate> partitionUpdates) {
        return partitionUpdates.stream().flatMap(update -> update.getFileNames().stream()).collect(Collectors.toSet());
    }

    private List<PartitionUpdate> updateSnapshotFileNames(List<PartitionUpdate> partitionUpdates, String queryId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (PartitionUpdate partitionUpdate : partitionUpdates) {
            builder.add((Object)new PartitionUpdate(partitionUpdate.getName(), partitionUpdate.getUpdateMode(), partitionUpdate.getWritePath(), partitionUpdate.getTargetPath(), this.updateSnapshotFileName(partitionUpdate.getFileNames(), queryId), partitionUpdate.getRowCount(), partitionUpdate.getInMemoryDataSizeInBytes(), partitionUpdate.getOnDiskDataSizeInBytes(), partitionUpdate.getMiscData()));
        }
        return builder.build();
    }

    private List<String> updateSnapshotFileName(List<String> fileNames, String queryId) {
        return fileNames.stream().map(name -> HiveWriterFactory.removeSnapshotFileName(name, queryId)).collect(Collectors.toList());
    }

    protected void finishInsertOverwrite(ConnectorSession session, HiveInsertTableHandle handle, Table table, PartitionUpdate partitionUpdate, PartitionStatistics partitionStatistics) {
        PrincipalPrivileges principalPrivileges = PrincipalPrivileges.fromHivePrivilegeInfos(this.metastore.listTablePrivileges(handle.getSchemaName(), handle.getTableName(), null));
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName());
        this.metastore.createTable(session, table, principalPrivileges, Optional.of(partitionUpdate.getWritePath()), false, partitionStatistics, Optional.of(partitionUpdate.getFileNames()), handle.isRetriesEnabled());
    }

    protected void finishInsertInNewPartition(ConnectorSession session, HiveInsertTableHandle handle, Table table, Map<String, Type> columnTypes, PartitionUpdate partitionUpdate, Map<List<String>, ComputedStatistics> partitionComputedStatistics, HiveACIDWriteType acidWriteType) {
        Partition partition = this.buildPartitionObject(session, table, partitionUpdate);
        if (!partition.getStorage().getStorageFormat().getInputFormat().equals(handle.getPartitionStorageFormat().getInputFormat()) && HiveSessionProperties.isRespectTableFormat(session)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CONCURRENT_MODIFICATION_DETECTED, "Partition format changed during insert");
        }
        if (partitionUpdate.getUpdateMode() == PartitionUpdate.UpdateMode.OVERWRITE) {
            this.metastore.dropPartition(session, handle.getSchemaName(), handle.getTableName(), partition.getValues());
        }
        PartitionStatistics partitionStatistics = this.createPartitionStatistics(session, partitionUpdate.getStatistics(), columnTypes, HiveMetadata.getColumnStatistics(partitionComputedStatistics, partition.getValues()));
        this.metastore.addPartition(session, handle.getSchemaName(), handle.getTableName(), partition, partitionUpdate.getWritePath(), partitionStatistics, acidWriteType, Optional.of(partitionUpdate.getFileNames()), handle.isRetriesEnabled());
    }

    public void setExternalTable(boolean externalTable) {
        this.externalTable = externalTable;
    }

    protected void verifyStorageFormatForCatalog(StorageFormat storageFormat) {
        Objects.requireNonNull(storageFormat, "Storage format is null");
        if (storageFormat.getInputFormat().contains("CarbonInputFormat")) {
            String sf = storageFormat.getInputFormat();
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Tables with %s are not supported by Hive connector", sf.substring(sf.lastIndexOf(".") + 1)));
        }
    }

    public List<ConnectorVacuumTableInfo> getTablesForVacuum() {
        if (this.autoVacuumEnabled) {
            return VacuumEligibleTableCollector.getVacuumTableList(this.metastore, this.hdfsEnvironment, this.vacuumDeltaNumThreshold, this.vacuumDeltaPercentThreshold, this.vacuumExecutorService, this.vacuumCollectorInterval);
        }
        return null;
    }

    public PartialAndFinalAggregationType validateAndGetSortAggregationType(ConnectorSession session, ConnectorTableHandle tableHandle, List<String> groupKeyNames) {
        boolean singleOrZeroBucketedColumn;
        PartialAndFinalAggregationType partialAndFinalAggregationType = new PartialAndFinalAggregationType();
        ConnectorTableMetadata connectorTableMetadata = this.getTableMetadata(session, ((HiveTableHandle)tableHandle).getSchemaTableName());
        List sortingColumn = (List)connectorTableMetadata.getProperties().get("sorted_by");
        boolean isSortingColumnsNotPresent = sortingColumn == null || sortingColumn.size() == 0;
        ArrayList partitionedBy = new ArrayList();
        List partitionedByTemp = (List)connectorTableMetadata.getProperties().get("partitioned_by");
        if (partitionedByTemp != null && partitionedByTemp.size() != 0) {
            partitionedBy.addAll(partitionedByTemp);
            if (isSortingColumnsNotPresent && partitionedByTemp.size() != groupKeyNames.size()) {
                return partialAndFinalAggregationType;
            }
        } else if (isSortingColumnsNotPresent) {
            return partialAndFinalAggregationType;
        }
        int bucketCount = 0;
        ArrayList bucketedColumns = new ArrayList();
        if (!isSortingColumnsNotPresent) {
            bucketedColumns.addAll((List)connectorTableMetadata.getProperties().get("bucketed_by"));
            if (null != bucketedColumns) {
                bucketCount = (Integer)connectorTableMetadata.getProperties().get("bucket_count");
            }
        }
        ArrayList sortedColumnNames = new ArrayList();
        if (sortingColumn != null && sortingColumn.size() != 0) {
            sortedColumnNames.addAll(sortingColumn.stream().map(column -> column.getColumnName()).collect(Collectors.toList()));
        }
        if (partitionedBy.size() + sortedColumnNames.size() < groupKeyNames.size() || partitionedBy.size() > groupKeyNames.size()) {
            log.debug("number of sorted columns " + sortedColumnNames.size() + "are less join column size " + groupKeyNames.size());
            return partialAndFinalAggregationType;
        }
        int partitionedByCount = partitionedBy.size() == 0 ? 0 : partitionedBy.size() - 1;
        boolean bl = singleOrZeroBucketedColumn = bucketCount == 1 && bucketedColumns.size() == 1 && groupKeyNames.get(partitionedByCount).equals(bucketedColumns.get(0)) || bucketCount == 0;
        if (bucketCount == 1 && bucketedColumns.size() > 1) {
            int minSize = Math.min(groupKeyNames.size() - partitionedBy.size(), bucketedColumns.size());
            int partSize = partitionedBy.size();
            for (int keyIdx = 0; keyIdx < minSize; ++keyIdx) {
                if (groupKeyNames.get(keyIdx + partSize).equals(bucketedColumns.get(keyIdx))) continue;
                return partialAndFinalAggregationType;
            }
            singleOrZeroBucketedColumn = true;
        }
        for (int numOfComparedKeys = 0; numOfComparedKeys < partitionedBy.size(); ++numOfComparedKeys) {
            if (groupKeyNames.get(numOfComparedKeys).equals(partitionedBy.get(numOfComparedKeys))) continue;
            return partialAndFinalAggregationType;
        }
        if (groupKeyNames.size() == partitionedBy.size()) {
            partialAndFinalAggregationType.setPartialAsSortAndFinalAsHashAggregation(true);
            return partialAndFinalAggregationType;
        }
        if (singleOrZeroBucketedColumn || groupKeyNames.size() == bucketedColumns.size() + partitionedBy.size()) {
            int numOfCmpKeysAfterPartitionedBy = partitionedBy.size();
            int numOfComparedKeys = 0;
            while (numOfComparedKeys < groupKeyNames.size() - partitionedBy.size()) {
                boolean bucketedColumnsResult;
                boolean bl2 = bucketedColumnsResult = !singleOrZeroBucketedColumn && !groupKeyNames.get(numOfComparedKeys).equals(bucketedColumns.get(numOfComparedKeys));
                if (!groupKeyNames.get(numOfCmpKeysAfterPartitionedBy).equals(sortedColumnNames.get(numOfComparedKeys)) || !singleOrZeroBucketedColumn && bucketedColumnsResult) {
                    if (log.isDebugEnabled()) {
                        String[] dbgGroupKeyNames = new String[]{new String("")};
                        groupKeyNames.stream().forEach(k -> {
                            dbgGroupKeyNames[0] = dbgGroupKeyNames[0].concat(k + " , ");
                        });
                        String[] dbgSortedColumnNames = new String[]{new String("")};
                        sortedColumnNames.stream().forEach(k -> {
                            dbgSortedColumnNames[0] = dbgSortedColumnNames[0].concat(k + " , ");
                        });
                        if (null != bucketedColumns && bucketedColumns.size() > 0) {
                            String[] dbgbucketedColumns = new String[]{new String("")};
                            bucketedColumns.stream().forEach(k -> {
                                dbgbucketedColumns[0] = dbgbucketedColumns[0].concat(k + " , ");
                            });
                            log.debug("Not matching sortedColumnNames: " + dbgSortedColumnNames + " group columns name: " + dbgGroupKeyNames + " bucketedColumns :" + dbgbucketedColumns);
                        }
                        log.debug("Not matching sortedColumnNames: " + dbgSortedColumnNames + " group columns name: " + dbgGroupKeyNames);
                    }
                    return partialAndFinalAggregationType;
                }
                ++numOfComparedKeys;
                ++numOfCmpKeysAfterPartitionedBy;
            }
            partialAndFinalAggregationType.setSortAggregation(true);
            return partialAndFinalAggregationType;
        }
        return partialAndFinalAggregationType;
    }

    public void refreshMetadataCache() {
        this.metastore.refreshMetastoreCache();
    }

    private static /* synthetic */ ColumnMetadata lambda$columnMetadataGetter$89(TypeManager typeManager, Map columnComment, HiveColumnHandle handle) {
        return new ColumnMetadata(handle.getName(), typeManager.getType(handle.getTypeSignature()), true, (String)((Optional)columnComment.get(handle.getName())).orElse(null), HiveUtil.columnExtraInfo(handle.isPartitionKey()), handle.isHidden(), Collections.emptyMap(), handle.isRequired());
    }

    private static /* synthetic */ boolean lambda$validateCsvColumns$86(Set partitionedBy, ColumnMetadata columnMetadata) {
        return !partitionedBy.contains(columnMetadata.getName());
    }

    private static /* synthetic */ RecordCursor lambda$getPropertiesSystemTable$5(List types, Iterable propertyValues, TupleDomain constraint) {
        return new InMemoryRecordSet((Collection)types, propertyValues).cursor();
    }

    private static enum SystemTableHandler {
        PARTITIONS,
        PROPERTIES;

        private final String suffix = "$" + this.name().toLowerCase(Locale.ENGLISH);

        boolean matches(SchemaTableName table) {
            return table.getTableName().endsWith(this.suffix) && table.getTableName().length() > this.suffix.length();
        }

        SchemaTableName getSourceTableName(SchemaTableName table) {
            return new SchemaTableName(table.getSchemaName(), table.getTableName().substring(0, table.getTableName().length() - this.suffix.length()));
        }
    }
}

