/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.airlift.concurrent.BoundedExecutor;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.ForHive;
import io.prestosql.plugin.hive.ForHiveMetastore;
import io.prestosql.plugin.hive.ForHiveTransactionHeartbeats;
import io.prestosql.plugin.hive.ForHiveVacuum;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveMetadata;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.NodeVersion;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.TransactionalMetadata;
import io.prestosql.plugin.hive.TypeTranslator;
import io.prestosql.plugin.hive.metastore.CachingHiveMetastore;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.security.AccessControlMetadataFactory;
import io.prestosql.plugin.hive.statistics.MetastoreHiveStatisticsProvider;
import io.prestosql.plugin.hive.statistics.TableColumnStatistics;
import io.prestosql.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.inject.Inject;

public class HiveMetadataFactory
implements Supplier<TransactionalMetadata> {
    protected final Map<String, TableColumnStatistics> statsCache = new ConcurrentHashMap<String, TableColumnStatistics>();
    protected final Map<Table, MetastoreHiveStatisticsProvider.SamplePartition> samplePartitionCache = new ConcurrentHashMap<Table, MetastoreHiveStatisticsProvider.SamplePartition>();
    private final boolean skipDeletionForAlter;
    private final boolean skipTargetCleanupOnRollback;
    private final boolean writesToNonManagedTablesEnabled;
    private final boolean createsOfNonManagedTablesEnabled;
    private final boolean tableCreatesWithLocationAllowed;
    private final long perTransactionCacheMaximumSize;
    private final HiveMetastore metastore;
    private final HdfsEnvironment hdfsEnvironment;
    private final HivePartitionManager partitionManager;
    private final TypeManager typeManager;
    private final LocationService locationService;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final BoundedExecutor renameExecution;
    private final ScheduledExecutorService hiveVacuumService;
    private final TypeTranslator typeTranslator;
    private final String prestoVersion;
    private final AccessControlMetadataFactory accessControlMetadataFactory;
    private final Optional<Duration> hiveTransactionHeartbeatInterval;
    private final ScheduledExecutorService heartbeatService;
    private final ScheduledExecutorService hiveMetastoreClientService;
    private final Duration vacuumCleanupRecheckInterval;
    private final int vacuumDeltaNumThreshold;
    private final double vacuumDeltaPercentThreshold;
    private final boolean autoVacuumEnabled;
    private Optional<Duration> vacuumCollectorInterval;
    protected final int hmsWriteBatchSize;

    @Inject
    public HiveMetadataFactory(HiveConfig hiveConfig, HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, @ForHive ExecutorService executorService, @ForHiveVacuum ScheduledExecutorService hiveVacuumService, @ForHiveMetastore ScheduledExecutorService hiveMetastoreClientService, @ForHiveTransactionHeartbeats ScheduledExecutorService heartbeatService, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, TypeTranslator typeTranslator, NodeVersion nodeVersion, AccessControlMetadataFactory accessControlMetadataFactory) {
        this(metastore, hdfsEnvironment, partitionManager, hiveConfig.getMaxConcurrentFileRenames(), hiveConfig.isSkipDeletionForAlter(), hiveConfig.isSkipTargetCleanupOnRollback(), hiveConfig.getWritesToNonManagedTablesEnabled(), hiveConfig.getCreatesOfNonManagedTablesEnabled(), hiveConfig.getTableCreatesWithLocationAllowed(), hiveConfig.getPerTransactionMetastoreCacheMaximumSize(), hiveConfig.getHiveTransactionHeartbeatInterval(), hiveConfig.getVacuumCleanupRecheckInterval(), typeManager, locationService, partitionUpdateCodec, executorService, hiveVacuumService, heartbeatService, hiveMetastoreClientService, typeTranslator, nodeVersion.toString(), accessControlMetadataFactory, hiveConfig.getVacuumDeltaNumThreshold(), hiveConfig.getVacuumDeltaPercentThreshold(), hiveConfig.getAutoVacuumEnabled(), hiveConfig.getVacuumCollectorInterval(), hiveConfig.getMetastoreWriteBatchSize());
    }

    public HiveMetadataFactory(HiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HivePartitionManager partitionManager, int maxConcurrentFileRenames, boolean skipDeletionForAlter, boolean skipTargetCleanupOnRollback, boolean writesToNonManagedTablesEnabled, boolean createsOfNonManagedTablesEnabled, boolean tableCreatesWithLocationAllowed, long perTransactionCacheMaximumSize, Optional<Duration> hiveTransactionHeartbeatInterval, Duration vacuumCleanupRecheckInterval, TypeManager typeManager, LocationService locationService, JsonCodec<PartitionUpdate> partitionUpdateCodec, ExecutorService executorService, ScheduledExecutorService hiveVacuumService, ScheduledExecutorService heartbeatService, ScheduledExecutorService hiveMetastoreClientService, TypeTranslator typeTranslator, String prestoVersion, AccessControlMetadataFactory accessControlMetadataFactory, int vacuumDeltaNumThreshold, double vacuumDeltaPercentThreshold, boolean autoVacuumEnabled, Optional<Duration> vacuumCollectorInterval, int hmsWriteBatchSize) {
        this.skipDeletionForAlter = skipDeletionForAlter;
        this.skipTargetCleanupOnRollback = skipTargetCleanupOnRollback;
        this.writesToNonManagedTablesEnabled = writesToNonManagedTablesEnabled;
        this.createsOfNonManagedTablesEnabled = createsOfNonManagedTablesEnabled;
        this.tableCreatesWithLocationAllowed = tableCreatesWithLocationAllowed;
        this.perTransactionCacheMaximumSize = perTransactionCacheMaximumSize;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        this.typeTranslator = Objects.requireNonNull(typeTranslator, "typeTranslator is null");
        this.prestoVersion = Objects.requireNonNull(prestoVersion, "prestoVersion is null");
        this.accessControlMetadataFactory = Objects.requireNonNull(accessControlMetadataFactory, "accessControlMetadataFactory is null");
        this.hiveTransactionHeartbeatInterval = Objects.requireNonNull(hiveTransactionHeartbeatInterval, "hiveTransactionHeartbeatInterval is null");
        this.vacuumCleanupRecheckInterval = Objects.requireNonNull(vacuumCleanupRecheckInterval, "vacuumCleanupInterval is null");
        this.renameExecution = new BoundedExecutor((Executor)executorService, maxConcurrentFileRenames);
        this.hiveVacuumService = Objects.requireNonNull(hiveVacuumService, "hiveVacuumService is null");
        this.heartbeatService = Objects.requireNonNull(heartbeatService, "heartbeatService is null");
        this.hiveMetastoreClientService = Objects.requireNonNull(hiveMetastoreClientService, "heartbeatService is null");
        this.vacuumDeltaNumThreshold = vacuumDeltaNumThreshold;
        this.vacuumDeltaPercentThreshold = vacuumDeltaPercentThreshold;
        this.autoVacuumEnabled = autoVacuumEnabled;
        this.vacuumCollectorInterval = vacuumCollectorInterval;
        this.hmsWriteBatchSize = hmsWriteBatchSize;
    }

    @Override
    public HiveMetadata get() {
        SemiTransactionalHiveMetastore localMetastore = new SemiTransactionalHiveMetastore(this.hdfsEnvironment, CachingHiveMetastore.memoizeMetastore(this.metastore, this.perTransactionCacheMaximumSize), (Executor)this.renameExecution, this.hiveVacuumService, this.vacuumCleanupRecheckInterval, this.skipDeletionForAlter, this.skipTargetCleanupOnRollback, this.hiveTransactionHeartbeatInterval, this.heartbeatService, this.hiveMetastoreClientService, this.hmsWriteBatchSize);
        return new HiveMetadata(localMetastore, this.hdfsEnvironment, this.partitionManager, this.writesToNonManagedTablesEnabled, this.createsOfNonManagedTablesEnabled, this.tableCreatesWithLocationAllowed, this.typeManager, this.locationService, this.partitionUpdateCodec, this.typeTranslator, this.prestoVersion, new MetastoreHiveStatisticsProvider(localMetastore, this.statsCache, this.samplePartitionCache), this.accessControlMetadataFactory.create(localMetastore), this.autoVacuumEnabled, this.vacuumDeltaNumThreshold, this.vacuumDeltaPercentThreshold, this.hiveVacuumService, this.vacuumCollectorInterval, this.hiveMetastoreClientService);
    }
}

