/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class HiveMetastoreClosure {
    private final HiveMetastore delegate;

    public HiveMetastoreClosure(HiveMetastore delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    public Optional<Table> getTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTable(identity, databaseName, tableName);
    }

    public PartitionStatistics getTableStatistics(HiveIdentity identity, String databaseName, String tableName) {
        return this.delegate.getTableStatistics(identity, this.getExistingTable(identity, databaseName, tableName));
    }

    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, String databaseName, String tableName, Set<String> partitionNames) {
        Table table = this.getExistingTable(identity, databaseName, tableName);
        List<Partition> partitions = this.getExistingPartitionsByNames(identity, table, (List<String>)ImmutableList.copyOf(partitionNames));
        return this.delegate.getPartitionStatistics(identity, table, partitions);
    }

    private List<Partition> getExistingPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        Map partitions = (Map)this.delegate.getPartitionsByNames(identity, table.getDatabaseName(), table.getTableName(), partitionNames).entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), ((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), HivePartitionManager.extractPartitionValues((String)entry.getKey()))))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (List)partitionNames.stream().map(partitions::get).collect(ImmutableList.toImmutableList());
    }

    public void updateTableStatistics(HiveIdentity identity, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updateTableStatistics(identity, databaseName, tableName, update);
    }

    public void updatePartitionStatistics(HiveIdentity identity, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        this.delegate.updatePartitionStatistics(identity, databaseName, tableName, partitionName, update);
    }

    public void addPartitions(HiveIdentity identity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(identity, databaseName, tableName, partitions);
    }

    public void dropPartition(HiveIdentity identity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
    }

    public void alterPartition(HiveIdentity identity, String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(identity, databaseName, tableName, partition);
    }

    public Optional<Partition> getPartition(HiveIdentity identity, String databaseName, String tableName, List<String> partitionValues) {
        return this.delegate.getPartition(identity, databaseName, tableName, partitionValues);
    }
}

