/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveBucketFunction;
import io.prestosql.plugin.hive.HivePartitionHandle;
import io.prestosql.plugin.hive.HivePartitioningHandle;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.spi.connector.BucketFunction;
import io.prestosql.spi.connector.ConnectorBucketNodeMap;
import io.prestosql.spi.connector.ConnectorNodePartitioningProvider;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.Type;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(handle.getBucketingVersion(), bucketCount, hiveTypes, handle.isForUpdateOrDelete());
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        return ConnectorBucketNodeMap.createBucketNodeMap((int)handle.getBucketCount());
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplitWrapper)value).getBucketNumber().orElseThrow(() -> new IllegalArgumentException("Bucket number not set in split"));
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        int bucketCount = handle.getBucketCount();
        return (List)IntStream.range(0, bucketCount).mapToObj(HivePartitionHandle::new).collect(ImmutableList.toImmutableList());
    }
}

