/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveBucketFunction;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.HiveWriter;
import io.prestosql.plugin.hive.HiveWriterFactory;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PageIndexer;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.IntArrayBlockBuilder;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ConnectorPageSink;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.snapshot.BlockEncodingSerdeProvider;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class HivePageSink
implements ConnectorPageSink {
    private static final Logger log = Logger.get(HivePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final HiveWriterFactory writerFactory;
    private final int[] dataColumnInputIndex;
    private final int[] partitionColumnsInputIndex;
    private final int rowIdColumnIndex;
    private final HiveACIDWriteType acidWriteType;
    private final int[] bucketColumns;
    private final HiveBucketFunction bucketFunction;
    private final HiveWriterPagePartitioner pagePartitioner;
    private final HdfsEnvironment hdfsEnvironment;
    private final int maxOpenWriters;
    private final ListeningExecutorService writeVerificationExecutor;
    private final JsonCodec<PartitionUpdate> partitionUpdateCodec;
    private final List<HiveWriter> writers = new ArrayList<HiveWriter>();
    private final List<WriterParam> writerParams = new ArrayList<WriterParam>();
    protected final ConnectorSession session;
    private final List<Block> nullBlocks;
    private long rows;
    private long writtenBytes;
    private long systemMemoryUsage;
    private long validationCpuNanos;
    protected final List<HiveColumnHandle> inputColumns;
    private final TypeManager typeManager;
    protected final HiveWritableTableHandle writableTableHandle;
    private final ThreadLocal<Map<String, AcidOutputFormat.Options>> vacuumOptionsMap = ThreadLocal.withInitial(() -> null);
    private VaccumOp vacuumOp;

    public HivePageSink(HiveWriterFactory writerFactory, List<HiveColumnHandle> inputColumns, Optional<HiveBucketProperty> bucketProperty, PageIndexerFactory pageIndexerFactory, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, int maxOpenWriters, ListeningExecutorService writeVerificationExecutor, JsonCodec<PartitionUpdate> partitionUpdateCodec, ConnectorSession session, HiveACIDWriteType acidWriteType, HiveWritableTableHandle handle) {
        int inputIndex;
        this.writerFactory = Objects.requireNonNull(writerFactory, "writerFactory is null");
        this.acidWriteType = acidWriteType;
        this.writableTableHandle = Objects.requireNonNull(handle, "hive table handle is null");
        this.inputColumns = Objects.requireNonNull(inputColumns, "inputColumns is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typemMnager is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.maxOpenWriters = maxOpenWriters;
        this.writeVerificationExecutor = Objects.requireNonNull(writeVerificationExecutor, "writeVerificationExecutor is null");
        this.partitionUpdateCodec = Objects.requireNonNull(partitionUpdateCodec, "partitionUpdateCodec is null");
        Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.pagePartitioner = new HiveWriterPagePartitioner(inputColumns, bucketProperty.isPresent() || handle.getTableStorageFormat() == HiveStorageFormat.ORC && HiveACIDWriteType.isRowIdNeeded(acidWriteType) && HiveACIDWriteType.VACUUM_UNIFY != acidWriteType && !this.isInsertOnlyTable(), this.isVacuumOperationValid() && !this.isInsertOnlyTable(), pageIndexerFactory, typeManager);
        ImmutableList.Builder partitionColumns = ImmutableList.builder();
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        ImmutableList.Builder dataColumnTypes = ImmutableList.builder();
        Object2IntOpenHashMap dataColumnNameToIdMap = new Object2IntOpenHashMap();
        HashMap<String, HiveType> dataColumnNameToTypeMap = new HashMap<String, HiveType>();
        for (inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            HiveColumnHandle column = inputColumns.get(inputIndex);
            if (column.isPartitionKey()) {
                partitionColumns.add((Object)inputIndex);
                continue;
            }
            dataColumnsInputIndex.add((Object)inputIndex);
            dataColumnNameToIdMap.put((Object)column.getName(), inputIndex);
            dataColumnNameToTypeMap.put(column.getName(), column.getHiveType());
            dataColumnTypes.add((Object)typeManager.getType(column.getTypeSignature()));
        }
        this.rowIdColumnIndex = HiveACIDWriteType.isRowIdNeeded(acidWriteType) ? inputIndex : -1;
        this.partitionColumnsInputIndex = Ints.toArray((Collection)partitionColumns.build());
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        if (bucketProperty.isPresent()) {
            HiveBucketing.BucketingVersion bucketingVersion = bucketProperty.get().getBucketingVersion();
            int bucketCount = bucketProperty.get().getBucketCount();
            this.bucketColumns = bucketProperty.get().getBucketedBy().stream().mapToInt(arg_0 -> ((Object2IntMap)dataColumnNameToIdMap).get(arg_0)).toArray();
            List<HiveType> bucketColumnTypes = bucketProperty.get().getBucketedBy().stream().map(dataColumnNameToTypeMap::get).collect(Collectors.toList());
            this.bucketFunction = new HiveBucketFunction(bucketingVersion, bucketCount, bucketColumnTypes);
        } else if (handle.getTableStorageFormat() == HiveStorageFormat.ORC && HiveACIDWriteType.isRowIdNeeded(acidWriteType) && !this.isInsertOnlyTable()) {
            this.bucketColumns = new int[]{this.rowIdColumnIndex};
            this.bucketFunction = new HiveBucketFunction(HiveBucketing.BucketingVersion.BUCKETING_V2, 999999, (List<HiveType>)ImmutableList.of((Object)HiveColumnHandle.updateRowIdHandle().getHiveType()), true);
        } else {
            this.bucketColumns = null;
            this.bucketFunction = null;
        }
        if (acidWriteType == HiveACIDWriteType.DELETE) {
            ImmutableList.Builder localNullBlocks = ImmutableList.builder();
            for (Type dataColumnType : dataColumnTypes.build()) {
                BlockBuilder blockBuilder = dataColumnType.createBlockBuilder(null, 1, 0);
                blockBuilder.appendNull();
                localNullBlocks.add((Object)blockBuilder.build());
            }
            this.nullBlocks = localNullBlocks.build();
        } else {
            this.nullBlocks = ImmutableList.of();
        }
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getRowsWritten() {
        return this.rows;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryUsage;
    }

    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ListenableFuture result = this.hdfsEnvironment.doAs(this.session.getUser(), this::doFinish);
        if (!this.session.isSnapshotEnabled()) {
            return MoreFutures.toCompletableFuture((ListenableFuture)result);
        }
        this.writtenBytes = 0L;
        ListenableFuture mergedResult = this.hdfsEnvironment.doAs(this.session.getUser(), this::mergeFiles);
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.transform((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{result, mergedResult}), results -> (Collection)results.get(1), (Executor)MoreExecutors.directExecutor()));
    }

    private ListenableFuture<Collection<Slice>> doFinish() {
        ImmutableList.Builder partitionUpdates = ImmutableList.builder();
        ArrayList verificationTasks = new ArrayList();
        for (HiveWriter writer : this.writers) {
            if (writer == null) continue;
            writer.commit();
            PartitionUpdate partitionUpdate = writer.getPartitionUpdate();
            partitionUpdates.add((Object)Slices.wrappedBuffer((byte[])this.partitionUpdateCodec.toJsonBytes((Object)partitionUpdate)));
            writer.getVerificationTask().map(Executors::callable).ifPresent(verificationTasks::add);
        }
        ImmutableList result = partitionUpdates.build();
        this.writtenBytes += this.writers.stream().filter(Objects::nonNull).mapToLong(HiveWriter::getWrittenBytes).sum();
        this.validationCpuNanos += this.writers.stream().filter(Objects::nonNull).mapToLong(HiveWriter::getValidationCpuNanos).sum();
        this.writers.clear();
        if (this.vacuumOp != null) {
            this.vacuumOp.close();
        }
        if (verificationTasks.isEmpty()) {
            return Futures.immediateFuture((Object)result);
        }
        try {
            List futures = this.writeVerificationExecutor.invokeAll(verificationTasks).stream().map(future -> (ListenableFuture)future).collect(Collectors.toList());
            return Futures.transform((ListenableFuture)Futures.allAsList(futures), arg_0 -> HivePageSink.lambda$doFinish$3((List)result, arg_0), (Executor)MoreExecutors.directExecutor());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private ListenableFuture<Collection<Slice>> mergeFiles() {
        Preconditions.checkState((boolean)this.writers.isEmpty());
        try {
            for (WriterParam param : this.writerParams) {
                HiveWriter hiveWriter = this.writerFactory.createWriterForSnapshotMerge(param.partitionValues, param.bucket, Optional.empty());
                this.writers.add(hiveWriter);
            }
            this.writerFactory.mergeSubFiles(this.writers);
            return this.doFinish();
        }
        catch (IOException e) {
            log.debug("exception '%s' while merging subfile", new Object[]{e});
            throw new RuntimeException(e);
        }
    }

    public void abort() {
        this.hdfsEnvironment.doAs(this.session.getUser(), () -> this.doAbort(false));
    }

    public void cancelToResume() {
        this.hdfsEnvironment.doAs(this.session.getUser(), () -> this.doAbort(true));
    }

    private void doAbort(boolean isCancel) {
        Optional<Object> rollbackException = Optional.empty();
        for (HiveWriter writer : this.writers) {
            if (writer == null) continue;
            try {
                writer.rollback(isCancel);
            }
            catch (Exception e) {
                log.warn("exception '%s' while rollback on %s", new Object[]{e, writer});
                rollbackException = Optional.of(e);
            }
        }
        this.writers.clear();
        if (rollbackException.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)rollbackException.get());
        }
    }

    public ConnectorPageSink.VacuumResult vacuum(ConnectorPageSourceProvider pageSourceProvider, ConnectorTransactionHandle transactionHandle, ConnectorTableHandle connectorTableHandle, List<ConnectorSplit> splits) {
        if (this.vacuumOp == null) {
            this.vacuumOp = new VaccumOp(pageSourceProvider, transactionHandle, connectorTableHandle, splits);
        }
        Page page = this.vacuumOp.processNext();
        return new ConnectorPageSink.VacuumResult(page, this.vacuumOp.isFinished());
    }

    private Optional<AcidOutputFormat.Options> getVacuumOptions(String partition) {
        Map<String, AcidOutputFormat.Options> partitionToOptions = this.vacuumOptionsMap.get();
        if (partitionToOptions == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(partitionToOptions.get(partition));
    }

    public CompletableFuture<?> appendPage(Page page) {
        if (page.getPositionCount() > 0) {
            this.hdfsEnvironment.doAs(this.session.getUser(), () -> this.doAppend(page));
        }
        return NOT_BLOCKED;
    }

    private void doAppend(Page inputPage) {
        Page page = inputPage;
        while (page.getPositionCount() > 4096) {
            Page chunk = page.getRegion(0, 4096);
            page = page.getRegion(4096, page.getPositionCount() - 4096);
            this.writePage(chunk);
        }
        this.writePage(page);
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify((positions.length == counts[index] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            HiveWriter writer = this.writers.get(index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getSystemMemoryUsage();
            writer.append(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.systemMemoryUsage += writer.getSystemMemoryUsage() - currentMemory;
        }
        this.rows += (long)page.getPositionCount();
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = HivePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        Block bucketBlock = this.buildBucketBlock(page);
        Block operationIdBlock = this.buildAcidOperationBlock(page);
        int[] writerIndexes = this.pagePartitioner.partitionPage(partitionColumns, bucketBlock, operationIdBlock);
        if (this.pagePartitioner.getMaxIndex() >= this.maxOpenWriters) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, String.format("Exceeded limit of %s open writers for partitions/buckets", this.maxOpenWriters));
        }
        while (this.writers.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writers.add(null);
        }
        while (this.writerParams.size() <= this.pagePartitioner.getMaxIndex()) {
            this.writerParams.add(null);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            if (this.writers.get(writerIndex) != null) continue;
            Optional<String> partitionName = this.writerFactory.getPartitionName(partitionColumns, position);
            String partition = partitionName.orElse("<UNPARTITIONED>");
            OptionalInt bucketNumber = OptionalInt.empty();
            Optional<AcidOutputFormat.Options> partitionOptions = this.getVacuumOptions(partition);
            if (bucketBlock != null) {
                bucketNumber = OptionalInt.of(bucketBlock.getInt(position, 0));
            } else if (this.acidWriteType == HiveACIDWriteType.VACUUM_UNIFY) {
                bucketNumber = OptionalInt.of(0);
            } else if (this.isVacuumOperationValid() && this.isInsertOnlyTable()) {
                bucketNumber = OptionalInt.of(partitionOptions.get().getBucketId());
            } else if (this.session.getTaskId().isPresent() && this.writerFactory.isTxnTable()) {
                bucketNumber = this.generateBucketNumber(partitionColumns.getChannelCount() != 0);
            }
            List<String> partitionValues = this.writerFactory.getPartitionValues(partitionColumns, position);
            HiveWriter writer = this.writerFactory.createWriter(partitionValues, bucketNumber, partitionOptions);
            this.writerParams.set(writerIndex, new WriterParam(partitionValues, bucketNumber, writer.getFilePath()));
            this.writers.set(writerIndex, writer);
        }
        Verify.verify((this.writers.size() == this.pagePartitioner.getMaxIndex() + 1 ? 1 : 0) != 0);
        Verify.verify((this.session.isSnapshotEnabled() || !this.writers.contains(null) ? 1 : 0) != 0);
        return writerIndexes;
    }

    private OptionalInt generateBucketNumber(boolean isPartitionedTable) {
        if (this.session.getTaskId().isPresent() && this.session.getDriverId().isPresent() && this.writerFactory.isTxnTable() && (!isPartitionedTable || !HiveSessionProperties.isWritePartitionDistributionEnabled(this.session))) {
            int taskId = this.session.getTaskId().getAsInt();
            int driverId = this.session.getDriverId().getAsInt();
            int taskWriterCount = this.session.getTaskWriterCount();
            int bucketNumber = taskId * taskWriterCount + driverId;
            return OptionalInt.of(bucketNumber);
        }
        return OptionalInt.empty();
    }

    private Page getDataPage(Page page) {
        Block[] blocks = null;
        if (HiveACIDWriteType.isRowIdNeeded(this.acidWriteType) && !this.isInsertOnlyTable()) {
            blocks = new Block[this.dataColumnInputIndex.length + 1];
            blocks[this.dataColumnInputIndex.length] = page.getBlock(this.rowIdColumnIndex);
        } else {
            blocks = new Block[this.dataColumnInputIndex.length];
        }
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            if (this.acidWriteType == HiveACIDWriteType.DELETE) {
                blocks[i] = new RunLengthEncodedBlock(this.nullBlocks.get(i), page.getPositionCount());
                continue;
            }
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private Block buildBucketBlock(Page page) {
        if (this.acidWriteType == HiveACIDWriteType.VACUUM_UNIFY) {
            return null;
        }
        if (this.bucketFunction == null) {
            return null;
        }
        IntArrayBlockBuilder bucketColumnBuilder = new IntArrayBlockBuilder(null, page.getPositionCount());
        Page bucketColumnsPage = HivePageSink.extractColumns(page, this.bucketColumns);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int bucket = this.bucketFunction.getBucket(bucketColumnsPage, position);
            bucketColumnBuilder.writeInt(bucket);
        }
        return bucketColumnBuilder.build();
    }

    private Block buildAcidOperationBlock(Page page) {
        if (!this.isVacuumOperationValid() || this.isInsertOnlyTable()) {
            return null;
        }
        IntArrayBlockBuilder operationIdBuilder = new IntArrayBlockBuilder(null, page.getPositionCount());
        Block rowIdBlock = page.getBlock(this.rowIdColumnIndex);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(position);
            int operationId = rowBlock.getRawFieldBlocks()[4].getInt(0, 0);
            if (operationId == HiveACIDWriteType.DELETE.getOperationId()) {
                operationIdBuilder.writeInt(operationId);
                continue;
            }
            operationIdBuilder.writeInt(0);
        }
        return operationIdBuilder.build();
    }

    private boolean isVacuumOperationValid() {
        return HiveACIDWriteType.isVacuum(this.acidWriteType) && this.writableTableHandle != null && this.writableTableHandle.getTableStorageFormat() == HiveStorageFormat.ORC;
    }

    private boolean isInsertOnlyTable() {
        Optional<Table> table = this.writableTableHandle.getPageSinkMetadata().getTable();
        return table.isPresent() && AcidUtils.isInsertOnlyTable(table.get().getParameters());
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public Object capture(BlockEncodingSerdeProvider serdeProvider) {
        Preconditions.checkState((this.vacuumOp == null ? 1 : 0) != 0);
        try {
            this.hdfsEnvironment.doAs(this.session.getUser(), this::doFinish).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("pagePartitioner", this.pagePartitioner.pageIndexer.capture(serdeProvider));
        state.put("writerFactory", this.writerFactory.capture());
        state.put("writerParams", new ArrayList(this.writerParams.stream().map(p -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("partitionValues", ((WriterParam)p).partitionValues);
            map.put("bucket", ((WriterParam)p).bucket.isPresent() ? Integer.valueOf(((WriterParam)p).bucket.getAsInt()) : null);
            map.put("filePath", ((WriterParam)p).filePath);
            return map;
        }).collect(Collectors.toList())));
        state.put("rows", this.rows);
        state.put("writtenBytes", this.writtenBytes);
        state.put("systemMemoryUsage", this.systemMemoryUsage);
        state.put("validationCpuNanos", this.validationCpuNanos);
        return state;
    }

    public void restore(Object obj, BlockEncodingSerdeProvider serdeProvider, long resumeCount) {
        Preconditions.checkState((boolean)this.writers.isEmpty());
        Map state = (Map)obj;
        this.pagePartitioner.pageIndexer.restore(state.get("pagePartitioner"), serdeProvider);
        this.writerFactory.restore(state.get("writerFactory"), resumeCount);
        this.writerParams.clear();
        this.writerParams.addAll(((List)state.get("writerParams")).stream().map(p -> new WriterParam((List)p.get("partitionValues"), p.get("bucket") == null ? OptionalInt.empty() : OptionalInt.of((Integer)p.get("bucket")), (String)p.get("filePath"))).collect(Collectors.toList()));
        this.rows = (Long)state.get("rows");
        this.writtenBytes = (Long)state.get("writtenBytes");
        this.systemMemoryUsage = (Long)state.get("systemMemoryUsage");
        this.validationCpuNanos = (Long)state.get("validationCpuNanos");
    }

    private static /* synthetic */ Collection lambda$doFinish$3(List result, List input) {
        return result;
    }

    private static class WriterParam
    implements Serializable {
        private final List<String> partitionValues;
        private final OptionalInt bucket;
        private final String filePath;

        private WriterParam(List<String> partitionValues, OptionalInt bucket, String filePath) {
            this.partitionValues = partitionValues;
            this.bucket = bucket;
            this.filePath = filePath;
        }
    }

    private static class State
    implements Serializable {
        private Object pagePartitioner;
        private Object writerFactory;
        private List<WriterParam> writerParams;
        private long rows;
        private long writtenBytes;
        private long systemMemoryUsage;
        private long validationCpuNanos;

        private State() {
        }
    }

    private static class HiveWriterPagePartitioner {
        private final PageIndexer pageIndexer;

        public HiveWriterPagePartitioner(List<HiveColumnHandle> inputColumns, boolean bucketed, boolean isVacuum, PageIndexerFactory pageIndexerFactory, TypeManager typeManager) {
            Objects.requireNonNull(inputColumns, "inputColumns is null");
            Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
            List partitionColumnTypes = inputColumns.stream().filter(HiveColumnHandle::isPartitionKey).map(column -> typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
            if (bucketed) {
                partitionColumnTypes.add(IntegerType.INTEGER);
            }
            if (isVacuum) {
                partitionColumnTypes.add(IntegerType.INTEGER);
            }
            this.pageIndexer = pageIndexerFactory.createPageIndexer(partitionColumnTypes);
        }

        public int[] partitionPage(Page inputPartitionColumns, Block bucketBlock, Block operationIdBlock) {
            int i;
            Block[] blocks;
            Page partitionColumns = inputPartitionColumns;
            if (bucketBlock != null) {
                blocks = new Block[partitionColumns.getChannelCount() + 1];
                for (i = 0; i < partitionColumns.getChannelCount(); ++i) {
                    blocks[i] = partitionColumns.getBlock(i);
                }
                blocks[blocks.length - 1] = bucketBlock;
                partitionColumns = new Page(partitionColumns.getPositionCount(), blocks);
            }
            if (operationIdBlock != null) {
                blocks = new Block[partitionColumns.getChannelCount() + 1];
                for (i = 0; i < partitionColumns.getChannelCount(); ++i) {
                    blocks[i] = partitionColumns.getBlock(i);
                }
                blocks[blocks.length - 1] = operationIdBlock;
                partitionColumns = new Page(partitionColumns.getPositionCount(), blocks);
            }
            return this.pageIndexer.indexPage(partitionColumns);
        }

        public int getMaxIndex() {
            return this.pageIndexer.getMaxIndex();
        }
    }

    private class VaccumOp {
        List<ConnectorPageSource> pageSources;
        Iterator<Page> sortedPagesForVacuum;
        Set<Integer> allBucketList = new HashSet<Integer>();
        Map<String, Set<Integer>> partitionToBuckets = new HashMap<String, Set<Integer>>();
        Map<String, List<HivePartitionKey>> partitionToKeys = new HashMap<String, List<HivePartitionKey>>();
        AtomicInteger rowsWritten = new AtomicInteger();
        AtomicBoolean emptyfileWriten = new AtomicBoolean();

        private VaccumOp(ConnectorPageSourceProvider pageSourceProvider, ConnectorTransactionHandle transactionHandle, ConnectorTableHandle connectorTableHandle, List<ConnectorSplit> splits) {
            ArrayList<HiveSplit> hiveSplits = new ArrayList<HiveSplit>();
            splits.forEach(split -> hiveSplits.addAll(((HiveSplitWrapper)split).getSplits()));
            HivePageSink.this.vacuumOptionsMap.set(this.initVacuumOptions(hiveSplits));
            hiveSplits.stream().forEach(split -> {
                String partitionName = split.getPartitionName();
                if (partitionName != null && !partitionName.isEmpty()) {
                    Set partitionBuckets = this.partitionToBuckets.computeIfAbsent(partitionName, partition -> new HashSet());
                    List<HivePartitionKey> partitionKeys = split.getPartitionKeys();
                    this.partitionToKeys.put(partitionName, partitionKeys);
                    partitionBuckets.add(split.getBucketNumber().orElse(0));
                }
                this.allBucketList.add(split.getBucketNumber().orElse(0));
            });
            ArrayList<HiveColumnHandle> localInputColumns = new ArrayList<HiveColumnHandle>(HivePageSink.this.inputColumns);
            if (HivePageSink.this.isInsertOnlyTable() || HivePageSink.this.acidWriteType == HiveACIDWriteType.VACUUM_UNIFY) {
                List multiSplits = hiveSplits.stream().map(HiveSplitWrapper::wrap).collect(Collectors.toList());
                if (HivePageSink.this.isInsertOnlyTable()) {
                    Collections.sort(multiSplits, this::compareInsertOnlySplits);
                } else if (HivePageSink.this.acidWriteType == HiveACIDWriteType.VACUUM_UNIFY) {
                    HiveColumnHandle rowIdHandle = HiveColumnHandle.updateRowIdHandle();
                    localInputColumns.add(rowIdHandle);
                }
                this.pageSources = multiSplits.stream().map(split -> pageSourceProvider.createPageSource(transactionHandle, HivePageSink.this.session, (ConnectorSplit)split, connectorTableHandle, localInputColumns)).collect(Collectors.toList());
                List<Iterator<Page>> pageSourceIterators = HiveUtil.getPageSourceIterators(this.pageSources);
                this.sortedPagesForVacuum = Iterators.concat(pageSourceIterators.iterator());
            } else {
                HiveColumnHandle rowIdHandle = HiveColumnHandle.updateRowIdHandle();
                localInputColumns.add(rowIdHandle);
                List multiSplits = hiveSplits.stream().map(HiveSplitWrapper::wrap).collect(Collectors.toList());
                this.pageSources = multiSplits.stream().map(split -> pageSourceProvider.createPageSource(transactionHandle, HivePageSink.this.session, (ConnectorSplit)split, connectorTableHandle, localInputColumns)).collect(Collectors.toList());
                List<Type> columnTypes = localInputColumns.stream().map(c -> ((HiveColumnHandle)c).getHiveType().getType(HivePageSink.this.typeManager)).collect(Collectors.toList());
                ImmutableList sortFields = ImmutableList.of((Object)(localInputColumns.size() - 1));
                this.sortedPagesForVacuum = HiveUtil.getMergeSortedPages(this.pageSources, columnTypes, (List<Integer>)sortFields, (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST));
            }
        }

        Page processNext() {
            if (this.sortedPagesForVacuum.hasNext()) {
                Page page = this.sortedPagesForVacuum.next();
                HivePageSink.this.appendPage(page);
                this.rowsWritten.addAndGet(page.getPositionCount());
                return page;
            }
            if (this.rowsWritten.get() == 0) {
                if (this.partitionToBuckets.isEmpty()) {
                    this.createEmptyFiles((List<HivePartitionKey>)ImmutableList.of(), this.allBucketList);
                } else {
                    this.partitionToBuckets.entrySet().stream().forEach(entry -> {
                        String partitionName = (String)entry.getKey();
                        List<HivePartitionKey> partitionKeys = this.partitionToKeys.get(partitionName);
                        Set buckets = (Set)entry.getValue();
                        this.createEmptyFiles(partitionKeys, buckets);
                    });
                }
            }
            return null;
        }

        private synchronized void createEmptyFiles(List<HivePartitionKey> partitionKeys, Set<Integer> bucketNumbers) {
            PageBuilder builder;
            if (this.emptyfileWriten.get()) {
                return;
            }
            if (partitionKeys != null && !partitionKeys.isEmpty()) {
                List partitionTypes = HivePageSink.this.inputColumns.stream().filter(HiveColumnHandle::isPartitionKey).map(HiveColumnHandle::getHiveType).map(t -> t.getType(HivePageSink.this.typeManager)).collect(Collectors.toList());
                builder = new PageBuilder(partitionTypes);
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    HivePartitionKey partitionKey = partitionKeys.get(i);
                    Type type = (Type)partitionTypes.get(i);
                    Object partitionColumnValue = HiveUtil.typedPartitionKey(partitionKey.getValue(), type, partitionKey.getName());
                    RunLengthEncodedBlock block = RunLengthEncodedBlock.create((Type)type, (Object)partitionColumnValue, (int)1);
                    type.appendTo((Block)block, 0, builder.getBlockBuilder(i));
                }
                builder.declarePosition();
            } else {
                builder = new PageBuilder((List)ImmutableList.of());
            }
            Page partitionColumns = builder.build();
            String partitionName = HivePageSink.this.writerFactory.getPartitionName(partitionColumns, 0).orElse("<UNPARTITIONED>");
            bucketNumbers.forEach(bucket -> {
                List<String> partitionValues = HivePageSink.this.writerFactory.getPartitionValues(partitionColumns, 0);
                HivePageSink.this.writers.add(HivePageSink.this.writerFactory.createWriter(partitionValues, OptionalInt.of(bucket), HivePageSink.this.getVacuumOptions(partitionName)));
                HivePageSink.this.writerParams.add(null);
            });
            this.emptyfileWriten.compareAndSet(false, true);
        }

        boolean isFinished() {
            return !this.sortedPagesForVacuum.hasNext();
        }

        private Map<String, AcidOutputFormat.Options> initVacuumOptions(List<HiveSplit> hiveSplits) {
            return HivePageSink.this.hdfsEnvironment.doAs(HivePageSink.this.session.getUser(), () -> {
                HashMap<String, AcidOutputFormat.Options> localVacuumOptionsMap = new HashMap<String, AcidOutputFormat.Options>();
                HiveVacuumTableHandle vacuumTableHandle = (HiveVacuumTableHandle)HivePageSink.this.writableTableHandle;
                for (HiveSplit split : hiveSplits) {
                    String partition = split.getPartitionName();
                    AcidOutputFormat.Options options = (AcidOutputFormat.Options)localVacuumOptionsMap.get(partition);
                    if (options == null) {
                        options = new AcidOutputFormat.Options((Configuration)HivePageSink.this.writerFactory.getConf()).maximumWriteId(-1L).minimumWriteId(Long.MAX_VALUE);
                        localVacuumOptionsMap.put(partition, options);
                    }
                    if (vacuumTableHandle.isFullVacuum()) {
                        OptionalInt bucketNumber;
                        options.writingBase(true);
                        HiveVacuumTableHandle.Range range = (HiveVacuumTableHandle.Range)Iterables.getOnlyElement((Iterable)vacuumTableHandle.getRanges().get(partition));
                        options.minimumWriteId(range.getMin());
                        if (vacuumTableHandle.isUnifyVacuum()) {
                            options.maximumWriteId(vacuumTableHandle.getLocationHandle().getJsonSerializablewriteIdInfo().get().getMaxWriteId());
                        } else {
                            options.maximumWriteId(range.getMax());
                        }
                        Path bucketFile = new Path(split.getPath());
                        OptionalInt optionalInt = bucketNumber = vacuumTableHandle.isUnifyVacuum() ? OptionalInt.of(0) : HiveUtil.getBucketNumber(bucketFile.getName());
                        if (bucketNumber.isPresent()) {
                            options.bucket(bucketNumber.getAsInt());
                            continue;
                        }
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Error while parsing split info for vacuum");
                    }
                    Path bucketFile = new Path(split.getPath());
                    try {
                        AcidOutputFormat.Options currentOptions = new AcidOutputFormat.Options((Configuration)HivePageSink.this.writerFactory.getConf());
                        if (HivePageSink.this.isInsertOnlyTable()) {
                            Path parent = bucketFile.getParent();
                            if (parent.getName().startsWith("base_")) {
                                long baseWriteId = AcidUtils.parseBase((Path)parent);
                                currentOptions.writingBase(true);
                                currentOptions.minimumWriteId(0L);
                                currentOptions.maximumWriteId(baseWriteId);
                            } else if (parent.getName().startsWith("delta_")) {
                                AcidUtils.ParsedDelta parsedDelta = AcidUtils.parsedDelta((Path)parent, (FileSystem)parent.getFileSystem((Configuration)HivePageSink.this.writerFactory.getConf()));
                                currentOptions.maximumWriteId(parsedDelta.getMaxWriteId());
                                currentOptions.minimumWriteId(parsedDelta.getMinWriteId());
                            }
                        } else {
                            currentOptions = AcidUtils.parseBaseOrDeltaBucketFilename((Path)bucketFile, (Configuration)HivePageSink.this.writerFactory.getConf());
                        }
                        if (currentOptions.isWritingBase() || options.isWritingBase()) {
                            options.writingBase(true);
                        } else if (options.isWritingDeleteDelta() || AcidUtils.isDeleteDelta((Path)bucketFile.getParent())) {
                            options.writingDeleteDelta(true);
                        }
                        if (currentOptions.getMinimumWriteId() < options.getMinimumWriteId()) {
                            options.minimumWriteId(currentOptions.getMinimumWriteId());
                        }
                        if (currentOptions.getMaximumWriteId() > options.getMaximumWriteId()) {
                            options.maximumWriteId(currentOptions.getMaximumWriteId());
                        }
                        options.bucket(currentOptions.getBucketId());
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Error while parsing split info for vacuum", (Throwable)e);
                    }
                    HiveVacuumTableHandle.Range suitableRange = (HiveVacuumTableHandle.Range)Iterables.getOnlyElement((Iterable)vacuumTableHandle.getRanges().get(partition));
                    options.minimumWriteId(suitableRange.getMin());
                    options.maximumWriteId(suitableRange.getMax());
                }
                return localVacuumOptionsMap;
            });
        }

        void close() {
            this.pageSources.forEach(c -> {
                try {
                    c.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        private int compareInsertOnlySplits(HiveSplitWrapper o1, HiveSplitWrapper o2) {
            boolean isP2AcidDir;
            String p2Parent;
            if (o1.getFilePath().equals(o2.getFilePath())) {
                return Long.compare(o1.getStartIndex(), o2.getStartIndex());
            }
            Path p1 = new Path(o1.getFilePath());
            Path p2 = new Path(o2.getFilePath());
            String p1Parent = p1.getParent().getName();
            if (p1Parent.equals(p2Parent = p2.getParent().getName())) {
                return p1.getName().compareTo(p2.getName());
            }
            boolean isP1AcidDir = p1Parent.startsWith("base_") || p1Parent.startsWith("delta_");
            boolean bl = isP2AcidDir = p2Parent.startsWith("base_") || p2Parent.startsWith("delta_");
            if (isP1AcidDir && isP2AcidDir) {
                if (p1Parent.startsWith("base_")) {
                    return -1;
                }
                if (p2Parent.startsWith("base_")) {
                    return 1;
                }
                return p1Parent.compareTo(p2Parent);
            }
            if (!isP1AcidDir && !isP2AcidDir) {
                return p1.getName().compareTo(p2.getName());
            }
            if (!isP1AcidDir) {
                return -1;
            }
            return 1;
        }
    }
}

