/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePageSourceProvider;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.coercions.HiveCoercer;
import io.prestosql.plugin.hive.orc.OrcSelectivePageSource;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.block.LazyBlockLoader;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.dynamicfilter.BloomFilterDynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HivePageSource
implements ConnectorPageSource {
    private static final Logger log = Logger.get(HivePageSource.class);
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Optional<BucketAdapter> bucketAdapter;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final TypeManager typeManager;
    private final List<Optional<Function<Block, Block>>> coercers;
    private final int rowFilteringThreshold;
    protected boolean eligibleForRowFiltering;
    private final ConnectorPageSource delegate;
    private final List<HivePartitionKey> partitionKeys;
    private final Optional<DynamicFilterSupplier> dynamicFilterSupplier;
    private boolean isSelectiveRead;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, Optional<HivePageSourceProvider.BucketAdaptation> bucketAdaptation, TypeManager typeManager, ConnectorPageSource delegate, Optional<DynamicFilterSupplier> dynamicFilterSupplier, ConnectorSession session, List<HivePartitionKey> partitionKeys) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        this.bucketAdapter = bucketAdaptation.map(BucketAdapter::new);
        this.dynamicFilterSupplier = dynamicFilterSupplier;
        this.partitionKeys = partitionKeys;
        this.rowFilteringThreshold = HiveSessionProperties.getDynamicFilteringRowFilteringThreshold(session);
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        ImmutableList.Builder localCoercers = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            String name = column.getName();
            this.types[columnIndex] = type = typeManager.getType(column.getTypeSignature());
            if (columnMapping.getCoercionFrom().isPresent()) {
                localCoercers.add(Optional.of(HiveCoercer.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType())));
            } else {
                localCoercers.add(Optional.empty());
            }
            if (columnMapping.getKind() != HivePageSourceProvider.ColumnMappingKind.PREFILLED) continue;
            this.prefilledValues[columnIndex] = columnMapping.getPrefilledValue() == null ? null : HiveUtil.typedPartitionKey(columnMapping.getPrefilledValue(), type, name);
        }
        this.coercers = localCoercers.build();
        this.isSelectiveRead = delegate instanceof OrcSelectivePageSource;
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            List<Map<Integer, ColumnHandle>> eligibleColumns;
            Page dataPage;
            Object dynamicFilters;
            if (this.dynamicFilterSupplier.isPresent()) {
                dynamicFilters = this.dynamicFilterSupplier.get().getDynamicFilters();
                if (dynamicFilters.isEmpty() && this.dynamicFilterSupplier.get().isBlocked()) {
                    return null;
                }
                ArrayList<Set<DynamicFilter>> dynamicFilterList = new ArrayList<Set<DynamicFilter>>();
                Iterator iterator = dynamicFilters.iterator();
                while (iterator.hasNext()) {
                    Map df = (Map)iterator.next();
                    Set values = df.values().stream().collect(Collectors.toSet());
                    dynamicFilterList.add(values);
                }
                if (HiveUtil.isPartitionFiltered(this.partitionKeys, dynamicFilterList, this.typeManager)) {
                    this.close();
                    return null;
                }
            } else {
                dynamicFilters = ImmutableList.of();
            }
            if ((dataPage = this.delegate.getNextPage()) == null) {
                return null;
            }
            if (!dynamicFilters.isEmpty() && !(eligibleColumns = this.getEligibleColumnsForRowFiltering(dataPage.getChannelCount(), (List<Map<ColumnHandle, DynamicFilter>>)dynamicFilters)).isEmpty()) {
                dataPage = HivePageSource.filter((List<Map<ColumnHandle, DynamicFilter>>)dynamicFilters, dataPage, eligibleColumns, this.types);
            }
            if (this.bucketAdapter.isPresent()) {
                IntArrayList rowsToKeep = this.bucketAdapter.get().computeEligibleRowIds(dataPage);
                Block[] adaptedBlocks = new Block[dataPage.getChannelCount()];
                for (int i = 0; i < adaptedBlocks.length; ++i) {
                    Block block = dataPage.getBlock(i);
                    adaptedBlocks[i] = block instanceof LazyBlock && !((LazyBlock)block).isLoaded() ? new LazyBlock(rowsToKeep.size(), (LazyBlockLoader)new RowFilterLazyBlockLoader(dataPage.getBlock(i), rowsToKeep.elements())) : block.getPositions(rowsToKeep.elements(), 0, rowsToKeep.size());
                }
                dataPage = new Page(rowsToKeep.size(), adaptedBlocks);
            }
            if (this.isSelectiveRead) {
                return dataPage;
            }
            int batchSize = dataPage.getPositionCount();
            ArrayList<Object> blocks = new ArrayList<Object>();
            block10: for (int fieldId = 0; fieldId < this.columnMappings.size(); ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                switch (columnMapping.getKind()) {
                    case PREFILLED: {
                        blocks.add(RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize));
                        continue block10;
                    }
                    case REGULAR: 
                    case TRANSACTIONID: {
                        Block block = dataPage.getBlock(columnMapping.getIndex());
                        Optional<Function<Block, Block>> coercer = this.coercers.get(fieldId);
                        if (coercer.isPresent()) {
                            block = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(block, coercer.get()));
                        }
                        blocks.add(block);
                        continue block10;
                    }
                    case INTERIM: {
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            return new Page(batchSize, dataPage.getPageMetadata(), blocks.toArray(new Block[0]));
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private List<Map<Integer, ColumnHandle>> getEligibleColumnsForRowFiltering(int channelCount, List<Map<ColumnHandle, DynamicFilter>> dynamicFilters) {
        boolean eligibleFilterFound = false;
        ArrayList<Map<Integer, ColumnHandle>> eligibleColumnsList = new ArrayList<Map<Integer, ColumnHandle>>();
        for (Map<ColumnHandle, DynamicFilter> dynamicFilter : dynamicFilters) {
            HashMap<Integer, HiveColumnHandle> eligibleColumns = new HashMap<Integer, HiveColumnHandle>();
            for (int channel = 0; channel < channelCount; ++channel) {
                HiveColumnHandle columnHandle = this.columnMappings.get(channel).getHiveColumnHandle();
                if (columnHandle.isPartitionKey() || !dynamicFilter.containsKey(columnHandle) || dynamicFilter.get(columnHandle).getSize() > (long)this.rowFilteringThreshold) continue;
                eligibleColumns.put(channel, columnHandle);
            }
            if (eligibleColumns.size() > 0) {
                eligibleFilterFound = true;
            }
            eligibleColumnsList.add(eligibleColumns);
        }
        if (!eligibleFilterFound) {
            return new ArrayList<Map<Integer, ColumnHandle>>();
        }
        return eligibleColumnsList;
    }

    private static boolean[] filterRows(List<Map<ColumnHandle, DynamicFilter>> dynamicFilters, Page page, List<Map<Integer, ColumnHandle>> eligibleColumns, Type[] types) {
        boolean[] result = new boolean[page.getPositionCount()];
        Arrays.fill(result, Boolean.FALSE);
        for (int j = 0; j < dynamicFilters.size(); ++j) {
            int columnIndex;
            boolean[] filterResult = new boolean[page.getPositionCount()];
            Arrays.fill(filterResult, Boolean.TRUE);
            for (Map.Entry<Integer, ColumnHandle> column : eligibleColumns.get(j).entrySet()) {
                columnIndex = column.getKey();
                ColumnHandle columnHandle = column.getValue();
                DynamicFilter dynamicFilter = dynamicFilters.get(j).get(columnHandle);
                Block block = page.getBlock(columnIndex).getLoadedBlock();
                if (dynamicFilter instanceof BloomFilterDynamicFilter) {
                    block.filter(((BloomFilterDynamicFilter)dynamicFilters.get(j).get(columnHandle)).getBloomFilterDeserialized(), filterResult);
                    continue;
                }
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    filterResult[i] = filterResult[i] && dynamicFilter.contains(TypeUtils.readNativeValue((Type)types[columnIndex], (Block)block, (int)i));
                }
            }
            for (Map.Entry<Integer, ColumnHandle> column : eligibleColumns.get(j).entrySet()) {
                columnIndex = column.getKey();
                Block block = page.getBlock(columnIndex).getLoadedBlock();
                for (int i = 0; i < block.getPositionCount(); ++i) {
                    result[i] = result[i] || filterResult[i];
                }
            }
        }
        return result;
    }

    @VisibleForTesting
    public static Page filter(List<Map<ColumnHandle, DynamicFilter>> dynamicFilters, Page page, List<Map<Integer, ColumnHandle>> eligibleColumns, Type[] types) {
        boolean[] result = HivePageSource.filterRows(dynamicFilters, page, eligibleColumns, types);
        int[] rowsToKeep = HivePageSource.toPositions(result);
        if (rowsToKeep.length == page.getPositionCount()) {
            return page;
        }
        Block[] adaptedBlocks = new Block[page.getChannelCount()];
        for (int i = 0; i < adaptedBlocks.length; ++i) {
            Block block = page.getBlock(i);
            adaptedBlocks[i] = block instanceof LazyBlock && !((LazyBlock)block).isLoaded() ? new LazyBlock(rowsToKeep.length, (LazyBlockLoader)new RowFilterLazyBlockLoader(page.getBlock(i), rowsToKeep)) : block.getPositions(rowsToKeep, 0, rowsToKeep.length);
        }
        return new Page(rowsToKeep.length, adaptedBlocks);
    }

    private static int[] toPositions(boolean[] keep) {
        int size = Booleans.countTrue((boolean[])keep);
        int[] result = new int[size];
        int idx = 0;
        for (int i = 0; i < keep.length; ++i) {
            if (!keep[i]) continue;
            result[idx] = i;
            ++idx;
        }
        return result;
    }

    public boolean needMergingForPages() {
        return this.isSelectiveRead;
    }

    public static class BucketAdapter {
        private final int[] bucketColumns;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int bucketToKeep;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final List<TypeInfo> typeInfoList;

        public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
            this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
            this.bucketingVersion = bucketAdaptation.getBucketingVersion();
            this.bucketToKeep = bucketAdaptation.getBucketToKeep();
            this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
            this.tableBucketCount = bucketAdaptation.getTableBucketCount();
            this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
        }

        public IntArrayList computeEligibleRowIds(Page page) {
            IntArrayList ids = new IntArrayList(page.getPositionCount());
            Page bucketColumnsPage = HivePageSource.extractColumns(page, this.bucketColumns);
            for (int position = 0; position < page.getPositionCount(); ++position) {
                int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
                if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
                }
                if (bucket != this.bucketToKeep) continue;
                ids.add(position);
            }
            return ids;
        }
    }

    private static final class RowFilterLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int[] rowsToKeep;
        private Block block;

        public RowFilterLazyBlockLoader(Block block, int[] rowsToKeep) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.rowsToKeep = Objects.requireNonNull(rowsToKeep, "rowsToKeep is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            lazyBlock.setBlock(this.block.getPositions(this.rowsToKeep, 0, this.rowsToKeep.length));
            this.block = null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RowFilterLazyBlockLoader other = (RowFilterLazyBlockLoader)obj;
            return Arrays.equals(this.rowsToKeep, other.rowsToKeep) && Objects.equals(this.block, other.block);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.rowsToKeep), this.block);
        }
    }

    private static final class CoercionLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            lazyBlock.setBlock(this.coercer.apply(this.block.getLoadedBlock()));
            this.block = null;
        }
    }
}

