/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.DeleteDeltaLocations;
import io.prestosql.plugin.hive.GenericHiveRecordCursorProvider;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveBucketAdapterRecordCursor;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveCoercionRecordCursor;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HivePageSource;
import io.prestosql.plugin.hive.HivePageSourceFactory;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveRecordCursor;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveSelectivePageSourceFactory;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.coercions.HiveCoercer;
import io.prestosql.plugin.hive.orc.OrcConcatPageSource;
import io.prestosql.plugin.hive.util.IndexCache;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.connector.ConnectorPageSourceProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.FixedPageSource;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.RecordPageSource;
import io.prestosql.spi.dynamicfilter.CombinedDynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.dynamicfilter.FilteredDynamicFilter;
import io.prestosql.spi.function.BuiltInFunctionHandle;
import io.prestosql.spi.function.Signature;
import io.prestosql.spi.heuristicindex.IndexMetadata;
import io.prestosql.spi.heuristicindex.SplitMetadata;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.relation.CallExpression;
import io.prestosql.spi.relation.RowExpression;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.eclipse.jetty.util.URIUtil;

public class HivePageSourceProvider
implements ConnectorPageSourceProvider {
    private final HdfsEnvironment hdfsEnvironment;
    private final Set<HiveRecordCursorProvider> cursorProviders;
    private final TypeManager typeManager;
    private final Set<HivePageSourceFactory> pageSourceFactories;
    private static final String HIVE_DEFAULT_PARTITION_VALUE = "\\N";
    private final IndexCache indexCache;
    private final Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories;

    @Inject
    public HivePageSourceProvider(HiveConfig hiveConfig, HdfsEnvironment hdfsEnvironment, Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, TypeManager typeManager, IndexCache indexCache, Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories) {
        Objects.requireNonNull(hiveConfig, "hiveConfig is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.cursorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(cursorProviders, "cursorProviders is null"));
        this.pageSourceFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(pageSourceFactories, "pageSourceFactories is null"));
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.indexCache = indexCache;
        this.selectivePageSourceFactories = selectivePageSourceFactories;
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns) {
        return this.createPageSource(transaction, session, split, table, columns, Optional.empty());
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, Optional<DynamicFilterSupplier> dynamicFilterSupplier) {
        List dynamicFilters = null;
        if (dynamicFilterSupplier.isPresent()) {
            dynamicFilters = dynamicFilterSupplier.get().getDynamicFilters();
        }
        HiveTableHandle hiveTable = (HiveTableHandle)table;
        List<HiveColumnHandle> hiveColumns = columns.stream().map(HiveColumnHandle.class::cast).collect(Collectors.toList());
        List<HiveSplit> hiveSplits = ((HiveSplitWrapper)split).getSplits();
        if (hiveSplits.size() == 1) {
            HiveSplit hiveSplit2 = hiveSplits.get(0);
            return this.createPageSourceInternal(session, dynamicFilterSupplier, dynamicFilters, hiveTable, hiveColumns, hiveSplit2);
        }
        List finalDynamicFilters = dynamicFilters;
        List<ConnectorPageSource> pageSources = hiveSplits.stream().map(hiveSplit -> this.createPageSourceInternal(session, dynamicFilterSupplier, finalDynamicFilters, hiveTable, hiveColumns, (HiveSplit)hiveSplit)).collect(Collectors.toList());
        return new OrcConcatPageSource(pageSources);
    }

    private ConnectorPageSource createPageSourceInternal(ConnectorSession session, Optional<DynamicFilterSupplier> dynamicFilterSupplier, List<Map<ColumnHandle, DynamicFilter>> dynamicFilters, HiveTableHandle hiveTable, List<HiveColumnHandle> hiveColumns, HiveSplit hiveSplit) {
        String columnNameDelimiter;
        Path path = new Path(hiveSplit.getPath());
        ArrayList<Set<DynamicFilter>> dynamicFilterList = new ArrayList<Set<DynamicFilter>>();
        if (dynamicFilters != null) {
            for (Map<ColumnHandle, DynamicFilter> df : dynamicFilters) {
                Set values = df.values().stream().collect(Collectors.toSet());
                dynamicFilterList.add(values);
            }
        }
        if (dynamicFilters != null && !dynamicFilters.isEmpty() && HiveUtil.isPartitionFiltered(hiveSplit.getPartitionKeys(), dynamicFilterList, this.typeManager)) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        Configuration configuration = this.hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, hiveSplit.getDatabase(), hiveSplit.getTable()), path);
        Properties schema = hiveSplit.getSchema();
        String string = columnNameDelimiter = schema.containsKey("column.name.delimiter") ? schema.getProperty("column.name.delimiter") : String.valueOf(',');
        List<String> partitionColumnNames = schema.containsKey("partition_metadata") ? Arrays.asList(schema.getProperty("partition_metadata").split(columnNameDelimiter)) : (schema.containsKey("columns") ? Arrays.asList(schema.getProperty("columns").split(columnNameDelimiter)) : new ArrayList<String>());
        List tableColumns = hiveColumns.stream().map(cols -> cols.getName()).collect(Collectors.toList());
        List<String> missingColumns = tableColumns.stream().skip(partitionColumnNames.size()).collect(Collectors.toList());
        ArrayList<IndexMetadata> indexes = new ArrayList<IndexMetadata>();
        if (this.indexCache != null && session.isHeuristicIndexFilterEnabled()) {
            indexes.addAll(this.indexCache.getIndices(session.getCatalog().orElse(null), hiveTable.getSchemaTableName().toString(), hiveSplit, hiveTable.getCompactEffectivePredicate(), hiveTable.getPartitionColumns()));
            if (hiveTable.getDisjunctCompactEffectivePredicate().isPresent() && hiveTable.getDisjunctCompactEffectivePredicate().get().size() > 0) {
                hiveTable.getDisjunctCompactEffectivePredicate().get().forEach(orPredicate -> indexes.addAll(this.indexCache.getIndices(session.getCatalog().orElse(null), hiveTable.getSchemaTableName().toString(), hiveSplit, (TupleDomain<HiveColumnHandle>)orPredicate, hiveTable.getPartitionColumns())));
            }
        }
        Optional<List<IndexMetadata>> indexOptional = indexes == null || indexes.isEmpty() ? Optional.empty() : Optional.of(indexes);
        URI splitUri = URI.create(URIUtil.encodePath((String)hiveSplit.getPath()));
        SplitMetadata splitMetadata = new SplitMetadata(splitUri.getRawPath(), hiveSplit.getLastModifiedTime());
        TupleDomain predicate = TupleDomain.all();
        if (dynamicFilterSupplier.isPresent() && dynamicFilters != null && !dynamicFilters.isEmpty() && dynamicFilters.size() == 1) {
            List filteredHiveColumnHandles = hiveColumns.stream().filter(column -> ((Map)dynamicFilters.get(0)).containsKey(column)).collect(Collectors.toList());
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)filteredHiveColumnHandles.get(0);
            Type type = hiveColumnHandle.getColumnMetadata(this.typeManager).getType();
            predicate = HivePageSourceProvider.getPredicate(dynamicFilters.get(0).get(hiveColumnHandle), type, hiveColumnHandle);
            if (predicate.isNone()) {
                predicate = TupleDomain.all();
            }
        }
        if (hiveTable.isSuitableToPush()) {
            return HivePageSourceProvider.createSelectivePageSource(this.selectivePageSourceFactories, configuration, session, hiveSplit, HivePageSourceProvider.assignUniqueIndicesToPartitionColumns(hiveColumns), this.typeManager, dynamicFilterSupplier, hiveSplit.getDeleteDeltaLocations(), hiveSplit.getStartRowOffsetOfFile(), indexOptional, hiveSplit.isCacheable(), hiveTable.getCompactEffectivePredicate(), hiveTable.getPredicateColumns(), hiveTable.getDisjunctCompactEffectivePredicate(), hiveSplit.getBucketConversion(), hiveSplit.getBucketNumber(), hiveSplit.getLastModifiedTime(), missingColumns);
        }
        Optional<ConnectorPageSource> pageSource = HivePageSourceProvider.createHivePageSource(this.cursorProviders, this.pageSourceFactories, configuration, session, path, hiveSplit.getBucketNumber(), hiveSplit.getStart(), hiveSplit.getLength(), hiveSplit.getFileSize(), hiveSplit.getSchema(), (TupleDomain<HiveColumnHandle>)hiveTable.getCompactEffectivePredicate().intersect(predicate), hiveColumns, hiveSplit.getPartitionKeys(), this.typeManager, hiveSplit.getColumnCoercions(), hiveSplit.getBucketConversion(), hiveSplit.isS3SelectPushdownEnabled(), dynamicFilterSupplier, hiveSplit.getDeleteDeltaLocations(), hiveSplit.getStartRowOffsetOfFile(), indexOptional, splitMetadata, hiveSplit.isCacheable(), hiveSplit.getLastModifiedTime(), hiveSplit.getCustomSplitInfo(), missingColumns);
        if (pageSource.isPresent()) {
            return pageSource.get();
        }
        throw new RuntimeException("Could not find a file reader for split " + hiveSplit);
    }

    private static List<HiveColumnHandle> assignUniqueIndicesToPartitionColumns(List<HiveColumnHandle> columns) {
        ImmutableList.Builder newColumns = ImmutableList.builder();
        int nextIndex = -14;
        for (HiveColumnHandle column : columns) {
            if (column.isPartitionKey()) {
                newColumns.add((Object)new HiveColumnHandle(column.getName(), column.getHiveType(), column.getTypeSignature(), nextIndex--, column.getColumnType(), column.getComment()));
                continue;
            }
            newColumns.add((Object)column);
        }
        return newColumns.build();
    }

    private static ConnectorPageSource createSelectivePageSource(Set<HiveSelectivePageSourceFactory> selectivePageSourceFactories, Configuration configuration, ConnectorSession session, HiveSplit split, List<HiveColumnHandle> columns, TypeManager typeManager, Optional<DynamicFilterSupplier> dynamicFilterSupplier, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, boolean splitCacheable, TupleDomain<HiveColumnHandle> effectivePredicate, Map<String, HiveColumnHandle> predicateColumns, Optional<List<TupleDomain<HiveColumnHandle>>> additionPredicates, Optional<HiveSplit.BucketConversion> bucketConversion, OptionalInt bucketNumber, long dataSourceLastModifiedTime, List<String> missingColumns) {
        ImmutableSet interimColumns = ImmutableSet.builder().addAll(predicateColumns.values()).addAll((Iterable)bucketConversion.map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of())).build();
        Path path = new Path(split.getPath());
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(split.getPartitionKeys(), columns, (List<HiveColumnHandle>)ImmutableList.copyOf((Collection)interimColumns), split.getColumnCoercions(), path, bucketNumber, true, missingColumns);
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = HivePageSourceProvider.toBucketAdaptation(bucketConversion, regularAndInterimColumnMappings, bucketNumber);
        Preconditions.checkArgument((!bucketAdaptation.isPresent() ? 1 : 0) != 0, (Object)"Bucket conversion is not yet supported");
        Map prefilledValues = (Map)columnMappings.stream().filter(mapping -> mapping.getKind() == ColumnMappingKind.PREFILLED).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex(), ColumnMapping::getPrefilledValue));
        Map coercers = (Map)columnMappings.stream().filter(mapping -> mapping.getCoercionFrom().isPresent()).collect(ImmutableMap.toImmutableMap(mapping -> mapping.getHiveColumnHandle().getHiveColumnIndex(), mapping -> HiveCoercer.createCoercer(typeManager, mapping.getCoercionFrom().get(), mapping.getHiveColumnHandle().getHiveType())));
        List outputColumns = (List)columns.stream().map(HiveColumnHandle::getHiveColumnIndex).collect(ImmutableList.toImmutableList());
        for (HiveSelectivePageSourceFactory pageSourceFactory : selectivePageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, split.getStart(), split.getLength(), split.getFileSize(), split.getSchema(), ColumnMapping.toColumnHandles(columnMappings, true), prefilledValues, outputColumns, effectivePredicate, additionPredicates, deleteDeltaLocations, startRowOffsetOfFile, indexes, splitCacheable, columnMappings, coercers, dataSourceLastModifiedTime);
            if (!pageSource.isPresent()) continue;
            return new HivePageSource(columnMappings, Optional.empty(), typeManager, pageSource.get(), dynamicFilterSupplier, session, split.getPartitionKeys());
        }
        throw new IllegalStateException("Could not find a file reader for split " + split);
    }

    public static Optional<ConnectorPageSource> createHivePageSource(Set<HiveRecordCursorProvider> cursorProviders, Set<HivePageSourceFactory> pageSourceFactories, Configuration configuration, ConnectorSession session, Path path, OptionalInt bucketNumber, long start, long length, long fileSize, Properties schema, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> hiveColumns, List<HivePartitionKey> partitionKeys, TypeManager typeManager, Map<Integer, HiveType> columnCoercions, Optional<HiveSplit.BucketConversion> bucketConversion, boolean s3SelectPushdownEnabled, Optional<DynamicFilterSupplier> dynamicFilterSupplier, Optional<DeleteDeltaLocations> deleteDeltaLocations, Optional<Long> startRowOffsetOfFile, Optional<List<IndexMetadata>> indexes, SplitMetadata splitMetadata, boolean splitCacheable, long dataSourceLastModifiedTime, Map<String, String> customSplitInfo, List<String> missingColumns) {
        List<ColumnMapping> columnMappings = ColumnMapping.buildColumnMappings(partitionKeys, hiveColumns, bucketConversion.map(HiveSplit.BucketConversion::getBucketColumnHandles).orElse((List)ImmutableList.of()), columnCoercions, path, bucketNumber, true, missingColumns);
        List<ColumnMapping> regularAndInterimColumnMappings = ColumnMapping.extractRegularAndInterimColumnMappings(columnMappings);
        Optional<BucketAdaptation> bucketAdaptation = HivePageSourceProvider.toBucketAdaptation(bucketConversion, regularAndInterimColumnMappings, bucketNumber);
        for (HivePageSourceFactory pageSourceFactory : pageSourceFactories) {
            Optional<? extends ConnectorPageSource> pageSource = pageSourceFactory.createPageSource(configuration, session, path, start, length, fileSize, schema, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, true), effectivePredicate, dynamicFilterSupplier, deleteDeltaLocations, startRowOffsetOfFile, indexes, splitMetadata, splitCacheable, dataSourceLastModifiedTime);
            if (!pageSource.isPresent()) continue;
            return Optional.of(new HivePageSource(columnMappings, bucketAdaptation, typeManager, pageSource.get(), dynamicFilterSupplier, session, partitionKeys));
        }
        Iterator<Object> iterator = cursorProviders.iterator();
        while (iterator.hasNext()) {
            HiveRecordCursorProvider provider;
            boolean doCoercion = !((provider = (HiveRecordCursorProvider)iterator.next()) instanceof GenericHiveRecordCursorProvider);
            Optional<RecordCursor> cursor = provider.createRecordCursor(configuration, session, path, start, length, fileSize, schema, ColumnMapping.toColumnHandles(regularAndInterimColumnMappings, doCoercion), effectivePredicate, typeManager, s3SelectPushdownEnabled, customSplitInfo);
            if (!cursor.isPresent()) continue;
            RecordCursor delegate = cursor.get();
            Preconditions.checkArgument((!deleteDeltaLocations.isPresent() ? 1 : 0) != 0, (Object)"Delete delta is not supported");
            if (bucketAdaptation.isPresent()) {
                delegate = new HiveBucketAdapterRecordCursor(bucketAdaptation.get().getBucketColumnIndices(), bucketAdaptation.get().getBucketColumnHiveTypes(), bucketAdaptation.get().getBucketingVersion(), bucketAdaptation.get().getTableBucketCount(), bucketAdaptation.get().getPartitionBucketCount(), bucketAdaptation.get().getBucketToKeep(), typeManager, delegate);
            }
            if (doCoercion) {
                delegate = new HiveCoercionRecordCursor(regularAndInterimColumnMappings, typeManager, delegate);
            }
            HiveRecordCursor hiveRecordCursor = new HiveRecordCursor(columnMappings, typeManager, delegate);
            List columnTypes = hiveColumns.stream().map(input -> typeManager.getType(input.getTypeSignature())).collect(Collectors.toList());
            return Optional.of(new RecordPageSource(columnTypes, (RecordCursor)hiveRecordCursor));
        }
        return Optional.empty();
    }

    public static Optional<BucketAdaptation> toBucketAdaptation(Optional<HiveSplit.BucketConversion> bucketConversion, List<ColumnMapping> regularAndInterimColumnMappings, OptionalInt bucketNumber) {
        return bucketConversion.map(conversion -> {
            ImmutableMap hiveIndexToBlockIndex = Maps.uniqueIndex((Iterable)regularAndInterimColumnMappings, columnMapping -> columnMapping.getHiveColumnHandle().getHiveColumnIndex());
            int[] bucketColumnIndices = conversion.getBucketColumnHandles().stream().mapToInt(arg_0 -> HivePageSourceProvider.lambda$null$11((Map)hiveIndexToBlockIndex, arg_0)).toArray();
            List bucketColumnHiveTypes = (List)conversion.getBucketColumnHandles().stream().map(arg_0 -> HivePageSourceProvider.lambda$null$12((Map)hiveIndexToBlockIndex, arg_0)).collect(ImmutableList.toImmutableList());
            return new BucketAdaptation(bucketColumnIndices, bucketColumnHiveTypes, conversion.getBucketingVersion(), conversion.getTableBucketCount(), conversion.getPartitionBucketCount(), bucketNumber.getAsInt());
        });
    }

    public static Object getValue(Type type, String partitionValue) {
        Class javaType = type.getJavaType();
        if (javaType == Long.TYPE) {
            return Long.valueOf(partitionValue);
        }
        if (javaType == Double.TYPE) {
            return Double.valueOf(partitionValue);
        }
        if (javaType == Boolean.TYPE) {
            return Boolean.valueOf(partitionValue);
        }
        if (javaType == Slice.class) {
            return Slices.utf8Slice((String)partitionValue);
        }
        return partitionValue;
    }

    protected static Domain modifyDomain(Domain inputDomain, Optional<RowExpression> filter) {
        CallExpression call;
        BuiltInFunctionHandle builtInFunctionHandle;
        String name;
        Domain domain = inputDomain;
        Range range = domain.getValues().getRanges().getSpan();
        if (filter.isPresent() && filter.get() instanceof CallExpression && (name = (builtInFunctionHandle = (BuiltInFunctionHandle)(call = (CallExpression)filter.get()).getFunctionHandle()).getSignature().getNameSuffix()).contains("$operator$") && Signature.unmangleOperator((String)name).isComparisonOperator()) {
            switch (Signature.unmangleOperator((String)name)) {
                case LESS_THAN: {
                    range = Range.lessThan((Type)domain.getType(), (Object)range.getHigh().getValue());
                    break;
                }
                case GREATER_THAN: {
                    range = Range.greaterThan((Type)domain.getType(), (Object)range.getLow().getValue());
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    range = Range.lessThanOrEqual((Type)domain.getType(), (Object)range.getHigh().getValue());
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    range = Range.greaterThanOrEqual((Type)domain.getType(), (Object)range.getLow().getValue());
                    break;
                }
                default: {
                    return domain;
                }
            }
            domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)range, (Range[])new Range[0]), (boolean)false);
        }
        return domain;
    }

    private static TupleDomain<HiveColumnHandle> getPredicate(DynamicFilter dynamicFilter, Type type, HiveColumnHandle hiveColumnHandle) {
        if (dynamicFilter instanceof CombinedDynamicFilter) {
            List filters = ((CombinedDynamicFilter)dynamicFilter).getFilters();
            List predicates = filters.stream().map(filter -> HivePageSourceProvider.getPredicate(filter, type, hiveColumnHandle)).collect(Collectors.toList());
            return predicates.stream().reduce(TupleDomain.all(), TupleDomain::intersect);
        }
        if (dynamicFilter instanceof FilteredDynamicFilter && !((FilteredDynamicFilter)dynamicFilter).getSetValues().isEmpty()) {
            Domain domain = Domain.create((ValueSet)ValueSet.copyOf((Type)type, (Collection)((FilteredDynamicFilter)dynamicFilter).getSetValues()), (boolean)false);
            domain = HivePageSourceProvider.modifyDomain(domain, ((FilteredDynamicFilter)dynamicFilter).getFilterExpression());
            return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)hiveColumnHandle, (Object)domain));
        }
        return TupleDomain.all();
    }

    private static /* synthetic */ HiveType lambda$null$12(Map hiveIndexToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)hiveIndexToBlockIndex.get(columnHandle.getHiveColumnIndex())).getHiveColumnHandle().getHiveType();
    }

    private static /* synthetic */ int lambda$null$11(Map hiveIndexToBlockIndex, HiveColumnHandle columnHandle) {
        return ((ColumnMapping)hiveIndexToBlockIndex.get(columnHandle.getHiveColumnIndex())).getIndex();
    }

    public static class BucketAdaptation {
        private final int[] bucketColumnIndices;
        private final List<HiveType> bucketColumnHiveTypes;
        private final HiveBucketing.BucketingVersion bucketingVersion;
        private final int tableBucketCount;
        private final int partitionBucketCount;
        private final int bucketToKeep;

        public BucketAdaptation(int[] bucketColumnIndices, List<HiveType> bucketColumnHiveTypes, HiveBucketing.BucketingVersion bucketingVersion, int tableBucketCount, int partitionBucketCount, int bucketToKeep) {
            this.bucketColumnIndices = bucketColumnIndices;
            this.bucketColumnHiveTypes = bucketColumnHiveTypes;
            this.bucketingVersion = bucketingVersion;
            this.tableBucketCount = tableBucketCount;
            this.partitionBucketCount = partitionBucketCount;
            this.bucketToKeep = bucketToKeep;
        }

        public int[] getBucketColumnIndices() {
            return this.bucketColumnIndices;
        }

        public List<HiveType> getBucketColumnHiveTypes() {
            return this.bucketColumnHiveTypes;
        }

        public HiveBucketing.BucketingVersion getBucketingVersion() {
            return this.bucketingVersion;
        }

        public int getTableBucketCount() {
            return this.tableBucketCount;
        }

        public int getPartitionBucketCount() {
            return this.partitionBucketCount;
        }

        public int getBucketToKeep() {
            return this.bucketToKeep;
        }
    }

    public static enum ColumnMappingKind {
        REGULAR,
        PREFILLED,
        INTERIM,
        TRANSACTIONID;

    }

    public static class ColumnMapping {
        private final ColumnMappingKind kind;
        private final HiveColumnHandle hiveColumnHandle;
        private final Optional<String> prefilledValue;
        private final OptionalInt index;
        private final Optional<HiveType> coercionFrom;

        public static ColumnMapping regular(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), coerceFrom);
        }

        public static ColumnMapping synthesized(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.REGULAR, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), coerceFrom);
        }

        public static ColumnMapping prefilled(HiveColumnHandle hiveColumnHandle, String prefilledValue, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.PARTITION_KEY || hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.PREFILLED, hiveColumnHandle, Optional.of(prefilledValue), OptionalInt.empty(), coerceFrom);
        }

        public static ColumnMapping transaction(HiveColumnHandle hiveColumnHandle, int index, Optional<HiveType> coerceFrom) {
            Preconditions.checkArgument((hiveColumnHandle.getColumnType() == HiveColumnHandle.ColumnType.SYNTHESIZED ? 1 : 0) != 0);
            return new ColumnMapping(ColumnMappingKind.TRANSACTIONID, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), coerceFrom);
        }

        public static ColumnMapping interim(HiveColumnHandle hiveColumnHandle, int index) {
            return new ColumnMapping(ColumnMappingKind.INTERIM, hiveColumnHandle, Optional.empty(), OptionalInt.of(index), Optional.empty());
        }

        private ColumnMapping(ColumnMappingKind kind, HiveColumnHandle hiveColumnHandle, Optional<String> prefilledValue, OptionalInt index, Optional<HiveType> coerceFrom) {
            this.kind = Objects.requireNonNull(kind, "kind is null");
            this.hiveColumnHandle = Objects.requireNonNull(hiveColumnHandle, "hiveColumnHandle is null");
            this.prefilledValue = Objects.requireNonNull(prefilledValue, "prefilledValue is null");
            this.index = Objects.requireNonNull(index, "index is null");
            this.coercionFrom = Objects.requireNonNull(coerceFrom, "coerceFrom is null");
        }

        public ColumnMappingKind getKind() {
            return this.kind;
        }

        public String getPrefilledValue() {
            Preconditions.checkState((this.kind == ColumnMappingKind.PREFILLED ? 1 : 0) != 0);
            return this.prefilledValue.isPresent() ? this.prefilledValue.get() : HivePageSourceProvider.HIVE_DEFAULT_PARTITION_VALUE;
        }

        public HiveColumnHandle getHiveColumnHandle() {
            return this.hiveColumnHandle;
        }

        public int getIndex() {
            Preconditions.checkState((this.kind == ColumnMappingKind.REGULAR || this.kind == ColumnMappingKind.INTERIM || this.kind == ColumnMappingKind.TRANSACTIONID ? 1 : 0) != 0);
            return this.index.getAsInt();
        }

        public Optional<HiveType> getCoercionFrom() {
            return this.coercionFrom;
        }

        public static List<ColumnMapping> buildColumnMappings(List<HivePartitionKey> partitionKeys, List<HiveColumnHandle> columns, List<HiveColumnHandle> requiredInterimColumns, Map<Integer, HiveType> columnCoercions, Path path, OptionalInt bucketNumber, boolean filterPushDown, List<String> missingColumns) {
            ImmutableMap partitionKeysByName = Maps.uniqueIndex(partitionKeys, HivePartitionKey::getName);
            int regularIndex = 0;
            HashSet<Integer> regularColumnIndices = new HashSet<Integer>();
            ImmutableList.Builder columnMappings = ImmutableList.builder();
            for (HiveColumnHandle column : columns) {
                Optional<HiveType> localCoercionFrom = Optional.ofNullable(columnCoercions.get(column.getHiveColumnIndex()));
                if (column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR) {
                    if (missingColumns.contains(column.getColumnName())) {
                        columnMappings.add((Object)new ColumnMapping(ColumnMappingKind.PREFILLED, column, Optional.empty(), OptionalInt.empty(), localCoercionFrom));
                        continue;
                    }
                    Preconditions.checkArgument((boolean)regularColumnIndices.add(column.getHiveColumnIndex()), (Object)"duplicate hiveColumnIndex in columns list");
                    columnMappings.add((Object)ColumnMapping.regular(column, regularIndex, localCoercionFrom));
                    ++regularIndex;
                    continue;
                }
                if (HiveColumnHandle.isUpdateColumnHandle(column)) {
                    columnMappings.add((Object)ColumnMapping.transaction(column, regularIndex, localCoercionFrom));
                    ++regularIndex;
                    continue;
                }
                columnMappings.add((Object)ColumnMapping.prefilled(column, HiveUtil.getPrefilledColumnValue(column, (HivePartitionKey)partitionKeysByName.get(column.getName()), path, bucketNumber), localCoercionFrom));
            }
            for (HiveColumnHandle column : requiredInterimColumns) {
                Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR || filterPushDown ? 1 : 0) != 0);
                if (regularColumnIndices.contains(column.getHiveColumnIndex())) continue;
                columnMappings.add((Object)ColumnMapping.interim(column, regularIndex));
                ++regularIndex;
            }
            return columnMappings.build();
        }

        public static List<ColumnMapping> extractRegularAndInterimColumnMappings(List<ColumnMapping> columnMappings) {
            return (List)columnMappings.stream().filter(columnMapping -> columnMapping.getKind() == ColumnMappingKind.REGULAR || columnMapping.getKind() == ColumnMappingKind.INTERIM || columnMapping.getKind() == ColumnMappingKind.TRANSACTIONID).collect(ImmutableList.toImmutableList());
        }

        public static List<HiveColumnHandle> toColumnHandles(List<ColumnMapping> regularColumnMappings, boolean doCoercion) {
            return regularColumnMappings.stream().map(columnMapping -> {
                HiveColumnHandle columnHandle = columnMapping.getHiveColumnHandle();
                if (!doCoercion || !columnMapping.getCoercionFrom().isPresent()) {
                    return columnHandle;
                }
                return new HiveColumnHandle(columnHandle.getName(), columnMapping.getCoercionFrom().get(), columnMapping.getCoercionFrom().get().getTypeSignature(), columnHandle.getHiveColumnIndex(), columnHandle.getColumnType(), Optional.empty());
            }).collect(Collectors.toList());
        }
    }
}

