/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionResult;
import io.prestosql.plugin.hive.HiveTableHandle;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.hadoop.hive.common.FileUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class HivePartitionManager {
    private static final String PARTITION_VALUE_WILDCARD = "";
    private final int maxPartitions;
    private final boolean assumeCanonicalPartitionKeys;
    private final int domainCompactionThreshold;
    private final TypeManager typeManager;

    @Inject
    public HivePartitionManager(TypeManager typeManager, HiveConfig hiveConfig) {
        this(typeManager, hiveConfig.getMaxPartitionsPerScan(), hiveConfig.isAssumeCanonicalPartitionKeys(), hiveConfig.getDomainCompactionThreshold());
    }

    public HivePartitionManager(TypeManager typeManager, int maxPartitions, boolean assumeCanonicalPartitionKeys, int domainCompactionThreshold) {
        Preconditions.checkArgument((maxPartitions >= 1 ? 1 : 0) != 0, (Object)"maxPartitions must be at least 1");
        this.maxPartitions = maxPartitions;
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        Preconditions.checkArgument((domainCompactionThreshold >= 1 ? 1 : 0) != 0, (Object)"domainCompactionThreshold must be at least 1");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public HivePartitionResult getPartitions(SemiTransactionalHiveMetastore metastore, HiveIdentity identity, ConnectorTableHandle tableHandle, Constraint constraint, Table table) {
        Iterable<HivePartition> partitionsIterable;
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        TupleDomain effectivePredicate = constraint.getSummary().intersect(hiveTableHandle.getEnforcedConstraint());
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        Optional<HiveBucketHandle> hiveBucketHandle = hiveTableHandle.getBucketHandle();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        if (effectivePredicate.isNone()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of(), (TupleDomain<HiveColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), (TupleDomain<ColumnHandle>)TupleDomain.none(), hiveBucketHandle, Optional.empty());
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = HiveBucketing.getHiveBucketFilter(table, (TupleDomain<ColumnHandle>)effectivePredicate);
        TupleDomain<HiveColumnHandle> compactEffectivePredicate = HivePartitionManager.toCompactTupleDomain((TupleDomain<ColumnHandle>)effectivePredicate, this.domainCompactionThreshold);
        if (partitionColumns.isEmpty()) {
            return new HivePartitionResult(partitionColumns, (Iterable<HivePartition>)ImmutableList.of((Object)new HivePartition(tableName)), compactEffectivePredicate, (TupleDomain<ColumnHandle>)effectivePredicate, (TupleDomain<ColumnHandle>)TupleDomain.all(), hiveBucketHandle, bucketFilter);
        }
        List partitionTypes = partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(Collectors.toList());
        Predicate<Map> predicate = constraint.predicate().orElse(value -> true);
        if (hiveTableHandle.getPartitions().isPresent()) {
            partitionsIterable = (Iterable<HivePartition>)hiveTableHandle.getPartitions().get().stream().filter(partition -> this.partitionMatches(partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate, (Predicate<Map<ColumnHandle, NullableValue>>)predicate, (HivePartition)partition)).collect(ImmutableList.toImmutableList());
        } else {
            List<String> partitionNames = this.getFilteredPartitionNames(metastore, identity, tableName, partitionColumns, (TupleDomain<ColumnHandle>)effectivePredicate, table);
            partitionsIterable = () -> partitionNames.stream().map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionTypes, (TupleDomain<ColumnHandle>)effectivePredicate, predicate)).filter(Optional::isPresent).map(Optional::get).iterator();
        }
        TupleDomain remainingTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.not((com.google.common.base.Predicate)Predicates.in(partitionColumns))));
        TupleDomain enforcedTupleDomain = TupleDomain.withColumnDomains((Map)Maps.filterKeys((Map)((Map)effectivePredicate.getDomains().get()), (com.google.common.base.Predicate)Predicates.in(partitionColumns)));
        return new HivePartitionResult(partitionColumns, partitionsIterable, compactEffectivePredicate, (TupleDomain<ColumnHandle>)remainingTupleDomain, (TupleDomain<ColumnHandle>)enforcedTupleDomain, hiveBucketHandle, bucketFilter);
    }

    public HivePartitionResult getPartitions(ConnectorTableHandle tableHandle, List<List<String>> partitionValuesList) {
        HiveTableHandle hiveTableHandle = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTableHandle.getSchemaTableName();
        List<HiveColumnHandle> partitionColumns = hiveTableHandle.getPartitionColumns();
        Optional<HiveBucketHandle> bucketHandle = hiveTableHandle.getBucketHandle();
        List partitionColumnNames = (List)partitionColumns.stream().map(HiveColumnHandle::getName).collect(ImmutableList.toImmutableList());
        List partitionColumnTypes = (List)partitionColumns.stream().map(column -> this.typeManager.getType(column.getTypeSignature())).collect(ImmutableList.toImmutableList());
        List partitionList = (List)partitionValuesList.stream().map(partitionValues -> MetastoreUtil.toPartitionName(partitionColumnNames, partitionValues)).map(partitionName -> this.parseValuesAndFilterPartition(tableName, (String)partitionName, partitionColumns, partitionColumnTypes, (TupleDomain<ColumnHandle>)TupleDomain.all(), value -> true)).map(partition -> (HivePartition)partition.orElseThrow(() -> new VerifyException("partition must exist"))).collect(ImmutableList.toImmutableList());
        return new HivePartitionResult(partitionColumns, partitionList, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty());
    }

    public List<HivePartition> getPartitionsAsList(HivePartitionResult partitionResult) {
        ImmutableList.Builder partitionList = ImmutableList.builder();
        int count = 0;
        Iterator<HivePartition> iterator = partitionResult.getPartitions();
        while (iterator.hasNext()) {
            HivePartition partition = iterator.next();
            if (count == this.maxPartitions) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_PARTITION_LIMIT, String.format("Query over table '%s' can potentially read more than %s partitions", partition.getTableName(), this.maxPartitions));
            }
            partitionList.add((Object)partition);
            ++count;
        }
        return partitionList.build();
    }

    public HiveTableHandle applyPartitionResult(HiveTableHandle handle, HivePartitionResult partitions) {
        return new HiveTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getTableParameters(), (List<HiveColumnHandle>)ImmutableList.copyOf(partitions.getPartitionColumns()), Optional.of(this.getPartitionsAsList(partitions)), partitions.getCompactEffectivePredicate(), partitions.getEnforcedConstraint(), partitions.getBucketHandle(), partitions.getBucketFilter(), handle.getAnalyzePartitionValues(), handle.getPredicateColumns(), handle.getDisjunctCompactEffectivePredicate(), handle.isSuitableToPush());
    }

    public List<HivePartition> getOrLoadPartitions(ConnectorSession session, SemiTransactionalHiveMetastore metastore, HiveIdentity identity, HiveTableHandle tableHandle) {
        SchemaTableName tableName = tableHandle.getSchemaTableName();
        Table table = metastore.getTable(new HiveIdentity(session), tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return tableHandle.getPartitions().orElseGet(() -> this.getPartitionsAsList(this.getPartitions(metastore, identity, tableHandle, new Constraint(tableHandle.getEnforcedConstraint()), table)));
    }

    private static TupleDomain<HiveColumnHandle> toCompactTupleDomain(TupleDomain<ColumnHandle> effectivePredicate, int threshold) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        effectivePredicate.getDomains().ifPresent(domains -> {
            for (Map.Entry entry : domains.entrySet()) {
                HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)entry.getKey();
                builder.put((Object)hiveColumnHandle, (Object)((Domain)entry.getValue()).simplify(threshold));
            }
        });
        return TupleDomain.withColumnDomains((Map)builder.build());
    }

    private Optional<HivePartition> parseValuesAndFilterPartition(SchemaTableName tableName, String partitionId, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint) {
        HivePartition partition = HivePartitionManager.parsePartition(tableName, partitionId, partitionColumns, partitionColumnTypes);
        if (this.partitionMatches(partitionColumns, constraintSummary, constraint, partition)) {
            return Optional.of(partition);
        }
        return Optional.empty();
    }

    private boolean partitionMatches(List<HiveColumnHandle> partitionColumns, TupleDomain<ColumnHandle> constraintSummary, Predicate<Map<ColumnHandle, NullableValue>> constraint, HivePartition partition) {
        Map domains = (Map)constraintSummary.getDomains().get();
        for (HiveColumnHandle column : partitionColumns) {
            NullableValue value = partition.getKeys().get(column);
            Domain allowedDomain = (Domain)domains.get(column);
            if (allowedDomain == null || allowedDomain.includesNullableValue(value.getValue())) continue;
            return false;
        }
        return constraint.test(partition.getKeys());
    }

    private List<String> getFilteredPartitionNames(SemiTransactionalHiveMetastore metastore, HiveIdentity identity, SchemaTableName tableName, List<HiveColumnHandle> partitionKeys, TupleDomain<ColumnHandle> effectivePredicate, Table table) {
        Preconditions.checkArgument((boolean)effectivePredicate.getDomains().isPresent());
        ArrayList<String> filter = new ArrayList<String>();
        for (HiveColumnHandle partitionKey : partitionKeys) {
            Domain domain = (Domain)((Map)effectivePredicate.getDomains().get()).get(partitionKey);
            if (domain != null && domain.isNullableSingleValue()) {
                Slice slice;
                Object value = domain.getNullableSingleValue();
                Type type = domain.getType();
                if (value == null) {
                    filter.add("__HIVE_DEFAULT_PARTITION__");
                    continue;
                }
                if (type instanceof CharType) {
                    slice = (Slice)value;
                    filter.add(Chars.padSpaces((Slice)slice, (CharType)((CharType)type)).toStringUtf8());
                    continue;
                }
                if (type instanceof VarcharType) {
                    slice = (Slice)value;
                    filter.add(slice.toStringUtf8());
                    continue;
                }
                if (!this.assumeCanonicalPartitionKeys) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof DecimalType && !((DecimalType)type).isShort()) {
                    slice = (Slice)value;
                    filter.add(Decimals.toString((Slice)slice, (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DecimalType && ((DecimalType)type).isShort()) {
                    filter.add(Decimals.toString((long)((Long)value), (int)((DecimalType)type).getScale()));
                    continue;
                }
                if (type instanceof DateType) {
                    DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.date().withZoneUTC();
                    filter.add(dateTimeFormatter.print(TimeUnit.DAYS.toMillis((Long)value)));
                    continue;
                }
                if (type instanceof TimestampType) {
                    filter.add(PARTITION_VALUE_WILDCARD);
                    continue;
                }
                if (type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType || type instanceof DoubleType || type instanceof RealType || type instanceof BooleanType) {
                    filter.add(value.toString());
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported partition key type: %s", type.getDisplayName()));
            }
            filter.add(PARTITION_VALUE_WILDCARD);
        }
        return metastore.getPartitionNamesByParts(identity, tableName.getSchemaName(), tableName.getTableName(), filter, table).orElseThrow(() -> new TableNotFoundException(tableName));
    }

    public static HivePartition parsePartition(SchemaTableName tableName, String partitionName, List<HiveColumnHandle> partitionColumns, List<Type> partitionColumnTypes) {
        List<String> partitionValues = HivePartitionManager.extractPartitionValues(partitionName);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            HiveColumnHandle column = partitionColumns.get(i);
            NullableValue parsedValue = HiveUtil.parsePartitionValue(partitionName, partitionValues.get(i), partitionColumnTypes.get(i));
            builder.put((Object)column, (Object)parsedValue);
        }
        ImmutableMap values = builder.build();
        return new HivePartition(tableName, partitionName, (Map<ColumnHandle, NullableValue>)values);
    }

    public static List<String> extractPartitionValues(String partitionName) {
        ImmutableList.Builder values = ImmutableList.builder();
        boolean inKey = true;
        int valueStart = -1;
        for (int i = 0; i < partitionName.length(); ++i) {
            char current = partitionName.charAt(i);
            if (inKey) {
                Preconditions.checkArgument((current != '/' ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
                if (current != '=') continue;
                inKey = false;
                valueStart = i + 1;
                continue;
            }
            if (current != '/') continue;
            Preconditions.checkArgument((valueStart != -1 ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
            values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, i)));
            inKey = true;
            valueStart = -1;
        }
        Preconditions.checkArgument((!inKey ? 1 : 0) != 0, (String)"Invalid partition spec: %s", (Object)partitionName);
        values.add((Object)FileUtils.unescapePathName((String)partitionName.substring(valueStart, partitionName.length())));
        return values.build();
    }
}

