/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HivePartitionResult {
    private final List<HiveColumnHandle> partitionColumns;
    private final Iterable<HivePartition> partitions;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;

    public HivePartitionResult(List<HiveColumnHandle> partitionColumns, Iterable<HivePartition> partitions, TupleDomain<HiveColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> unenforcedConstraint, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
    }

    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Iterator<HivePartition> getPartitions() {
        return this.partitions.iterator();
    }

    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }
}

