/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveConnectorFactory;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.function.ConnectorConfig;
import io.prestosql.spi.queryeditorui.ConnectorUtil;
import io.prestosql.spi.queryeditorui.ConnectorWithProperties;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

@ConnectorConfig(connectorLabel="Hive: Query data stored in a Hive data warehouse", propertiesEnabled=true, catalogConfigFilesEnabled=true, globalConfigFilesEnabled=true, docLink="https://openlookeng.io/docs/docs/connector/hive.html", configLink="https://openlookeng.io/docs/docs/connector/hive.html#configuration")
public class HivePlugin
implements Plugin {
    private final String name;
    private final Optional<HiveMetastore> metastore;

    public HivePlugin(String name) {
        this(name, Optional.empty());
    }

    public HivePlugin(String name, Optional<HiveMetastore> metastore) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new HiveConnectorFactory(this.name, HivePlugin.class.getClassLoader(), this.metastore));
    }

    public Optional<ConnectorWithProperties> getConnectorWithProperties() {
        ConnectorConfig connectorConfig = HivePlugin.class.getAnnotation(ConnectorConfig.class);
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(StaticMetastoreConfig.class.getDeclaredMethods()));
        methods.addAll(Arrays.asList(HiveConfig.class.getDeclaredMethods()));
        return ConnectorUtil.assembleConnectorProperties((ConnectorConfig)connectorConfig, methods);
    }
}

