/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.OrcFileWriterConfig;
import io.prestosql.plugin.hive.ParquetFileWriterConfig;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;

public final class HiveSessionProperties {
    private static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    private static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final String INSERT_EXISTING_PARTITIONS_BEHAVIOR = "insert_existing_partitions_behavior";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_TINY_STRIPE_THRESHOLD = "orc_tiny_stripe_threshold";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_NESTED_LAZY_ENABLED = "orc_nested_lazy_enabled";
    private static final String ORC_STRING_STATISTICS_LIMIT = "orc_string_statistics_limit";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE = "orc_optimized_writer_validate_percentage";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE_MODE = "orc_optimized_writer_validate_mode";
    private static final String ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE = "orc_optimized_writer_min_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE = "orc_optimized_writer_max_stripe_size";
    private static final String ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS = "orc_optimized_writer_max_stripe_rows";
    private static final String ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY = "orc_optimized_writer_max_dictionary_memory";
    private static final String ORC_FILE_TAIL_CACHE_ENABLED = "orc_file_tail_cache_enabled";
    private static final String ORC_STRIPE_FOOTER_CACHE_ENABLED = "orc_stripe_footer_cache_enabled";
    private static final String ORC_ROW_INDEX_CACHE_ENABLED = "orc_row_index_cache_enabled";
    private static final String ORC_BLOOM_FILTERS_CACHE_ENABLED = "orc_bloom_filters_cache_enabled";
    private static final String ORC_ROW_DATA_CACHE_ENABLED = "orc_row_data_cache_enabled";
    private static final String HIVE_STORAGE_FORMAT = "hive_storage_format";
    private static final String RESPECT_TABLE_FORMAT = "respect_table_format";
    private static final String CREATE_EMPTY_BUCKET_FILES = "create_empty_bucket_files";
    private static final String PARQUET_USE_COLUMN_NAME = "parquet_use_column_names";
    private static final String PARQUET_FAIL_WITH_CORRUPTED_STATISTICS = "parquet_fail_with_corrupted_statistics";
    private static final String PARQUET_MAX_READ_BLOCK_SIZE = "parquet_max_read_block_size";
    private static final String PARQUET_WRITER_BLOCK_SIZE = "parquet_writer_block_size";
    private static final String PARQUET_WRITER_PAGE_SIZE = "parquet_writer_page_size";
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    private static final String RCFILE_OPTIMIZED_WRITER_VALIDATE = "rcfile_optimized_writer_validate";
    private static final String SORTED_WRITING_ENABLED = "sorted_writing_enabled";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    private static final String PARTITION_STATISTICS_SAMPLE_SIZE = "partition_statistics_sample_size";
    private static final String IGNORE_CORRUPTED_STATISTICS = "ignore_corrupted_statistics";
    private static final String COLLECT_COLUMN_STATISTICS_ON_WRITE = "collect_column_statistics_on_write";
    private static final String OPTIMIZE_MISMATCHED_BUCKET_COUNT = "optimize_mismatched_bucket_count";
    private static final String S3_SELECT_PUSHDOWN_ENABLED = "s3_select_pushdown_enabled";
    private static final String TEMPORARY_STAGING_DIRECTORY_ENABLED = "temporary_staging_directory_enabled";
    private static final String TEMPORARY_STAGING_DIRECTORY_PATH = "temporary_staging_directory_path";
    private static final String DYNAMIC_FILTERING_SPLIT_FILTERING = "dynamic_filtering_partition_filtering";
    private static final String DYNAMIC_FILTERING_ROW_FILTERING_THRESHOLD = "dynamic_filtering_filter_rows_threshold";
    private static final String ORC_PREDICATE_PUSHDOWN = "orc_predicate_pushdown_enabled";
    private static final String ORC_DISJUCT_PREDICATE_PUSHDOWN = "orc_disjunct_predicate_pushdown_enabled";
    private static final String ORC_PUSHDOWN_DATACACHE = "orc_pushdown_data_cache_enabled";
    private static final String WRITE_PARTITION_DISTRIBUTION = "write_partition_distribution";
    private static final String METASTORE_WRITE_BATCH_SIZE = "metastore_write_batch_size";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveConfig hiveConfig, OrcFileWriterConfig orcFileWriterConfig, ParquetFileWriterConfig parquetFileWriterConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: only use a single worker per bucket", (Boolean)hiveConfig.isBucketExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)WRITE_PARTITION_DISTRIBUTION, (String)"Distribute writes based on partition columns", (Boolean)false, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)FORCE_LOCAL_SCHEDULING, (String)"Only schedule splits on workers colocated with data node", (Boolean)hiveConfig.isForceLocalScheduling(), (boolean)false), (Object)new PropertyMetadata(INSERT_EXISTING_PARTITIONS_BEHAVIOR, "Behavior on insert existing partitions; this session property doesn't control behavior on insert existing unpartitioned table", (Type)VarcharType.VARCHAR, InsertExistingPartitionsBehavior.class, (Object)(hiveConfig.isImmutablePartitions() ? InsertExistingPartitionsBehavior.ERROR : InsertExistingPartitionsBehavior.APPEND), false, value -> InsertExistingPartitionsBehavior.valueOf((String)value, hiveConfig.isImmutablePartitions()), Enum::toString), (Object)PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)hiveConfig.isOrcBloomFiltersEnabled(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)ORC_MAX_MERGE_DISTANCE, (String)"ORC: Maximum size of gap between two reads to merge into a single read", (DataSize)hiveConfig.getOrcMaxMergeDistance(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)ORC_MAX_BUFFER_SIZE, (String)"ORC: Maximum size of a single read", (DataSize)hiveConfig.getOrcMaxBufferSize(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)ORC_STREAM_BUFFER_SIZE, (String)"ORC: Size of buffer for streaming reads", (DataSize)hiveConfig.getOrcStreamBufferSize(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)ORC_TINY_STRIPE_THRESHOLD, (String)"ORC: Threshold below which an ORC stripe or file will read in its entirety", (DataSize)hiveConfig.getOrcTinyStripeThreshold(), (boolean)false), (Object)PropertyMetadata.dataSizeProperty((String)ORC_MAX_READ_BLOCK_SIZE, (String)"ORC: Soft max size of Presto blocks produced by ORC reader", (DataSize)hiveConfig.getOrcMaxReadBlockSize(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)hiveConfig.isOrcLazyReadSmallRanges(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ORC_NESTED_LAZY_ENABLED, (String)"Experimental: ORC: Lazily read nested data", (Boolean)true, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.dataSizeProperty((String)ORC_STRING_STATISTICS_LIMIT, (String)"ORC: Maximum size of string statistics; drop if exceeding", (DataSize)orcFileWriterConfig.getStringStatisticsLimit(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Force all validation for files", (Boolean)(hiveConfig.getOrcWriterValidationPercentage() > 0.0 ? 1 : 0), (boolean)false), new PropertyMetadata(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, "Experimental: ORC: sample percentage for validation for files", (Type)DoubleType.DOUBLE, Double.class, (Object)hiveConfig.getOrcWriterValidationPercentage(), false, value -> {
            double doubleValue = ((Number)value).doubleValue();
            if (doubleValue < 0.0 || doubleValue > 100.0) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be between 0.0 and 100.0 inclusive: %s", ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, doubleValue));
            }
            return doubleValue;
        }, value -> value), PropertyMetadata.stringProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE_MODE, (String)"Experimental: ORC: Level of detail in ORC validation", (String)hiveConfig.getOrcWriterValidationMode().toString(), (boolean)false), PropertyMetadata.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, (String)"Experimental: ORC: Min stripe size", (DataSize)orcFileWriterConfig.getStripeMinSize(), (boolean)false), PropertyMetadata.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, (String)"Experimental: ORC: Max stripe size", (DataSize)orcFileWriterConfig.getStripeMaxSize(), (boolean)false), PropertyMetadata.integerProperty((String)ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, (String)"Experimental: ORC: Max stripe row count", (Integer)orcFileWriterConfig.getStripeMaxRowCount(), (boolean)false), PropertyMetadata.dataSizeProperty((String)ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, (String)"Experimental: ORC: Max dictionary memory", (DataSize)orcFileWriterConfig.getDictionaryMaxMemory(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_FILE_TAIL_CACHE_ENABLED, (String)"Cache Orc file tail", (Boolean)hiveConfig.isOrcFileTailCacheEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_STRIPE_FOOTER_CACHE_ENABLED, (String)"Cache Orc stripes' footer", (Boolean)hiveConfig.isOrcStripeFooterCacheEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_ROW_INDEX_CACHE_ENABLED, (String)"Cache Orc row index", (Boolean)hiveConfig.isOrcRowIndexCacheEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_BLOOM_FILTERS_CACHE_ENABLED, (String)"Cache Orc bloom filters", (Boolean)hiveConfig.isOrcBloomFiltersCacheEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_ROW_DATA_CACHE_ENABLED, (String)"Cache Orc row data", (Boolean)hiveConfig.isOrcRowDataCacheEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)HIVE_STORAGE_FORMAT, (String)"Default storage format for new tables or partitions", (String)hiveConfig.getHiveStorageFormat().toString(), (boolean)false), PropertyMetadata.booleanProperty((String)RESPECT_TABLE_FORMAT, (String)"Write new partitions using table format rather than default storage format", (Boolean)hiveConfig.isRespectTableFormat(), (boolean)false), PropertyMetadata.booleanProperty((String)CREATE_EMPTY_BUCKET_FILES, (String)"Create empty files for buckets that have no data", (Boolean)hiveConfig.isCreateEmptyBucketFiles(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_USE_COLUMN_NAME, (String)"Experimental: Parquet: Access Parquet columns using names from the file", (Boolean)hiveConfig.isUseParquetColumnNames(), (boolean)false), PropertyMetadata.booleanProperty((String)PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, (String)"Parquet: Fail when scanning Parquet files with corrupted statistics", (Boolean)hiveConfig.isFailOnCorruptedParquetStatistics(), (boolean)false), PropertyMetadata.dataSizeProperty((String)PARQUET_MAX_READ_BLOCK_SIZE, (String)"Parquet: Maximum size of a block to read", (DataSize)hiveConfig.getParquetMaxReadBlockSize(), (boolean)false), PropertyMetadata.dataSizeProperty((String)PARQUET_WRITER_BLOCK_SIZE, (String)"Parquet: Writer block size", (DataSize)parquetFileWriterConfig.getBlockSize(), (boolean)false), PropertyMetadata.dataSizeProperty((String)PARQUET_WRITER_PAGE_SIZE, (String)"Parquet: Writer page size", (DataSize)parquetFileWriterConfig.getPageSize(), (boolean)false), PropertyMetadata.dataSizeProperty((String)MAX_SPLIT_SIZE, (String)"Max split size", (DataSize)hiveConfig.getMaxSplitSize(), (boolean)true), PropertyMetadata.dataSizeProperty((String)MAX_INITIAL_SPLIT_SIZE, (String)"Max initial split size", (DataSize)hiveConfig.getMaxInitialSplitSize(), (boolean)true), PropertyMetadata.booleanProperty((String)RCFILE_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: RCFile: Validate writer files", (Boolean)hiveConfig.isRcfileWriterValidate(), (boolean)false), PropertyMetadata.booleanProperty((String)SORTED_WRITING_ENABLED, (String)"Enable writing to bucketed sorted tables", (Boolean)hiveConfig.isSortedWritingEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)STATISTICS_ENABLED, (String)"Experimental: Expose table statistics", (Boolean)hiveConfig.isTableStatisticsEnabled(), (boolean)false), PropertyMetadata.integerProperty((String)PARTITION_STATISTICS_SAMPLE_SIZE, (String)"Maximum sample size of the partitions column statistics", (Integer)hiveConfig.getPartitionStatisticsSampleSize(), (boolean)false), PropertyMetadata.booleanProperty((String)IGNORE_CORRUPTED_STATISTICS, (String)"Experimental: Ignore corrupted statistics rather than failing", (Boolean)hiveConfig.isIgnoreCorruptedStatistics(), (boolean)false), PropertyMetadata.booleanProperty((String)COLLECT_COLUMN_STATISTICS_ON_WRITE, (String)"Experimental: Enables automatic column level statistics collection on write", (Boolean)hiveConfig.isCollectColumnStatisticsOnWrite(), (boolean)false), PropertyMetadata.booleanProperty((String)OPTIMIZE_MISMATCHED_BUCKET_COUNT, (String)"Experimenal: Enable optimization to avoid shuffle when bucket count is compatible but not the same", (Boolean)hiveConfig.isOptimizeMismatchedBucketCount(), (boolean)false), PropertyMetadata.booleanProperty((String)S3_SELECT_PUSHDOWN_ENABLED, (String)"S3 Select pushdown enabled", (Boolean)hiveConfig.isS3SelectPushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)TEMPORARY_STAGING_DIRECTORY_ENABLED, (String)"Should use temporary staging directory for write operations", (Boolean)hiveConfig.isTemporaryStagingDirectoryEnabled(), (boolean)false), PropertyMetadata.stringProperty((String)TEMPORARY_STAGING_DIRECTORY_PATH, (String)"Temporary staging directory location", (String)hiveConfig.getTemporaryStagingDirectoryPath(), (boolean)false), PropertyMetadata.integerProperty((String)METASTORE_WRITE_BATCH_SIZE, (String)"Batch size for requests to HMS for partition and partition statistics write operation", (Integer)hiveConfig.getMetastoreWriteBatchSize(), (boolean)false), PropertyMetadata.integerProperty((String)DYNAMIC_FILTERING_ROW_FILTERING_THRESHOLD, (String)"Only enable row filtering with dynamic filter if the filter size is below this threshold", (Integer)hiveConfig.getDynamicFilteringRowFilteringThreshold(), (boolean)false), PropertyMetadata.booleanProperty((String)DYNAMIC_FILTERING_SPLIT_FILTERING, (String)"Filter out hive splits early based on partition value using dynamic filter", (Boolean)hiveConfig.isDynamicFilterPartitionFilteringEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_PREDICATE_PUSHDOWN, (String)"Experimental: Consume deterministic predicates(conjucts: AND) for ORC scan.", (Boolean)hiveConfig.isOrcPredicatePushdownEnabled(), (boolean)false), PropertyMetadata.booleanProperty((String)ORC_DISJUCT_PREDICATE_PUSHDOWN, (String)"Experimental: Consume deterministic predicates(disjucts: OR) for ORC scan.", (Boolean)true, (boolean)false), PropertyMetadata.booleanProperty((String)ORC_PUSHDOWN_DATACACHE, (String)"Experimental: Enable data cache or result cache with predicate pushdown.", (Boolean)true, (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isWritePartitionDistributionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(WRITE_PARTITION_DISTRIBUTION, Boolean.class);
    }

    public static int getMetastoreWriteBatchSize(ConnectorSession session) {
        return (Integer)session.getProperty(METASTORE_WRITE_BATCH_SIZE, Integer.class);
    }

    public static boolean isForceLocalScheduling(ConnectorSession session) {
        return (Boolean)session.getProperty(FORCE_LOCAL_SCHEDULING, Boolean.class);
    }

    public static InsertExistingPartitionsBehavior getInsertExistingPartitionsBehavior(ConnectorSession session) {
        return (InsertExistingPartitionsBehavior)((Object)session.getProperty(INSERT_EXISTING_PARTITIONS_BEHAVIOR, InsertExistingPartitionsBehavior.class));
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcTinyStripeThreshold(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_TINY_STRIPE_THRESHOLD, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcNestedLazy(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_NESTED_LAZY_ENABLED, Boolean.class);
    }

    public static DataSize getOrcStringStatisticsLimit(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STRING_STATISTICS_LIMIT, DataSize.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        boolean validate = (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
        double percentage = (Double)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_PERCENTAGE, Double.class);
        Preconditions.checkArgument((percentage >= 0.0 && percentage <= 100.0 ? 1 : 0) != 0);
        if (!validate) {
            return false;
        }
        return ThreadLocalRandom.current().nextDouble(100.0) < percentage;
    }

    public static OrcWriteValidation.OrcWriteValidationMode getOrcOptimizedWriterValidateMode(ConnectorSession session) {
        return OrcWriteValidation.OrcWriteValidationMode.valueOf((String)((String)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE_MODE, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static DataSize getOrcOptimizedWriterMinStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MIN_STRIPE_SIZE, DataSize.class);
    }

    public static DataSize getOrcOptimizedWriterMaxStripeSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_SIZE, DataSize.class);
    }

    public static int getOrcOptimizedWriterMaxStripeRows(ConnectorSession session) {
        return (Integer)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_STRIPE_ROWS, Integer.class);
    }

    public static DataSize getOrcOptimizedWriterMaxDictionaryMemory(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_OPTIMIZED_WRITER_MAX_DICTIONARY_MEMORY, DataSize.class);
    }

    public static boolean isOrcFileTailCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_FILE_TAIL_CACHE_ENABLED, Boolean.class);
    }

    public static boolean isOrcStripeFooterCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_STRIPE_FOOTER_CACHE_ENABLED, Boolean.class);
    }

    public static boolean isOrcRowIndexCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_ROW_INDEX_CACHE_ENABLED, Boolean.class);
    }

    public static boolean isOrcBloomFiltersCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_CACHE_ENABLED, Boolean.class);
    }

    public static boolean isOrcRowDataCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_ROW_DATA_CACHE_ENABLED, Boolean.class);
    }

    public static HiveStorageFormat getHiveStorageFormat(ConnectorSession session) {
        return HiveStorageFormat.valueOf(((String)session.getProperty(HIVE_STORAGE_FORMAT, String.class)).toUpperCase(Locale.ENGLISH));
    }

    public static boolean isRespectTableFormat(ConnectorSession session) {
        return (Boolean)session.getProperty(RESPECT_TABLE_FORMAT, Boolean.class);
    }

    public static boolean isCreateEmptyBucketFiles(ConnectorSession session) {
        return (Boolean)session.getProperty(CREATE_EMPTY_BUCKET_FILES, Boolean.class);
    }

    public static boolean isUseParquetColumnNames(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_USE_COLUMN_NAME, Boolean.class);
    }

    public static boolean isFailOnCorruptedParquetStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_FAIL_WITH_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static DataSize getParquetMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_BLOCK_SIZE, DataSize.class);
    }

    public static DataSize getParquetWriterPageSize(ConnectorSession session) {
        return (DataSize)session.getProperty(PARQUET_WRITER_PAGE_SIZE, DataSize.class);
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static boolean isRcfileOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isSortedWritingEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(SORTED_WRITING_ENABLED, Boolean.class);
    }

    public static boolean isS3SelectPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(S3_SELECT_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static int getPartitionStatisticsSampleSize(ConnectorSession session) {
        int size = (Integer)session.getProperty(PARTITION_STATISTICS_SAMPLE_SIZE, Integer.class);
        if (size < 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("%s must be greater than 0: %s", PARTITION_STATISTICS_SAMPLE_SIZE, size));
        }
        return size;
    }

    public static boolean isIgnoreCorruptedStatistics(ConnectorSession session) {
        return (Boolean)session.getProperty(IGNORE_CORRUPTED_STATISTICS, Boolean.class);
    }

    public static boolean isCollectColumnStatisticsOnWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(COLLECT_COLUMN_STATISTICS_ON_WRITE, Boolean.class);
    }

    public static boolean isOptimizedMismatchedBucketCount(ConnectorSession session) {
        return (Boolean)session.getProperty(OPTIMIZE_MISMATCHED_BUCKET_COUNT, Boolean.class);
    }

    public static boolean isTemporaryStagingDirectoryEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(TEMPORARY_STAGING_DIRECTORY_ENABLED, Boolean.class);
    }

    public static int getDynamicFilteringRowFilteringThreshold(ConnectorSession session) {
        return (Integer)session.getProperty(DYNAMIC_FILTERING_ROW_FILTERING_THRESHOLD, Integer.class);
    }

    public static boolean isDynamicFilteringSplitFilteringEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(DYNAMIC_FILTERING_SPLIT_FILTERING, Boolean.class);
    }

    public static boolean isOrcPredicatePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_PREDICATE_PUSHDOWN, Boolean.class);
    }

    public static boolean isOrcDisjunctPredicatePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_DISJUCT_PREDICATE_PUSHDOWN, Boolean.class);
    }

    public static boolean isOrcPushdownDataCacheEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_PUSHDOWN_DATACACHE, Boolean.class);
    }

    public static enum InsertExistingPartitionsBehavior {
        ERROR,
        APPEND,
        OVERWRITE;


        public static InsertExistingPartitionsBehavior valueOf(String value, boolean immutablePartition) {
            InsertExistingPartitionsBehavior enumValue = InsertExistingPartitionsBehavior.valueOf(value.toUpperCase(Locale.ENGLISH));
            if (immutablePartition) {
                Preconditions.checkArgument((enumValue != APPEND ? 1 : 0) != 0, (String)"Presto is configured to treat Hive partitions as immutable. %s is not allowed to be set to %s", (Object)HiveSessionProperties.INSERT_EXISTING_PARTITIONS_BEHAVIOR, (Object)((Object)APPEND));
            }
            return enumValue;
        }
    }
}

