/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartitionHandle;
import io.prestosql.plugin.hive.HivePartitionKey;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitLoader;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.InternalHiveSplit;
import io.prestosql.plugin.hive.util.AsyncQueue;
import io.prestosql.plugin.hive.util.ThrottledAsyncQueue;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class HiveSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(HiveSplitSource.class);
    private final String queryId;
    private final String databaseName;
    private final String tableName;
    private final PerBucket queues;
    private final AtomicInteger bufferedInternalSplitCount = new AtomicInteger();
    private final int maxOutstandingSplitsBytes;
    private final DataSize maxSplitSize;
    private final DataSize maxInitialSplitSize;
    private final AtomicInteger remainingInitialSplits;
    private final HiveSplitLoader splitLoader;
    private final AtomicReference<State> stateReference;
    private final AtomicLong estimatedSplitSizeInBytes = new AtomicLong();
    private final CounterStat highMemorySplitSourceCounter;
    private final AtomicBoolean loggedHighMemoryWarning = new AtomicBoolean();
    private final Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier;
    private final Set<TupleDomain<ColumnMetadata>> userDefinedCachePredicates;
    private final boolean isSplitFilteringEnabled;
    private final HiveConfig hiveConfig;
    private final TypeManager typeManager;
    private final HiveStorageFormat hiveStorageFormat;

    private HiveSplitSource(ConnectorSession session, String databaseName, String tableName, PerBucket queues, int maxInitialSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, AtomicReference<State> stateReference, CounterStat highMemorySplitSourceCounter, Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier, Set<TupleDomain<ColumnMetadata>> userDefinedCachedPredicates, TypeManager typeManager, HiveConfig hiveConfig, HiveStorageFormat hiveStorageFormat) {
        Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.queues = Objects.requireNonNull(queues, "queues is null");
        this.maxOutstandingSplitsBytes = Math.toIntExact(maxOutstandingSplitsSize.toBytes());
        this.splitLoader = Objects.requireNonNull(splitLoader, "splitLoader is null");
        this.stateReference = Objects.requireNonNull(stateReference, "stateReference is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        this.maxSplitSize = HiveSessionProperties.getMaxSplitSize(session);
        this.maxInitialSplitSize = HiveSessionProperties.getMaxInitialSplitSize(session);
        this.remainingInitialSplits = new AtomicInteger(maxInitialSplits);
        this.dynamicFilterSupplier = dynamicFilterSupplier;
        this.isSplitFilteringEnabled = HiveSessionProperties.isDynamicFilteringSplitFilteringEnabled(session);
        this.userDefinedCachePredicates = userDefinedCachedPredicates;
        this.typeManager = typeManager;
        this.hiveConfig = hiveConfig;
        this.hiveStorageFormat = hiveStorageFormat;
    }

    public static HiveSplitSource allAtOnce(ConnectorSession session, String databaseName, String tableName, int maxInitialSplits, final int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, final int maxSplitsPerSecond, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter, Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier, Set<TupleDomain<ColumnMetadata>> userDefinedCachePredicates, TypeManager typeManager, HiveConfig hiveConfig, HiveStorageFormat hiveStorageFormat) {
        AtomicReference<State> localStateReference = new AtomicReference<State>(State.initial());
        return new HiveSplitSource(session, databaseName, tableName, new PerBucket(){
            private final AsyncQueue<InternalHiveSplit> queue;
            {
                this.queue = new ThrottledAsyncQueue<InternalHiveSplit>(maxSplitsPerSecond, maxOutstandingSplits, executor);
            }

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                return this.queue.offer(connectorSplit);
            }

            @Override
            public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> function) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.borrowBatchAsync(maxSize, function);
            }

            @Override
            public void finish() {
                this.queue.finish();
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                Preconditions.checkArgument((!bucketNumber.isPresent() ? 1 : 0) != 0);
                return this.queue.isFinished();
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, localStateReference, highMemorySplitSourceCounter, dynamicFilterSupplier, userDefinedCachePredicates, typeManager, hiveConfig, hiveStorageFormat);
    }

    public static HiveSplitSource bucketed(ConnectorSession session, String databaseName, String tableName, final int estimatedOutstandingSplitsPerBucket, int maxInitialSplits, DataSize maxOutstandingSplitsSize, final int maxSplitsPerSecond, HiveSplitLoader splitLoader, final Executor executor, CounterStat highMemorySplitSourceCounter, Supplier<List<Set<DynamicFilter>>> dynamicFilterSupplier, Set<TupleDomain<ColumnMetadata>> userDefinedCachePredicates, TypeManager typeManager, HiveConfig hiveConfig, HiveStorageFormat hiveStorageFormat) {
        AtomicReference<State> localStateReference = new AtomicReference<State>(State.initial());
        return new HiveSplitSource(session, databaseName, tableName, new PerBucket(){
            private final Map<Integer, AsyncQueue<InternalHiveSplit>> queues = new ConcurrentHashMap<Integer, AsyncQueue<InternalHiveSplit>>();
            private final AtomicBoolean finished = new AtomicBoolean();

            @Override
            public ListenableFuture<?> offer(OptionalInt bucketNumber, InternalHiveSplit connectorSplit) {
                AsyncQueue<InternalHiveSplit> queue = this.queueFor(bucketNumber);
                queue.offer(connectorSplit);
                return Futures.immediateFuture(null);
            }

            @Override
            public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt bucketNumber, int maxSize, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> function) {
                return this.queueFor(bucketNumber).borrowBatchAsync(maxSize, function);
            }

            @Override
            public void finish() {
                if (this.finished.compareAndSet(false, true)) {
                    this.queues.values().forEach(AsyncQueue::finish);
                }
            }

            @Override
            public boolean isFinished(OptionalInt bucketNumber) {
                return this.queueFor(bucketNumber).isFinished();
            }

            public AsyncQueue<InternalHiveSplit> queueFor(OptionalInt bucketNumber) {
                Preconditions.checkArgument((boolean)bucketNumber.isPresent());
                AtomicBoolean isNew = new AtomicBoolean();
                AsyncQueue queue = this.queues.computeIfAbsent(bucketNumber.getAsInt(), ignored -> {
                    isNew.set(true);
                    return new ThrottledAsyncQueue(maxSplitsPerSecond, estimatedOutstandingSplitsPerBucket, executor);
                });
                if (isNew.get() && this.finished.get()) {
                    queue.finish();
                }
                return queue;
            }
        }, maxInitialSplits, maxOutstandingSplitsSize, splitLoader, localStateReference, highMemorySplitSourceCounter, dynamicFilterSupplier, userDefinedCachePredicates, typeManager, hiveConfig, hiveStorageFormat);
    }

    @VisibleForTesting
    int getBufferedInternalSplitCount() {
        return this.bufferedInternalSplitCount.get();
    }

    ListenableFuture<?> addToQueue(List<? extends InternalHiveSplit> splits) {
        ListenableFuture<?> lastResult = Futures.immediateFuture(null);
        for (InternalHiveSplit internalHiveSplit : splits) {
            lastResult = this.addToQueue(internalHiveSplit);
        }
        return lastResult;
    }

    ListenableFuture<?> addToQueue(InternalHiveSplit split) {
        if (this.stateReference.get().getKind() != StateKind.INITIAL) {
            return Futures.immediateFuture(null);
        }
        if (this.estimatedSplitSizeInBytes.addAndGet(split.getEstimatedSizeInBytes()) > (long)this.maxOutstandingSplitsBytes) {
            if (this.loggedHighMemoryWarning.compareAndSet(false, true)) {
                this.highMemorySplitSourceCounter.update(1L);
                log.warn("Split buffering for %s.%s in query %s exceeded memory limit (%s). %s splits are buffered.", new Object[]{this.databaseName, this.tableName, this.queryId, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()});
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_EXCEEDED_SPLIT_BUFFERING_LIMIT, String.format("Split buffering for %s.%s exceeded memory limit (%s). %s splits are buffered.", this.databaseName, this.tableName, DataSize.succinctBytes((long)this.maxOutstandingSplitsBytes), this.getBufferedInternalSplitCount()));
        }
        this.bufferedInternalSplitCount.incrementAndGet();
        OptionalInt bucketNumber = split.getBucketNumber();
        return this.queues.offer(bucketNumber, split);
    }

    void noMoreSplits() {
        if (HiveSplitSource.setIf(this.stateReference, State.noMoreSplits(), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    void fail(Throwable e) {
        if (HiveSplitSource.setIf(this.stateReference, State.failed(e), state -> state.getKind() == StateKind.INITIAL)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        boolean noMoreSplits;
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                noMoreSplits = false;
                break;
            }
            case NO_MORE_SPLITS: {
                noMoreSplits = true;
                break;
            }
            case FAILED: {
                return MoreFutures.failedFuture((Throwable)state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        OptionalInt bucketNumber = HiveSplitSource.toBucketNumber(partitionHandle);
        ListenableFuture future = this.queues.borrowBatchAsync(bucketNumber, maxSize, internalSplits -> {
            ImmutableList.Builder splitsToInsertBuilder = ImmutableList.builder();
            ImmutableList.Builder resultBuilder = ImmutableList.builder();
            int removedEstimatedSizeInBytes = 0;
            for (InternalHiveSplit internalSplit : internalSplits) {
                long maxSplitBytes = this.getMaxSplitBytes();
                InternalHiveSplit.InternalHiveBlock block = internalSplit.currentBlock();
                long splitBytes = internalSplit.isSplittable() ? Math.min(maxSplitBytes, block.getEnd() - internalSplit.getStart()) : internalSplit.getEnd() - internalSplit.getStart();
                boolean splitCacheable = this.matchesUserDefinedCachedPredicates(internalSplit.getPartitionKeys());
                resultBuilder.add((Object)HiveSplitWrapper.wrap(new HiveSplit(this.databaseName, this.tableName, internalSplit.getPartitionName(), internalSplit.getPath(), internalSplit.getStart(), splitBytes, internalSplit.getFileSize(), internalSplit.getLastModifiedTime(), internalSplit.getSchema(), internalSplit.getPartitionKeys(), block.getAddresses(), internalSplit.getBucketNumber(), internalSplit.isForceLocalScheduling(), Maps.transformValues(internalSplit.getColumnCoercions(), HiveTypeName::toHiveType), internalSplit.getBucketConversion(), internalSplit.isS3SelectPushdownEnabled(), internalSplit.getDeleteDeltaLocations(), internalSplit.getStartRowOffsetOfFile(), splitCacheable, internalSplit.getCustomSplitInfo())));
                internalSplit.increaseStart(splitBytes);
                if (internalSplit.isDone()) {
                    removedEstimatedSizeInBytes += internalSplit.getEstimatedSizeInBytes();
                    continue;
                }
                splitsToInsertBuilder.add((Object)internalSplit);
            }
            this.estimatedSplitSizeInBytes.addAndGet(-removedEstimatedSizeInBytes);
            ImmutableList splitsToInsert = splitsToInsertBuilder.build();
            ImmutableList result = resultBuilder.build();
            this.bufferedInternalSplitCount.addAndGet(splitsToInsert.size() - result.size());
            return new AsyncQueue.BorrowResult(splitsToInsert, result);
        });
        ListenableFuture transform = Futures.transform(future, splits -> {
            Objects.requireNonNull(splits, "splits is null");
            if (this.dynamicFilterSupplier != null && this.isSplitFilteringEnabled) {
                splits = splits.stream().filter(split -> !HiveUtil.isPartitionFiltered(HiveSplitWrapper.getOnlyHiveSplit(split).getPartitionKeys(), this.dynamicFilterSupplier.get(), this.typeManager)).collect(Collectors.toList());
            }
            if (noMoreSplits) {
                return new ConnectorSplitSource.ConnectorSplitBatch((List)splits, splits.isEmpty() && this.queues.isFinished(bucketNumber));
            }
            return new ConnectorSplitSource.ConnectorSplitBatch((List)splits, false);
        }, (Executor)MoreExecutors.directExecutor());
        return MoreFutures.toCompletableFuture((ListenableFuture)transform);
    }

    private boolean matchesUserDefinedCachedPredicates(List<HivePartitionKey> partitionKeys) {
        if (this.userDefinedCachePredicates == null || this.userDefinedCachePredicates.isEmpty() || partitionKeys == null || partitionKeys.isEmpty()) {
            return false;
        }
        try {
            Map hivePartitionKeyMap = partitionKeys.stream().collect(Collectors.toMap(HivePartitionKey::getName, Function.identity()));
            for (TupleDomain<ColumnMetadata> tupleDomain : this.userDefinedCachePredicates) {
                boolean allMatches;
                if (!tupleDomain.getDomains().isPresent()) continue;
                Map domainMap = (Map)tupleDomain.getDomains().get();
                Collection columnsDefinedInPredicate = domainMap.keySet().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
                if (!hivePartitionKeyMap.keySet().containsAll(columnsDefinedInPredicate) || !(allMatches = domainMap.entrySet().stream().allMatch(entry -> {
                    ColumnMetadata columnMetadata = (ColumnMetadata)entry.getKey();
                    Domain domain = (Domain)entry.getValue();
                    String partitionStringValue = ((HivePartitionKey)hivePartitionKeyMap.get(columnMetadata.getName())).getValue();
                    NullableValue nullableValue = partitionStringValue.equals("\\N") ? NullableValue.asNull((Type)columnMetadata.getType()) : HiveUtil.parsePartitionValue(columnMetadata.getName(), partitionStringValue, columnMetadata.getType());
                    return domain.includesNullableValue(nullableValue.getValue());
                }))) continue;
                return true;
            }
        }
        catch (Exception ex) {
            log.warn((Throwable)ex, "Unable to match partition keys %s with cached predicates. Ignoring this partition key. Error = %s", new Object[]{partitionKeys, ex.getMessage()});
        }
        return false;
    }

    public boolean isFinished() {
        State state = this.stateReference.get();
        switch (state.getKind()) {
            case INITIAL: {
                return false;
            }
            case NO_MORE_SPLITS: {
                return this.bufferedInternalSplitCount.get() == 0;
            }
            case FAILED: {
                throw HiveSplitSource.propagatePrestoException(state.getThrowable());
            }
            case CLOSED: {
                throw new IllegalStateException("HiveSplitSource is already closed");
            }
        }
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (HiveSplitSource.setIf(this.stateReference, State.closed(), state -> state.getKind() == StateKind.INITIAL || state.getKind() == StateKind.NO_MORE_SPLITS)) {
            this.splitLoader.stop();
            this.queues.finish();
        }
    }

    private static OptionalInt toBucketNumber(ConnectorPartitionHandle partitionHandle) {
        if (partitionHandle == NotPartitionedPartitionHandle.NOT_PARTITIONED) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(((HivePartitionHandle)partitionHandle).getBucket());
    }

    private static <T> boolean setIf(AtomicReference<T> atomicReference, T newValue, Predicate<T> predicate) {
        T current;
        do {
            if (predicate.test(current = atomicReference.get())) continue;
            return false;
        } while (!atomicReference.compareAndSet(current, newValue));
        return true;
    }

    static RuntimeException propagatePrestoException(Throwable throwable) {
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        if (throwable instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
    }

    public List<ConnectorSplit> groupSmallSplits(List<ConnectorSplit> splitList, int maxGroupSize) {
        if (splitList.isEmpty()) {
            return splitList;
        }
        int maxSmallSplitsCanBeGrouped = Math.max(this.hiveConfig.getMaxSplitsToGroup(), maxGroupSize);
        if (maxSmallSplitsCanBeGrouped < 2) {
            return splitList;
        }
        if (this.hiveStorageFormat != HiveStorageFormat.ORC) {
            return splitList;
        }
        ImmutableList.Builder connectorSplitList = ImmutableList.builder();
        ArrayList<HiveSplitWrapper> hiveSplitWrappers = new ArrayList<HiveSplitWrapper>();
        splitList.forEach(pendingSplit -> hiveSplitWrappers.add((HiveSplitWrapper)pendingSplit));
        long maxSplitBytes = this.getMaxSplitBytes();
        HashMultimap bucketNumToHiveSplitsMap = HashMultimap.create();
        int replicationFactor = ((HiveSplitWrapper)hiveSplitWrappers.get(0)).getSplits().get(0).getAddresses().size();
        boolean bucketNumberPresent = ((HiveSplitWrapper)hiveSplitWrappers.get(0)).getBucketNumber().isPresent();
        if (!this.getSmallerSplits(hiveSplitWrappers, (Multimap<Integer, HiveSplit>)bucketNumToHiveSplitsMap, maxSplitBytes, replicationFactor, (ImmutableList.Builder<ConnectorSplit>)connectorSplitList)) {
            return splitList;
        }
        for (Integer bucketNumber : bucketNumToHiveSplitsMap.keySet()) {
            HashMultimap hostAddressHiveSplits = HashMultimap.create();
            Collection hiveSplits = bucketNumToHiveSplitsMap.get((Object)bucketNumber);
            this.groupBaseOnLocation(hiveSplits, (Multimap<String, HiveSplit>)hostAddressHiveSplits);
            for (String hostAddressText : hostAddressHiveSplits.keySet()) {
                ArrayList locationBaseHiveSplits = new ArrayList();
                hostAddressHiveSplits.get((Object)hostAddressText).forEach(split1 -> locationBaseHiveSplits.add(split1));
                locationBaseHiveSplits.sort((split1, split2) -> (int)(split2.getFileSize() - split1.getFileSize()));
                int numberOfSplitsPerLocation = locationBaseHiveSplits.size();
                int avgSplitsPerNode = replicationFactor != 0 && numberOfSplitsPerLocation >= replicationFactor ? numberOfSplitsPerLocation / replicationFactor : numberOfSplitsPerLocation;
                ArrayList<HiveSplit> groupedHiveSplit = new ArrayList<HiveSplit>();
                long totalSize = 0L;
                int numberOfSplitsGrouped = 0;
                while (!locationBaseHiveSplits.isEmpty()) {
                    int i = 0;
                    if (maxSplitBytes < (totalSize += ((HiveSplit)locationBaseHiveSplits.get(i)).getFileSize()) || avgSplitsPerNode < ++numberOfSplitsGrouped || maxSmallSplitsCanBeGrouped < numberOfSplitsGrouped) {
                        connectorSplitList.add((Object)HiveSplitWrapper.wrap(groupedHiveSplit, bucketNumberPresent ? OptionalInt.of(bucketNumber) : OptionalInt.empty()));
                        log.debug("info table %s,  groupedHiveSplit size %d, maxSplitBytes %d, totalSize %d, avgSplitsPerNode %d, numberOfSplitsGrouped %d, maxSmallSplitsCanBeGrouped %d, numberOfSplitsGrouped %d ", new Object[]{((HiveSplit)groupedHiveSplit.get(0)).getTable(), groupedHiveSplit.size(), maxSplitBytes, totalSize, avgSplitsPerNode, numberOfSplitsGrouped, maxSmallSplitsCanBeGrouped, numberOfSplitsGrouped});
                        totalSize = 0L;
                        numberOfSplitsGrouped = 0;
                        groupedHiveSplit = new ArrayList();
                        continue;
                    }
                    groupedHiveSplit.add((HiveSplit)locationBaseHiveSplits.get(i));
                    locationBaseHiveSplits.remove(i);
                    if (locationBaseHiveSplits.isEmpty()) break;
                    int lastSplitLocation = locationBaseHiveSplits.size() - 1;
                    if (maxSplitBytes < (totalSize += ((HiveSplit)locationBaseHiveSplits.get(lastSplitLocation)).getFileSize()) || avgSplitsPerNode < ++numberOfSplitsGrouped || maxSmallSplitsCanBeGrouped < numberOfSplitsGrouped) {
                        connectorSplitList.add((Object)HiveSplitWrapper.wrap(groupedHiveSplit, bucketNumberPresent ? OptionalInt.of(bucketNumber) : OptionalInt.empty()));
                        log.debug("info table %s,  groupedHiveSplit size %d, maxSplitBytes %d, totalSize %d, avgSplitsPerNode %d, numberOfSplitsGrouped %d, maxSmallSplitsCanBeGrouped %d, numberOfSplitsGrouped %d ", new Object[]{((HiveSplit)groupedHiveSplit.get(0)).getTable(), groupedHiveSplit.size(), maxSplitBytes, totalSize, avgSplitsPerNode, numberOfSplitsGrouped, maxSmallSplitsCanBeGrouped, numberOfSplitsGrouped});
                        totalSize = 0L;
                        numberOfSplitsGrouped = 0;
                        groupedHiveSplit = new ArrayList();
                        continue;
                    }
                    groupedHiveSplit.add((HiveSplit)locationBaseHiveSplits.get(lastSplitLocation));
                    locationBaseHiveSplits.remove(lastSplitLocation);
                }
                if (groupedHiveSplit.isEmpty()) continue;
                connectorSplitList.add((Object)HiveSplitWrapper.wrap(groupedHiveSplit, bucketNumberPresent ? OptionalInt.of(bucketNumber) : OptionalInt.empty()));
            }
        }
        ImmutableList resultConnectorSplits = connectorSplitList.build();
        log.debug("info resultBuilder size %d", new Object[]{resultConnectorSplits.size()});
        return resultConnectorSplits;
    }

    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return Optional.empty();
    }

    private boolean getSmallerSplits(List<HiveSplitWrapper> hiveSplitWrappers, Multimap<Integer, HiveSplit> bucketNumberHiveSplits, long maxSplitBytes, int replicationFactor, ImmutableList.Builder<ConnectorSplit> connectorSplitList) {
        int numSmallSplits = 0;
        for (HiveSplitWrapper hiveSplitWrapper : hiveSplitWrappers) {
            HiveSplit hiveSplit = hiveSplitWrapper.getSplits().get(0);
            long fileSize = hiveSplit.getFileSize();
            if (hiveSplit.isCacheable() || replicationFactor != hiveSplit.getAddresses().size()) {
                return false;
            }
            if (fileSize < maxSplitBytes) {
                bucketNumberHiveSplits.put((Object)(hiveSplit.getBucketNumber().isPresent() ? hiveSplit.getBucketNumber().getAsInt() : 0), (Object)hiveSplit);
                ++numSmallSplits;
                continue;
            }
            connectorSplitList.add((Object)HiveSplitWrapper.wrap(hiveSplit));
        }
        if (0 == numSmallSplits) {
            return false;
        }
        log.info("info total Split %d,  numSmallSplits %d ", new Object[]{hiveSplitWrappers.size(), numSmallSplits});
        return true;
    }

    private void groupBaseOnLocation(Collection<HiveSplit> bucketBasedHiveSplits, Multimap<String, HiveSplit> hostAddressHiveSplits) {
        for (HiveSplit hiveSplit : bucketBasedHiveSplits) {
            ArrayList<HostAddress> hostAddresses = new ArrayList<HostAddress>();
            hostAddresses.addAll(hiveSplit.getAddresses());
            hostAddresses.sort((host1, host2) -> host1.getHostText().compareTo(host2.getHostText()));
            StringBuilder hostAddressText = new StringBuilder();
            hostAddresses.forEach(hostAddress -> hostAddressText.append(hostAddress.getHostText()));
            hostAddressHiveSplits.put((Object)hostAddressText.toString(), (Object)hiveSplit);
        }
    }

    private long getMaxSplitBytes() {
        long maxSplitBytes = this.maxSplitSize.toBytes();
        if (this.remainingInitialSplits.get() > 0 && this.remainingInitialSplits.getAndDecrement() > 0) {
            maxSplitBytes = this.maxInitialSplitSize.toBytes();
        }
        return maxSplitBytes;
    }

    static enum StateKind {
        INITIAL,
        NO_MORE_SPLITS,
        FAILED,
        CLOSED;

    }

    static class State {
        private final StateKind kind;
        private final Throwable throwable;

        private State(StateKind kind, Throwable throwable) {
            this.kind = kind;
            this.throwable = throwable;
        }

        public StateKind getKind() {
            return this.kind;
        }

        public Throwable getThrowable() {
            Preconditions.checkState((this.throwable != null ? 1 : 0) != 0);
            return this.throwable;
        }

        public static State initial() {
            return new State(StateKind.INITIAL, null);
        }

        public static State noMoreSplits() {
            return new State(StateKind.NO_MORE_SPLITS, null);
        }

        public static State failed(Throwable throwable) {
            return new State(StateKind.FAILED, throwable);
        }

        public static State closed() {
            return new State(StateKind.CLOSED, null);
        }
    }

    static interface PerBucket {
        public ListenableFuture<?> offer(OptionalInt var1, InternalHiveSplit var2);

        public <O> ListenableFuture<O> borrowBatchAsync(OptionalInt var1, int var2, Function<List<InternalHiveSplit>, AsyncQueue.BorrowResult<InternalHiveSplit, O>> var3);

        public void finish();

        public boolean isFinished(OptionalInt var1);
    }
}

