/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.util.SizeOf;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.openjdk.jol.info.ClassLayout;

public class HiveSplitWrapper
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(HiveSplitWrapper.class).instanceSize();
    private final List<HiveSplit> splits;
    private final OptionalInt bucketNumber;

    @JsonCreator
    public HiveSplitWrapper(@JsonProperty(value="splits") List<HiveSplit> splits, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber) {
        this.splits = Objects.requireNonNull(splits, "split lists is null");
        this.bucketNumber = bucketNumber;
    }

    public String getFilePath() {
        return ((HiveSplit)this.splits.stream().findFirst().orElseThrow(IllegalArgumentException::new)).getFilePath();
    }

    public long getStartIndex() {
        return ((HiveSplit)this.splits.stream().findFirst().orElseThrow(IllegalArgumentException::new)).getStartIndex();
    }

    public long getEndIndex() {
        return ((HiveSplit)this.splits.stream().findFirst().orElseThrow(IllegalArgumentException::new)).getEndIndex();
    }

    public long getLastModifiedTime() {
        return ((HiveSplit)this.splits.stream().findFirst().orElseThrow(IllegalArgumentException::new)).getLastModifiedTime();
    }

    public boolean isCacheable() {
        return ((HiveSplit)this.splits.stream().findFirst().orElseThrow(IllegalAccessError::new)).isCacheable();
    }

    @JsonProperty
    public List<HiveSplit> getSplits() {
        return this.splits;
    }

    public List<ConnectorSplit> getUnwrappedSplits() {
        return this.splits.stream().map(x -> HiveSplitWrapper.wrap(x)).collect(Collectors.toList());
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return this.splits.stream().flatMap(s -> s.getAddresses().stream()).distinct().collect(Collectors.toList());
    }

    public Object getInfo() {
        if (this.splits.isEmpty()) {
            return ImmutableMap.of();
        }
        HiveSplit split = this.splits.get(0);
        return ImmutableMap.builder().put((Object)"hosts", this.getAddresses()).put((Object)"database", (Object)split.getDatabase()).put((Object)"table", (Object)split.getTable()).put((Object)"partitionName", (Object)split.getPartitionName()).build();
    }

    public static HiveSplitWrapper wrap(HiveSplit hiveSplit) {
        return new HiveSplitWrapper((List<HiveSplit>)ImmutableList.of((Object)hiveSplit), hiveSplit.getBucketNumber());
    }

    public static HiveSplitWrapper wrap(List<HiveSplit> hiveSplitList, OptionalInt bucketNumber) {
        return new HiveSplitWrapper(hiveSplitList, bucketNumber);
    }

    public static HiveSplit getOnlyHiveSplit(ConnectorSplit connectorSplit) {
        return (HiveSplit)Iterables.getOnlyElement(((HiveSplitWrapper)connectorSplit).getSplits());
    }

    public int getSplitCount() {
        return this.splits.size();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.splits, HiveSplit::getRetainedSizeInBytes) + SizeOf.sizeOf((OptionalInt)this.bucketNumber);
    }
}

