/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.plugin.hive.HiveBucketHandle;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class HiveTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final Optional<Map<String, String>> tableParameters;
    private final List<HiveColumnHandle> partitionColumns;
    private final Optional<List<HivePartition>> partitions;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> enforcedConstraint;
    private final Optional<HiveBucketHandle> bucketHandle;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final Optional<List<List<String>>> analyzePartitionValues;
    private final Map<String, HiveColumnHandle> predicateColumns;
    private final Optional<List<TupleDomain<HiveColumnHandle>>> disjunctCompactEffectivePredicate;
    private final boolean suitableToPush;

    @JsonCreator
    public HiveTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partitionColumns") List<HiveColumnHandle> partitionColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<HiveColumnHandle> compactEffectivePredicate, @JsonProperty(value="enforcedConstraint") TupleDomain<ColumnHandle> enforcedConstraint, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle, @JsonProperty(value="bucketFilter") Optional<HiveBucketing.HiveBucketFilter> bucketFilter, @JsonProperty(value="analyzePartitionValues") Optional<List<List<String>>> analyzePartitionValues, @JsonProperty(value="predicateColumns") Map<String, HiveColumnHandle> predicateColumns, @JsonProperty(value="additionaPredicates") Optional<List<TupleDomain<HiveColumnHandle>>> disjunctCompactEffectivePredicate, @JsonProperty(value="suitableToPush") boolean suitableToPush) {
        this(schemaName, tableName, Optional.empty(), partitionColumns, Optional.empty(), compactEffectivePredicate, enforcedConstraint, bucketHandle, bucketFilter, analyzePartitionValues, predicateColumns, disjunctCompactEffectivePredicate, suitableToPush);
    }

    public HiveTableHandle(String schemaName, String tableName, Map<String, String> tableParameters, List<HiveColumnHandle> partitionColumns, Optional<HiveBucketHandle> bucketHandle) {
        this(schemaName, tableName, Optional.of(tableParameters), partitionColumns, Optional.empty(), (TupleDomain<HiveColumnHandle>)TupleDomain.all(), (TupleDomain<ColumnHandle>)TupleDomain.all(), bucketHandle, Optional.empty(), Optional.empty(), null, Optional.empty(), false);
    }

    public HiveTableHandle(String schemaName, String tableName, Optional<Map<String, String>> tableParameters, List<HiveColumnHandle> partitionColumns, Optional<List<HivePartition>> partitions, TupleDomain<HiveColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> enforcedConstraint, Optional<HiveBucketHandle> bucketHandle, Optional<HiveBucketing.HiveBucketFilter> bucketFilter, Optional<List<List<String>>> analyzePartitionValues, Map<String, HiveColumnHandle> predicateColumns, Optional<List<TupleDomain<HiveColumnHandle>>> disjunctCompactEffectivePredicate, boolean suitableToPush) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableParameters = Objects.requireNonNull(tableParameters, "tableParameters is null").map(ImmutableMap::copyOf);
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null").map(ImmutableList::copyOf);
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.enforcedConstraint = Objects.requireNonNull(enforcedConstraint, "enforcedConstraint is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
        this.analyzePartitionValues = Objects.requireNonNull(analyzePartitionValues, "analyzePartitionValues is null");
        this.predicateColumns = predicateColumns;
        this.disjunctCompactEffectivePredicate = Objects.requireNonNull(disjunctCompactEffectivePredicate, "disjunctCompactEffectivePredicate is null");
        this.suitableToPush = suitableToPush;
    }

    public HiveTableHandle withAnalyzePartitionValues(Optional<List<List<String>>> analyzePartitionValues) {
        return new HiveTableHandle(this.schemaName, this.tableName, this.tableParameters, this.partitionColumns, this.partitions, this.compactEffectivePredicate, this.enforcedConstraint, this.bucketHandle, this.bucketFilter, analyzePartitionValues, this.predicateColumns, Optional.empty(), this.suitableToPush);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonIgnore
    public Optional<Map<String, String>> getTableParameters() {
        return this.tableParameters;
    }

    public String getSchemaPrefixedTableName() {
        return String.format("%s.%s", this.schemaName, this.tableName);
    }

    public boolean isFilterSupported() {
        return true;
    }

    @JsonProperty
    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return this.partitions;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public Map<String, HiveColumnHandle> getPredicateColumns() {
        return this.predicateColumns;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getEnforcedConstraint() {
        return this.enforcedConstraint;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    @JsonProperty
    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }

    @JsonProperty
    public Optional<List<List<String>>> getAnalyzePartitionValues() {
        return this.analyzePartitionValues;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonProperty
    public Optional<List<TupleDomain<HiveColumnHandle>>> getDisjunctCompactEffectivePredicate() {
        return this.disjunctCompactEffectivePredicate;
    }

    @JsonProperty
    public boolean isSuitableToPush() {
        return this.suitableToPush;
    }

    public ConnectorTableHandle createFrom(ConnectorTableHandle oldConnectorTableHandle) {
        HiveTableHandle oldHiveConnectorTableHandle = (HiveTableHandle)oldConnectorTableHandle;
        return new HiveTableHandle(oldHiveConnectorTableHandle.getSchemaName(), oldHiveConnectorTableHandle.getTableName(), oldHiveConnectorTableHandle.getTableParameters(), oldHiveConnectorTableHandle.getPartitionColumns(), oldHiveConnectorTableHandle.getPartitions(), oldHiveConnectorTableHandle.getCompactEffectivePredicate(), oldHiveConnectorTableHandle.getEnforcedConstraint(), oldHiveConnectorTableHandle.getBucketHandle(), oldHiveConnectorTableHandle.getBucketFilter(), oldHiveConnectorTableHandle.getAnalyzePartitionValues(), oldHiveConnectorTableHandle.getPredicateColumns(), oldHiveConnectorTableHandle.getDisjunctCompactEffectivePredicate(), oldHiveConnectorTableHandle.isSuitableToPush());
    }

    public boolean hasDisjunctFiltersPushdown() {
        return this.disjunctCompactEffectivePredicate.isPresent() && this.disjunctCompactEffectivePredicate.get().size() > 0;
    }

    private String formatPredicate(Function<Domain, String> printer, TupleDomain<HiveColumnHandle> predicate) {
        return ((Map)predicate.getDomains().get()).entrySet().stream().map(filter -> ((HiveColumnHandle)filter.getKey()).getColumnName() + " <- " + (String)printer.apply((Domain)filter.getValue())).collect(Collectors.joining(" AND ", "{", "}"));
    }

    public String getDisjunctFilterConditions(Function<Domain, String> printer) {
        if (this.disjunctCompactEffectivePredicate.isPresent()) {
            return this.disjunctCompactEffectivePredicate.get().stream().map(predicate -> "[ " + this.formatPredicate(printer, (TupleDomain<HiveColumnHandle>)predicate) + " ]").collect(Collectors.joining(" OR "));
        }
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableParameters, that.tableParameters) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.partitions, that.partitions) && Objects.equals(this.compactEffectivePredicate, that.compactEffectivePredicate) && Objects.equals(this.enforcedConstraint, that.enforcedConstraint) && Objects.equals(this.bucketHandle, that.bucketHandle) && Objects.equals(this.bucketFilter, that.bucketFilter) && Objects.equals(this.analyzePartitionValues, that.analyzePartitionValues) && Objects.equals(this.predicateColumns, that.predicateColumns) && Objects.equals(this.disjunctCompactEffectivePredicate, that.disjunctCompactEffectivePredicate) && this.suitableToPush == that.suitableToPush;
    }

    public boolean basicEquals(ConnectorTableHandle o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableHandle that = (HiveTableHandle)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.tableParameters, that.tableParameters) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.bucketHandle, that.bucketHandle);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.schemaName).append(":").append(this.tableName);
        this.bucketHandle.ifPresent(bucket -> builder.append(" bucket=").append(bucket.getReadBucketCount()));
        return builder.toString();
    }

    public boolean isDeleteAsInsertSupported() {
        return AcidUtils.isTransactionalTable(this.getTableParameters().get()) && !AcidUtils.isInsertOnlyTable(this.getTableParameters().get());
    }

    public boolean isUpdateAsInsertSupported() {
        return true;
    }

    public boolean isSuitableForPushdown() {
        return this.suitableToPush;
    }

    public boolean isTableCacheable() {
        return HiveStorageFormat.ORC.getOutputFormat().equals(this.tableParameters.get().get("storage_format"));
    }

    public boolean isHeuristicIndexSupported() {
        return Stream.of(HiveStorageFormat.ORC).anyMatch(storageFormat -> storageFormat.getOutputFormat().equals(this.tableParameters.get().get("storage_format")));
    }

    public boolean isPartitionColumn(String column) {
        return this.partitionColumns.stream().map(HiveColumnHandle::getColumnName).collect(Collectors.toSet()).contains(column);
    }

    public boolean isReuseTableScanSupported() {
        return true;
    }

    public boolean isTablePropertiesCacheSupported() {
        return true;
    }

    public boolean isSortBasedAggregationSupported() {
        return true;
    }
}

