/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveBucketing;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class HiveTableProperties {
    @Deprecated
    public static final String EXTERNAL_LOCATION_PROPERTY = "external_location";
    public static final String LOCATION_PROPERTY = "location";
    public static final String IS_EXTERNAL_TABLE = "external";
    public static final String STORAGE_FORMAT_PROPERTY = "format";
    public static final String PARTITIONED_BY_PROPERTY = "partitioned_by";
    public static final String BUCKETED_BY_PROPERTY = "bucketed_by";
    public static final String BUCKETING_VERSION = "bucketing_version";
    public static final String BUCKET_COUNT_PROPERTY = "bucket_count";
    public static final String SORTED_BY_PROPERTY = "sorted_by";
    public static final String ORC_BLOOM_FILTER_COLUMNS = "orc_bloom_filter_columns";
    public static final String ORC_BLOOM_FILTER_FPP = "orc_bloom_filter_fpp";
    public static final String AVRO_SCHEMA_URL = "avro_schema_url";
    public static final String TEXTFILE_SKIP_HEADER_LINE_COUNT = "textfile_skip_header_line_count";
    public static final String TEXTFILE_SKIP_FOOTER_LINE_COUNT = "textfile_skip_footer_line_count";
    public static final String CSV_SEPARATOR = "csv_separator";
    public static final String CSV_QUOTE = "csv_quote";
    public static final String CSV_ESCAPE = "csv_escape";
    public static final String TRANSACTIONAL = "transactional";
    public static final Set<String> NON_INHERITABLE_PROPERTIES = ImmutableSet.of((Object)"external_location", (Object)"external", (Object)"location");
    private final List<PropertyMetadata<?>> tableProperties;

    @Inject
    public HiveTableProperties(TypeManager typeManager, HiveConfig config) {
        this.tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)EXTERNAL_LOCATION_PROPERTY, (String)String.format("Deprecated, use '%s' and '%s' table properties instead", LOCATION_PROPERTY, IS_EXTERNAL_TABLE), null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)LOCATION_PROPERTY, (String)"File system location URI for the table", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)IS_EXTERNAL_TABLE, (String)"Is the table external Hive table", (Boolean)false, (boolean)false), (Object)PropertyMetadata.enumProperty((String)STORAGE_FORMAT_PROPERTY, (String)"Hive storage format for the table", HiveStorageFormat.class, (Enum)config.getHiveStorageFormat(), (boolean)false), (Object)new PropertyMetadata(PARTITIONED_BY_PROPERTY, "Partition columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(BUCKETED_BY_PROPERTY, "Bucketing columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> ImmutableList.copyOf((Collection)((Collection)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(Collectors.toList())), value -> value), (Object)new PropertyMetadata(SORTED_BY_PROPERTY, "Bucket sorting columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).map(HiveTableProperties::sortingColumnFromString).collect(ImmutableList.toImmutableList()), value -> (ImmutableList)value.stream().map(SortingColumn.class::cast).map(HiveTableProperties::sortingColumnToString).collect(ImmutableList.toImmutableList())), (Object)new PropertyMetadata(ORC_BLOOM_FILTER_COLUMNS, "ORC Bloom filter index columns", typeManager.getType(TypeSignature.parseTypeSignature((String)"array(varchar)")), List.class, (Object)ImmutableList.of(), false, value -> (ImmutableList)((Collection)value).stream().map(String.class::cast).map(name -> name.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.doubleProperty((String)ORC_BLOOM_FILTER_FPP, (String)"ORC Bloom filter false positive probability", (Double)config.getOrcDefaultBloomFilterFpp(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKETING_VERSION, (String)"Bucketing version", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)BUCKET_COUNT_PROPERTY, (String)"Number of buckets", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)AVRO_SCHEMA_URL, (String)"URI pointing to Avro schema for the table", null, (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.integerProperty((String)TEXTFILE_SKIP_HEADER_LINE_COUNT, (String)"Number of header lines", null, (boolean)false), PropertyMetadata.integerProperty((String)TEXTFILE_SKIP_FOOTER_LINE_COUNT, (String)"Number of footer lines", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_SEPARATOR, (String)"CSV separator character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_QUOTE, (String)"CSV quote character", null, (boolean)false), PropertyMetadata.stringProperty((String)CSV_ESCAPE, (String)"CSV escape character", null, (boolean)false), PropertyMetadata.booleanProperty((String)TRANSACTIONAL, (String)"Is transactional property enabled", (Boolean)false, (boolean)false), PropertyMetadata.stringProperty((String)"field.delim", (String)String.format("Field Delimiter for the table", new Object[0]), null, (boolean)false)});
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static String getExternalLocation(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(EXTERNAL_LOCATION_PROPERTY);
    }

    public static Optional<String> getLocation(Map<String, Object> tableProperties) {
        return Optional.ofNullable((String)tableProperties.get(LOCATION_PROPERTY));
    }

    public static boolean isExternalTable(Map<String, Object> tableProperties) {
        return Boolean.TRUE.equals(tableProperties.get(IS_EXTERNAL_TABLE));
    }

    public static String getAvroSchemaUrl(Map<String, Object> tableProperties) {
        return (String)tableProperties.get(AVRO_SCHEMA_URL);
    }

    public static Optional<Integer> getTextHeaderSkipCount(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Integer)tableProperties.get(TEXTFILE_SKIP_HEADER_LINE_COUNT));
    }

    public static Optional<Integer> getTextFooterSkipCount(Map<String, Object> tableProperties) {
        return Optional.ofNullable((Integer)tableProperties.get(TEXTFILE_SKIP_FOOTER_LINE_COUNT));
    }

    public static HiveStorageFormat getHiveStorageFormat(Map<String, Object> tableProperties) {
        return (HiveStorageFormat)tableProperties.get(STORAGE_FORMAT_PROPERTY);
    }

    public static List<String> getPartitionedBy(Map<String, Object> tableProperties) {
        List partitionedBy = (List)tableProperties.get(PARTITIONED_BY_PROPERTY);
        return partitionedBy == null ? ImmutableList.of() : ImmutableList.copyOf((Collection)partitionedBy);
    }

    public static Optional<HiveBucketProperty> getBucketProperty(Map<String, Object> tableProperties) {
        List<String> bucketedBy = HiveTableProperties.getBucketedBy(tableProperties);
        List<SortingColumn> sortedBy = HiveTableProperties.getSortedBy(tableProperties);
        int bucketCount = (Integer)tableProperties.get(BUCKET_COUNT_PROPERTY);
        if (bucketedBy.isEmpty() && bucketCount == 0) {
            if (!sortedBy.isEmpty()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s may be specified only when %s is specified", SORTED_BY_PROPERTY, BUCKETED_BY_PROPERTY));
            }
            return Optional.empty();
        }
        if (bucketCount < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be greater than zero", BUCKET_COUNT_PROPERTY));
        }
        if (bucketedBy.isEmpty() || bucketCount == 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s and %s must be specified together", BUCKETED_BY_PROPERTY, BUCKET_COUNT_PROPERTY));
        }
        HiveBucketing.BucketingVersion bucketingVersion = HiveTableProperties.getBucketingVersion(tableProperties);
        return Optional.of(new HiveBucketProperty(bucketedBy, bucketingVersion, bucketCount, sortedBy));
    }

    public static HiveBucketing.BucketingVersion getBucketingVersion(Map<String, Object> tableProperties) {
        Integer property = (Integer)tableProperties.get(BUCKETING_VERSION);
        if (property == null || property == 1) {
            return HiveBucketing.BucketingVersion.BUCKETING_V1;
        }
        if (property == 2) {
            return HiveBucketing.BucketingVersion.BUCKETING_V2;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be between 1 and 2 (inclusive): %s", BUCKETING_VERSION, property));
    }

    private static List<String> getBucketedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(BUCKETED_BY_PROPERTY);
    }

    private static List<SortingColumn> getSortedBy(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(SORTED_BY_PROPERTY);
    }

    public static List<String> getOrcBloomFilterColumns(Map<String, Object> tableProperties) {
        return (List)tableProperties.get(ORC_BLOOM_FILTER_COLUMNS);
    }

    public static Double getOrcBloomFilterFpp(Map<String, Object> tableProperties) {
        return (Double)tableProperties.get(ORC_BLOOM_FILTER_FPP);
    }

    public static Optional<Character> getCsvProperty(Map<String, Object> tableProperties, String key) {
        Object value = tableProperties.get(key);
        if (value == null) {
            return Optional.empty();
        }
        String csvValue = (String)value;
        if (csvValue.length() != 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("%s must be a single character string, but was: '%s'", key, csvValue));
        }
        return Optional.of(Character.valueOf(csvValue.charAt(0)));
    }

    private static SortingColumn sortingColumnFromString(String inputName) {
        String name = inputName;
        SortingColumn.Order order = SortingColumn.Order.ASCENDING;
        String lower = name.toUpperCase(Locale.ENGLISH);
        if (lower.endsWith(" ASC")) {
            name = name.substring(0, name.length() - 4).trim();
        } else if (lower.endsWith(" DESC")) {
            name = name.substring(0, name.length() - 5).trim();
            order = SortingColumn.Order.DESCENDING;
        }
        return new SortingColumn(name, order);
    }

    private static String sortingColumnToString(SortingColumn column) {
        return column.getColumnName() + (column.getOrder() == SortingColumn.Order.DESCENDING ? " DESC" : "");
    }

    public static boolean getTransactionalValue(Map<String, Object> tableProperties) {
        return Boolean.TRUE.equals(tableProperties.get(TRANSACTIONAL));
    }
}

