/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartitionHandle;
import io.prestosql.plugin.hive.HiveSplit;
import io.prestosql.plugin.hive.HiveSplitSource;
import io.prestosql.plugin.hive.HiveSplitWrapper;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveVacuumTableHandle;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.ConnectorSplitSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class HiveVacuumSplitSource
implements ConnectorSplitSource {
    private HiveSplitSource splitSource;
    private Map<String, Map<Integer, Map<Boolean, List<HiveSplit>>>> splitsMap = new HashMap<String, Map<Integer, Map<Boolean, List<HiveSplit>>>>();
    private HiveVacuumTableHandle vacuumTableHandle;
    private HdfsEnvironment hdfsEnvironment;
    private HdfsEnvironment.HdfsContext hdfsContext;

    public HiveVacuumSplitSource(HiveSplitSource splitSource, HiveVacuumTableHandle vacuumTableHandle, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext, ConnectorSession session) {
        this.splitSource = splitSource;
        this.vacuumTableHandle = vacuumTableHandle;
        this.hdfsContext = hdfsContext;
        this.hdfsEnvironment = hdfsEnvironment;
    }

    private int getBucketNumber(HiveSplit hiveSplit) {
        if (hiveSplit.getBucketNumber().isPresent()) {
            return hiveSplit.getBucketNumber().getAsInt();
        }
        Path bucketFile = new Path(hiveSplit.getFilePath());
        OptionalInt bucketNumber = HiveUtil.getBucketNumber(bucketFile.getName());
        return bucketNumber.orElse(0);
    }

    private boolean isDeleteDelta(HiveSplit hiveSplit) {
        Path bucketFile = new Path(hiveSplit.getPath());
        return AcidUtils.isDeleteDelta((Path)bucketFile.getParent());
    }

    private List<HiveSplit> getHiveSplitsFor(int bucketNumber, String inputPartition, boolean isDeleteDelta) {
        Map<Integer, Map<Boolean, List<HiveSplit>>> bucketToSplits;
        String partition = inputPartition;
        if (partition == null) {
            partition = "default";
        }
        if ((bucketToSplits = this.splitsMap.get(partition)) == null) {
            bucketToSplits = new HashMap<Integer, Map<Boolean, List<HiveSplit>>>();
            this.splitsMap.put(partition, bucketToSplits);
        }
        Map<Boolean, List<HiveSplit>> partitionMap = this.getDeltaTypeToSplitsMap(bucketNumber, bucketToSplits);
        return this.getSplitsFromPartition(isDeleteDelta, partitionMap);
    }

    private Map<Boolean, List<HiveSplit>> getDeltaTypeToSplitsMap(int bucketNumber, Map<Integer, Map<Boolean, List<HiveSplit>>> bucketsToSplits) {
        Map<Boolean, List<HiveSplit>> deltaTypeToSplits = bucketsToSplits.get(bucketNumber);
        if (deltaTypeToSplits == null) {
            deltaTypeToSplits = new HashMap<Boolean, List<HiveSplit>>();
            bucketsToSplits.put(bucketNumber, deltaTypeToSplits);
        }
        return deltaTypeToSplits;
    }

    private List<HiveSplit> getSplitsFromPartition(boolean isDeleteDelta, Map<Boolean, List<HiveSplit>> partitionMap) {
        List<HiveSplit> hiveSplits = partitionMap.get(isDeleteDelta);
        if (hiveSplits == null) {
            hiveSplits = new ArrayList<HiveSplit>();
            partitionMap.put(isDeleteDelta, hiveSplits);
        }
        return hiveSplits;
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, int maxSize) {
        while (true) {
            CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> nextBatch = this.splitSource.getNextBatch(partitionHandle, maxSize);
            try {
                ConnectorSplitSource.ConnectorSplitBatch splitBatch = nextBatch.get();
                List splits = splitBatch.getSplits();
                for (ConnectorSplit split : splits) {
                    HiveSplit hiveSplit = ((HiveSplitWrapper)split).getSplits().get(0);
                    int bucketNumber = this.vacuumTableHandle.isUnifyVacuum() ? 0 : this.getBucketNumber(hiveSplit);
                    boolean isDeleteDelta = this.isDeleteDelta(hiveSplit);
                    List<HiveSplit> hiveSplits = this.getHiveSplitsFor(bucketNumber, hiveSplit.getPartitionName(), isDeleteDelta);
                    hiveSplits.add(hiveSplit);
                }
                if (!splitBatch.isNoMoreSplits()) continue;
            }
            catch (InterruptedException e) {
                HiveSplitSource.propagatePrestoException(e);
                continue;
            }
            catch (ExecutionException e) {
                HiveSplitSource.propagatePrestoException(e.getCause());
                continue;
            }
            break;
        }
        ConnectorSplitSource.ConnectorSplitBatch splitBatch = this.getCurrentBatch(partitionHandle);
        return CompletableFuture.completedFuture(splitBatch);
    }

    private ConnectorSplitSource.ConnectorSplitBatch getCurrentBatch(ConnectorPartitionHandle partitionHandle) {
        List<HiveSplit> bucketedSplits = null;
        int bucketNumber = 0;
        int bucketToChoose = partitionHandle instanceof HivePartitionHandle ? ((HivePartitionHandle)partitionHandle).getBucket() : -1;
        Iterator<Map.Entry<String, Map<Integer, Map<Boolean, List<HiveSplit>>>>> localPartitions = this.splitsMap.entrySet().iterator();
        while (localPartitions.hasNext()) {
            HiveVacuumTableHandle.Range suitableRange;
            HiveSplit split;
            Path bucketFile;
            HiveVacuumTableHandle.Range range;
            Map.Entry<String, Map<Integer, Map<Boolean, List<HiveSplit>>>> currentPartitionEntry = localPartitions.next();
            String currentPartition = currentPartitionEntry.getKey();
            if (this.vacuumTableHandle.isUnifyVacuum() && currentPartition.contains("__HIVE_DEFAULT_PARTITION__")) {
                localPartitions.remove();
                continue;
            }
            Map<Integer, Map<Boolean, List<HiveSplit>>> buckets = currentPartitionEntry.getValue();
            Map<Boolean, List<HiveSplit>> deltaTypeToSplits = null;
            if (bucketToChoose != -1) {
                deltaTypeToSplits = buckets.get(bucketToChoose);
                bucketNumber = bucketToChoose;
            } else {
                Iterator<Map.Entry<Integer, Map<Boolean, List<HiveSplit>>>> deltaTypeIterator = buckets.entrySet().iterator();
                if (deltaTypeIterator.hasNext()) {
                    Map.Entry<Integer, Map<Boolean, List<HiveSplit>>> entry = deltaTypeIterator.next();
                    deltaTypeToSplits = entry.getValue();
                    bucketNumber = entry.getKey();
                }
            }
            if (deltaTypeToSplits == null) {
                if (buckets.size() != 0) continue;
                localPartitions.remove();
                continue;
            }
            Iterator<Map.Entry<Boolean, List<HiveSplit>>> splitsIterator = deltaTypeToSplits.entrySet().iterator();
            if (splitsIterator.hasNext()) {
                Map.Entry<Boolean, List<HiveSplit>> entry = splitsIterator.next();
                bucketedSplits = entry.getValue();
                splitsIterator.remove();
            }
            if (!splitsIterator.hasNext()) {
                buckets.remove(bucketNumber);
                if (buckets.size() == 0) {
                    localPartitions.remove();
                }
            }
            if (bucketedSplits == null || bucketedSplits.isEmpty() || bucketedSplits == null) continue;
            if (bucketedSplits.size() != 1 || !(range = this.getRange(bucketFile = new Path((split = bucketedSplits.get(0)).getPath()))).equals(suitableRange = (HiveVacuumTableHandle.Range)Iterables.getOnlyElement(this.vacuumTableHandle.getSuitableRange(currentPartition, range)))) break;
            bucketedSplits = null;
        }
        if (bucketedSplits != null && !bucketedSplits.isEmpty()) {
            HiveSplitWrapper multiSplit = new HiveSplitWrapper(bucketedSplits, OptionalInt.of(bucketNumber));
            return new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of((Object)multiSplit), false);
        }
        return new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), true);
    }

    private HiveVacuumTableHandle.Range getRange(Path bucketFile) {
        HiveVacuumTableHandle.Range range;
        try {
            Configuration configuration = this.hdfsEnvironment.getConfiguration(this.hdfsContext, bucketFile);
            AcidOutputFormat.Options options = this.hdfsEnvironment.doAs(this.hdfsContext.getIdentity().getUser(), () -> AcidUtils.parseBaseOrDeltaBucketFilename((Path)bucketFile, (Configuration)configuration));
            range = new HiveVacuumTableHandle.Range(options.getMinimumWriteId(), options.getMaximumWriteId());
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Error while parsing split info for vacuum", (Throwable)e);
        }
        return range;
    }

    public void close() {
        this.splitSource.close();
    }

    public boolean isFinished() {
        return this.splitSource.isFinished();
    }
}

