/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.hive.HiveBucketProperty;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveWritableTableHandle;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadata;
import io.prestosql.spi.connector.ConnectorVacuumTableHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class HiveVacuumTableHandle
extends HiveWritableTableHandle
implements ConnectorVacuumTableHandle {
    private boolean full;
    private boolean unify;
    Map<String, List<Range>> ranges;

    @JsonCreator
    public HiveVacuumTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="inputColumns") List<HiveColumnHandle> inputColumns, @JsonProperty(value="pageSinkMetadata") HivePageSinkMetadata pageSinkMetadata, @JsonProperty(value="locationHandle") LocationHandle locationHandle, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="tableStorageFormat") HiveStorageFormat tableStorageFormat, @JsonProperty(value="partitionStorageFormat") HiveStorageFormat partitionStorageFormat, @JsonProperty(value="full") boolean full, @JsonProperty(value="unify") boolean unify, @JsonProperty(value="ranges") Map<String, List<Range>> ranges) {
        super(schemaName, tableName, inputColumns, pageSinkMetadata, locationHandle, bucketProperty, tableStorageFormat, partitionStorageFormat, false, false);
        this.full = full;
        this.unify = unify;
        this.ranges = ranges;
    }

    synchronized void addRange(String partitionName, Range range) {
        List<Range> partitionRanges;
        Objects.requireNonNull(partitionName, "Partition name is null");
        if (this.ranges == null) {
            this.ranges = new HashMap<String, List<Range>>();
        }
        if ((partitionRanges = this.ranges.get(partitionName)) == null) {
            partitionRanges = new ArrayList<Range>();
            this.ranges.put(partitionName, partitionRanges);
        }
        HiveVacuumTableHandle.addRange(range, partitionRanges);
    }

    static void addRange(Range range, List<Range> ranges) {
        List<Range> suitableRange = HiveVacuumTableHandle.getSuitableRange(range, ranges);
        if (!suitableRange.isEmpty()) {
            return;
        }
        List expandableEntries = ranges.stream().filter(r -> range.getMin() >= r.getMin() && range.getMax() > r.getMax() && range.getMin() <= r.getMax() || range.getMax() <= r.getMax() && range.getMin() < r.getMin() && range.getMax() >= r.getMin()).collect(Collectors.toList());
        if (expandableEntries.isEmpty()) {
            ranges.add(range);
        } else {
            long min = range.getMin();
            long max = range.getMax();
            for (Range expandableRange : expandableEntries) {
                min = Math.min(expandableRange.getMin(), min);
                max = Math.max(expandableRange.getMax(), max);
                ranges.remove(expandableRange);
            }
            Range expandedRange = new Range(min, max);
            ranges.add(expandedRange);
        }
        Collections.sort(ranges);
        long current = 0L;
        Iterator<Range> it = ranges.iterator();
        while (it.hasNext()) {
            Range next = it.next();
            if (next.getMax() > current) {
                current = next.getMax();
                continue;
            }
            it.remove();
        }
    }

    List<Range> getSuitableRange(String partitionName, Range range) {
        List<Range> partitionRanges = this.ranges.get(partitionName);
        if (partitionRanges == null || partitionRanges.isEmpty()) {
            return partitionRanges;
        }
        return HiveVacuumTableHandle.getSuitableRange(range, partitionRanges);
    }

    static List<Range> getSuitableRange(Range range, List<Range> ranges) {
        return ranges.stream().filter(r -> range.getMin() >= r.getMin() && range.getMax() <= r.getMax()).collect(Collectors.toList());
    }

    @JsonProperty(value="full")
    public boolean isFullVacuum() {
        return this.full;
    }

    @JsonProperty(value="unify")
    public boolean isUnifyVacuum() {
        return this.unify;
    }

    @JsonProperty(value="ranges")
    public synchronized Map<String, List<Range>> getRanges() {
        return this.ranges;
    }

    public static class Range
    implements Comparable {
        private final long min;
        private final long max;

        @JsonCreator
        public Range(@JsonProperty(value="min") long min, @JsonProperty(value="max") long max) {
            this.min = min;
            this.max = max;
        }

        @JsonProperty(value="min")
        public long getMin() {
            return this.min;
        }

        @JsonProperty(value="max")
        public long getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.min == range.min && this.max == range.max;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max);
        }

        public int compareTo(Object o) {
            Range other = (Range)o;
            return this.min < other.getMin() ? -1 : (this.min > other.getMin() ? 1 : (this.max > other.getMax() ? -1 : 1));
        }

        public String toString() {
            return "Range{min=" + this.min + ", max=" + this.max + '}';
        }
    }
}

