/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.spi.Page;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class HiveWriter {
    private final HiveFileWriter fileWriter;
    private final Optional<String> partitionName;
    private final PartitionUpdate.UpdateMode updateMode;
    private final String fileName;
    private final String writePath;
    private final String targetPath;
    private final String filePath;
    private final Consumer<HiveWriter> onCommit;
    private final HiveWriterStats hiveWriterStats;
    private List<String> extraPartitionFiles;
    private List<String> miscData;
    private long rowCount;
    private long inputSizeInBytes;

    public HiveWriter(HiveFileWriter fileWriter, Optional<String> partitionName, PartitionUpdate.UpdateMode updateMode, String fileName, String writePath, String targetPath, String filePath, Consumer<HiveWriter> onCommit, HiveWriterStats hiveWriterStats, List<String> extraPartitionFiles) {
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
        this.fileName = Objects.requireNonNull(fileName, "fileName is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.filePath = Objects.requireNonNull(filePath, "filePath is null");
        this.onCommit = Objects.requireNonNull(onCommit, "onCommit is null");
        this.hiveWriterStats = hiveWriterStats;
        this.extraPartitionFiles = extraPartitionFiles != null ? ImmutableList.copyOf(extraPartitionFiles) : Collections.emptyList();
        this.miscData = Collections.emptyList();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getSystemMemoryUsage() {
        return this.fileWriter.getSystemMemoryUsage();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void append(Page dataPage) {
        if (this.hiveWriterStats != null) {
            this.hiveWriterStats.addInputPageSizesInBytes(dataPage.getRetainedSizeInBytes());
        }
        this.fileWriter.appendRows(dataPage);
        this.rowCount += (long)dataPage.getPositionCount();
        this.inputSizeInBytes += dataPage.getSizeInBytes();
    }

    public void commit() {
        this.fileWriter.commit();
        HashSet<String> set = new HashSet<String>(this.extraPartitionFiles);
        set.addAll((Collection<String>)this.fileWriter.getExtraPartitionFiles());
        this.extraPartitionFiles = ImmutableList.copyOf(set);
        this.miscData = this.fileWriter.getMiscData();
        this.onCommit.accept(this);
    }

    long getValidationCpuNanos() {
        return this.fileWriter.getValidationCpuNanos();
    }

    public Optional<Runnable> getVerificationTask() {
        return this.fileWriter.getVerificationTask();
    }

    public void rollback(boolean isCancel) {
        if (isCancel) {
            this.fileWriter.cancel();
        } else {
            this.fileWriter.rollback();
        }
    }

    public PartitionUpdate getPartitionUpdate() {
        return new PartitionUpdate(this.partitionName.orElse(""), this.updateMode, this.writePath, this.targetPath, (List<String>)ImmutableList.builder().addAll(this.extraPartitionFiles).add((Object)this.fileName).build(), this.rowCount, this.inputSizeInBytes, this.fileWriter.getWrittenBytes(), this.miscData);
    }

    @VisibleForTesting
    public HiveFileWriter getFileWriter() {
        return this.fileWriter;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("filePath", (Object)(this.writePath + "/" + this.fileName)).toString();
    }
}

