/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.event.client.EventClient;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcDataSourceId;
import io.prestosql.plugin.hive.FileFormatDataSourceStats;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.HiveFileWriterFactory;
import io.prestosql.plugin.hive.HiveSessionProperties;
import io.prestosql.plugin.hive.HiveStorageFormat;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveTypeName;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.HiveWriteUtils;
import io.prestosql.plugin.hive.HiveWriter;
import io.prestosql.plugin.hive.HiveWriterStats;
import io.prestosql.plugin.hive.LocationHandle;
import io.prestosql.plugin.hive.LocationService;
import io.prestosql.plugin.hive.OrcFileWriter;
import io.prestosql.plugin.hive.OrcFileWriterFactory;
import io.prestosql.plugin.hive.PartitionUpdate;
import io.prestosql.plugin.hive.RecordFileWriter;
import io.prestosql.plugin.hive.SnapshotTempFileWriter;
import io.prestosql.plugin.hive.SortingFileWriter;
import io.prestosql.plugin.hive.WriteCompletedEvent;
import io.prestosql.plugin.hive.WriteIdInfo;
import io.prestosql.plugin.hive.metastore.Column;
import io.prestosql.plugin.hive.metastore.HivePageSinkMetadataProvider;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.SortingColumn;
import io.prestosql.plugin.hive.metastore.StorageFormat;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.orc.HdfsOrcDataSource;
import io.prestosql.plugin.hive.util.ConfigurationUtils;
import io.prestosql.plugin.hive.util.TempFileReader;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageSorter;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.session.PropertyMetadata;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.common.util.ReflectionUtil;
import org.joda.time.DateTimeZone;

public class HiveWriterFactory {
    private static Logger log = Logger.get(HiveWriterFactory.class);
    private static final int MAX_BUCKET_COUNT = 100000;
    private static final int BUCKET_NUMBER_PADDING = Integer.toString(99999).length();
    private static final Pattern BUCKET_FROM_FILENAME_PATTERN = Pattern.compile("(0[0-9]+)_.*");
    private final Set<HiveFileWriterFactory> fileWriterFactories;
    private final String schemaName;
    private final String tableName;
    private final List<DataColumn> dataColumns;
    private final List<String> partitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final HiveStorageFormat tableStorageFormat;
    private final HiveStorageFormat partitionStorageFormat;
    private final Map<String, String> additionalTableParameters;
    protected final LocationHandle locationHandle;
    protected final LocationService locationService;
    private final String queryId;
    private final HivePageSinkMetadataProvider pageSinkMetadataProvider;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final PageSorter pageSorter;
    private final JobConf conf;
    private final Table table;
    private final DataSize sortBufferSize;
    private final int maxOpenSortFiles;
    private final boolean immutablePartitions;
    private final HiveSessionProperties.InsertExistingPartitionsBehavior insertExistingPartitionsBehavior;
    private final DateTimeZone parquetTimeZone;
    private final ConnectorSession session;
    private final OptionalInt bucketCount;
    private final List<SortingColumn> sortedBy;
    private final NodeManager nodeManager;
    private final EventClient eventClient;
    private final Map<String, String> sessionProperties;
    private final HiveWriterStats hiveWriterStats;
    private final HiveACIDWriteType acidWriteType;
    private final OrcFileWriterFactory orcFileWriterFactory;
    private boolean isSnapshotEnabled;
    private final List<Long> snapshotSuffixes = new ArrayList<Long>();
    private long resumeCount;

    public HiveWriterFactory(Set<HiveFileWriterFactory> fileWriterFactories, String schemaName, String tableName, boolean isCreateTable, HiveACIDWriteType acidWriteType, List<HiveColumnHandle> inputColumns, HiveStorageFormat tableStorageFormat, HiveStorageFormat partitionStorageFormat, Map<String, String> additionalTableParameters, OptionalInt bucketCount, List<SortingColumn> sortedBy, LocationHandle locationHandle, LocationService locationService, String queryId, HivePageSinkMetadataProvider pageSinkMetadataProvider, TypeManager typeManager, HdfsEnvironment hdfsEnvironment, PageSorter pageSorter, DataSize sortBufferSize, int maxOpenSortFiles, boolean immutablePartitions, DateTimeZone parquetTimeZone, ConnectorSession session, NodeManager nodeManager, EventClient eventClient, HiveSessionProperties hiveSessionProperties, HiveWriterStats hiveWriterStats, OrcFileWriterFactory orcFileWriterFactory) {
        Path writePath;
        this.fileWriterFactories = ImmutableSet.copyOf((Collection)Objects.requireNonNull(fileWriterFactories, "fileWriterFactories is null"));
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableStorageFormat = Objects.requireNonNull(tableStorageFormat, "tableStorageFormat is null");
        this.partitionStorageFormat = Objects.requireNonNull(partitionStorageFormat, "partitionStorageFormat is null");
        this.additionalTableParameters = ImmutableMap.copyOf(Objects.requireNonNull(additionalTableParameters, "additionalTableParameters is null"));
        this.locationHandle = Objects.requireNonNull(locationHandle, "locationHandle is null");
        this.locationService = Objects.requireNonNull(locationService, "locationService is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.pageSinkMetadataProvider = Objects.requireNonNull(pageSinkMetadataProvider, "pageSinkMetadataProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.sortBufferSize = Objects.requireNonNull(sortBufferSize, "sortBufferSize is null");
        this.maxOpenSortFiles = maxOpenSortFiles;
        this.immutablePartitions = immutablePartitions;
        this.insertExistingPartitionsBehavior = acidWriteType == HiveACIDWriteType.INSERT_OVERWRITE ? (pageSinkMetadataProvider.getTable().isPresent() && AcidUtils.isTransactionalTable(pageSinkMetadataProvider.getTable().get().getParameters()) ? HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND : HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE) : (acidWriteType == HiveACIDWriteType.UPDATE ? HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND : HiveSessionProperties.getInsertExistingPartitionsBehavior(session));
        if (immutablePartitions) {
            Preconditions.checkArgument((this.insertExistingPartitionsBehavior != HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND ? 1 : 0) != 0, (Object)"insertExistingPartitionsBehavior cannot be APPEND");
        }
        this.parquetTimeZone = Objects.requireNonNull(parquetTimeZone, "parquetTimeZone is null");
        this.acidWriteType = acidWriteType;
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        ImmutableList.Builder localPartitionColumnNames = ImmutableList.builder();
        ImmutableList.Builder localPartitionColumnTypes = ImmutableList.builder();
        ImmutableList.Builder localDataColumns = ImmutableList.builder();
        for (HiveColumnHandle column : inputColumns) {
            HiveType hiveType = column.getHiveType();
            if (column.isPartitionKey()) {
                localPartitionColumnNames.add((Object)column.getName());
                localPartitionColumnTypes.add((Object)typeManager.getType(column.getTypeSignature()));
                continue;
            }
            localDataColumns.add((Object)new DataColumn(column.getName(), hiveType));
        }
        this.partitionColumnNames = localPartitionColumnNames.build();
        this.partitionColumnTypes = localPartitionColumnTypes.build();
        this.dataColumns = localDataColumns.build();
        if (isCreateTable) {
            this.table = null;
            LocationService.WriteInfo writeInfo = locationService.getQueryWriteInfo(locationHandle);
            Preconditions.checkArgument((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"CREATE TABLE write mode cannot be DIRECT_TO_TARGET_EXISTING_DIRECTORY");
            writePath = writeInfo.getWritePath();
        } else {
            Optional<Table> localTable = pageSinkMetadataProvider.getTable();
            if (!localTable.isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table %s.%s was dropped during insert", schemaName, tableName));
            }
            this.table = localTable.get();
            writePath = locationService.getQueryWriteInfo(locationHandle).getWritePath();
        }
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        if (bucketCount.isPresent()) {
            Preconditions.checkArgument((bucketCount.getAsInt() < 100000 ? 1 : 0) != 0, (Object)"bucketCount must be smaller than 100000");
        }
        this.sortedBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortedBy, "sortedBy is null"));
        this.session = Objects.requireNonNull(session, "session is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.eventClient = Objects.requireNonNull(eventClient, "eventClient is null");
        Objects.requireNonNull(hiveSessionProperties, "hiveSessionProperties is null");
        this.sessionProperties = (Map)hiveSessionProperties.getSessionProperties().stream().collect(ImmutableMap.toImmutableMap(PropertyMetadata::getName, entry -> session.getProperty(entry.getName(), entry.getJavaType()).toString()));
        Configuration localConf = hdfsEnvironment.getConfiguration(new HdfsEnvironment.HdfsContext(session, schemaName, tableName), writePath);
        this.conf = ConfigurationUtils.toJobConf(localConf);
        try {
            hdfsEnvironment.getFileSystem(session.getUser(), writePath, localConf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + writePath, (Throwable)e);
        }
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
        this.orcFileWriterFactory = Objects.requireNonNull(orcFileWriterFactory, "orcFileWriterFactory is null");
        this.isSnapshotEnabled = session.isSnapshotEnabled();
    }

    JobConf getConf() {
        return this.conf;
    }

    List<String> getPartitionValues(Page partitionColumns, int position) {
        return HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
    }

    Optional<String> getPartitionName(Page partitionColumns, int position) {
        List<String> partitionValues = HiveWriteUtils.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
        Optional<String> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        return partitionName;
    }

    public HiveWriter createWriter(List<String> partitionValues, OptionalInt bucketNumber, Optional<AcidOutputFormat.Options> vacuumOptions) {
        return this.createWriter(partitionValues, bucketNumber, vacuumOptions, false);
    }

    public HiveWriter createWriterForSnapshotMerge(List<String> partitionValues, OptionalInt bucketNumber, Optional<AcidOutputFormat.Options> vacuumOptions) {
        return this.createWriter(partitionValues, bucketNumber, vacuumOptions, true);
    }

    private HiveWriter createWriter(List<String> partitionValues, OptionalInt bucketNumber, Optional<AcidOutputFormat.Options> vacuumOptions, boolean forMerge) {
        FileSystem fileSystem;
        Optional<AcidOutputFormat.Options> acidOptions;
        String fileNameWithExtension;
        Path path;
        StorageFormat outputStorageFormat;
        LocationService.WriteInfo writeInfo;
        Properties schema;
        PartitionUpdate.UpdateMode updateMode;
        boolean isTxnTable = this.isTxnTable();
        if (this.bucketCount.isPresent()) {
            Preconditions.checkArgument((boolean)bucketNumber.isPresent(), (Object)"Bucket not provided for bucketed table");
            Preconditions.checkArgument((bucketNumber.getAsInt() < this.bucketCount.getAsInt() ? 1 : 0) != 0, (String)"Bucket number %s must be less than bucket count %s", (Object)bucketNumber, (Object)this.bucketCount);
        } else {
            Preconditions.checkArgument((isTxnTable || !bucketNumber.isPresent() ? 1 : 0) != 0, (Object)"Bucket number provided by for table that is not bucketed");
        }
        String fileName = bucketNumber.isPresent() ? HiveWriterFactory.computeBucketedFileName(this.queryId, bucketNumber.getAsInt()) : (this.isSnapshotEnabled ? String.format(Locale.ENGLISH, "%s_%d_%d_%d", this.queryId, this.session.getTaskId().getAsInt(), this.session.getPipelineId().getAsInt(), this.session.getDriverId().getAsInt()) : this.queryId + "_" + UUID.randomUUID());
        Optional<Object> partitionName = !this.partitionColumnNames.isEmpty() ? Optional.of(FileUtils.makePartName(this.partitionColumnNames, partitionValues)) : Optional.empty();
        Optional<Partition> partition = Optional.empty();
        if (!partitionValues.isEmpty() && this.table != null) {
            partition = this.pageSinkMetadataProvider.getPartition(partitionValues);
        }
        if (!partition.isPresent()) {
            if (this.table == null) {
                updateMode = PartitionUpdate.UpdateMode.NEW;
                schema = new Properties();
                schema.setProperty("columns", this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.joining(",")));
                schema.setProperty("columns.types", this.dataColumns.stream().map(DataColumn::getHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
                this.setAdditionalSchemaProperties(schema);
                if (!partitionName.isPresent()) {
                    writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                } else {
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                    if (!writeInfo.getWriteMode().isWritePathSameAsTargetPath() && HiveWriteUtils.pathExists(new HdfsEnvironment.HdfsContext(this.session, this.schemaName, this.tableName), this.hdfsEnvironment, writeInfo.getTargetPath())) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PATH_ALREADY_EXISTS, String.format("Target directory for new partition '%s' of table '%s.%s' already exists: %s", partitionName, this.schemaName, this.tableName, writeInfo.getTargetPath()));
                    }
                }
            } else {
                if (partitionName.isPresent()) {
                    updateMode = PartitionUpdate.UpdateMode.NEW;
                    writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
                } else {
                    switch (this.insertExistingPartitionsBehavior) {
                        case APPEND: {
                            Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
                            updateMode = PartitionUpdate.UpdateMode.APPEND;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, false);
                            break;
                        }
                        case OVERWRITE: {
                            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
                            writeInfo = this.locationService.getTableWriteInfo(this.locationHandle, true);
                            break;
                        }
                        case ERROR: {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_TABLE_READ_ONLY, "Unpartitioned Hive tables are immutable");
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported insert existing table behavior: " + (Object)((Object)this.insertExistingPartitionsBehavior));
                        }
                    }
                }
                schema = MetastoreUtil.getHiveSchema(this.table);
            }
            outputStorageFormat = partitionName.isPresent() ? StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat) : StorageFormat.fromHiveStorageFormat(this.tableStorageFormat);
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.APPEND) {
            Preconditions.checkState((!this.immutablePartitions ? 1 : 0) != 0);
            updateMode = PartitionUpdate.UpdateMode.APPEND;
            List<Column> tableColumns = this.table.getDataColumns();
            List<Column> existingPartitionColumns = partition.get().getColumns();
            for (int i = 0; i < Math.min(existingPartitionColumns.size(), tableColumns.size()); ++i) {
                HiveType partitionType;
                HiveType tableType = tableColumns.get(i).getType();
                if (tableType.equals(partitionType = existingPartitionColumns.get(i).getType())) continue;
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("You are trying to write into an existing partition in a table. The table schema has changed since the creation of the partition. Inserting rows into such partition is not supported. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumns.get(i).getName(), this.tableName, tableType, partitionName, existingPartitionColumns.get(i).getName(), partitionType));
            }
            HiveWriteUtils.checkPartitionIsWritable((String)partitionName.get(), partition.get());
            outputStorageFormat = partition.get().getStorage().getStorageFormat();
            schema = MetastoreUtil.getHiveSchema(partition.get(), this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, partition, (String)partitionName.get());
        } else if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.OVERWRITE) {
            updateMode = PartitionUpdate.UpdateMode.OVERWRITE;
            outputStorageFormat = StorageFormat.fromHiveStorageFormat(this.partitionStorageFormat);
            schema = MetastoreUtil.getHiveSchema(this.table);
            writeInfo = this.locationService.getPartitionWriteInfo(this.locationHandle, Optional.empty(), (String)partitionName.get());
            this.checkWriteMode(writeInfo);
        } else {
            if (this.insertExistingPartitionsBehavior == HiveSessionProperties.InsertExistingPartitionsBehavior.ERROR) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_READ_ONLY, "Cannot insert into an existing partition of Hive table: " + (String)partitionName.get());
            }
            throw new IllegalArgumentException(String.format("Unsupported insert existing partitions behavior: %s", new Object[]{this.insertExistingPartitionsBehavior}));
        }
        schema.putAll(this.additionalTableParameters);
        if (this.acidWriteType != HiveACIDWriteType.DELETE) {
            this.validateSchema(partitionName, schema);
        }
        if (isTxnTable) {
            WriteIdInfo writeIdInfo = this.locationHandle.getJsonSerializablewriteIdInfo().get();
            AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).minimumWriteId(writeIdInfo.getMinWriteId()).maximumWriteId(writeIdInfo.getMaxWriteId()).statementId(writeIdInfo.getStatementId()).bucket(bucketNumber.isPresent() ? bucketNumber.getAsInt() : 0);
            if (this.acidWriteType == HiveACIDWriteType.DELETE) {
                options.writingDeleteDelta(true);
            } else if (this.acidWriteType == HiveACIDWriteType.INSERT_OVERWRITE) {
                options.writingBase(true);
            }
            if (vacuumOptions.isPresent() && HiveACIDWriteType.isVacuum(this.acidWriteType)) {
                AcidOutputFormat.Options vOptions = vacuumOptions.get();
                options.maximumWriteId(vOptions.getMaximumWriteId()).minimumWriteId(vOptions.getMinimumWriteId()).writingBase(vOptions.isWritingBase()).writingDeleteDelta(vOptions.isWritingDeleteDelta()).bucket(vOptions.getBucketId()).statementId(-1);
            }
            if (AcidUtils.isInsertOnlyTable((Properties)schema)) {
                String subdir = options.isWritingBase() ? AcidUtils.baseDir((long)options.getMaximumWriteId()) : (HiveACIDWriteType.isVacuum(this.acidWriteType) ? AcidUtils.deltaSubdir((long)options.getMinimumWriteId(), (long)options.getMaximumWriteId()) : AcidUtils.deltaSubdir((long)options.getMinimumWriteId(), (long)options.getMaximumWriteId(), (int)options.getStatementId()));
                Path parentDir = new Path(writeInfo.getWritePath(), subdir);
                fileName = String.format("%06d", options.getBucketId()) + "_0" + HiveWriterFactory.getFileExtension(this.conf, outputStorageFormat);
                path = new Path(parentDir, fileName);
                Properties properties = new Properties();
                properties.setProperty("transactional_properties", "insert_only");
                options.tableProperties(properties);
            } else {
                path = AcidUtils.createFilename((Path)writeInfo.getWritePath(), (AcidOutputFormat.Options)options);
            }
            fileNameWithExtension = path.getParent().getName();
            acidOptions = Optional.of(options);
        } else {
            fileNameWithExtension = fileName + HiveWriterFactory.getFileExtension(this.conf, outputStorageFormat);
            path = new Path(writeInfo.getWritePath(), fileNameWithExtension);
            acidOptions = Optional.empty();
        }
        try {
            fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getUser(), path, (Configuration)this.conf);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, (Throwable)e);
        }
        if (this.isSnapshotEnabled) {
            String oldFileName = path.getName();
            String newFileName = HiveWriterFactory.toSnapshotFileName(oldFileName, this.queryId);
            path = new Path(path.getParent(), newFileName);
            if (fileNameWithExtension.equals(oldFileName)) {
                fileNameWithExtension = newFileName;
            }
        }
        Object hiveFileWriter = null;
        if (this.isSnapshotEnabled && !forMerge) {
            String oldFileName = path.getName();
            String newFileName = this.toSnapshotSubFile(oldFileName);
            path = new Path(path.getParent(), newFileName);
            if (fileNameWithExtension.equals(oldFileName)) {
                fileNameWithExtension = newFileName;
            }
            this.logContainingFolderInfo(fileSystem, path, "Creating SnapshotTempFileWriter for %s", path);
            try {
                Path finalPath = path;
                hiveFileWriter = new SnapshotTempFileWriter(this.orcFileWriterFactory.createOrcDataSink(this.session, fileSystem, path), this.dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager)).collect(Collectors.toList()));
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_OPEN_ERROR, "Error creating ORC file", (Throwable)e);
            }
        } else {
            this.conf.set("table.write.path", writeInfo.getWritePath().toString());
            for (HiveFileWriterFactory fileWriterFactory : this.fileWriterFactories) {
                Optional<HiveFileWriter> fileWriter = fileWriterFactory.createFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.conf, this.session, acidOptions, Optional.of(this.acidWriteType));
                if (!fileWriter.isPresent()) continue;
                hiveFileWriter = fileWriter.get();
                break;
            }
            if (this.isSnapshotEnabled) {
                Preconditions.checkState((boolean)(hiveFileWriter instanceof OrcFileWriter), (Object)"Only support ORC format with snapshot");
                this.logContainingFolderInfo(fileSystem, path, "Creating file writer for final result: %s", path);
            }
            if (hiveFileWriter == null) {
                hiveFileWriter = new RecordFileWriter(path, this.dataColumns.stream().map(DataColumn::getName).collect(Collectors.toList()), outputStorageFormat, schema, this.partitionStorageFormat.getEstimatedWriterSystemMemoryUsage(), this.conf, this.typeManager, this.parquetTimeZone, this.session);
            }
            if (isTxnTable) {
                hiveFileWriter.initWriter(true, path, fileSystem);
            }
        }
        Path finalPath = path;
        String writerImplementation = hiveFileWriter.getClass().getName();
        Consumer<HiveWriter> onCommit = this.isSnapshotEnabled && !forMerge ? hiveWriter -> {} : hiveWriter -> {
            Optional<Object> size;
            try {
                size = Optional.of(this.hdfsEnvironment.getFileSystem(this.session.getUser(), finalPath, (Configuration)this.conf).getFileStatus(finalPath).getLen());
            }
            catch (IOException | RuntimeException e) {
                size = Optional.empty();
            }
            this.eventClient.post((Object[])new WriteCompletedEvent[]{new WriteCompletedEvent(this.session.getQueryId(), finalPath.toString(), this.schemaName, this.tableName, partitionName.orElse(null), outputStorageFormat.getOutputFormat(), writerImplementation, this.nodeManager.getCurrentNode().getVersion(), this.nodeManager.getCurrentNode().getHost(), this.session.getIdentity().getPrincipal().map(Principal::getName).orElse(null), this.nodeManager.getEnvironment(), this.sessionProperties, size.orElse(null), hiveWriter.getRowCount())});
        };
        if (!this.sortedBy.isEmpty() || this.isTxnTable() && HiveACIDWriteType.isUpdateOrDelete(this.acidWriteType)) {
            List<Type> types = this.dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager)).collect(Collectors.toList());
            HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
            for (int i = 0; i < this.dataColumns.size(); ++i) {
                columnIndexes.put(this.dataColumns.get(i).getName(), i);
            }
            if (this.sortedBy.isEmpty() && this.isTxnTable() && HiveACIDWriteType.isUpdateOrDelete(this.acidWriteType)) {
                types.add(HiveColumnHandle.updateRowIdHandle().getHiveType().getType(this.typeManager));
                columnIndexes.put("$rowId", this.dataColumns.size());
            }
            ArrayList<Integer> sortFields = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            ImmutableList sortigColumns = this.sortedBy;
            if (this.sortedBy.isEmpty() && this.isTxnTable() && HiveACIDWriteType.isUpdateOrDelete(this.acidWriteType)) {
                sortigColumns = ImmutableList.of((Object)new SortingColumn("$rowId", SortingColumn.Order.ASCENDING));
            }
            for (SortingColumn column2 : sortigColumns) {
                Integer index = (Integer)columnIndexes.get(column2.getColumnName());
                if (index == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Sorting column '%s' does not exist in table '%s.%s'", column2.getColumnName(), this.schemaName, this.tableName));
                }
                sortFields.add(index);
                sortOrders.add(column2.getOrder().getSortOrder());
            }
            FileSystem sortFileSystem = fileSystem;
            String child = ".tmp-sort." + path.getName();
            Path tempFilePrefix = new Path(path.getParent(), child);
            hiveFileWriter = new SortingFileWriter(sortFileSystem, tempFilePrefix, (HiveFileWriter)hiveFileWriter, this.sortBufferSize, this.maxOpenSortFiles, types, sortFields, sortOrders, this.pageSorter, (fs, p) -> this.orcFileWriterFactory.createOrcDataSink(this.session, fs, p));
        }
        return new HiveWriter((HiveFileWriter)hiveFileWriter, (Optional<String>)partitionName, updateMode, fileNameWithExtension, writeInfo.getWritePath().toString(), writeInfo.getTargetPath().toString(), path.toString(), onCommit, (HiveWriterStats)(this.isSnapshotEnabled && !forMerge ? null : this.hiveWriterStats), (List<String>)hiveFileWriter.getExtraPartitionFiles());
    }

    public boolean isTxnTable() {
        Map<String, String> tableParameters = this.table != null ? this.table.getParameters() : this.additionalTableParameters;
        return tableParameters != null && AcidUtils.isTransactionalTable(tableParameters);
    }

    private void validateSchema(Optional<String> partitionName, Properties schema) {
        List<String> fileColumnNames = HiveUtil.getColumnNames(schema);
        List<HiveType> fileColumnHiveTypes = HiveUtil.getColumnTypes(schema);
        Map inputColumnMap = this.dataColumns.stream().collect(Collectors.toMap(DataColumn::getName, Function.identity()));
        Sets.SetView missingColumns = Sets.difference(inputColumnMap.keySet(), new HashSet<String>(fileColumnNames));
        if (!missingColumns.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Table %s.%s does not have columns %s", schema, this.tableName, missingColumns));
        }
        if (fileColumnNames.size() != fileColumnHiveTypes.size()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Partition '%s' in table '%s.%s' has mismatched metadata for column names and types", partitionName, this.schemaName, this.tableName));
        }
        for (int fileIndex = 0; fileIndex < fileColumnNames.size(); ++fileIndex) {
            HiveType inputHiveType;
            String columnName = fileColumnNames.get(fileIndex);
            HiveType fileColumnHiveType = fileColumnHiveTypes.get(fileIndex);
            if (fileColumnHiveType.equals(inputHiveType = ((DataColumn)inputColumnMap.get(columnName)).getHiveType())) continue;
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The column '%s' in table '%s.%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", columnName, this.schemaName, this.tableName, inputHiveType, partitionName, columnName, fileColumnHiveType));
        }
    }

    public static String computeBucketedFileName(String queryId, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        return String.format("0%s_0_%s", paddedBucket, queryId);
    }

    public static int getBucketFromFileName(String fileName) {
        Matcher matcher = BUCKET_FROM_FILENAME_PATTERN.matcher(fileName);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"filename %s does not match pattern %s", (Object)fileName, (Object)BUCKET_FROM_FILENAME_PATTERN);
        return Integer.parseInt(matcher.group(1));
    }

    public static String computeTransactionalBucketedFilename(int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.empty(), bucket);
    }

    public static String computeNonTransactionalBucketedFilename(String queryId, int bucket) {
        return HiveWriterFactory.computeBucketedFileName(Optional.of(UUID.randomUUID() + "_" + queryId), bucket);
    }

    private static String computeBucketedFileName(Optional<String> suffix, int bucket) {
        String paddedBucket = Strings.padStart((String)Integer.toString(bucket), (int)BUCKET_NUMBER_PADDING, (char)'0');
        if (suffix.isPresent()) {
            return String.format("0%s_0_%s", paddedBucket, suffix.get());
        }
        return String.format("0%s_0", paddedBucket);
    }

    protected void checkWriteMode(LocationService.WriteInfo writeInfo) {
        Preconditions.checkState((writeInfo.getWriteMode() != LocationHandle.WriteMode.DIRECT_TO_TARGET_EXISTING_DIRECTORY ? 1 : 0) != 0, (Object)"Overwriting existing partition doesn't support DIRECT_TO_TARGET_EXISTING_DIRECTORY write mode");
    }

    public static String getFileExtension(JobConf conf, StorageFormat storageFormat) {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.COMPRESSRESULT) || !HiveIgnoreKeyTextOutputFormat.class.getName().equals(storageFormat.getOutputFormat())) {
            return "";
        }
        String compressionCodecClass = conf.get("mapred.output.compression.codec");
        if (compressionCodecClass == null) {
            return new DefaultCodec().getDefaultExtension();
        }
        try {
            Class<CompressionCodec> codecClass = conf.getClassByName(compressionCodecClass).asSubclass(CompressionCodec.class);
            return ((CompressionCodec)ReflectionUtil.newInstance(codecClass, (Configuration)conf)).getDefaultExtension();
        }
        catch (ClassNotFoundException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Compression codec not found: " + compressionCodecClass, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Failed to load compression codec: " + compressionCodecClass, (Throwable)e);
        }
    }

    protected void setAdditionalSchemaProperties(Properties schema) {
    }

    static String toSnapshotFileName(String fileName, String queryId) {
        return fileName + "_snapshot_" + queryId;
    }

    static boolean isSnapshotFile(String fileName, String queryId) {
        String identifier = "_snapshot_" + queryId;
        return fileName.contains(identifier);
    }

    static boolean isSnapshotSubFile(String fileName, String queryId) {
        return HiveWriterFactory.getSnapshotSubFileIndex(fileName, queryId) >= 0L;
    }

    static long getSnapshotSubFileIndex(String fileName, String queryId) {
        String identifier = "_snapshot_" + queryId;
        int index = fileName.indexOf(identifier);
        if (index < 0) {
            return index;
        }
        if ((index += identifier.length()) == fileName.length()) {
            return -1L;
        }
        String suffix = fileName.substring(fileName.indexOf(95, index) + 1);
        return Long.valueOf(suffix);
    }

    static String removeSnapshotFileName(String fileName, String queryId) {
        String identifier = "_snapshot_" + queryId;
        int index = fileName.indexOf(identifier);
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    private String toSnapshotSubFile(String path) {
        return this.toSnapshotSubFile(path, this.resumeCount, this.snapshotSuffixes.size());
    }

    private String toSnapshotSubFile(String path, long resumeCount, int index) {
        return path + '.' + resumeCount + '_' + index;
    }

    public void mergeSubFiles(List<HiveWriter> writers) throws IOException {
        if (writers.isEmpty()) {
            return;
        }
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(this.session.getUser(), new Path(writers.get(0).getFilePath()), (Configuration)this.conf);
        List<Type> types = this.dataColumns.stream().map(column -> column.getHiveType().getType(this.typeManager)).collect(Collectors.toList());
        for (HiveWriter writer : writers) {
            String filePath = writer.getFilePath();
            Path path = new Path(filePath);
            this.logContainingFolderInfo(fileSystem, path, "Merging snapshot files to result file: %s", path);
            this.snapshotSuffixes.add(this.resumeCount);
            for (int i = 0; i < this.snapshotSuffixes.size(); ++i) {
                long resume = this.snapshotSuffixes.get(i);
                Path file = new Path(this.toSnapshotSubFile(filePath, resume, i));
                if (!fileSystem.exists(file)) continue;
                FileStatus fileStatus = fileSystem.getFileStatus(file);
                try (TempFileReader reader = new TempFileReader(types, (OrcDataSource)new HdfsOrcDataSource(new OrcDataSourceId(file.toString()), fileStatus.getLen(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), new DataSize(8.0, DataSize.Unit.MEGABYTE), false, fileSystem.open(file), new FileFormatDataSourceStats(), fileStatus.getModificationTime()));){
                    while (reader.hasNext()) {
                        writer.append((Page)reader.next());
                    }
                    continue;
                }
            }
        }
    }

    private void logContainingFolderInfo(FileSystem fileSystem, Path path, String message, Object ... params) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(message, params);
                Arrays.stream(fileSystem.listStatus(path.getParent())).forEach(file -> log.debug("%d\t%s", new Object[]{file.getLen(), file.getPath()}));
            }
        }
        catch (IOException e) {
            log.debug((Throwable)e, "Failed to list folder content for %s: %s", new Object[]{path, e.getMessage()});
        }
    }

    public Object capture() {
        this.snapshotSuffixes.add(this.resumeCount);
        return this.snapshotSuffixes;
    }

    public void restore(Object obj, long resumeCount) {
        this.snapshotSuffixes.clear();
        this.snapshotSuffixes.addAll((List)obj);
        this.resumeCount = resumeCount;
    }

    public static class DataColumn {
        private final String name;
        private final HiveType hiveType;

        public DataColumn(String name, HiveType hiveType) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        }

        public String getName() {
            return this.name;
        }

        public HiveType getHiveType() {
            return this.hiveType;
        }
    }
}

