/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.plugin.hive.WriteIdInfo;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class LocationHandle {
    private final Path targetPath;
    private final Path writePath;
    private final boolean isExistingTable;
    private final WriteMode writeMode;
    private final Optional<WriteIdInfo> writeIdInfo;

    public LocationHandle(Path targetPath, Path writePath, boolean isExistingTable, WriteMode writeMode, Optional<WriteIdInfo> writeIdInfo) {
        if (writeMode.isWritePathSameAsTargetPath() && !targetPath.equals((Object)writePath)) {
            throw new IllegalArgumentException(String.format("targetPath is expected to be same as writePath for writeMode %s", new Object[]{writeMode}));
        }
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.isExistingTable = isExistingTable;
        this.writeMode = Objects.requireNonNull(writeMode, "writeMode is null");
        this.writeIdInfo = writeIdInfo;
    }

    @JsonCreator
    public LocationHandle(@JsonProperty(value="targetPath") String targetPath, @JsonProperty(value="writePath") String writePath, @JsonProperty(value="isExistingTable") boolean isExistingTable, @JsonProperty(value="writeMode") WriteMode writeMode, @JsonProperty(value="writeIdInfo") Optional<WriteIdInfo> writeIdInfo) {
        this(new Path(Objects.requireNonNull(targetPath, "targetPath is null")), new Path(Objects.requireNonNull(writePath, "writePath is null")), isExistingTable, writeMode, writeIdInfo);
    }

    public Path getTargetPath() {
        return this.targetPath;
    }

    public Path getWritePath() {
        return this.writePath;
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    boolean isExistingTable() {
        return this.isExistingTable;
    }

    @JsonProperty(value="targetPath")
    public String getJsonSerializableTargetPath() {
        return this.targetPath.toString();
    }

    @JsonProperty(value="writePath")
    public String getJsonSerializableWritePath() {
        return this.writePath.toString();
    }

    @JsonProperty(value="isExistingTable")
    public boolean getJsonSerializableIsExistingTable() {
        return this.isExistingTable;
    }

    @JsonProperty(value="writeMode")
    public WriteMode getJsonSerializableWriteMode() {
        return this.writeMode;
    }

    @JsonProperty(value="writeIdInfo")
    public Optional<WriteIdInfo> getJsonSerializablewriteIdInfo() {
        return this.writeIdInfo;
    }

    public static enum WriteMode {
        STAGE_AND_MOVE_TO_TARGET_DIRECTORY(false),
        DIRECT_TO_TARGET_NEW_DIRECTORY(true),
        DIRECT_TO_TARGET_EXISTING_DIRECTORY(true);

        private final boolean writePathSameAsTargetPath;

        private WriteMode(boolean writePathSameAsTargetPath) {
            this.writePathSameAsTargetPath = writePathSameAsTargetPath;
        }

        public boolean isWritePathSameAsTargetPath() {
            return this.writePathSameAsTargetPath;
        }
    }
}

