/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.orc.OrcDataSource;
import io.prestosql.orc.OrcWriteValidation;
import io.prestosql.orc.OrcWriter;
import io.prestosql.orc.OrcWriterOptions;
import io.prestosql.orc.OrcWriterStats;
import io.prestosql.orc.metadata.CompressionKind;
import io.prestosql.plugin.hive.HiveACIDWriteType;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.orc.OrcAcidRowId;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.IntArrayBlockBuilder;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.block.RunLengthEncodedBlock;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.orc.impl.AcidStats;
import org.openjdk.jol.info.ClassLayout;

public class OrcFileWriter
implements HiveFileWriter {
    private static final Logger log = Logger.get(OrcFileWriter.class);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OrcFileWriter.class).instanceSize();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private static final String ACID_KEY_INDEX_NAME = "hive.acid.key.index";
    private final OrcWriter orcWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final List<Block> dataNullBlocks;
    private final Optional<Supplier<OrcDataSource>> validationInputFactory;
    private final Optional<AcidOutputFormat.Options> acidOptions;
    private StringBuilder indexKey = new StringBuilder();
    private OrcAcidRowId lastKey;
    private long writeId;
    private long indexWriteId;
    private int encodedBucketId;
    private int indexEncodedBucketId;
    private long rowId;
    private long indexRowId;
    private Optional<HiveACIDWriteType> acidWriteType;
    private AcidStats acidStats = new AcidStats();
    private Path path;
    private long validationCpuNanos;
    private Optional<HiveFileWriter> deleteDeltaFileWriter;

    public OrcFileWriter(OrcDataSink orcDataSink, Callable<Void> rollbackAction, List<String> columnNames, List<Type> fileColumnTypes, List<Type> dataFileColumnTypes, CompressionKind compression, OrcWriterOptions options, boolean writeLegacyVersion, int[] fileInputColumnIndexes, Map<String, String> metadata, Optional<Supplier<OrcDataSource>> validationInputFactory, OrcWriteValidation.OrcWriteValidationMode validationMode, OrcWriterStats stats, Optional<AcidOutputFormat.Options> acidOptions, Optional<HiveACIDWriteType> acidWriteType, Optional<HiveFileWriter> deleteDeltaFileWriter, Path path) {
        Objects.requireNonNull(orcDataSink, "orcDataSink is null");
        this.path = path;
        this.orcWriter = new OrcWriter(orcDataSink, columnNames, fileColumnTypes, compression, options, writeLegacyVersion, metadata, validationInputFactory.isPresent(), validationMode, stats, Optional.of(this.flushStripeCallback()), Optional.of(this.closeCallback()));
        this.deleteDeltaFileWriter = deleteDeltaFileWriter;
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "outputColumnInputIndexes is null");
        ImmutableList.Builder localNullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            localNullBlocks.add((Object)blockBuilder.build());
        }
        this.nullBlocks = localNullBlocks.build();
        ImmutableList.Builder localDataNullBlocks = ImmutableList.builder();
        for (Type fileColumnType : dataFileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(null, 1, 0);
            blockBuilder.appendNull();
            localDataNullBlocks.add((Object)blockBuilder.build());
        }
        this.dataNullBlocks = localDataNullBlocks.build();
        this.validationInputFactory = validationInputFactory;
        this.acidOptions = acidOptions;
        this.lastKey = new OrcAcidRowId(-1L, -1, -1L);
        this.rowId = -1L;
        if (acidOptions.isPresent()) {
            this.writeId = acidOptions.get().getMaximumWriteId();
            this.encodedBucketId = BucketCodec.V1.encode(acidOptions.get());
        }
        this.acidWriteType = acidWriteType;
    }

    @Override
    public void initWriter(boolean isAcid, Path path, FileSystem fileSystem) {
        if (isAcid && this.isFullAcid()) {
            if (this.deleteDeltaFileWriter.isPresent()) {
                AcidOutputFormat.Options deleteOptions = this.acidOptions.get().clone().writingDeleteDelta(true);
                Path deletePath = AcidUtils.createFilename((Path)path.getParent().getParent(), (AcidOutputFormat.Options)deleteOptions);
                this.deleteDeltaFileWriter.get().initWriter(isAcid, deletePath, fileSystem);
            }
            try {
                AcidUtils.OrcAcidVersion.writeVersionFile((Path)path.getParent(), (FileSystem)fileSystem);
            }
            catch (IOException e) {
                if (e instanceof AlreadyBeingCreatedException || e instanceof RemoteException && ((RemoteException)e).unwrapRemoteException(new Class[]{AlreadyBeingCreatedException.class}) != e || e instanceof FileAlreadyExistsException) {
                    return;
                }
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
            }
        }
    }

    private boolean isFullAcid() {
        if (!this.acidOptions.isPresent()) {
            return false;
        }
        Properties tableProperties = this.acidOptions.get().getTableProperties();
        return tableProperties == null || !AcidUtils.isInsertOnlyTable((Properties)tableProperties);
    }

    Callable<Void> flushStripeCallback() {
        return () -> {
            if (!this.isFullAcid()) {
                return null;
            }
            OrcAcidRowId currentKey = new OrcAcidRowId(this.indexWriteId, this.indexEncodedBucketId, this.indexRowId);
            if (this.lastKey.compareTo(currentKey) < 0) {
                this.indexKey.append(this.indexWriteId);
                this.indexKey.append(",");
                this.indexKey.append(this.indexEncodedBucketId);
                this.indexKey.append(",");
                this.indexKey.append(this.indexRowId);
                this.indexKey.append(";");
                this.lastKey = currentKey;
            }
            return null;
        };
    }

    Callable<Void> closeCallback() {
        return () -> {
            if (!this.isFullAcid()) {
                return null;
            }
            OrcAcidRowId currentKey = new OrcAcidRowId(this.indexWriteId, this.indexEncodedBucketId, this.indexRowId);
            if (this.lastKey.compareTo(currentKey) < 0) {
                this.flushStripeCallback().call();
            }
            this.orcWriter.addUserMetadata(ACID_KEY_INDEX_NAME, this.indexKey.toString());
            this.orcWriter.addUserMetadata("hive.acid.stats", this.acidStats.serialize());
            return null;
        };
    }

    @Override
    public long getWrittenBytes() {
        return this.orcWriter.getWrittenBytes() + (long)this.orcWriter.getBufferedBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.orcWriter.getRetainedBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        if (this.deleteDeltaFileWriter.isPresent()) {
            this.deleteDeltaFileWriter.get().appendRows(dataPage);
        }
        Block[] dataBlocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            dataBlocks[i] = inputColumnIndex < 0 ? new RunLengthEncodedBlock(this.dataNullBlocks.get(i), dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Block[] blocks = null;
        int i = 0;
        if (this.isFullAcid()) {
            Block rowIdBlock = null;
            if (HiveACIDWriteType.isRowIdNeeded(this.acidWriteType.get())) {
                Block block = dataPage.getBlock(dataPage.getChannelCount() - 1);
                rowIdBlock = block.getLoadedBlock();
            }
            int totalColumns = 6;
            blocks = new Block[totalColumns];
            blocks[i++] = this.insertOperationId(dataPage, rowIdBlock, this.acidWriteType.get().getOperationId());
            blocks[i++] = this.insertOriginalTransaction(dataPage, rowIdBlock, this.writeId);
            blocks[i++] = this.insertBucketIdBlock(dataPage, rowIdBlock, this.encodedBucketId);
            blocks[i++] = this.insertRowIdBlock(dataPage, rowIdBlock);
            blocks[i++] = this.insertCurrentTransaction(dataPage, rowIdBlock, this.writeId);
            boolean isDelete = this.acidWriteType.get() == HiveACIDWriteType.DELETE || this.acidWriteType.get() == HiveACIDWriteType.VACUUM && this.acidOptions.map(o -> o.isWritingDeleteDelta()).orElse(false) != false;
            Object object = blocks[i] = !isDelete ? RowBlock.fromFieldBlocks((int)dataPage.getPositionCount(), Optional.empty(), (Block[])dataBlocks) : new RunLengthEncodedBlock(this.nullBlocks.get(this.nullBlocks.size() - 1), dataPage.getPositionCount());
            if (isDelete) {
                this.acidStats.deletes += (long)dataPage.getPositionCount();
            } else {
                this.acidStats.inserts += (long)dataPage.getPositionCount();
            }
        } else {
            blocks = dataBlocks;
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.orcWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    private Block insertOperationId(Page dataPage, Block rowIdBlock, int value) {
        IntArrayBlockBuilder builder = new IntArrayBlockBuilder(null, dataPage.getPositionCount());
        boolean keepOriginal = this.acidWriteType.map(HiveACIDWriteType::isVacuum).orElse(false);
        int valueToWrite = value;
        for (int j = 0; j < dataPage.getPositionCount(); ++j) {
            if (rowIdBlock != null && keepOriginal) {
                RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(j);
                valueToWrite = rowBlock.getRawFieldBlocks()[4].getInt(0, 0);
            }
            builder.writeInt(valueToWrite);
        }
        return builder.build();
    }

    private Block insertOriginalTransaction(Page dataPage, Block rowIdBlock, long value) {
        LongArrayBlockBuilder builder = new LongArrayBlockBuilder(null, dataPage.getPositionCount());
        boolean keepOriginal = this.acidWriteType.map(t -> t == HiveACIDWriteType.DELETE || t == HiveACIDWriteType.VACUUM).orElse(false);
        long valueToWrite = value;
        for (int j = 0; j < dataPage.getPositionCount(); ++j) {
            if (rowIdBlock != null && keepOriginal) {
                RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(j);
                valueToWrite = rowBlock.getRawFieldBlocks()[0].getLong(0, 0);
            }
            builder.writeLong(valueToWrite);
        }
        return builder.build();
    }

    private Block insertCurrentTransaction(Page dataPage, Block rowIdBlock, long value) {
        LongArrayBlockBuilder builder = new LongArrayBlockBuilder(null, dataPage.getPositionCount());
        boolean keepOriginal = this.acidWriteType.map(t -> t == HiveACIDWriteType.VACUUM).orElse(false);
        long valueToWrite = value;
        for (int j = 0; j < dataPage.getPositionCount(); ++j) {
            if (rowIdBlock != null && keepOriginal) {
                RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(j);
                valueToWrite = rowBlock.getRawFieldBlocks()[3].getLong(0, 0);
            }
            builder.writeLong(valueToWrite);
        }
        this.indexWriteId = valueToWrite;
        return builder.build();
    }

    private Block insertRowIdBlock(Page dataPage, Block rowIdBlock) {
        LongArrayBlockBuilder builder = new LongArrayBlockBuilder(null, dataPage.getPositionCount());
        boolean keepOriginal = this.acidWriteType.map(t -> t == HiveACIDWriteType.DELETE || t == HiveACIDWriteType.VACUUM).orElse(false);
        long valueToWrite = -1L;
        for (int j = 0; j < dataPage.getPositionCount(); ++j) {
            valueToWrite = this.rowId + 1L;
            if (rowIdBlock != null && keepOriginal) {
                RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(j);
                valueToWrite = rowBlock.getRawFieldBlocks()[2].getLong(0, 0);
            } else {
                ++this.rowId;
            }
            builder.writeLong(valueToWrite);
        }
        this.indexRowId = valueToWrite;
        return builder.build();
    }

    private Block insertBucketIdBlock(Page dataPage, Block rowIdBlock, int value) {
        boolean keepOriginal = this.acidWriteType.map(t -> t == HiveACIDWriteType.DELETE || t == HiveACIDWriteType.VACUUM).orElse(false);
        IntArrayBlockBuilder builder = new IntArrayBlockBuilder(null, dataPage.getPositionCount());
        int valueToWrite = value;
        for (int j = 0; j < dataPage.getPositionCount(); ++j) {
            if (rowIdBlock != null && keepOriginal) {
                RowBlock rowBlock = (RowBlock)rowIdBlock.getSingleValueBlock(j);
                valueToWrite = rowBlock.getRawFieldBlocks()[1].getInt(0, 0);
            }
            builder.writeInt(valueToWrite);
        }
        this.indexEncodedBucketId = valueToWrite;
        return builder.build();
    }

    @Override
    public void commit() {
        try {
            if (this.deleteDeltaFileWriter.isPresent()) {
                this.deleteDeltaFileWriter.get().commit();
            }
            this.orcWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception ignored) {
                log.warn("RollbackAction error after roc commit error");
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (OrcDataSource input = this.validationInputFactory.get().get();){
                long startThreadCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
                this.orcWriter.validate(input);
                this.validationCpuNanos += THREAD_MX_BEAN.getCurrentThreadCpuTime() - startThreadCpuTime;
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                if (this.deleteDeltaFileWriter.isPresent()) {
                    this.deleteDeltaFileWriter.get().rollback();
                }
                this.orcWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public void cancel() {
        try {
            if (this.deleteDeltaFileWriter.isPresent()) {
                this.deleteDeltaFileWriter.get().cancel();
            }
            this.orcWriter.close();
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return this.validationCpuNanos;
    }

    @Override
    public ImmutableList<String> getExtraPartitionFiles() {
        if (this.deleteDeltaFileWriter.isPresent()) {
            OrcFileWriter deleteFileWriter = (OrcFileWriter)this.deleteDeltaFileWriter.get();
            Path deletePath = deleteFileWriter.path.getParent();
            return ImmutableList.of((Object)deletePath.getName());
        }
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.orcWriter).toString();
    }
}

