/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableSet;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.HiveColumnHandle;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveRecordCursorProvider;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.IonSqlQueryBuilder;
import io.prestosql.plugin.hive.S3SelectCsvRecordReader;
import io.prestosql.plugin.hive.S3SelectRecordCursor;
import io.prestosql.plugin.hive.s3.PrestoS3ClientFactory;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class S3SelectRecordCursorProvider
implements HiveRecordCursorProvider {
    private static final Set<String> CSV_SERDES = ImmutableSet.of((Object)LazySimpleSerDe.class.getName());
    private final HdfsEnvironment hdfsEnvironment;
    private final HiveConfig hiveConfig;
    private final PrestoS3ClientFactory s3ClientFactory;

    @Inject
    public S3SelectRecordCursorProvider(HdfsEnvironment hdfsEnvironment, HiveConfig hiveConfig, PrestoS3ClientFactory s3ClientFactory) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.hiveConfig = Objects.requireNonNull(hiveConfig, "hiveConfig is null");
        this.s3ClientFactory = Objects.requireNonNull(s3ClientFactory, "s3ClientFactory is null");
    }

    @Override
    public Optional<RecordCursor> createRecordCursor(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, TypeManager typeManager, boolean s3SelectPushdownEnabled, Map<String, String> customSplitInfo) {
        if (!s3SelectPushdownEnabled) {
            return Optional.empty();
        }
        try {
            this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed getting FileSystem: " + path, (Throwable)e);
        }
        String serdeName = HiveUtil.getDeserializerClassName(schema);
        if (CSV_SERDES.contains(serdeName)) {
            IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager);
            String ionSqlQuery = queryBuilder.buildSql(columns, effectivePredicate);
            S3SelectCsvRecordReader recordReader = new S3SelectCsvRecordReader(configuration, this.hiveConfig, path, start, length, schema, ionSqlQuery, this.s3ClientFactory);
            return Optional.of(new S3SelectRecordCursor<LongWritable, Text>(configuration, path, recordReader, length, schema, columns, typeManager));
        }
        return Optional.empty();
    }
}

