/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.base.MoreObjects;
import io.airlift.log.Logger;
import io.prestosql.orc.OrcDataSink;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HiveFileWriter;
import io.prestosql.plugin.hive.util.TempFileWriter;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class SnapshotTempFileWriter
implements HiveFileWriter {
    private static final Logger log = Logger.get(SnapshotTempFileWriter.class);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SnapshotTempFileWriter.class).instanceSize();
    private final TempFileWriter writer;

    public SnapshotTempFileWriter(OrcDataSink dataSink, List<Type> types) {
        this.writer = new TempFileWriter(types, dataSink);
    }

    @Override
    public long getWrittenBytes() {
        return this.writer.getWrittenBytes();
    }

    @Override
    public long getSystemMemoryUsage() {
        return (long)INSTANCE_SIZE + this.writer.getRetainedBytes();
    }

    @Override
    public void appendRows(Page page) {
        this.writer.writePage(page);
    }

    @Override
    public void commit() {
        try {
            this.writer.close();
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.writer.close();
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Error rolling back write to Hive");
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("writer", (Object)this.writer).toString();
    }
}

