/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.VacuumTableInfoForCleaner;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.ql.io.AcidUtils;

public class VacuumCleaner {
    private final VacuumTableInfoForCleaner vacuumTableInfo;
    private static final Logger log = Logger.get(VacuumCleaner.class);
    private final ScheduledExecutorService executorService;
    private final long cleanupInterval;
    private final HdfsEnvironment hdfsEnvironment;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final Configuration configuration;
    private final SemiTransactionalHiveMetastore metastore;
    private ScheduledFuture<?> cleanupTask;
    private Set<Long> lockIds;

    public VacuumCleaner(VacuumTableInfoForCleaner vacuumTableInfo, SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, HdfsEnvironment.HdfsContext hdfsContext) {
        this.vacuumTableInfo = vacuumTableInfo;
        this.hdfsEnvironment = hdfsEnvironment;
        this.hdfsContext = hdfsContext;
        this.metastore = metastore;
        this.executorService = this.metastore.getVacuumExecutorService();
        this.cleanupInterval = this.metastore.getVacuumCleanupInterval();
        this.configuration = hdfsEnvironment.getConfiguration(hdfsContext, this.vacuumTableInfo.getDirectoryPath());
    }

    private void log(String message) {
        String logPrefix = String.format("%s.%s", this.vacuumTableInfo.getDbName(), this.vacuumTableInfo.getTableName()) + (this.vacuumTableInfo.getPartitionName().length() > 0 ? "." + this.vacuumTableInfo.getPartitionName() : "");
        log.debug(logPrefix + " : " + message);
    }

    public void submitVacuumCleanupTask() {
        this.log("Submitting task to Vacuum Cleaner thread pool");
        this.cleanupTask = this.executorService.scheduleAtFixedRate(new CleanerTask(), 0L, this.cleanupInterval, TimeUnit.MILLISECONDS);
    }

    void stopScheduledCleanupTask() {
        this.log("Vacuum cleanup task Finished");
        this.cleanupTask.cancel(true);
    }

    private class CleanerTask
    implements Runnable {
        private int maxCleanerAttempts = 5;
        private int currentAttempt = 1;
        private boolean stop;

        private CleanerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            VacuumCleaner.this.log("Starting Vacuum cleaner task. Attempt: " + this.currentAttempt);
            try {
                if (!this.readyToClean()) {
                    VacuumCleaner.this.log("Waiting for readers to finish");
                    ++this.currentAttempt;
                    if (this.currentAttempt <= this.maxCleanerAttempts) {
                        return;
                    }
                    VacuumCleaner.this.log("Vacuum Cleaner task reached to the maximum number of attempts.");
                } else {
                    String fullTableName = VacuumCleaner.this.vacuumTableInfo.getDbName() + "." + VacuumCleaner.this.vacuumTableInfo.getTableName();
                    long highestWriteId = VacuumCleaner.this.vacuumTableInfo.getMaxId();
                    ValidReaderWriteIdList validWriteIdList = highestWriteId > 0L ? new ValidReaderWriteIdList(fullTableName, new long[0], new BitSet(), highestWriteId) : new ValidReaderWriteIdList();
                    VacuumCleaner.this.hdfsEnvironment.doAs(VacuumCleaner.this.hdfsContext.getIdentity().getUser(), () -> this.lambda$run$0((ValidWriteIdList)validWriteIdList));
                }
                this.stop = true;
            }
            catch (Exception e) {
                log.info("Exception in Vacuum cleanup: " + e.toString());
                this.stop = true;
            }
            finally {
                if (this.stop) {
                    VacuumCleaner.this.stopScheduledCleanupTask();
                }
            }
        }

        private void removeFiles(ValidWriteIdList writeIdList) {
            List filesToDelete;
            FileSystem fileSystem = null;
            try {
                AcidUtils.Directory dir = AcidUtils.getAcidState((Path)VacuumCleaner.this.vacuumTableInfo.getDirectoryPath(), (Configuration)VacuumCleaner.this.configuration, (ValidWriteIdList)writeIdList);
                filesToDelete = dir.getObsolete().stream().map(fs -> fs.getPath()).collect(Collectors.toList());
                if (filesToDelete.size() < 1) {
                    VacuumCleaner.this.log("No files to delete");
                    return;
                }
                fileSystem = ((Path)filesToDelete.get(0)).getFileSystem(VacuumCleaner.this.configuration);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failure while getting file system: ", (Throwable)e);
            }
            for (Path filePath : filesToDelete) {
                VacuumCleaner.this.log(String.format("Removing directory on path : %s", filePath.toString()));
                try {
                    fileSystem.delete(filePath, true);
                }
                catch (IOException e) {
                    VacuumCleaner.this.log(String.format("Directory %s deletion failed: %s", filePath, e.getMessage()));
                }
            }
        }

        private boolean readyToClean() {
            ShowLocksResponse response = VacuumCleaner.this.metastore.showLocks(VacuumCleaner.this.vacuumTableInfo);
            if (VacuumCleaner.this.lockIds == null) {
                VacuumCleaner.this.lockIds = this.lockResponseToSet(response);
                if (VacuumCleaner.this.lockIds.size() < 1) {
                    VacuumCleaner.this.log("No readers at present");
                    return true;
                }
            }
            VacuumCleaner.this.log(String.format(Locale.ENGLISH, "Number of readers = %d", VacuumCleaner.this.lockIds.size()));
            Set<Long> currentLockIds = this.lockResponseToSet(response);
            Iterator iterator = VacuumCleaner.this.lockIds.iterator();
            while (iterator.hasNext()) {
                if (currentLockIds.contains(iterator.next())) {
                    return false;
                }
                iterator.remove();
            }
            return true;
        }

        private Set<Long> lockResponseToSet(ShowLocksResponse response) {
            if (response.getLocks() == null) {
                return ImmutableSet.of();
            }
            return response.getLocks().stream().map(e -> e.getLockid()).collect(Collectors.toSet());
        }

        private /* synthetic */ void lambda$run$0(ValidWriteIdList validWriteIdList) {
            this.removeFiles(validWriteIdList);
        }
    }
}

