/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.prestosql.plugin.hive.HdfsEnvironment;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.spi.connector.ConnectorVacuumTableInfo;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.shims.HadoopShims;

public class VacuumEligibleTableCollector {
    private static VacuumEligibleTableCollector instance;
    private final ScheduledExecutorService executorService;
    private static final Logger log;
    private SemiTransactionalHiveMetastore metastore;
    private HdfsEnvironment hdfsEnvironment;
    private int vacuumDeltaNumThreshold;
    private double vacuumDeltaPercentThreshold;
    private List<ConnectorVacuumTableInfo> vacuumTableList = Collections.synchronizedList(new ArrayList());
    private Map<String, ConnectorVacuumTableInfo> inProgressVacuums = new ConcurrentHashMap<String, ConnectorVacuumTableInfo>();
    private VacuumTableCollectorTask task = new VacuumTableCollectorTask();

    private VacuumEligibleTableCollector(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, int vacuumDeltaNumThreshold, double vacuumDeltaPercentThreshold, ScheduledExecutorService executorService) {
        this.metastore = metastore;
        this.hdfsEnvironment = hdfsEnvironment;
        this.vacuumDeltaNumThreshold = vacuumDeltaNumThreshold;
        this.vacuumDeltaPercentThreshold = vacuumDeltaPercentThreshold;
        this.executorService = executorService;
    }

    public static synchronized void createInstance(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, int vacuumDeltaNumThreshold, double vacuumDeltaPercentThreshold, ScheduledExecutorService executorService, long vacuumCollectorInterval) {
        if (instance == null) {
            instance = new VacuumEligibleTableCollector(metastore, hdfsEnvironment, vacuumDeltaNumThreshold, vacuumDeltaPercentThreshold, executorService);
            HdfsEnvironment.HdfsContext context = new HdfsEnvironment.HdfsContext(new ConnectorIdentity("openLooKeng", Optional.empty(), Optional.empty()));
            try {
                hdfsEnvironment.getFileSystem(context, new Path("/"));
            }
            catch (IOException e) {
                log.warn("Get file system error(schema=%s tableName=%s)", new Object[]{context.getSchemaName(), context.getTableName()});
            }
            VacuumEligibleTableCollector.instance.executorService.scheduleAtFixedRate(VacuumEligibleTableCollector.instance.task, 0L, vacuumCollectorInterval, TimeUnit.MILLISECONDS);
        }
    }

    public static void finishVacuum(String schemaTable) {
        if (VacuumEligibleTableCollector.instance.inProgressVacuums.containsKey(schemaTable)) {
            VacuumEligibleTableCollector.instance.inProgressVacuums.remove(schemaTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ConnectorVacuumTableInfo> getVacuumTableList(SemiTransactionalHiveMetastore metastore, HdfsEnvironment hdfsEnvironment, int vacuumDeltaNumThreshold, double vacuumDeltaPercentThreshold, ScheduledExecutorService executorService, long vacuumCollectorInterval) {
        VacuumEligibleTableCollector.createInstance(metastore, hdfsEnvironment, vacuumDeltaNumThreshold, vacuumDeltaPercentThreshold, executorService, vacuumCollectorInterval);
        VacuumEligibleTableCollector vacuumEligibleTableCollector = instance;
        synchronized (vacuumEligibleTableCollector) {
            VacuumEligibleTableCollector.instance.metastore = metastore;
            ImmutableList newList = ImmutableList.copyOf(VacuumEligibleTableCollector.instance.vacuumTableList);
            VacuumEligibleTableCollector.instance.vacuumTableList.clear();
            return newList;
        }
    }

    private synchronized void addToVacuumTableList(List<ConnectorVacuumTableInfo> tablesForVacuum) {
        for (ConnectorVacuumTableInfo tableInfo : tablesForVacuum) {
            if (this.inProgressVacuums.containsKey(tableInfo.getSchemaTableName()) || this.vacuumTableList.contains(tableInfo)) continue;
            this.inProgressVacuums.put(tableInfo.getSchemaTableName(), tableInfo);
            this.vacuumTableList.add(tableInfo);
        }
    }

    static {
        log = Logger.get(VacuumEligibleTableCollector.class);
    }

    private class VacuumTableCollectorTask
    implements Runnable {
        private VacuumTableCollectorTask() {
        }

        private Table getTable(String schemaName, String tableName, SemiTransactionalHiveMetastore metastore) {
            HiveIdentity identity = new HiveIdentity(new ConnectorIdentity("openLooKeng", Optional.empty(), Optional.empty()));
            Optional<Table> table = metastore.getTable(identity, schemaName, tableName);
            if (!table.isPresent() || table.get().getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
                throw new TableNotFoundException(new SchemaTableName(schemaName, tableName));
            }
            return table.get();
        }

        @Override
        public void run() {
            try {
                this.collectTablesForVacuum();
            }
            catch (Exception e) {
                log.info("Error while collecting tables for auto-vacuum" + e.toString());
            }
        }

        private void collectTablesForVacuum() {
            SemiTransactionalHiveMetastore taskMetastore = VacuumEligibleTableCollector.this.metastore;
            List<String> databases = taskMetastore.getAllDatabases();
            for (String database : databases) {
                VacuumEligibleTableCollector.this.executorService.submit(() -> {
                    try {
                        this.scanDatabase(database, taskMetastore);
                    }
                    catch (Exception e) {
                        log.info("Error while scanning database for vacuum" + e.toString());
                    }
                });
            }
        }

        private void scanDatabase(String database, SemiTransactionalHiveMetastore taskMetastore) {
            Optional<List<String>> tables = taskMetastore.getAllTables(database);
            if (tables.isPresent()) {
                ArrayList tablesForVacuum = new ArrayList();
                for (String table : tables.get()) {
                    if (VacuumEligibleTableCollector.this.inProgressVacuums.containsKey(this.appendTableWithSchema(database, table))) {
                        log.debug("Auto-vacuum is in progress for table: " + this.appendTableWithSchema(database, table));
                        continue;
                    }
                    Table tableInfo = this.getTable(database, table, taskMetastore);
                    if (!this.isTransactional(tableInfo)) continue;
                    ConnectorIdentity connectorIdentity = new ConnectorIdentity("openLooKeng", Optional.empty(), Optional.empty());
                    HiveIdentity identity = new HiveIdentity(connectorIdentity);
                    Optional<List<String>> partitions = taskMetastore.getPartitionNames(identity, database, table);
                    String tablePath = this.getLocation(tableInfo);
                    HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(connectorIdentity);
                    VacuumEligibleTableCollector.this.hdfsEnvironment.doAs("openLooKeng", () -> {
                        block4: {
                            try {
                                if (partitions.isPresent() && ((List)partitions.get()).size() > 0) {
                                    for (String partitionName : (List)partitions.get()) {
                                        String partitionPath = tablePath + "/" + partitionName;
                                        boolean updated = this.determineVacuumType(partitionPath, database, table, tablesForVacuum, tableInfo.getParameters(), hdfsContext);
                                        if (!updated) continue;
                                        break block4;
                                    }
                                    break block4;
                                }
                                this.determineVacuumType(tablePath, database, table, tablesForVacuum, tableInfo.getParameters(), hdfsContext);
                            }
                            catch (Exception e) {
                                log.info("Exception while determining vacuum type for table: " + database + "." + table + ": " + e.toString());
                            }
                        }
                    });
                }
                VacuumEligibleTableCollector.this.addToVacuumTableList(tablesForVacuum);
            }
        }

        private String getLocation(Table tableInfo) {
            return tableInfo.getStorage().getLocation();
        }

        private boolean isTransactional(Table tableInfo) {
            if (!tableInfo.getParameters().containsKey("transactional")) {
                return false;
            }
            return tableInfo.getParameters().get("transactional").equalsIgnoreCase("true");
        }

        private boolean determineVacuumType(String path, String schema, String table, List<ConnectorVacuumTableInfo> tablesForVacuum, Map<String, String> parameters, HdfsEnvironment.HdfsContext hdfsContext) throws IOException {
            ConnectorVacuumTableInfo vacuumTable;
            log.debug("Determining vacuum type for path: " + path);
            Path tablePath = new Path(path);
            AcidUtils.Directory dir = this.getDirectory(hdfsContext, tablePath);
            FileSystem fs = VacuumEligibleTableCollector.this.hdfsEnvironment.getFileSystem(hdfsContext, tablePath);
            boolean noBase = false;
            Path base = dir.getBaseDirectory();
            long baseSize = 0L;
            if (base != null) {
                baseSize += this.sumDirSize(fs, base);
            }
            List originals = dir.getOriginalFiles();
            for (HadoopShims.HdfsFileStatusWithId origStat : originals) {
                baseSize += origStat.getFileStatus().getLen();
            }
            long deltaSize = 0L;
            List deltas = dir.getCurrentDirectories();
            for (AcidUtils.ParsedDelta delta : deltas) {
                deltaSize += this.sumDirSize(fs, delta.getPath());
            }
            this.logStats(schema, table, baseSize, deltaSize, dir.getCurrentDirectories().size());
            if (baseSize == 0L && deltaSize > 0L) {
                noBase = true;
            } else {
                boolean bigEnough;
                boolean bl = bigEnough = (double)((float)deltaSize / (float)baseSize) > VacuumEligibleTableCollector.this.vacuumDeltaPercentThreshold;
                if (bigEnough) {
                    vacuumTable = new ConnectorVacuumTableInfo(this.appendTableWithSchema(schema, table), true);
                    tablesForVacuum.add(vacuumTable);
                    return true;
                }
            }
            if (dir.getCurrentDirectories().size() > VacuumEligibleTableCollector.this.vacuumDeltaNumThreshold) {
                boolean isFull = false;
                if (AcidUtils.isInsertOnlyTable(parameters) || noBase) {
                    isFull = true;
                }
                vacuumTable = new ConnectorVacuumTableInfo(this.appendTableWithSchema(schema, table), isFull);
                tablesForVacuum.add(vacuumTable);
                return true;
            }
            return false;
        }

        private void logStats(String schema, String table, long baseSize, long deltaSize, int numOfDeltaDir) {
            log.debug(String.format(Locale.ENGLISH, "Auto-vacuum stats for table '%s': baseSize='%d', delatSize='%d', numOfDeltaDir='%d'", this.appendTableWithSchema(schema, table), baseSize, deltaSize, numOfDeltaDir));
        }

        private String appendTableWithSchema(String schema, String table) {
            return schema + "." + table;
        }

        public AcidUtils.Directory getDirectory(HdfsEnvironment.HdfsContext hdfsContext, Path tablePath) throws IOException {
            Configuration conf = VacuumEligibleTableCollector.this.hdfsEnvironment.getConfiguration(hdfsContext, tablePath);
            ValidReaderWriteIdList validWriteIds = new ValidReaderWriteIdList();
            return AcidUtils.getAcidState((Path)tablePath, (Configuration)conf, (ValidWriteIdList)validWriteIds);
        }

        private long sumDirSize(FileSystem fs, Path dir) throws IOException {
            long size = 0L;
            FileStatus[] buckets = fs.listStatus(dir, FileUtils.HIDDEN_FILES_PATH_FILTER);
            for (int i = 0; i < buckets.length; ++i) {
                size += buckets[i].getLen();
            }
            return size;
        }
    }
}

