/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.authentication;

import com.google.common.base.MoreObjects;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;

public final class HiveIdentity {
    private static final HiveIdentity NONE_IDENTITY = new HiveIdentity();
    private final Optional<String> username;

    private HiveIdentity() {
        this.username = Optional.empty();
    }

    public HiveIdentity(ConnectorSession session) {
        this(Objects.requireNonNull(session, "session is null").getIdentity());
    }

    public HiveIdentity(ConnectorIdentity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.username = Optional.of(Objects.requireNonNull(identity.getUser(), "identity.getUser() is null"));
    }

    public static HiveIdentity none() {
        return NONE_IDENTITY;
    }

    public Optional<String> getUsername() {
        return this.username;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("username", this.username).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveIdentity other = (HiveIdentity)o;
        return Objects.equals(this.username, other.username);
    }

    public int hashCode() {
        return Objects.hash(this.username);
    }
}

