/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.coercions;

import com.google.common.collect.ImmutableList;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.HiveUtil;
import io.prestosql.plugin.hive.coercions.DecimalCoercers;
import io.prestosql.plugin.hive.coercions.DoubleToFloatCoercer;
import io.prestosql.plugin.hive.coercions.FloatToDoubleCoercer;
import io.prestosql.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.prestosql.plugin.hive.coercions.IntegerNumberUpscaleCoercer;
import io.prestosql.plugin.hive.coercions.VarcharToIntegerNumberCoercer;
import io.prestosql.plugin.hive.coercions.VarcharToVarcharCoercer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.ArrayBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.ColumnarArray;
import io.prestosql.spi.block.ColumnarMap;
import io.prestosql.spi.block.ColumnarRow;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.block.RowBlock;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;

public interface HiveCoercer
extends Function<Block, Block> {
    public static HiveCoercer createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && fromType instanceof VarcharType) {
            return new VarcharToVarcharCoercer((VarcharType)fromType, (VarcharType)toType);
        }
        if (toType instanceof VarcharType && (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer<Type>(fromType, (VarcharType)toType);
        }
        if (fromType instanceof VarcharType && (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer<Type>((VarcharType)fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer<Type, Type>(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        if (fromHiveType.equals(HiveType.HIVE_DOUBLE) && toHiveType.equals(HiveType.HIVE_FLOAT)) {
            return new DoubleToFloatCoercer();
        }
        if (fromType instanceof DecimalType && toType instanceof DecimalType) {
            return DecimalCoercers.createDecimalToDecimalCoercer((DecimalType)fromType, (DecimalType)toType);
        }
        if (fromType instanceof DecimalType && toType == DoubleType.DOUBLE) {
            return DecimalCoercers.createDecimalToDoubleCoercer((DecimalType)fromType);
        }
        if (fromType instanceof DecimalType && toType == RealType.REAL) {
            return DecimalCoercers.createDecimalToRealCoercer((DecimalType)fromType);
        }
        if (fromType == DoubleType.DOUBLE && toType instanceof DecimalType) {
            return DecimalCoercers.createDoubleToDecimalCoercer((DecimalType)toType);
        }
        if (fromType == RealType.REAL && toType instanceof DecimalType) {
            return DecimalCoercers.createRealToDecimalCoercer((DecimalType)toType);
        }
        if (HiveUtil.isArrayType(fromType) && HiveUtil.isArrayType(toType)) {
            return new ListCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (HiveUtil.isMapType(fromType) && HiveUtil.isMapType(toType)) {
            return new MapCoercer(typeManager, fromHiveType, toHiveType);
        }
        if (HiveUtil.isRowType(fromType) && HiveUtil.isRowType(toType)) {
            return new StructCoercer(typeManager, fromHiveType, toHiveType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    public static class StructCoercer
    implements HiveCoercer {
        private final List<Optional<Function<Block, Block>>> coercers;
        private final Block[] nullBlocks;

        public StructCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            List<HiveType> fromFieldTypes = HiveUtil.extractStructFieldTypes(fromHiveType);
            List<HiveType> toFieldTypes = HiveUtil.extractStructFieldTypes(toHiveType);
            ImmutableList.Builder coercersBuilder = ImmutableList.builder();
            this.nullBlocks = new Block[toFieldTypes.size()];
            for (int i = 0; i < toFieldTypes.size(); ++i) {
                if (i >= fromFieldTypes.size()) {
                    this.nullBlocks[i] = toFieldTypes.get(i).getType(typeManager).createBlockBuilder(null, 1).appendNull().build();
                    coercersBuilder.add(Optional.empty());
                    continue;
                }
                if (!fromFieldTypes.get(i).equals(toFieldTypes.get(i))) {
                    coercersBuilder.add(Optional.of(HiveCoercer.createCoercer(typeManager, fromFieldTypes.get(i), toFieldTypes.get(i))));
                    continue;
                }
                coercersBuilder.add(Optional.empty());
            }
            this.coercers = coercersBuilder.build();
        }

        @Override
        public Block apply(Block block) {
            ColumnarRow rowBlock = ColumnarRow.toColumnarRow((Block)block);
            Block[] fields = new Block[this.coercers.size()];
            int[] ids = new int[rowBlock.getField(0).getPositionCount()];
            for (int i = 0; i < this.coercers.size(); ++i) {
                Optional<Function<Block, Block>> coercer = this.coercers.get(i);
                fields[i] = coercer.isPresent() ? coercer.get().apply(rowBlock.getField(i)) : (i < rowBlock.getFieldCount() ? rowBlock.getField(i) : new DictionaryBlock(this.nullBlocks[i], ids));
            }
            boolean[] valueIsNull = new boolean[rowBlock.getPositionCount()];
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                valueIsNull[i] = rowBlock.isNull(i);
            }
            return RowBlock.fromFieldBlocks((int)valueIsNull.length, Optional.of(valueIsNull), (Block[])fields);
        }
    }

    public static class MapCoercer
    implements HiveCoercer {
        private final Type toType;
        private final Function<Block, Block> keyCoercer;
        private final Function<Block, Block> valueCoercer;

        public MapCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            this.toType = Objects.requireNonNull(toHiveType, "toHiveType is null").getType(typeManager);
            HiveType fromKeyHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType fromValueHiveType = HiveType.valueOf(((MapTypeInfo)fromHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            HiveType toKeyHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapKeyTypeInfo().getTypeName());
            HiveType toValueHiveType = HiveType.valueOf(((MapTypeInfo)toHiveType.getTypeInfo()).getMapValueTypeInfo().getTypeName());
            this.keyCoercer = fromKeyHiveType.equals(toKeyHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromKeyHiveType, toKeyHiveType);
            this.valueCoercer = fromValueHiveType.equals(toValueHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromValueHiveType, toValueHiveType);
        }

        @Override
        public Block apply(Block block) {
            ColumnarMap mapBlock = ColumnarMap.toColumnarMap((Block)block);
            Block keysBlock = this.keyCoercer == null ? mapBlock.getKeysBlock() : this.keyCoercer.apply(mapBlock.getKeysBlock());
            Block valuesBlock = this.valueCoercer == null ? mapBlock.getValuesBlock() : this.valueCoercer.apply(mapBlock.getValuesBlock());
            boolean[] valueIsNull = new boolean[mapBlock.getPositionCount()];
            int[] offsets = new int[mapBlock.getPositionCount() + 1];
            for (int i = 0; i < mapBlock.getPositionCount(); ++i) {
                valueIsNull[i] = mapBlock.isNull(i);
                offsets[i + 1] = offsets[i] + mapBlock.getEntryCount(i);
            }
            return ((MapType)this.toType).createBlockFromKeyValue(Optional.of(valueIsNull), offsets, keysBlock, valuesBlock);
        }
    }

    public static class ListCoercer
    implements HiveCoercer {
        private final Function<Block, Block> elementCoercer;

        public ListCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
            Objects.requireNonNull(typeManager, "typeManage is null");
            Objects.requireNonNull(fromHiveType, "fromHiveType is null");
            Objects.requireNonNull(toHiveType, "toHiveType is null");
            HiveType fromElementHiveType = HiveType.valueOf(((ListTypeInfo)fromHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            HiveType toElementHiveType = HiveType.valueOf(((ListTypeInfo)toHiveType.getTypeInfo()).getListElementTypeInfo().getTypeName());
            this.elementCoercer = fromElementHiveType.equals(toElementHiveType) ? null : HiveCoercer.createCoercer(typeManager, fromElementHiveType, toElementHiveType);
        }

        @Override
        public Block apply(Block block) {
            if (this.elementCoercer == null) {
                return block;
            }
            ColumnarArray arrayBlock = ColumnarArray.toColumnarArray((Block)block);
            Block elementsBlock = this.elementCoercer.apply(arrayBlock.getElementsBlock());
            boolean[] valueIsNull = new boolean[arrayBlock.getPositionCount()];
            int[] offsets = new int[arrayBlock.getPositionCount() + 1];
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                valueIsNull[i] = arrayBlock.isNull(i);
                offsets[i + 1] = offsets[i] + arrayBlock.getLength(i);
            }
            return ArrayBlock.fromElementBlock((int)arrayBlock.getPositionCount(), Optional.of(valueIsNull), (int[])offsets, (Block)elementsBlock);
        }
    }
}

