/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.coercions;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.plugin.hive.coercions.TypeCoercer;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.VarcharType;

public class VarcharToVarcharCoercer
extends TypeCoercer<VarcharType, VarcharType> {
    public VarcharToVarcharCoercer(VarcharType fromType, VarcharType toType) {
        super(fromType, toType);
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        Slice from = ((VarcharType)this.fromType).getSlice(block, position);
        int length = Math.min(from.length(), ((VarcharType)this.toType).getLength().orElse(Integer.MAX_VALUE));
        Slice copy = Slices.copyOf((Slice)from, (int)0, (int)length);
        ((VarcharType)this.toType).writeSlice(blockBuilder, copy);
    }
}

