/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.plugin.hive.metastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.prestosql.plugin.hive.ForCachingHiveMetastore;
import io.prestosql.plugin.hive.ForCachingHiveMetastoreTableRefresh;
import io.prestosql.plugin.hive.HiveBasicStatistics;
import io.prestosql.plugin.hive.HiveConfig;
import io.prestosql.plugin.hive.HiveErrorCode;
import io.prestosql.plugin.hive.HivePartition;
import io.prestosql.plugin.hive.HivePartitionManager;
import io.prestosql.plugin.hive.HiveType;
import io.prestosql.plugin.hive.PartitionNotFoundException;
import io.prestosql.plugin.hive.PartitionStatistics;
import io.prestosql.plugin.hive.authentication.HiveIdentity;
import io.prestosql.plugin.hive.metastore.Database;
import io.prestosql.plugin.hive.metastore.HiveMetastore;
import io.prestosql.plugin.hive.metastore.HivePartitionName;
import io.prestosql.plugin.hive.metastore.HivePrincipal;
import io.prestosql.plugin.hive.metastore.HivePrivilegeInfo;
import io.prestosql.plugin.hive.metastore.HiveTableName;
import io.prestosql.plugin.hive.metastore.MetastoreUtil;
import io.prestosql.plugin.hive.metastore.Partition;
import io.prestosql.plugin.hive.metastore.PartitionFilter;
import io.prestosql.plugin.hive.metastore.PartitionWithStatistics;
import io.prestosql.plugin.hive.metastore.PrincipalPrivileges;
import io.prestosql.plugin.hive.metastore.Table;
import io.prestosql.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.NodeManager;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ColumnStatisticType;
import io.prestosql.spi.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.weakref.jmx.Managed;

@ThreadSafe
public class CachingHiveMetastore
implements HiveMetastore {
    private static final Logger LOG = Logger.get(CachingHiveMetastore.class);
    public static final int PASSIVE_CACHE_VERIFICATION_THRESHOLD = 300000;
    public static final int TABLE_CACHE_CLEANUP_TIME = 2000;
    public static final int TABLE_CACHE_REFRESH_TIME = 1000;
    protected final HiveMetastore delegate;
    private final LoadingCache<String, Optional<Database>> databaseCache;
    private final LoadingCache<String, List<String>> databaseNamesCache;
    private final LoadingCache<String, Optional<List<String>>> tableNamesCache;
    private final LoadingCache<String, Optional<List<String>>> viewNamesCache;
    private final LoadingCache<String, Set<String>> rolesCache;
    private final LoadingCache<HivePrincipal, Set<RoleGrant>> roleGrantsCache;
    private final LoadingCache<String, Optional<String>> configValuesCache;
    private final LoadingCache<WithIdentity<HiveTableName>, Optional<Table>> tableCache;
    private final LoadingCache<WithIdentity<HiveTableName>, Optional<List<String>>> partitionNamesCache;
    private final LoadingCache<WithIdentity<HiveTableName>, WithValidation<Table, PartitionStatistics>> tableStatisticsCache;
    private final LoadingCache<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>> partitionStatisticsCache;
    private final LoadingCache<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> partitionCache;
    private final LoadingCache<WithIdentity<PartitionFilter>, Optional<WithValidation<Table, List<String>>>> partitionFilterCache;
    private final boolean skipCache;
    private final boolean skipTableCache;
    private final boolean dontVerifyCacheEntry;

    @Inject
    public CachingHiveMetastore(@ForCachingHiveMetastore HiveMetastore delegate, @ForCachingHiveMetastore Executor executor, @ForCachingHiveMetastoreTableRefresh Executor tableRefreshExecutor, HiveConfig hiveConfig, NodeManager nodeManager) {
        this(delegate, executor, tableRefreshExecutor, hiveConfig.getMetastoreCacheTtl(), hiveConfig.getMetastoreRefreshInterval(), hiveConfig.getMetastoreDBCacheTtl(), hiveConfig.getMetastoreDBRefreshInterval(), hiveConfig.getMetastoreCacheMaximumSize(), !nodeManager.getCurrentNode().isCoordinator() && !hiveConfig.getWorkerMetaStoreCacheEnabled());
    }

    public CachingHiveMetastore(HiveMetastore delegate, Executor executor, Executor tableRefreshExecutor, Duration cacheTtl, Duration refreshInterval, Duration dbCacheTtl, Duration dbRefreshInterval, long maximumSize, boolean skipCache) {
        this(delegate, executor, tableRefreshExecutor, OptionalLong.of(cacheTtl.toMillis()), refreshInterval.toMillis() >= cacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(refreshInterval.toMillis()), OptionalLong.of(dbCacheTtl.toMillis()), dbRefreshInterval.toMillis() >= dbCacheTtl.toMillis() ? OptionalLong.empty() : OptionalLong.of(dbRefreshInterval.toMillis()), maximumSize, skipCache);
    }

    public static CachingHiveMetastore memoizeMetastore(HiveMetastore delegate, long maximumSize) {
        return new CachingHiveMetastore(delegate, (Executor)MoreExecutors.newDirectExecutorService(), (Executor)MoreExecutors.newDirectExecutorService(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), maximumSize, delegate instanceof CachingHiveMetastore);
    }

    private CachingHiveMetastore(HiveMetastore delegate, Executor executor, Executor tableRefreshExecutor, OptionalLong expiresAfterWriteMillisTable, OptionalLong refreshMillsTable, OptionalLong expiresAfterWriteMillisDB, OptionalLong refreshMillsDB, long maximumSize, boolean skipCache) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Objects.requireNonNull(executor, "executor is null");
        this.skipCache = skipCache || refreshMillsDB.isPresent() && refreshMillsDB.getAsLong() == 0L;
        this.skipTableCache = skipCache || refreshMillsTable.isPresent() && refreshMillsTable.getAsLong() == 0L && expiresAfterWriteMillisTable.isPresent() && expiresAfterWriteMillisTable.getAsLong() == 0L;
        boolean dontVerifyCache = true;
        OptionalLong tableCacheTtl = expiresAfterWriteMillisTable;
        OptionalLong tableRefreshTtl = refreshMillsTable;
        if (!this.skipTableCache) {
            long refresh = refreshMillsTable.orElse(0L);
            long ttl = expiresAfterWriteMillisTable.orElse(0L);
            if (refresh > 300000L || 0L == refresh && ttl > 300000L) {
                dontVerifyCache = false;
                tableCacheTtl = OptionalLong.of(2000L);
                tableRefreshTtl = OptionalLong.of(1000L);
            }
        }
        this.dontVerifyCacheEntry = dontVerifyCache;
        this.databaseNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllDatabases), (Executor)executor));
        this.databaseCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadDatabase), (Executor)executor));
        this.tableNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllTables), (Executor)executor));
        this.viewNamesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadAllViews), (Executor)executor));
        this.tableCache = CachingHiveMetastore.newCacheBuilder(tableCacheTtl, tableRefreshTtl, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadTable), (Executor)tableRefreshExecutor));
        this.partitionNamesCache = CachingHiveMetastore.newCacheBuilder(tableCacheTtl, tableRefreshTtl, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNames), (Executor)tableRefreshExecutor));
        this.tableStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisTable, refreshMillsTable, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<WithIdentity<HiveTableName>, WithValidation<Table, PartitionStatistics>>(){

            public WithValidation<Table, PartitionStatistics> load(WithIdentity<HiveTableName> key) {
                Table table = CachingHiveMetastore.this.getExistingTable(key.getIdentity(), key.getKey().getDatabaseName(), key.getKey().getTableName());
                PartitionStatistics ps = CachingHiveMetastore.this.loadTableColumnStatistics(key, table);
                Table validationParams = CachingHiveMetastore.this.getCacheValidationParams(key.getIdentity(), table);
                return new WithValidation<Table, PartitionStatistics>(validationParams, ps);
            }
        }, (Executor)executor));
        this.partitionStatisticsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisTable, refreshMillsTable, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>>(){

            public WithValidation<Table, PartitionStatistics> load(WithIdentity<HivePartitionName> key) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(key);
            }

            public Map<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>> loadAll(Iterable<? extends WithIdentity<HivePartitionName>> keys) {
                return CachingHiveMetastore.this.loadPartitionColumnStatistics(keys);
            }
        }, (Executor)executor));
        this.partitionFilterCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisTable, refreshMillsTable, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadPartitionNamesByParts), (Executor)executor));
        this.partitionCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisTable, refreshMillsTable, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>>(){

            public Optional<WithValidation<Table, Partition>> load(WithIdentity<HivePartitionName> partitionName) {
                return CachingHiveMetastore.this.loadPartitionByName(partitionName);
            }

            public Map<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> loadAll(Iterable<? extends WithIdentity<HivePartitionName>> partitionNames) {
                return CachingHiveMetastore.this.loadPartitionsByNames(partitionNames);
            }
        }, (Executor)executor));
        this.rolesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(() -> this.loadRoles()), (Executor)executor));
        this.roleGrantsCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadRoleGrants), (Executor)executor));
        this.configValuesCache = CachingHiveMetastore.newCacheBuilder(expiresAfterWriteMillisDB, refreshMillsDB, maximumSize).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::loadConfigValue), (Executor)executor));
    }

    @Override
    public void refreshMetastoreCache() {
        if (this.skipCache) {
            this.delegate.refreshMetastoreCache();
        }
        this.flushCache();
    }

    @Managed
    public void flushCache() {
        this.databaseNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.viewNamesCache.invalidateAll();
        this.partitionNamesCache.invalidateAll();
        this.databaseCache.invalidateAll();
        this.tableCache.invalidateAll();
        this.partitionCache.invalidateAll();
        this.partitionFilterCache.invalidateAll();
        this.tableStatisticsCache.invalidateAll();
        this.partitionStatisticsCache.invalidateAll();
        this.rolesCache.invalidateAll();
    }

    private static <K, V> V get(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            throw e;
        }
    }

    private static <K, V> Map<K, V> getAll(LoadingCache<K, V> cache, Iterable<K> keys) {
        try {
            return cache.getAll(keys);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), PrestoException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new UncheckedExecutionException(e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        if (this.skipCache) {
            return this.delegate.getDatabase(databaseName);
        }
        return CachingHiveMetastore.get(this.databaseCache, databaseName);
    }

    private Optional<Database> loadDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllDatabases() {
        if (this.skipCache) {
            return this.delegate.getAllDatabases();
        }
        return CachingHiveMetastore.get(this.databaseNamesCache, "");
    }

    private List<String> loadAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    private Table getExistingTable(HiveIdentity identity, String databaseName, String tableName) {
        return this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    private Table getCacheValidationParams(HiveIdentity identity, String databaseName, String tableName) {
        if (this.dontVerifyCacheEntry) {
            return null;
        }
        Table table = this.getTable(identity, databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        if (table.getPartitionColumns().size() > 0) {
            Table.Builder builder = Table.builder(table);
            this.getPartitionNames(identity, databaseName, tableName).ifPresent(list -> builder.setParameter("partitionNames", String.valueOf(list.hashCode())));
            return builder.build();
        }
        return table;
    }

    private Table getCacheValidationParams(HiveIdentity identity, Table table) {
        if (this.dontVerifyCacheEntry) {
            return null;
        }
        if (table.getPartitionColumns().size() > 0) {
            Table.Builder builder = Table.builder(table);
            this.getPartitionNames(identity, table.getDatabaseName(), table.getTableName()).ifPresent(list -> builder.setParameter("partitionNames", String.valueOf(list.hashCode())));
            return builder.build();
        }
        return table;
    }

    private Table getCacheValidationPartitionParams(Table table, HiveBasicStatistics partition) {
        if (this.dontVerifyCacheEntry) {
            return null;
        }
        if (table.getPartitionColumns().size() > 0) {
            Table.Builder builder = Table.builder(table);
            builder.setParameter("partition::rowCount", partition.getRowCount().toString());
            builder.setParameter("partition::fileCount", partition.getFileCount().toString());
            builder.setParameter("partition::inMemSize", partition.getInMemoryDataSizeInBytes().toString());
            builder.setParameter("partition::onDiskSize", partition.getOnDiskDataSizeInBytes().toString());
            return builder.build();
        }
        return table;
    }

    @Override
    public Optional<Table> getTable(HiveIdentity inputIdentity, String databaseName, String tableName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        if (this.skipTableCache) {
            return this.delegate.getTable(identity, databaseName, tableName);
        }
        return CachingHiveMetastore.get(this.tableCache, new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
    }

    @Override
    public Set<ColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return this.delegate.getSupportedColumnStatistics(type);
    }

    private Optional<Table> loadTable(WithIdentity<HiveTableName> hiveTableName) {
        Optional allTables;
        String databaseName;
        Optional<Table> table = this.delegate.getTable(hiveTableName.getIdentity(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
        ConcurrentMap map = this.tableNamesCache.asMap();
        if (map.containsKey(databaseName = hiveTableName.getKey().getDatabaseName()) && (allTables = (Optional)map.get(databaseName)).isPresent() && (table.isPresent() && !((List)allTables.get()).contains(hiveTableName.getKey().getTableName()) || !table.isPresent() && ((List)allTables.get()).contains(hiveTableName.getKey().getTableName()))) {
            this.tableNamesCache.invalidate((Object)databaseName);
        }
        return table;
    }

    @Override
    public PartitionStatistics getTableStatistics(HiveIdentity identity, Table table) {
        if (this.skipTableCache) {
            return this.delegate.getTableStatistics(identity, table);
        }
        WithIdentity<HiveTableName> key = new WithIdentity<HiveTableName>(this.updateIdentity(identity), HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName()));
        WithValidation<Table, PartitionStatistics> ps = CachingHiveMetastore.get(this.tableStatisticsCache, key);
        if (this.dontVerifyCacheEntry || ps.matches(table)) {
            return ps.get();
        }
        this.tableStatisticsCache.invalidate(key);
        return CachingHiveMetastore.get(this.tableStatisticsCache, key).get();
    }

    private PartitionStatistics loadTableColumnStatistics(WithIdentity<HiveTableName> hiveTableName, Table table) {
        return this.delegate.getTableStatistics(hiveTableName.getIdentity(), table);
    }

    @Override
    public Map<String, PartitionStatistics> getPartitionStatistics(HiveIdentity identity, Table table, List<Partition> partitionNames) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(table.getDatabaseName(), table.getTableName());
        List partitions = (List)partitionNames.stream().map(partition -> new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(hiveTableName, MetastoreUtil.makePartitionName(table, partition)))).collect(ImmutableList.toImmutableList());
        if (this.skipTableCache) {
            HiveIdentity identity1 = this.updateIdentity(identity);
            return this.delegate.getPartitionStatistics(identity1, table, partitionNames);
        }
        Map<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>> statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitions);
        if (this.dontVerifyCacheEntry || statistics.size() == 0) {
            return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((WithIdentity)entry.getKey()).getKey()).getPartitionName().get(), entry -> (PartitionStatistics)((WithValidation)entry.getValue()).get()));
        }
        Map<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>> finalStatistics = statistics;
        boolean allMatch = partitionNames.stream().allMatch(partition -> ((WithValidation)finalStatistics.get(new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(hiveTableName, MetastoreUtil.makePartitionName(table, partition))))).matches(this.getCacheValidationPartitionParams(table, ThriftMetastoreUtil.getHiveBasicStatistics(partition.getParameters()))));
        if (allMatch) {
            return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((WithIdentity)entry.getKey()).getKey()).getPartitionName().get(), entry -> (PartitionStatistics)((WithValidation)entry.getValue()).get()));
        }
        this.partitionCache.invalidate((Object)partitions);
        this.partitionStatisticsCache.invalidate((Object)partitions);
        statistics = CachingHiveMetastore.getAll(this.partitionStatisticsCache, partitions);
        return (Map)statistics.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((HivePartitionName)((WithIdentity)entry.getKey()).getKey()).getPartitionName().get(), entry -> (PartitionStatistics)((WithValidation)entry.getValue()).get()));
    }

    private WithValidation<Table, PartitionStatistics> loadPartitionColumnStatistics(WithIdentity<HivePartitionName> partition) {
        HiveTableName hiveTableName = partition.getKey().getHiveTableName();
        HiveIdentity identity = partition.getIdentity();
        Table table = this.getExistingTable(identity, hiveTableName.getDatabaseName(), hiveTableName.getTableName());
        String partitionName = partition.getKey().getPartitionName().get();
        Map<String, PartitionStatistics> partitionStatistics = this.delegate.getPartitionStatistics(identity, table, (List<Partition>)ImmutableList.of((Object)this.getExistingPartition(identity, table, partition.getKey().getPartitionValues())));
        if (!partitionStatistics.containsKey(partitionName)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + partition.getKey().getPartitionName());
        }
        PartitionStatistics value = partitionStatistics.get(partitionName);
        return new WithValidation<Table, PartitionStatistics>(this.getCacheValidationPartitionParams(table, value.getBasicStatistics()), value);
    }

    private Map<WithIdentity<HivePartitionName>, WithValidation<Table, PartitionStatistics>> loadPartitionColumnStatistics(Iterable<? extends WithIdentity<HivePartitionName>> keys) {
        SetMultimap tablePartitions = (SetMultimap)Streams.stream(keys).collect(ImmutableSetMultimap.toImmutableSetMultimap(value -> new WithIdentity<HiveTableName>(value.getIdentity(), ((HivePartitionName)value.getKey()).getHiveTableName()), key -> key));
        ImmutableMap.Builder result = ImmutableMap.builder();
        tablePartitions.keySet().forEach(tableName -> {
            Set partitionNames = tablePartitions.get(tableName);
            Set partitionNameStrings = (Set)partitionNames.stream().map(partitionName -> ((HivePartitionName)partitionName.getKey()).getPartitionName().get()).collect(ImmutableSet.toImmutableSet());
            Table table = this.getExistingTable(tableName.getIdentity(), ((HiveTableName)tableName.getKey()).getDatabaseName(), ((HiveTableName)tableName.getKey()).getTableName());
            List<Partition> partitions = this.getExistingPartitionsByNames(tableName.getIdentity(), table, (List<String>)ImmutableList.copyOf((Collection)partitionNameStrings));
            Map<String, PartitionStatistics> statisticsByPartitionName = this.delegate.getPartitionStatistics(tableName.getIdentity(), table, partitions);
            for (WithIdentity partitionName2 : partitionNames) {
                String stringNameForPartition = ((HivePartitionName)partitionName2.getKey()).getPartitionName().get();
                PartitionStatistics value = statisticsByPartitionName.get(stringNameForPartition);
                if (value == null) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Statistics result does not contain entry for partition: " + stringNameForPartition);
                }
                result.put((Object)partitionName2, new WithValidation<Table, PartitionStatistics>(this.getCacheValidationPartitionParams(table, value.getBasicStatistics()), value));
            }
        });
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStatistics(HiveIdentity inputIdentity, String databaseName, String tableName, Function<PartitionStatistics, PartitionStatistics> update) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.updateTableStatistics(identity, databaseName, tableName, update);
        }
        finally {
            this.tableStatisticsCache.invalidate(new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
            this.tableCache.invalidate(new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionStatistics(HiveIdentity inputIdentity, String databaseName, String tableName, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.updatePartitionStatistics(identity, databaseName, tableName, partitionName, update);
        }
        finally {
            this.partitionStatisticsCache.invalidate(new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(databaseName, tableName, partitionName)));
            this.partitionCache.invalidate(new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(databaseName, tableName, partitionName)));
            this.tableCache.invalidate(new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePartitionsStatistics(HiveIdentity identity, String databaseName, String tableName, Map<String, Function<PartitionStatistics, PartitionStatistics>> partNamesUpdateFunctionMap) {
        try {
            this.delegate.updatePartitionsStatistics(identity, databaseName, tableName, partNamesUpdateFunctionMap);
        }
        finally {
            partNamesUpdateFunctionMap.entrySet().stream().forEach(e -> {
                this.partitionStatisticsCache.invalidate(new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(databaseName, tableName, (String)e.getKey())));
                this.partitionCache.invalidate(new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(databaseName, tableName, (String)e.getKey())));
            });
            this.tableCache.invalidate(new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName)));
        }
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        if (this.skipCache) {
            return this.delegate.getAllTables(databaseName);
        }
        return CachingHiveMetastore.get(this.tableNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        if (this.skipCache) {
            return this.delegate.getAllViews(databaseName);
        }
        return CachingHiveMetastore.get(this.viewNamesCache, databaseName);
    }

    private Optional<List<String>> loadAllViews(String databaseName) {
        return this.delegate.getAllViews(databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatabase(HiveIdentity inputIdentity, Database database) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.createDatabase(identity, database);
        }
        finally {
            this.invalidateDatabase(database.getDatabaseName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabase(HiveIdentity inputIdentity, String databaseName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropDatabase(identity, databaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameDatabase(HiveIdentity inputIdentity, String databaseName, String newDatabaseName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameDatabase(identity, databaseName, newDatabaseName);
        }
        finally {
            this.invalidateDatabase(databaseName);
            this.invalidateDatabase(newDatabaseName);
        }
    }

    protected void invalidateDatabase(String databaseName) {
        this.databaseCache.invalidate((Object)databaseName);
        this.databaseNamesCache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(HiveIdentity inputIdentity, Table table, PrincipalPrivileges principalPrivileges) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.createTable(identity, table, principalPrivileges);
        }
        finally {
            this.invalidateTable(table.getDatabaseName(), table.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(HiveIdentity inputIdentity, String databaseName, String tableName, boolean deleteData) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropTable(identity, databaseName, tableName, deleteData);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceTable(HiveIdentity inputIdentity, String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.replaceTable(identity, databaseName, tableName, newTable, principalPrivileges);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newTable.getDatabaseName(), newTable.getTableName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameTable(HiveIdentity inputIdentity, String databaseName, String tableName, String newDatabaseName, String newTableName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameTable(identity, databaseName, tableName, newDatabaseName, newTableName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
            this.invalidateTable(newDatabaseName, newTableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commentTable(HiveIdentity inputIdentity, String databaseName, String tableName, Optional<String> comment) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.commentTable(identity, databaseName, tableName, comment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(HiveIdentity inputIdentity, String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.addColumn(identity, databaseName, tableName, columnName, columnType, columnComment);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameColumn(HiveIdentity inputIdentity, String databaseName, String tableName, String oldColumnName, String newColumnName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.renameColumn(identity, databaseName, tableName, oldColumnName, newColumnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropColumn(HiveIdentity inputIdentity, String databaseName, String tableName, String columnName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropColumn(identity, databaseName, tableName, columnName);
        }
        finally {
            this.invalidateTable(databaseName, tableName);
        }
    }

    protected void invalidateTable(String databaseName, String tableName) {
        this.invalidateTableCache(databaseName, tableName);
        this.tableNamesCache.invalidate((Object)databaseName);
        this.viewNamesCache.invalidate((Object)databaseName);
        this.invalidateTableStatisticsCache(databaseName, tableName);
        this.invalidatePartitionCache(databaseName, tableName);
    }

    private Partition getExistingPartition(HiveIdentity identity, Table table, List<String> partitionValues) {
        return this.getPartition(identity, table.getDatabaseName(), table.getTableName(), partitionValues).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), partitionValues));
    }

    private List<Partition> getExistingPartitionsByNames(HiveIdentity identity, Table table, List<String> partitionNames) {
        Map partitions = (Map)this.getPartitionsByNames(identity, table.getDatabaseName(), table.getTableName(), partitionNames).entrySet().stream().map(entry -> Maps.immutableEntry(entry.getKey(), ((Optional)entry.getValue()).orElseThrow(() -> new PartitionNotFoundException(table.getSchemaTableName(), HivePartitionManager.extractPartitionValues((String)entry.getKey()))))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return (List)partitionNames.stream().map(partitions::get).collect(ImmutableList.toImmutableList());
    }

    private void invalidateTableCache(String databaseName, String tableName) {
        this.tableCache.asMap().keySet().stream().filter(table -> ((HiveTableName)table.getKey()).getDatabaseName().equals(databaseName) && ((HiveTableName)table.getKey()).getTableName().equals(tableName)).forEach(arg_0 -> this.tableCache.invalidate(arg_0));
    }

    private void invalidateTableStatisticsCache(String databaseName, String tableName) {
        this.tableStatisticsCache.asMap().keySet().stream().filter(table -> ((HiveTableName)table.getKey()).getDatabaseName().equals(databaseName) && ((HiveTableName)table.getKey()).getTableName().equals(tableName)).forEach(arg_0 -> this.tableStatisticsCache.invalidate(arg_0));
    }

    @Override
    public Optional<Partition> getPartition(HiveIdentity inputIdentity, String databaseName, String tableName, List<String> partitionValues) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        if (this.skipTableCache) {
            return this.delegate.getPartition(identity, databaseName, tableName, partitionValues);
        }
        WithIdentity<HivePartitionName> name = new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(databaseName, tableName, partitionValues));
        Optional<WithValidation<Table, Partition>> partition = CachingHiveMetastore.get(this.partitionCache, name);
        if (this.dontVerifyCacheEntry || !partition.isPresent()) {
            return partition.isPresent() ? Optional.of(partition.get().get()) : Optional.empty();
        }
        Table table = this.getCacheValidationParams(identity, databaseName, tableName);
        if (partition.get().matches(table)) {
            return Optional.of(partition.get().get());
        }
        this.partitionCache.invalidate(name);
        partition = CachingHiveMetastore.get(this.partitionCache, name);
        return partition.isPresent() ? Optional.of(partition.get().get()) : Optional.empty();
    }

    @Override
    public Optional<List<String>> getPartitionNames(HiveIdentity inputIdentity, String databaseName, String tableName) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        if (this.skipTableCache) {
            return this.delegate.getPartitionNames(identity, databaseName, tableName);
        }
        WithIdentity<HiveTableName> key = new WithIdentity<HiveTableName>(identity, HiveTableName.hiveTableName(databaseName, tableName));
        return CachingHiveMetastore.get(this.partitionNamesCache, key);
    }

    private Optional<List<String>> loadPartitionNames(WithIdentity<HiveTableName> hiveTableName) {
        return this.delegate.getPartitionNames(hiveTableName.getIdentity(), hiveTableName.getKey().getDatabaseName(), hiveTableName.getKey().getTableName());
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(HiveIdentity inputIdentity, String databaseName, String tableName, List<String> parts) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        if (this.skipTableCache) {
            return this.delegate.getPartitionNamesByParts(identity, databaseName, tableName, parts);
        }
        WithIdentity<PartitionFilter> key = new WithIdentity<PartitionFilter>(identity, PartitionFilter.partitionFilter(databaseName, tableName, parts));
        Optional<WithValidation<Table, List<String>>> values = CachingHiveMetastore.get(this.partitionFilterCache, key);
        if (this.dontVerifyCacheEntry || !values.isPresent()) {
            return values.isPresent() ? Optional.of(values.get().get()) : Optional.empty();
        }
        Table table = this.getCacheValidationParams(identity, databaseName, tableName);
        if (values.get().matches(table)) {
            return Optional.of(values.get().get());
        }
        this.partitionFilterCache.invalidate(key);
        values = CachingHiveMetastore.get(this.partitionFilterCache, key);
        return values.isPresent() ? Optional.of(values.get().get()) : Optional.empty();
    }

    private Optional<WithValidation<Table, List<String>>> loadPartitionNamesByParts(WithIdentity<PartitionFilter> partitionFilter) {
        Optional<List<String>> result = this.delegate.getPartitionNamesByParts(partitionFilter.getIdentity(), partitionFilter.getKey().getHiveTableName().getDatabaseName(), partitionFilter.getKey().getHiveTableName().getTableName(), partitionFilter.getKey().getParts());
        if (result.isPresent()) {
            Table table = this.getCacheValidationParams(partitionFilter.getIdentity(), partitionFilter.getKey().getHiveTableName().getDatabaseName(), partitionFilter.getKey().getHiveTableName().getTableName());
            return Optional.of(new WithValidation<Table, List<String>>(table, result.get()));
        }
        return Optional.empty();
    }

    @Override
    public Map<String, Optional<Partition>> getPartitionsByNames(HiveIdentity identity, String databaseName, String tableName, List<String> partitionNames) {
        if (this.skipTableCache) {
            HiveIdentity identity1 = this.updateIdentity(identity);
            return this.delegate.getPartitionsByNames(identity1, databaseName, tableName, partitionNames);
        }
        Iterable names = Iterables.transform(partitionNames, name -> new WithIdentity<HivePartitionName>(this.updateIdentity(identity), HivePartitionName.hivePartitionName(databaseName, tableName, name)));
        Map<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> all = CachingHiveMetastore.getAll(this.partitionCache, names);
        ImmutableMap.Builder partitionsByName = ImmutableMap.builder();
        if (this.dontVerifyCacheEntry || all.size() == 0) {
            return this.buildParitionsByName(all, (ImmutableMap.Builder<String, Optional<Partition>>)partitionsByName);
        }
        Table table = this.getCacheValidationParams(identity, databaseName, tableName);
        if (((WithValidation)((Optional)Iterables.get(all.values(), (int)0)).get()).matches(table)) {
            return this.buildParitionsByName(all, (ImmutableMap.Builder<String, Optional<Partition>>)partitionsByName);
        }
        this.partitionCache.invalidateAll(names);
        all = CachingHiveMetastore.getAll(this.partitionCache, names);
        return this.buildParitionsByName(all, (ImmutableMap.Builder<String, Optional<Partition>>)partitionsByName);
    }

    private Map<String, Optional<Partition>> buildParitionsByName(Map<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> all, ImmutableMap.Builder<String, Optional<Partition>> partitionsByName) {
        for (Map.Entry<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> entry : all.entrySet()) {
            partitionsByName.put((Object)entry.getKey().getKey().getPartitionName().get(), entry.getValue().isPresent() ? Optional.of(entry.getValue().get().get()) : Optional.empty());
        }
        return partitionsByName.build();
    }

    private Optional<WithValidation<Table, Partition>> loadPartitionByName(WithIdentity<HivePartitionName> partitionName) {
        Optional<Partition> result = this.delegate.getPartition(partitionName.getIdentity(), partitionName.getKey().getHiveTableName().getDatabaseName(), partitionName.getKey().getHiveTableName().getTableName(), partitionName.getKey().getPartitionValues());
        if (result.isPresent()) {
            Table table = this.getCacheValidationParams(partitionName.getIdentity(), partitionName.getKey().getHiveTableName().getDatabaseName(), partitionName.getKey().getHiveTableName().getTableName());
            return Optional.of(new WithValidation<Table, Partition>(table, result.get()));
        }
        return Optional.empty();
    }

    private Map<WithIdentity<HivePartitionName>, Optional<WithValidation<Table, Partition>>> loadPartitionsByNames(Iterable<? extends WithIdentity<HivePartitionName>> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        WithIdentity firstPartition = (WithIdentity)Iterables.get(partitionNames, (int)0);
        HiveTableName hiveTableName = ((HivePartitionName)firstPartition.getKey()).getHiveTableName();
        HiveIdentity identity = this.updateIdentity(firstPartition.getIdentity());
        String databaseName = hiveTableName.getDatabaseName();
        String tableName = hiveTableName.getTableName();
        ArrayList<String> partitionsToFetch = new ArrayList<String>();
        for (WithIdentity<HivePartitionName> withIdentity : partitionNames) {
            Preconditions.checkArgument((boolean)withIdentity.getKey().getHiveTableName().equals(hiveTableName), (String)"Expected table name %s but got %s", (Object)hiveTableName, (Object)withIdentity.getKey().getHiveTableName());
            partitionsToFetch.add(withIdentity.getKey().getPartitionName().get());
        }
        ImmutableMap.Builder partitions = ImmutableMap.builder();
        Map<String, Optional<Partition>> map = this.delegate.getPartitionsByNames(identity, databaseName, tableName, partitionsToFetch);
        Table table = this.getCacheValidationParams(identity, databaseName, tableName);
        for (Map.Entry<String, Optional<Partition>> entry : map.entrySet()) {
            partitions.put(new WithIdentity<HivePartitionName>(identity, HivePartitionName.hivePartitionName(hiveTableName, entry.getKey())), entry.getValue().isPresent() ? Optional.of(new WithValidation<Table, Partition>(table, entry.getValue().get())) : Optional.empty());
        }
        return partitions.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartitions(HiveIdentity inputIdentity, String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.addPartitions(identity, databaseName, tableName, partitions);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropPartition(HiveIdentity inputIdentity, String databaseName, String tableName, List<String> parts, boolean deleteData) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.dropPartition(identity, databaseName, tableName, parts, deleteData);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alterPartition(HiveIdentity inputIdentity, String databaseName, String tableName, PartitionWithStatistics partition) {
        HiveIdentity identity = inputIdentity;
        identity = this.updateIdentity(identity);
        try {
            this.delegate.alterPartition(identity, databaseName, tableName, partition);
        }
        finally {
            this.invalidatePartitionCache(databaseName, tableName);
        }
    }

    @Override
    public void createRole(String role, String grantor) {
        try {
            this.delegate.createRole(role, grantor);
        }
        finally {
            this.rolesCache.invalidateAll();
        }
    }

    @Override
    public void dropRole(String role) {
        try {
            this.delegate.dropRole(role);
        }
        finally {
            this.rolesCache.invalidateAll();
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<String> listRoles() {
        if (this.skipCache) {
            return this.delegate.listRoles();
        }
        return CachingHiveMetastore.get(this.rolesCache, "");
    }

    private Set<String> loadRoles() {
        return this.delegate.listRoles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean withAdminOption, HivePrincipal grantor) {
        try {
            this.delegate.grantRoles(roles, grantees, withAdminOption, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOptionFor, HivePrincipal grantor) {
        try {
            this.delegate.revokeRoles(roles, grantees, adminOptionFor, grantor);
        }
        finally {
            this.roleGrantsCache.invalidateAll();
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (this.skipCache) {
            return this.delegate.listRoleGrants(principal);
        }
        return CachingHiveMetastore.get(this.roleGrantsCache, principal);
    }

    private Set<RoleGrant> loadRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    private void invalidatePartitionCache(String databaseName, String tableName) {
        HiveTableName hiveTableName = HiveTableName.hiveTableName(databaseName, tableName);
        this.partitionNamesCache.asMap().keySet().stream().filter(partitionName -> ((HiveTableName)partitionName.getKey()).equals(hiveTableName)).forEach(arg_0 -> this.partitionNamesCache.invalidate(arg_0));
        this.partitionCache.asMap().keySet().stream().filter(partitionName -> ((HivePartitionName)partitionName.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionCache.invalidate(arg_0));
        this.partitionFilterCache.asMap().keySet().stream().filter(partitionFilter -> ((PartitionFilter)partitionFilter.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionFilterCache.invalidate(arg_0));
        this.partitionStatisticsCache.asMap().keySet().stream().filter(partitionFilter -> ((HivePartitionName)partitionFilter.getKey()).getHiveTableName().equals(hiveTableName)).forEach(arg_0 -> this.partitionStatisticsCache.invalidate(arg_0));
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.grantTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, HivePrincipal grantee, Set<HivePrivilegeInfo> privileges) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, grantee, privileges);
    }

    @Override
    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, HivePrincipal principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, principal);
    }

    @Override
    public Optional<String> getConfigValue(String name) {
        if (this.skipCache) {
            return this.delegate.getConfigValue(name);
        }
        return CachingHiveMetastore.get(this.configValuesCache, name);
    }

    private Optional<String> loadConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    @Override
    public long openTransaction(HiveIdentity identity) {
        return this.delegate.openTransaction(identity);
    }

    @Override
    public void commitTransaction(HiveIdentity identity, long transactionId) {
        this.delegate.commitTransaction(identity, transactionId);
    }

    @Override
    public void abortTransaction(HiveIdentity identity, long transactionId) {
        this.delegate.abortTransaction(identity, transactionId);
    }

    @Override
    public void sendTransactionHeartbeat(HiveIdentity identity, long transactionId) {
        this.delegate.sendTransactionHeartbeat(identity, transactionId);
    }

    @Override
    public void acquireSharedReadLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(identity, queryId, transactionId, fullTables, partitions);
    }

    @Override
    public void acquireLock(HiveIdentity identity, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions, DataOperationType operationType) {
        this.delegate.acquireLock(identity, queryId, transactionId, fullTables, partitions, operationType);
    }

    @Override
    public String getValidWriteIds(HiveIdentity identity, List<SchemaTableName> tables, long currentTransactionId, boolean isVacuum) {
        return this.delegate.getValidWriteIds(identity, tables, currentTransactionId, isVacuum);
    }

    @Override
    public ShowLocksResponse showLocks(ShowLocksRequest rqst) {
        return this.delegate.showLocks(rqst);
    }

    @Override
    public long getTableWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.getTableWriteId(dbName, tableName, transactionId);
    }

    @Override
    public boolean isImpersonationEnabled() {
        return this.delegate.isImpersonationEnabled();
    }

    public Set<HivePrivilegeInfo> loadTablePrivileges(String databaseName, String tableName, HivePrincipal principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, principal);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(OptionalLong expiresAfterWriteMillis, OptionalLong refreshMillis, long maximumSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        if (expiresAfterWriteMillis.isPresent()) {
            cacheBuilder = cacheBuilder.expireAfterWrite(expiresAfterWriteMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        if (refreshMillis.isPresent() && (!expiresAfterWriteMillis.isPresent() || expiresAfterWriteMillis.getAsLong() > refreshMillis.getAsLong())) {
            cacheBuilder = cacheBuilder.refreshAfterWrite(refreshMillis.getAsLong(), TimeUnit.MILLISECONDS);
        }
        cacheBuilder = cacheBuilder.maximumSize(maximumSize);
        return cacheBuilder;
    }

    @Override
    public Set<HivePrivilegeInfo> listSchemaPrivileges(String databaseName, String tableName, HivePrincipal principal) {
        return this.delegate.listSchemaPrivileges(databaseName, tableName, principal);
    }

    @Override
    public Set<HivePrivilegeInfo> listColumnPrivileges(String databaseName, String tableName, String columnName, HivePrincipal principal) {
        return this.delegate.listColumnPrivileges(databaseName, tableName, columnName, principal);
    }

    private HiveIdentity updateIdentity(HiveIdentity identity) {
        return this.delegate.isImpersonationEnabled() ? identity : HiveIdentity.none();
    }

    private static class WithValidation<K, T> {
        private final K key;
        private final T payload;

        public WithValidation(K key, T payload) {
            this.key = key;
            this.payload = payload;
        }

        public T get() {
            return this.payload;
        }

        public boolean matches(K key) {
            if (this.key == null) {
                return true;
            }
            return Objects.equals(key, this.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithValidation that = (WithValidation)o;
            return Objects.equals(this.key, that.key);
        }
    }

    private static class WithIdentity<T> {
        private final HiveIdentity identity;
        private final T key;

        public WithIdentity(HiveIdentity identity, T key) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.key = Objects.requireNonNull(key, "key is null");
        }

        public HiveIdentity getIdentity() {
            return this.identity;
        }

        public T getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WithIdentity other = (WithIdentity)o;
            return Objects.equals(this.identity, other.identity) && Objects.equals(this.key, other.key);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.key);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.identity).add("key", this.key).toString();
        }
    }
}

